/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain;

import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.BiDirectionalFetch;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.internal.BatchEntityInsideEmbeddableSelectFetchInitializer;
import org.hibernate.sql.results.graph.entity.internal.BatchEntitySelectFetchInitializer;
import org.hibernate.sql.results.graph.entity.internal.EntityDelayedFetchInitializer;
import org.hibernate.sql.results.graph.entity.internal.EntitySelectFetchByUniqueKeyInitializer;
import org.hibernate.sql.results.graph.entity.internal.EntitySelectFetchInitializer;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.JavaType;

public class CircularFetchImpl
implements BiDirectionalFetch {
    private final DomainResult<?> keyResult;
    private final ToOneAttributeMapping referencedModelPart;
    private final EntityMappingType entityMappingType;
    private final FetchTiming timing;
    private final NavigablePath navigablePath;
    private final ToOneAttributeMapping fetchable;
    private final boolean selectByUniqueKey;
    private final FetchParent fetchParent;
    private final NavigablePath referencedNavigablePath;

    public CircularFetchImpl(ToOneAttributeMapping referencedModelPart, EntityMappingType entityMappingType, FetchTiming timing, NavigablePath navigablePath, FetchParent fetchParent, ToOneAttributeMapping fetchable, boolean selectByUniqueKey, NavigablePath referencedNavigablePath, DomainResult<?> keyResult) {
        this.referencedModelPart = referencedModelPart;
        this.entityMappingType = entityMappingType;
        this.timing = timing;
        this.fetchParent = fetchParent;
        this.navigablePath = navigablePath;
        this.selectByUniqueKey = selectByUniqueKey;
        this.referencedNavigablePath = referencedNavigablePath;
        this.fetchable = fetchable;
        this.keyResult = keyResult;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public NavigablePath getReferencedPath() {
        return this.referencedNavigablePath;
    }

    @Override
    public FetchParent getFetchParent() {
        return this.fetchParent;
    }

    @Override
    public Fetchable getFetchedMapping() {
        return this.fetchable;
    }

    @Override
    public JavaType<?> getResultJavaType() {
        return this.fetchable.getJavaType();
    }

    @Override
    public DomainResultAssembler<?> createAssembler(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        DomainResultAssembler<?> keyAssembler = this.keyResult.createResultAssembler(parentAccess, creationState);
        Initializer initializer = creationState.resolveInitializer(this.getNavigablePath(), this.referencedModelPart, () -> {
            if (this.timing == FetchTiming.IMMEDIATE) {
                if (this.selectByUniqueKey) {
                    return new EntitySelectFetchByUniqueKeyInitializer(parentAccess, this.fetchable, this.getNavigablePath(), this.entityMappingType.getEntityPersister(), keyAssembler);
                }
                EntityPersister entityPersister = this.entityMappingType.getEntityPersister();
                if (entityPersister.isBatchLoadable()) {
                    if (parentAccess.isEmbeddableInitializer()) {
                        return new BatchEntityInsideEmbeddableSelectFetchInitializer(parentAccess, this.referencedModelPart, this.getNavigablePath(), entityPersister, this.keyResult.createResultAssembler(parentAccess, creationState));
                    }
                    return new BatchEntitySelectFetchInitializer(parentAccess, this.referencedModelPart, this.getReferencedPath(), entityPersister, keyAssembler);
                }
                return new EntitySelectFetchInitializer(parentAccess, this.referencedModelPart, this.getReferencedPath(), entityPersister, keyAssembler);
            }
            return new EntityDelayedFetchInitializer(parentAccess, this.getReferencedPath(), this.fetchable, this.selectByUniqueKey, keyAssembler);
        });
        return new BiDirectionalFetchAssembler(initializer.asEntityInitializer(), this.fetchable.getJavaType());
    }

    @Override
    public FetchTiming getTiming() {
        return this.timing;
    }

    @Override
    public boolean hasTableGroup() {
        return true;
    }

    private static class BiDirectionalFetchAssembler
    implements DomainResultAssembler {
        private EntityInitializer initializer;
        private JavaType assembledJavaType;

        public BiDirectionalFetchAssembler(EntityInitializer initializer, JavaType assembledJavaType) {
            this.initializer = initializer;
            this.assembledJavaType = assembledJavaType;
        }

        public Object assemble(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
            this.initializer.resolveInstance(rowProcessingState);
            return this.initializer.getInitializedInstance();
        }

        public JavaType getAssembledJavaType() {
            return this.assembledJavaType;
        }
    }
}

