/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Internal;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.AuxiliaryDatabaseObject;
import org.hibernate.boot.model.relational.ContributableDatabaseObject;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.Exportable;
import org.hibernate.boot.model.relational.InitCommand;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.boot.model.relational.internal.SqlStringGenerationContextImpl;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.internal.Formatter;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.mapping.UserDefinedType;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.tool.schema.SourceType;
import org.hibernate.tool.schema.internal.DefaultSchemaFilter;
import org.hibernate.tool.schema.internal.ExceptionHandlerHaltImpl;
import org.hibernate.tool.schema.internal.ExceptionHandlerLoggedImpl;
import org.hibernate.tool.schema.internal.Helper;
import org.hibernate.tool.schema.internal.HibernateSchemaManagementTool;
import org.hibernate.tool.schema.internal.exec.GenerationTarget;
import org.hibernate.tool.schema.internal.exec.JdbcContext;
import org.hibernate.tool.schema.internal.exec.ScriptSourceInputFromUrl;
import org.hibernate.tool.schema.internal.exec.ScriptSourceInputNonExistentImpl;
import org.hibernate.tool.schema.spi.CommandAcceptanceException;
import org.hibernate.tool.schema.spi.ContributableMatcher;
import org.hibernate.tool.schema.spi.ExceptionHandler;
import org.hibernate.tool.schema.spi.ExecutionOptions;
import org.hibernate.tool.schema.spi.SchemaCreator;
import org.hibernate.tool.schema.spi.SchemaFilter;
import org.hibernate.tool.schema.spi.SchemaManagementException;
import org.hibernate.tool.schema.spi.SchemaManagementTool;
import org.hibernate.tool.schema.spi.ScriptSourceInput;
import org.hibernate.tool.schema.spi.SourceDescriptor;
import org.hibernate.tool.schema.spi.SqlScriptCommandExtractor;
import org.hibernate.tool.schema.spi.TargetDescriptor;

public class SchemaCreatorImpl
implements SchemaCreator {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(SchemaCreatorImpl.class);
    public static final String DEFAULT_IMPORT_FILE = "/import.sql";
    private final HibernateSchemaManagementTool tool;
    private final SchemaFilter schemaFilter;

    public SchemaCreatorImpl(HibernateSchemaManagementTool tool) {
        this(tool, (SchemaFilter)DefaultSchemaFilter.INSTANCE);
    }

    public SchemaCreatorImpl(HibernateSchemaManagementTool tool, SchemaFilter schemaFilter) {
        this.tool = tool;
        this.schemaFilter = schemaFilter;
    }

    public SchemaCreatorImpl(ServiceRegistry serviceRegistry) {
        this(serviceRegistry, (SchemaFilter)DefaultSchemaFilter.INSTANCE);
    }

    public SchemaCreatorImpl(ServiceRegistry serviceRegistry, SchemaFilter schemaFilter) {
        SchemaManagementTool smt = serviceRegistry.getService(SchemaManagementTool.class);
        if (!(smt instanceof HibernateSchemaManagementTool)) {
            smt = new HibernateSchemaManagementTool();
            ((HibernateSchemaManagementTool)smt).injectServices((ServiceRegistryImplementor)serviceRegistry);
        }
        this.tool = (HibernateSchemaManagementTool)smt;
        this.schemaFilter = schemaFilter;
    }

    @Override
    public void doCreation(Metadata metadata, ExecutionOptions options, ContributableMatcher contributableInclusionFilter, SourceDescriptor sourceDescriptor, TargetDescriptor targetDescriptor) {
        if (!targetDescriptor.getTargetTypes().isEmpty()) {
            Map<String, Object> configuration = options.getConfigurationValues();
            JdbcContext jdbcContext = this.tool.resolveJdbcContext(configuration);
            this.doCreation(metadata, jdbcContext.getDialect(), options, contributableInclusionFilter, sourceDescriptor, this.tool.buildGenerationTargets(targetDescriptor, jdbcContext, configuration, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public void doCreation(Metadata metadata, Dialect dialect, ExecutionOptions options, ContributableMatcher contributableInclusionFilter, SourceDescriptor sourceDescriptor, GenerationTarget ... targets) {
        for (GenerationTarget target : targets) {
            target.prepare();
        }
        try {
            this.performCreation(metadata, dialect, options, contributableInclusionFilter, sourceDescriptor, targets);
        }
        finally {
            for (GenerationTarget target : targets) {
                try {
                    target.release();
                }
                catch (Exception e) {
                    log.debugf("Problem releasing GenerationTarget [%s] : %s", target, e.getMessage());
                }
            }
        }
    }

    private void performCreation(Metadata metadata, Dialect dialect, ExecutionOptions options, ContributableMatcher contributableInclusionFilter, SourceDescriptor sourceDescriptor, GenerationTarget ... targets) {
        SqlScriptCommandExtractor commandExtractor = this.getCommandExtractor();
        boolean format = Helper.interpretFormattingEnabled(options.getConfigurationValues());
        Formatter formatter = format ? FormatStyle.DDL.getFormatter() : FormatStyle.NONE.getFormatter();
        switch (sourceDescriptor.getSourceType()) {
            case SCRIPT: {
                this.createFromScript(sourceDescriptor.getScriptSourceInput(), commandExtractor, formatter, dialect, options, targets);
                break;
            }
            case METADATA: {
                this.createFromMetadata(metadata, options, contributableInclusionFilter, dialect, formatter, targets);
                break;
            }
            case METADATA_THEN_SCRIPT: {
                this.createFromMetadata(metadata, options, contributableInclusionFilter, dialect, formatter, targets);
                this.createFromScript(sourceDescriptor.getScriptSourceInput(), commandExtractor, formatter, dialect, options, targets);
                break;
            }
            case SCRIPT_THEN_METADATA: {
                this.createFromScript(sourceDescriptor.getScriptSourceInput(), commandExtractor, formatter, dialect, options, targets);
                this.createFromMetadata(metadata, options, contributableInclusionFilter, dialect, formatter, targets);
            }
        }
        this.applyImportSources(options, commandExtractor, format, dialect, targets);
    }

    private SqlScriptCommandExtractor getCommandExtractor() {
        return this.tool.getServiceRegistry().getService(SqlScriptCommandExtractor.class);
    }

    private ClassLoaderService getClassLoaderService() {
        return this.tool.getServiceRegistry().getService(ClassLoaderService.class);
    }

    public void createFromScript(ScriptSourceInput scriptSourceInput, SqlScriptCommandExtractor commandExtractor, Formatter formatter, Dialect dialect, ExecutionOptions options, GenerationTarget ... targets) {
        List<String> commands = scriptSourceInput.extract(reader -> commandExtractor.extractCommands((Reader)reader, dialect));
        for (String command : commands) {
            SchemaCreatorImpl.applySqlString(command, formatter, options, targets);
        }
    }

    @Internal
    public void createFromMetadata(Metadata metadata, ExecutionOptions options, Dialect dialect, Formatter formatter, GenerationTarget ... targets) {
        this.createFromMetadata(metadata, options, (ContributableDatabaseObject contributed) -> true, dialect, formatter, targets);
    }

    private static SqlStringGenerationContext createSqlStringGenerationContext(ExecutionOptions options, Metadata metadata) {
        Database database = metadata.getDatabase();
        return SqlStringGenerationContextImpl.fromConfigurationMap(database.getJdbcEnvironment(), database, options.getConfigurationValues());
    }

    @Internal
    public void createFromMetadata(Metadata metadata, ExecutionOptions options, ContributableMatcher contributableInclusionMatcher, Dialect dialect, Formatter formatter, GenerationTarget ... targets) {
        SqlStringGenerationContext context = SchemaCreatorImpl.createSqlStringGenerationContext(options, metadata);
        HashSet<String> exportIdentifiers = CollectionHelper.setOfSize(50);
        SchemaCreatorImpl.createSchemasAndCatalogs(metadata, options, dialect, formatter, context, targets);
        SchemaCreatorImpl.createUserDefinedTypes(metadata, options, dialect, formatter, context, targets);
        SchemaCreatorImpl.createAuxiliaryObjectsBeforeTables(metadata, options, dialect, formatter, context, exportIdentifiers, targets);
        SchemaCreatorImpl.createSequencesTablesConstraints(metadata, options, contributableInclusionMatcher, dialect, formatter, context, exportIdentifiers, targets);
        SchemaCreatorImpl.createForeignKeys(metadata, options, contributableInclusionMatcher, dialect, formatter, context, targets);
        SchemaCreatorImpl.createAuxiliaryObjectsAfterTables(metadata, options, dialect, formatter, context, exportIdentifiers, targets);
        SchemaCreatorImpl.executeInitCommands(metadata, options, formatter, targets);
    }

    private static void executeInitCommands(Metadata metadata, ExecutionOptions options, Formatter formatter, GenerationTarget[] targets) {
        for (InitCommand initCommand : metadata.getDatabase().getInitCommands()) {
            SchemaCreatorImpl.applySqlStrings(initCommand.getInitCommands(), formatter, options, targets);
        }
    }

    private static void createAuxiliaryObjectsAfterTables(Metadata metadata, ExecutionOptions options, Dialect dialect, Formatter formatter, SqlStringGenerationContext context, Set<String> exportIdentifiers, GenerationTarget[] targets) {
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : metadata.getDatabase().getAuxiliaryDatabaseObjects()) {
            if (!auxiliaryDatabaseObject.appliesToDialect(dialect) || auxiliaryDatabaseObject.beforeTablesOnCreation()) continue;
            SchemaCreatorImpl.checkExportIdentifier(auxiliaryDatabaseObject, exportIdentifiers);
            SchemaCreatorImpl.applySqlStrings(dialect.getAuxiliaryDatabaseObjectExporter().getSqlCreateStrings(auxiliaryDatabaseObject, metadata, context), formatter, options, targets);
        }
    }

    private static void createForeignKeys(Metadata metadata, ExecutionOptions options, ContributableMatcher contributableInclusionMatcher, Dialect dialect, Formatter formatter, SqlStringGenerationContext context, GenerationTarget[] targets) {
        for (Namespace namespace : metadata.getDatabase().getNamespaces()) {
            if (!options.getSchemaFilter().includeNamespace(namespace)) continue;
            for (Table table : namespace.getTables()) {
                if (!options.getSchemaFilter().includeTable(table) || !contributableInclusionMatcher.matches(table)) continue;
                for (ForeignKey foreignKey : table.getForeignKeys().values()) {
                    SchemaCreatorImpl.applySqlStrings(dialect.getForeignKeyExporter().getSqlCreateStrings(foreignKey, metadata, context), formatter, options, targets);
                }
            }
        }
    }

    private static void createSequencesTablesConstraints(Metadata metadata, ExecutionOptions options, ContributableMatcher contributableInclusionMatcher, Dialect dialect, Formatter formatter, SqlStringGenerationContext context, Set<String> exportIdentifiers, GenerationTarget[] targets) {
        for (Namespace namespace : metadata.getDatabase().getNamespaces()) {
            if (!options.getSchemaFilter().includeNamespace(namespace)) continue;
            SchemaCreatorImpl.createSequences(metadata, options, contributableInclusionMatcher, dialect, formatter, context, exportIdentifiers, targets, namespace);
            SchemaCreatorImpl.createTables(metadata, options, contributableInclusionMatcher, dialect, formatter, context, exportIdentifiers, targets, namespace);
            SchemaCreatorImpl.createTableConstraints(metadata, options, contributableInclusionMatcher, dialect, formatter, context, exportIdentifiers, targets, namespace);
        }
    }

    private static void createTableConstraints(Metadata metadata, ExecutionOptions options, ContributableMatcher contributableInclusionMatcher, Dialect dialect, Formatter formatter, SqlStringGenerationContext context, Set<String> exportIdentifiers, GenerationTarget[] targets, Namespace namespace) {
        for (Table table : namespace.getTables()) {
            if (!table.isPhysicalTable() || !options.getSchemaFilter().includeTable(table) || !contributableInclusionMatcher.matches(table)) continue;
            for (Index index : table.getIndexes().values()) {
                SchemaCreatorImpl.checkExportIdentifier(index, exportIdentifiers);
                SchemaCreatorImpl.applySqlStrings(dialect.getIndexExporter().getSqlCreateStrings(index, metadata, context), formatter, options, targets);
            }
            for (UniqueKey uniqueKey : table.getUniqueKeys().values()) {
                SchemaCreatorImpl.checkExportIdentifier(uniqueKey, exportIdentifiers);
                SchemaCreatorImpl.applySqlStrings(dialect.getUniqueKeyExporter().getSqlCreateStrings(uniqueKey, metadata, context), formatter, options, targets);
            }
        }
    }

    private static void createTables(Metadata metadata, ExecutionOptions options, ContributableMatcher contributableInclusionMatcher, Dialect dialect, Formatter formatter, SqlStringGenerationContext context, Set<String> exportIdentifiers, GenerationTarget[] targets, Namespace namespace) {
        for (Table table : namespace.getTables()) {
            if (!table.isPhysicalTable() || !options.getSchemaFilter().includeTable(table) || !contributableInclusionMatcher.matches(table)) continue;
            SchemaCreatorImpl.checkExportIdentifier(table, exportIdentifiers);
            SchemaCreatorImpl.applySqlStrings(dialect.getTableExporter().getSqlCreateStrings(table, metadata, context), formatter, options, targets);
        }
    }

    private static void createSequences(Metadata metadata, ExecutionOptions options, ContributableMatcher contributableInclusionMatcher, Dialect dialect, Formatter formatter, SqlStringGenerationContext context, Set<String> exportIdentifiers, GenerationTarget[] targets, Namespace namespace) {
        for (Sequence sequence : namespace.getSequences()) {
            if (!options.getSchemaFilter().includeSequence(sequence) || !contributableInclusionMatcher.matches(sequence)) continue;
            SchemaCreatorImpl.checkExportIdentifier(sequence, exportIdentifiers);
            SchemaCreatorImpl.applySqlStrings(dialect.getSequenceExporter().getSqlCreateStrings(sequence, metadata, context), formatter, options, targets);
        }
    }

    private static void createAuxiliaryObjectsBeforeTables(Metadata metadata, ExecutionOptions options, Dialect dialect, Formatter formatter, SqlStringGenerationContext context, Set<String> exportIdentifiers, GenerationTarget[] targets) {
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : metadata.getDatabase().getAuxiliaryDatabaseObjects()) {
            if (!auxiliaryDatabaseObject.beforeTablesOnCreation() || !auxiliaryDatabaseObject.appliesToDialect(dialect)) continue;
            SchemaCreatorImpl.checkExportIdentifier(auxiliaryDatabaseObject, exportIdentifiers);
            SchemaCreatorImpl.applySqlStrings(dialect.getAuxiliaryDatabaseObjectExporter().getSqlCreateStrings(auxiliaryDatabaseObject, metadata, context), formatter, options, targets);
        }
    }

    private static void createUserDefinedTypes(Metadata metadata, ExecutionOptions options, Dialect dialect, Formatter formatter, SqlStringGenerationContext context, GenerationTarget[] targets) {
        for (Namespace namespace : metadata.getDatabase().getNamespaces()) {
            if (!options.getSchemaFilter().includeNamespace(namespace)) continue;
            for (UserDefinedType userDefinedType : namespace.getDependencyOrderedUserDefinedTypes()) {
                SchemaCreatorImpl.applySqlStrings(dialect.getUserDefinedTypeExporter().getSqlCreateStrings(userDefinedType, metadata, context), formatter, options, targets);
            }
        }
    }

    private static void createSchemasAndCatalogs(Metadata metadata, ExecutionOptions options, Dialect dialect, Formatter formatter, SqlStringGenerationContext context, GenerationTarget[] targets) {
        boolean tryToCreateSchemas;
        boolean tryToCreateCatalogs = options.shouldManageNamespaces() && dialect.canCreateCatalog();
        boolean bl = tryToCreateSchemas = options.shouldManageNamespaces() && dialect.canCreateSchema();
        if (tryToCreateCatalogs || tryToCreateSchemas) {
            HashSet<Identifier> exportedCatalogs = new HashSet<Identifier>();
            for (Namespace namespace : metadata.getDatabase().getNamespaces()) {
                if (!options.getSchemaFilter().includeNamespace(namespace)) continue;
                if (tryToCreateCatalogs) {
                    Identifier catalogLogicalName = namespace.getName().getCatalog();
                    Identifier catalogPhysicalName = context.catalogWithDefault(namespace.getPhysicalName().getCatalog());
                    if (catalogPhysicalName != null && !exportedCatalogs.contains(catalogLogicalName)) {
                        SchemaCreatorImpl.applySqlStrings(dialect.getCreateCatalogCommand(catalogPhysicalName.render(dialect)), formatter, options, targets);
                        exportedCatalogs.add(catalogLogicalName);
                    }
                }
                Identifier schemaPhysicalName = context.schemaWithDefault(namespace.getPhysicalName().getSchema());
                if (!tryToCreateSchemas || schemaPhysicalName == null) continue;
                SchemaCreatorImpl.applySqlStrings(dialect.getCreateSchemaCommand(schemaPhysicalName.render(dialect)), formatter, options, targets);
            }
        }
    }

    private static void checkExportIdentifier(Exportable exportable, Set<String> exportIdentifiers) {
        String exportIdentifier = exportable.getExportIdentifier();
        if (exportIdentifiers.contains(exportIdentifier)) {
            throw new SchemaManagementException("SQL strings added more than once for: " + exportIdentifier);
        }
        exportIdentifiers.add(exportIdentifier);
    }

    private static void applySqlStrings(String[] sqlStrings, Formatter formatter, ExecutionOptions options, GenerationTarget ... targets) {
        if (sqlStrings != null) {
            for (String sqlString : sqlStrings) {
                SchemaCreatorImpl.applySqlString(sqlString, formatter, options, targets);
            }
        }
    }

    private static void applySqlString(String sqlString, Formatter formatter, ExecutionOptions options, GenerationTarget ... targets) {
        if (StringHelper.isNotEmpty(sqlString)) {
            try {
                String sqlStringFormatted = formatter.format(sqlString);
                for (GenerationTarget target : targets) {
                    target.accept(sqlStringFormatted);
                }
            }
            catch (CommandAcceptanceException e) {
                options.getExceptionHandler().handleException(e);
            }
        }
    }

    private void applyImportSources(ExecutionOptions options, SqlScriptCommandExtractor commandExtractor, boolean format, Dialect dialect, GenerationTarget ... targets) {
        Formatter formatter;
        boolean hasDefaultImportFileScriptBeenExecuted = this.applyImportScript(options, commandExtractor, dialect, formatter = SchemaCreatorImpl.getImportScriptFormatter(format), targets);
        this.applyImportFiles(options, commandExtractor, dialect, formatter, hasDefaultImportFileScriptBeenExecuted ? "" : DEFAULT_IMPORT_FILE, targets);
    }

    private static Formatter getImportScriptFormatter(boolean format) {
        return FormatStyle.NONE.getFormatter();
    }

    private boolean applyImportScript(ExecutionOptions options, SqlScriptCommandExtractor commandExtractor, Dialect dialect, Formatter formatter, GenerationTarget[] targets) {
        Object importScriptSetting = SchemaCreatorImpl.getImportScriptSetting(options);
        if (importScriptSetting != null) {
            ScriptSourceInput importScriptInput = Helper.interpretScriptSourceSetting(importScriptSetting, this.getClassLoaderService(), SchemaCreatorImpl.getCharsetName(options));
            SchemaCreatorImpl.applyImportScript(options, commandExtractor, dialect, importScriptInput, formatter, targets);
            return this.containsDefaultImportFile(importScriptInput);
        }
        return false;
    }

    private boolean containsDefaultImportFile(ScriptSourceInput importScriptInput) {
        URL defaultImportFileUrl = this.getClassLoaderService().locateResource(DEFAULT_IMPORT_FILE);
        return defaultImportFileUrl != null && importScriptInput.containsScript(defaultImportFileUrl);
    }

    private void applyImportFiles(ExecutionOptions options, SqlScriptCommandExtractor commandExtractor, Dialect dialect, Formatter formatter, String defaultImportFile, GenerationTarget[] targets) {
        String[] importFiles = ConfigurationHelper.getString("hibernate.hbm2ddl.import_files", options.getConfigurationValues(), defaultImportFile).split(",");
        String charsetName = SchemaCreatorImpl.getCharsetName(options);
        ClassLoaderService classLoaderService = this.getClassLoaderService();
        for (String currentFile : importFiles) {
            String resourceName = currentFile.trim();
            if (resourceName.isEmpty()) continue;
            SchemaCreatorImpl.applyImportScript(options, commandExtractor, dialect, this.interpretLegacyImportScriptSetting(resourceName, classLoaderService, charsetName), formatter, targets);
        }
    }

    private static void applyImportScript(ExecutionOptions options, SqlScriptCommandExtractor commandExtractor, Dialect dialect, ScriptSourceInput importScriptInput, Formatter formatter, GenerationTarget[] targets) {
        List<String> commands = importScriptInput.extract(reader -> commandExtractor.extractCommands((Reader)reader, dialect));
        for (String command : commands) {
            SchemaCreatorImpl.applySqlString(command, formatter, options, targets);
        }
    }

    private ScriptSourceInput interpretLegacyImportScriptSetting(String resourceName, ClassLoaderService classLoaderService, String charsetName) {
        try {
            URL resourceUrl = classLoaderService.locateResource(resourceName);
            return resourceUrl == null ? ScriptSourceInputNonExistentImpl.INSTANCE : new ScriptSourceInputFromUrl(resourceUrl, charsetName);
        }
        catch (Exception e) {
            throw new SchemaManagementException("Error resolving legacy import resource : " + resourceName, e);
        }
    }

    private static String getCharsetName(ExecutionOptions options) {
        return (String)options.getConfigurationValues().get("hibernate.hbm2ddl.charset_name");
    }

    private static Object getImportScriptSetting(ExecutionOptions options) {
        Map<String, Object> configuration = options.getConfigurationValues();
        Object importScriptSetting = configuration.get("javax.persistence.sql-load-script-source");
        return importScriptSetting == null ? configuration.get("jakarta.persistence.sql-load-script-source") : importScriptSetting;
    }

    public List<String> generateCreationCommands(Metadata metadata, final boolean manageNamespaces) {
        JournalingGenerationTarget target = new JournalingGenerationTarget();
        StandardServiceRegistry serviceRegistry = ((MetadataImplementor)metadata).getMetadataBuildingOptions().getServiceRegistry();
        Dialect dialect = serviceRegistry.getService(JdbcEnvironment.class).getDialect();
        ExecutionOptions options = new ExecutionOptions(){

            @Override
            public boolean shouldManageNamespaces() {
                return manageNamespaces;
            }

            @Override
            public Map<String, Object> getConfigurationValues() {
                return Collections.emptyMap();
            }

            @Override
            public ExceptionHandler getExceptionHandler() {
                return ExceptionHandlerHaltImpl.INSTANCE;
            }

            @Override
            public SchemaFilter getSchemaFilter() {
                return SchemaCreatorImpl.this.schemaFilter;
            }
        };
        this.createFromMetadata(metadata, options, dialect, FormatStyle.NONE.getFormatter(), target);
        return target.commands;
    }

    @Internal
    public void doCreation(Metadata metadata, boolean manageNamespaces, GenerationTarget ... targets) {
        StandardServiceRegistry serviceRegistry = ((MetadataImplementor)metadata).getMetadataBuildingOptions().getServiceRegistry();
        this.doCreation(metadata, serviceRegistry, serviceRegistry.getService(ConfigurationService.class).getSettings(), manageNamespaces, targets);
    }

    @Internal
    public void doCreation(Metadata metadata, ServiceRegistry serviceRegistry, final Map<String, Object> settings, final boolean manageNamespaces, GenerationTarget ... targets) {
        this.doCreation(metadata, serviceRegistry.getService(JdbcEnvironment.class).getDialect(), new ExecutionOptions(){

            @Override
            public boolean shouldManageNamespaces() {
                return manageNamespaces;
            }

            @Override
            public Map<String, Object> getConfigurationValues() {
                return settings;
            }

            @Override
            public ExceptionHandler getExceptionHandler() {
                return ExceptionHandlerLoggedImpl.INSTANCE;
            }

            @Override
            public SchemaFilter getSchemaFilter() {
                return SchemaCreatorImpl.this.schemaFilter;
            }
        }, (ContributableDatabaseObject contributed) -> true, new SourceDescriptor(){

            @Override
            public SourceType getSourceType() {
                return SourceType.METADATA;
            }

            @Override
            public ScriptSourceInput getScriptSourceInput() {
                return null;
            }
        }, targets);
    }

    private static class JournalingGenerationTarget
    implements GenerationTarget {
        private final ArrayList<String> commands = new ArrayList();

        private JournalingGenerationTarget() {
        }

        @Override
        public void prepare() {
        }

        @Override
        public void accept(String command) {
            this.commands.add(command);
        }

        @Override
        public void release() {
        }
    }
}

