/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.entity;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.generator.EventTypeSets;
import org.hibernate.generator.Generator;
import org.hibernate.generator.OnExecutionGenerator;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.tuple.entity.CompositeValueGenerationException;

class CompositeGeneratorBuilder {
    private final Property mappingProperty;
    private final Dialect dialect;
    private boolean hadBeforeExecutionGeneration;
    private boolean hadOnExecutionGeneration;
    private List<OnExecutionGenerator> onExecutionGenerators;

    public CompositeGeneratorBuilder(Property mappingProperty, Dialect dialect) {
        this.mappingProperty = mappingProperty;
        this.dialect = dialect;
    }

    public void add(Generator generator) {
        if (generator != null) {
            if (generator.generatedOnExecution()) {
                if (generator instanceof OnExecutionGenerator) {
                    this.add((OnExecutionGenerator)generator);
                }
            } else if (generator instanceof BeforeExecutionGenerator) {
                this.add((BeforeExecutionGenerator)generator);
            }
        }
    }

    private void add(BeforeExecutionGenerator beforeExecutionGenerator) {
        if (beforeExecutionGenerator.generatesSometimes()) {
            this.hadBeforeExecutionGeneration = true;
        }
    }

    private void add(OnExecutionGenerator onExecutionGenerator) {
        if (this.onExecutionGenerators == null) {
            this.onExecutionGenerators = new ArrayList<OnExecutionGenerator>();
        }
        this.onExecutionGenerators.add(onExecutionGenerator);
        if (onExecutionGenerator.generatesSometimes()) {
            this.hadOnExecutionGeneration = true;
        }
    }

    public Generator build() {
        if (this.hadBeforeExecutionGeneration && this.hadOnExecutionGeneration) {
            throw new CompositeValueGenerationException("Composite attribute [" + this.mappingProperty.getName() + "] contained both in-memory and in-database value generation");
        }
        if (this.hadBeforeExecutionGeneration) {
            throw new UnsupportedOperationException("Composite in-memory value generation not supported");
        }
        if (this.hadOnExecutionGeneration) {
            Component composite = (Component)this.mappingProperty.getValue();
            if (this.onExecutionGenerators.size() != composite.getPropertySpan()) {
                throw new CompositeValueGenerationException("Internal error : mismatch between number of collected in-db generation strategies and number of attributes for composite attribute : " + this.mappingProperty.getName());
            }
            final EnumSet<EventType> eventTypes = EnumSet.noneOf(EventType.class);
            boolean referenceColumns = false;
            final String[] columnValues = new String[composite.getColumnSpan()];
            int propertyIndex = -1;
            int columnIndex = 0;
            for (Property property : composite.getProperties()) {
                OnExecutionGenerator generator = this.onExecutionGenerators.get(++propertyIndex);
                eventTypes.addAll(generator.getEventTypes());
                if (!generator.referenceColumnsInSql(this.dialect)) continue;
                referenceColumns = true;
                String[] referencedColumnValues = generator.getReferencedColumnValues(this.dialect);
                if (referencedColumnValues == null) continue;
                int span = property.getColumnSpan();
                if (referencedColumnValues.length != span) {
                    throw new CompositeValueGenerationException("Mismatch between number of collected generated column values and number of columns for composite attribute: " + this.mappingProperty.getName() + "." + property.getName());
                }
                System.arraycopy(referencedColumnValues, 0, columnValues, columnIndex, span);
            }
            final boolean referenceColumnsInSql = referenceColumns;
            return new OnExecutionGenerator(){

                @Override
                public EnumSet<EventType> getEventTypes() {
                    return eventTypes;
                }

                @Override
                public boolean referenceColumnsInSql(Dialect dialect) {
                    return referenceColumnsInSql;
                }

                @Override
                public String[] getReferencedColumnValues(Dialect dialect) {
                    return columnValues;
                }

                @Override
                public boolean writePropertyValue() {
                    return false;
                }
            };
        }
        return new Generator(){

            @Override
            public EnumSet<EventType> getEventTypes() {
                return EventTypeSets.NONE;
            }

            @Override
            public boolean generatedOnExecution() {
                return false;
            }
        };
    }
}

