/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.hibernate.dialect.Dialect;
import org.hibernate.sql.ast.spi.SqlAppender;

public final class DateTimeUtils {
    public static final String FORMAT_STRING_DATE = "yyyy-MM-dd";
    public static final String FORMAT_STRING_TIME_WITH_OFFSET = "HH:mm:ssXXX";
    public static final String FORMAT_STRING_TIME = "HH:mm:ss";
    public static final String FORMAT_STRING_TIMESTAMP = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_STRING_TIMESTAMP_WITH_MILLIS = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String FORMAT_STRING_TIMESTAMP_WITH_MICROS = "yyyy-MM-dd HH:mm:ss.SSSSSS";
    public static final String FORMAT_STRING_TIMESTAMP_WITH_NANOS = "yyyy-MM-dd HH:mm:ss.SSSSSSSSS";
    public static final String FORMAT_STRING_TIMESTAMP_WITH_MILLIS_AND_OFFSET = "yyyy-MM-dd HH:mm:ss.SSSXXX";
    public static final String FORMAT_STRING_TIMESTAMP_WITH_MICROS_AND_OFFSET = "yyyy-MM-dd HH:mm:ss.SSSSSSXXX";
    public static final String FORMAT_STRING_TIMESTAMP_WITH_NANOS_AND_OFFSET = "yyyy-MM-dd HH:mm:ss.SSSSSSSSSXXX";
    public static final DateTimeFormatter DATE_TIME_FORMATTER_DATE = DateTimeFormatter.ofPattern("yyyy-MM-dd", Locale.ENGLISH);
    public static final DateTimeFormatter DATE_TIME_FORMATTER_TIME_WITH_OFFSET = DateTimeFormatter.ofPattern("HH:mm:ssXXX", Locale.ENGLISH);
    public static final DateTimeFormatter DATE_TIME_FORMATTER_TIME = DateTimeFormatter.ofPattern("HH:mm:ss", Locale.ENGLISH);
    public static final DateTimeFormatter DATE_TIME_FORMATTER_TIMESTAMP_WITH_MILLIS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS", Locale.ENGLISH);
    public static final DateTimeFormatter DATE_TIME_FORMATTER_TIMESTAMP_WITH_MICROS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS", Locale.ENGLISH);
    public static final DateTimeFormatter DATE_TIME_FORMATTER_TIMESTAMP_WITH_NANOS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSSSSS", Locale.ENGLISH);
    public static final DateTimeFormatter DATE_TIME_FORMATTER_TIMESTAMP_WITH_MILLIS_AND_OFFSET = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSXXX", Locale.ENGLISH);
    public static final DateTimeFormatter DATE_TIME_FORMATTER_TIMESTAMP_WITH_MICROS_AND_OFFSET = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSSXXX", Locale.ENGLISH);
    public static final DateTimeFormatter DATE_TIME_FORMATTER_TIMESTAMP_WITH_NANOS_AND_OFFSET = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSSSSSXXX", Locale.ENGLISH);
    public static final String JDBC_ESCAPE_START_DATE = "{d '";
    public static final String JDBC_ESCAPE_START_TIME = "{t '";
    public static final String JDBC_ESCAPE_START_TIMESTAMP = "{ts '";
    public static final String JDBC_ESCAPE_END = "'}";
    public static final DateTimeFormatter DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral(' ').optionalEnd().optionalStart().appendLiteral('T').optionalEnd().append(DateTimeFormatter.ISO_LOCAL_TIME).optionalStart().appendLiteral(' ').optionalEnd().optionalStart().appendZoneOrOffsetId().optionalEnd().toFormatter();
    private static final ThreadLocal<SimpleDateFormat> LOCAL_DATE_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat(FORMAT_STRING_DATE, Locale.ENGLISH));
    private static final ThreadLocal<SimpleDateFormat> LOCAL_TIME_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat(FORMAT_STRING_TIME, Locale.ENGLISH));
    private static final ThreadLocal<SimpleDateFormat> TIME_WITH_OFFSET_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat(FORMAT_STRING_TIME_WITH_OFFSET, Locale.ENGLISH));
    private static final ThreadLocal<SimpleDateFormat> TIMESTAMP_WITH_MILLIS_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat(FORMAT_STRING_TIMESTAMP_WITH_MILLIS, Locale.ENGLISH));
    public static final DateTimeFormatter OFFSET_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral(' ').optionalEnd().optionalStart().appendLiteral('T').optionalEnd().append(DateTimeFormatter.ISO_LOCAL_TIME).optionalStart().appendLiteral(' ').optionalEnd().appendOffset("+HH:mm", "+00").toFormatter();

    private DateTimeUtils() {
    }

    public static void appendAsTimestampWithNanos(SqlAppender appender, TemporalAccessor temporalAccessor, boolean supportsOffset, TimeZone jdbcTimeZone) {
        DateTimeUtils.appendAsTimestamp(appender, temporalAccessor, supportsOffset, jdbcTimeZone, DATE_TIME_FORMATTER_TIMESTAMP_WITH_NANOS, DATE_TIME_FORMATTER_TIMESTAMP_WITH_NANOS_AND_OFFSET);
    }

    public static void appendAsTimestampWithMicros(SqlAppender appender, TemporalAccessor temporalAccessor, boolean supportsOffset, TimeZone jdbcTimeZone) {
        DateTimeUtils.appendAsTimestamp(appender, temporalAccessor, supportsOffset, jdbcTimeZone, DATE_TIME_FORMATTER_TIMESTAMP_WITH_MICROS, DATE_TIME_FORMATTER_TIMESTAMP_WITH_MICROS_AND_OFFSET);
    }

    public static void appendAsTimestampWithMillis(SqlAppender appender, TemporalAccessor temporalAccessor, boolean supportsOffset, TimeZone jdbcTimeZone) {
        DateTimeUtils.appendAsTimestamp(appender, temporalAccessor, supportsOffset, jdbcTimeZone, DATE_TIME_FORMATTER_TIMESTAMP_WITH_MILLIS, DATE_TIME_FORMATTER_TIMESTAMP_WITH_MILLIS_AND_OFFSET);
    }

    private static void appendAsTimestamp(SqlAppender appender, TemporalAccessor temporalAccessor, boolean supportsOffset, TimeZone jdbcTimeZone, DateTimeFormatter format, DateTimeFormatter formatWithOffset) {
        if (temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
            if (supportsOffset) {
                formatWithOffset.formatTo(temporalAccessor, appender);
            } else {
                format.formatTo(LocalDateTime.ofInstant(Instant.from(temporalAccessor), jdbcTimeZone.toZoneId()), appender);
            }
        } else if (temporalAccessor instanceof Instant) {
            if (supportsOffset) {
                formatWithOffset.formatTo(((Instant)temporalAccessor).atZone(jdbcTimeZone.toZoneId()), appender);
            } else {
                format.formatTo(LocalDateTime.ofInstant((Instant)temporalAccessor, jdbcTimeZone.toZoneId()), appender);
            }
        } else {
            format.formatTo(temporalAccessor, appender);
        }
    }

    public static void appendAsDate(SqlAppender appender, TemporalAccessor temporalAccessor) {
        DATE_TIME_FORMATTER_DATE.formatTo(temporalAccessor, appender);
    }

    public static void appendAsTime(SqlAppender appender, TemporalAccessor temporalAccessor, boolean supportsOffset, TimeZone jdbcTimeZone) {
        if (temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
            if (supportsOffset) {
                DATE_TIME_FORMATTER_TIME_WITH_OFFSET.formatTo(temporalAccessor, appender);
            } else {
                DATE_TIME_FORMATTER_TIME.formatTo(LocalTime.from(temporalAccessor), appender);
            }
        } else {
            DATE_TIME_FORMATTER_TIME.formatTo(temporalAccessor, appender);
        }
    }

    public static void appendAsLocalTime(SqlAppender appender, TemporalAccessor temporalAccessor) {
        DATE_TIME_FORMATTER_TIME.formatTo(temporalAccessor, appender);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendAsTimestampWithMillis(SqlAppender appender, Date date, TimeZone jdbcTimeZone) {
        SimpleDateFormat simpleDateFormat = TIMESTAMP_WITH_MILLIS_FORMAT.get();
        TimeZone originalTimeZone = simpleDateFormat.getTimeZone();
        try {
            simpleDateFormat.setTimeZone(jdbcTimeZone);
            appender.appendSql(simpleDateFormat.format(date));
        }
        finally {
            simpleDateFormat.setTimeZone(originalTimeZone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendAsTimestampWithMicros(SqlAppender appender, Date date, TimeZone jdbcTimeZone) {
        if (date instanceof Timestamp) {
            DateTimeUtils.appendAsTimestamp(appender, date.toInstant().atZone(jdbcTimeZone.toZoneId()), false, jdbcTimeZone, DATE_TIME_FORMATTER_TIMESTAMP_WITH_MICROS, DATE_TIME_FORMATTER_TIMESTAMP_WITH_MICROS_AND_OFFSET);
        } else {
            SimpleDateFormat simpleDateFormat = TIMESTAMP_WITH_MILLIS_FORMAT.get();
            TimeZone originalTimeZone = simpleDateFormat.getTimeZone();
            try {
                simpleDateFormat.setTimeZone(jdbcTimeZone);
                appender.appendSql(simpleDateFormat.format(date));
            }
            finally {
                simpleDateFormat.setTimeZone(originalTimeZone);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendAsTimestampWithNanos(SqlAppender appender, Date date, TimeZone jdbcTimeZone) {
        if (date instanceof Timestamp) {
            DateTimeUtils.appendAsTimestamp(appender, date.toInstant().atZone(jdbcTimeZone.toZoneId()), false, jdbcTimeZone, DATE_TIME_FORMATTER_TIMESTAMP_WITH_NANOS, DATE_TIME_FORMATTER_TIMESTAMP_WITH_NANOS_AND_OFFSET);
        } else {
            SimpleDateFormat simpleDateFormat = TIMESTAMP_WITH_MILLIS_FORMAT.get();
            TimeZone originalTimeZone = simpleDateFormat.getTimeZone();
            try {
                simpleDateFormat.setTimeZone(jdbcTimeZone);
                appender.appendSql(simpleDateFormat.format(date));
            }
            finally {
                simpleDateFormat.setTimeZone(originalTimeZone);
            }
        }
    }

    public static void appendAsDate(SqlAppender appender, Date date) {
        appender.appendSql(LOCAL_DATE_FORMAT.get().format(date));
    }

    @Deprecated
    public static void appendAsTime(SqlAppender appender, Date date) {
        DateTimeUtils.appendAsLocalTime(appender, date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendAsTime(SqlAppender appender, Date date, TimeZone jdbcTimeZone) {
        SimpleDateFormat simpleDateFormat = TIME_WITH_OFFSET_FORMAT.get();
        TimeZone originalTimeZone = simpleDateFormat.getTimeZone();
        try {
            simpleDateFormat.setTimeZone(jdbcTimeZone);
            appender.appendSql(simpleDateFormat.format(date));
        }
        finally {
            simpleDateFormat.setTimeZone(originalTimeZone);
        }
    }

    public static void appendAsLocalTime(SqlAppender appender, Date date) {
        appender.appendSql(LOCAL_TIME_FORMAT.get().format(date));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendAsTimestampWithMillis(SqlAppender appender, Calendar calendar, TimeZone jdbcTimeZone) {
        SimpleDateFormat simpleDateFormat = TIMESTAMP_WITH_MILLIS_FORMAT.get();
        TimeZone originalTimeZone = simpleDateFormat.getTimeZone();
        try {
            simpleDateFormat.setTimeZone(jdbcTimeZone);
            appender.appendSql(simpleDateFormat.format(calendar.getTime()));
        }
        finally {
            simpleDateFormat.setTimeZone(originalTimeZone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(forRemoval=true)
    public static void appendAsTimestampWithMicros(SqlAppender appender, Calendar calendar, TimeZone jdbcTimeZone) {
        SimpleDateFormat simpleDateFormat = TIMESTAMP_WITH_MILLIS_FORMAT.get();
        TimeZone originalTimeZone = simpleDateFormat.getTimeZone();
        try {
            simpleDateFormat.setTimeZone(jdbcTimeZone);
            appender.appendSql(simpleDateFormat.format(calendar.getTime()));
        }
        finally {
            simpleDateFormat.setTimeZone(originalTimeZone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendAsDate(SqlAppender appender, Calendar calendar) {
        SimpleDateFormat simpleDateFormat = LOCAL_DATE_FORMAT.get();
        TimeZone originalTimeZone = simpleDateFormat.getTimeZone();
        try {
            simpleDateFormat.setTimeZone(calendar.getTimeZone());
            appender.appendSql(simpleDateFormat.format(calendar.getTime()));
        }
        finally {
            simpleDateFormat.setTimeZone(originalTimeZone);
        }
    }

    @Deprecated
    public static void appendAsTime(SqlAppender appender, Calendar calendar) {
        DateTimeUtils.appendAsLocalTime(appender, calendar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendAsTime(SqlAppender appender, Calendar calendar, TimeZone jdbcTimeZone) {
        SimpleDateFormat simpleDateFormat = TIME_WITH_OFFSET_FORMAT.get();
        TimeZone originalTimeZone = simpleDateFormat.getTimeZone();
        try {
            simpleDateFormat.setTimeZone(jdbcTimeZone);
            appender.appendSql(simpleDateFormat.format(calendar.getTime()));
        }
        finally {
            simpleDateFormat.setTimeZone(originalTimeZone);
        }
    }

    public static void appendAsLocalTime(SqlAppender appender, Calendar calendar) {
        appender.appendSql(LOCAL_TIME_FORMAT.get().format(calendar.getTime()));
    }

    public static <T extends Temporal> T roundToDefaultPrecision(T temporal, Dialect d) {
        int nanosToRound;
        int nano;
        int defaultTimestampPrecision = d.getDefaultTimestampPrecision();
        if (defaultTimestampPrecision >= 9 || !temporal.isSupported(ChronoField.NANO_OF_SECOND)) {
            return temporal;
        }
        int precisionMask = DateTimeUtils.pow10(9 - defaultTimestampPrecision);
        int finalNano = nano - nanosToRound + ((nanosToRound = (nano = temporal.get(ChronoField.NANO_OF_SECOND)) % precisionMask) >= precisionMask >> 1 ? precisionMask : 0);
        return (T)temporal.with(ChronoField.NANO_OF_SECOND, finalNano);
    }

    private static int pow10(int exponent) {
        switch (exponent) {
            case 0: {
                return 1;
            }
            case 1: {
                return 10;
            }
            case 2: {
                return 100;
            }
            case 3: {
                return 1000;
            }
            case 4: {
                return 10000;
            }
            case 5: {
                return 100000;
            }
            case 6: {
                return 1000000;
            }
            case 7: {
                return 10000000;
            }
            case 8: {
                return 100000000;
            }
        }
        return (int)Math.pow(10.0, exponent);
    }
}

