/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.XmlJdbcType;

public class XmlAsStringJdbcType
extends XmlJdbcType {
    public static final XmlAsStringJdbcType INSTANCE = new XmlAsStringJdbcType(null);

    private XmlAsStringJdbcType(EmbeddableMappingType embeddableMappingType) {
        super(embeddableMappingType);
    }

    @Override
    public AggregateJdbcType resolveAggregateJdbcType(EmbeddableMappingType mappingType, String sqlType, RuntimeModelCreationContext creationContext) {
        return new XmlAsStringJdbcType(mappingType);
    }

    @Override
    public int getJdbcTypeCode() {
        return 12;
    }

    @Override
    public int getDefaultSqlTypeCode() {
        return 2009;
    }

    @Override
    public String toString() {
        return "XmlAsStringJdbcType";
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                String xml = ((XmlAsStringJdbcType)this.getJdbcType()).toString(value, this.getJavaType(), options);
                st.setString(index, xml);
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                String xml = ((XmlAsStringJdbcType)this.getJdbcType()).toString(value, this.getJavaType(), options);
                st.setString(name, xml);
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return this.getObject(rs.getString(paramIndex), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getObject(statement.getString(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getObject(statement.getString(name), options);
            }

            private X getObject(String xml, WrapperOptions options) throws SQLException {
                if (xml == null) {
                    return null;
                }
                return ((XmlAsStringJdbcType)this.getJdbcType()).fromString(xml, this.getJavaType(), options);
            }
        };
    }
}

