/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.SecondPass;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.AggregateColumn;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.UserDefinedType;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.internal.EmbeddableHelper;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;
import org.hibernate.type.spi.TypeConfiguration;

public class AggregateComponentSecondPass
implements SecondPass {
    private final PropertyHolder propertyHolder;
    private final Component component;
    private final XClass returnedClassOrElement;
    private final MetadataBuildingContext context;

    public AggregateComponentSecondPass(PropertyHolder propertyHolder, Component component, XClass returnedClassOrElement, MetadataBuildingContext context) {
        this.propertyHolder = propertyHolder;
        this.component = component;
        this.returnedClassOrElement = returnedClassOrElement;
        this.context = context;
    }

    @Override
    public void doSecondPass(Map<String, PersistentClass> persistentClasses) throws MappingException {
        boolean addAuxiliaryObjects;
        InFlightMetadataCollector metadataCollector = this.context.getMetadataCollector();
        TypeConfiguration typeConfiguration = metadataCollector.getTypeConfiguration();
        Database database = metadataCollector.getDatabase();
        Dialect dialect = database.getDialect();
        AggregateSupport aggregateSupport = dialect.getAggregateSupport();
        List<Column> aggregatedColumns = this.component.getAggregatedColumns();
        AggregateColumn aggregateColumn = this.component.getAggregateColumn();
        AggregateComponentSecondPass.ensureInitialized(metadataCollector, typeConfiguration, dialect, aggregateColumn);
        this.validateSupportedColumnTypes(this.propertyHolder.getPath(), this.component);
        for (Column aggregatedColumn : aggregatedColumns) {
            aggregatedColumn.getSqlTypeCode(metadataCollector);
            aggregatedColumn.getSqlType(metadataCollector);
        }
        String structName = this.component.getStructName();
        if (structName != null) {
            Namespace defaultNamespace = database.getDefaultNamespace();
            Identifier udtName = Identifier.toIdentifier(structName);
            UserDefinedType udt = new UserDefinedType("orm", defaultNamespace, udtName);
            Comment comment = (Comment)this.returnedClassOrElement.getAnnotation(Comment.class);
            if (comment != null) {
                udt.setComment(comment.value());
            }
            for (Column aggregatedColumn : aggregatedColumns) {
                udt.addColumn(aggregatedColumn);
            }
            UserDefinedType registeredUdt = defaultNamespace.createUserDefinedType(udtName, name -> udt);
            if (registeredUdt == udt) {
                addAuxiliaryObjects = true;
                this.orderColumns(registeredUdt);
            } else {
                addAuxiliaryObjects = false;
                this.validateEqual(registeredUdt, udt);
            }
        } else {
            addAuxiliaryObjects = true;
        }
        String aggregateReadTemplate = aggregateColumn.getAggregateReadExpressionTemplate(dialect);
        String aggregateReadExpression = aggregateReadTemplate.replace("$PlaceHolder$.", "");
        String aggregateAssignmentExpression = aggregateColumn.getAggregateAssignmentExpressionTemplate(dialect).replace("$PlaceHolder$.", "");
        if (addAuxiliaryObjects) {
            aggregateSupport.aggregateAuxiliaryDatabaseObjects(database.getDefaultNamespace(), aggregateReadExpression, aggregateColumn, aggregatedColumns).forEach(database::addAuxiliaryDatabaseObject);
        }
        aggregateColumn.setCustomWrite(aggregateSupport.aggregateCustomWriteExpression(aggregateColumn, aggregatedColumns));
        for (Column subColumn : aggregatedColumns) {
            String selectableExpression = subColumn.getText(dialect);
            String assignmentExpression = aggregateSupport.aggregateComponentAssignmentExpression(aggregateAssignmentExpression, selectableExpression, aggregateColumn, subColumn);
            String customReadExpression = subColumn.getCustomReadExpression() == null ? (subColumn.isFormula() ? aggregateSupport.aggregateComponentCustomReadExpression(subColumn.getTemplate(dialect, typeConfiguration, null), "$PlaceHolder$.", aggregateReadTemplate, "", aggregateColumn, subColumn) : aggregateSupport.aggregateComponentCustomReadExpression("", "", aggregateReadTemplate, selectableExpression, aggregateColumn, subColumn)) : aggregateSupport.aggregateComponentCustomReadExpression(subColumn.getCustomReadExpression(), "$PlaceHolder$.", aggregateReadTemplate, "", aggregateColumn, subColumn);
            subColumn.setAssignmentExpression(assignmentExpression);
            subColumn.setCustomRead(customReadExpression);
        }
        this.propertyHolder.getTable().getColumns().removeAll(aggregatedColumns);
    }

    private void orderColumns(UserDefinedType userDefinedType) {
        int[] propertyMappingIndex;
        Class<?> componentClass = this.component.getComponentClass();
        int[] originalOrder = this.component.sortProperties();
        if (ReflectHelper.isRecord(componentClass)) {
            if (originalOrder == null) {
                propertyMappingIndex = null;
            } else {
                String[] componentNames = ReflectHelper.getRecordComponentNames(componentClass);
                propertyMappingIndex = EmbeddableHelper.determinePropertyMappingIndex(this.component.getPropertyNames(), componentNames);
            }
        } else {
            if (this.component.getInstantiatorPropertyNames() == null) {
                return;
            }
            propertyMappingIndex = EmbeddableHelper.determinePropertyMappingIndex(this.component.getPropertyNames(), this.component.getInstantiatorPropertyNames());
        }
        ArrayList<Column> orderedColumns = new ArrayList<Column>(userDefinedType.getColumnSpan());
        List<Property> properties = this.component.getProperties();
        if (propertyMappingIndex == null) {
            for (Property property : properties) {
                AggregateComponentSecondPass.addColumns(orderedColumns, property.getValue());
            }
        } else {
            for (int propertyIndex : propertyMappingIndex) {
                AggregateComponentSecondPass.addColumns(orderedColumns, properties.get(propertyIndex).getValue());
            }
        }
        userDefinedType.reorderColumns(orderedColumns);
    }

    private static void addColumns(ArrayList<Column> orderedColumns, Value value) {
        if (value instanceof Component) {
            Component subComponent = (Component)value;
            if (subComponent.getAggregateColumn() == null) {
                for (Property property : subComponent.getProperties()) {
                    AggregateComponentSecondPass.addColumns(orderedColumns, property.getValue());
                }
            } else {
                orderedColumns.add(subComponent.getAggregateColumn());
            }
        } else {
            orderedColumns.addAll(value.getColumns());
        }
    }

    private void validateSupportedColumnTypes(String basePath, Component component) {
        for (Property property : component.getProperties()) {
            BasicType basicType;
            Value value = property.getValue();
            if (value instanceof Component) {
                Component subComponent = (Component)value;
                if (subComponent.getAggregateColumn() != null) continue;
                this.validateSupportedColumnTypes(StringHelper.qualify(basePath, property.getName()), subComponent);
                continue;
            }
            if (!(value instanceof BasicValue) || !((basicType = (BasicType)value.getType()) instanceof BasicPluralType)) continue;
            throw new AnnotationException("Property '" + StringHelper.qualify(basePath, property.getName()) + "' uses not yet supported array mapping type in component class '" + component.getComponentClassName() + "'. Aggregate components currently may only contain simple basic values and components of simple basic values.");
        }
    }

    private static void ensureInitialized(InFlightMetadataCollector metadataCollector, TypeConfiguration typeConfiguration, Dialect dialect, AggregateColumn aggregateColumn) {
        do {
            aggregateColumn.getValue().getType();
            aggregateColumn.getSqlTypeCode(metadataCollector);
            aggregateColumn.getSqlType(metadataCollector);
        } while ((aggregateColumn = aggregateColumn.getComponent().getParentAggregateColumn()) != null);
    }

    private void validateEqual(UserDefinedType udt1, UserDefinedType udt2) {
        if (udt1.getColumnSpan() != udt2.getColumnSpan()) {
            throw new MappingException(String.format("Struct [%s] is defined by multiple components %s with different number of mappings %d and %d", udt1.getName(), this.findComponentClasses(), udt1.getColumnSpan(), udt2.getColumnSpan()));
        }
        ArrayList<Column> missingColumns = new ArrayList<Column>();
        for (Column column1 : udt1.getColumns()) {
            Column column2 = udt2.getColumn(column1);
            if (column2 == null) {
                missingColumns.add(column1);
                continue;
            }
            if (column1.getSqlType().equals(column2.getSqlType())) continue;
            throw new MappingException(String.format("Struct [%s] of class [%s] is defined by multiple components with different mappings [%s] and [%s] for column [%s]", udt1.getName(), this.returnedClassOrElement.getName(), column1.getSqlType(), column2.getSqlType(), column1.getCanonicalName()));
        }
        if (!missingColumns.isEmpty()) {
            throw new MappingException(String.format("Struct [%s] is defined by multiple components %s but some columns are missing in [%s]: %s", udt1.getName(), this.findComponentClasses(), this.returnedClassOrElement.getName(), missingColumns));
        }
    }

    private TreeSet<String> findComponentClasses() {
        TreeSet<String> componentClasses = new TreeSet<String>();
        this.context.getMetadataCollector().visitRegisteredComponents(c -> {
            if (this.component.getStructName().equals(c.getStructName())) {
                componentClasses.add(c.getComponentClassName());
            }
        });
        return componentClasses;
    }
}

