/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal;

import java.io.Serializable;
import java.util.Objects;
import org.hibernate.Internal;
import org.hibernate.type.Type;

@Internal
public final class CacheKeyImplementation
implements Serializable {
    private final Object id;
    private final String entityOrRoleName;
    private final String tenantId;
    private final int hashCode;
    private final boolean requiresDeepEquals;

    @Internal
    public CacheKeyImplementation(Object id, Serializable disassembledKey, Type type, String entityOrRoleName, String tenantId) {
        assert (entityOrRoleName != null);
        this.id = disassembledKey;
        this.entityOrRoleName = entityOrRoleName;
        this.tenantId = tenantId;
        this.hashCode = CacheKeyImplementation.calculateHashCode(id, type, tenantId);
        this.requiresDeepEquals = disassembledKey.getClass().isArray();
    }

    private static int calculateHashCode(Object id, Type type, String tenantId) {
        int result = type.getHashCode(id);
        result = 31 * result + (tenantId != null ? tenantId.hashCode() : 0);
        return result;
    }

    public Object getId() {
        return this.id;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other.getClass() != CacheKeyImplementation.class) {
            return false;
        }
        CacheKeyImplementation o = (CacheKeyImplementation)other;
        if (this.requiresDeepEquals) {
            return this.hashCode == o.hashCode && this.entityOrRoleName.equals(o.entityOrRoleName) && Objects.equals(this.tenantId, o.tenantId) && Objects.deepEquals(this.id, o.id);
        }
        return this.id.equals(o.id) && this.entityOrRoleName.equals(o.entityOrRoleName) && (this.tenantId != null ? this.tenantId.equals(o.tenantId) : o.tenantId == null);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.entityOrRoleName + "#" + this.id.toString();
    }
}

