/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.mutation.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.hibernate.engine.jdbc.batch.spi.Batch;
import org.hibernate.engine.jdbc.batch.spi.BatchKey;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.OperationResultChecker;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.engine.jdbc.mutation.TableInclusionChecker;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementGroup;
import org.hibernate.engine.jdbc.mutation.internal.AbstractMutationExecutor;
import org.hibernate.engine.jdbc.mutation.internal.JdbcValueBindingsImpl;
import org.hibernate.engine.jdbc.mutation.internal.ModelMutationHelper;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.PreparableMutationOperation;
import org.hibernate.sql.model.SelfExecutingUpdateOperation;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.ValuesAnalysis;
import org.hibernate.sql.model.jdbc.JdbcValueDescriptor;

public class MutationExecutorStandard
extends AbstractMutationExecutor {
    private final MutationOperationGroup mutationOperationGroup;
    private final Batch batch;
    private final PreparedStatementGroup nonBatchedStatementGroup;
    private final List<SelfExecutingUpdateOperation> selfExecutingMutations;
    private final JdbcValueBindingsImpl valueBindings;
    private final Map<String, StatementLocation> statementLocationMap = new HashMap<String, StatementLocation>();

    public MutationExecutorStandard(MutationOperationGroup mutationOperationGroup, Supplier<BatchKey> batchKeySupplier, int batchSize, SharedSessionContractImplementor session) {
        this.mutationOperationGroup = mutationOperationGroup;
        BatchKey batchKey = batchKeySupplier.get();
        ArrayList<PreparableMutationOperation> batchedJdbcMutations = null;
        ArrayList<PreparableMutationOperation> nonBatchedJdbcMutations = null;
        ArrayList<SelfExecutingUpdateOperation> selfExecutingMutations = null;
        List operations = mutationOperationGroup.getOperations();
        boolean hasAnyNonBatchedJdbcOperations = false;
        for (int i = operations.size() - 1; i >= 0; --i) {
            MutationOperation operation = (MutationOperation)operations.get(i);
            if (operation instanceof SelfExecutingUpdateOperation) {
                SelfExecutingUpdateOperation selfExecutingMutation = (SelfExecutingUpdateOperation)operation;
                if (selfExecutingMutations == null) {
                    selfExecutingMutations = new ArrayList<SelfExecutingUpdateOperation>();
                }
                selfExecutingMutations.add(0, selfExecutingMutation);
                continue;
            }
            PreparableMutationOperation preparableMutationOperation = (PreparableMutationOperation)operation;
            TableMapping tableDetails = operation.getTableDetails();
            boolean canBeBatched = tableDetails.isIdentifierTable() && hasAnyNonBatchedJdbcOperations ? false : preparableMutationOperation.canBeBatched(batchKey, batchSize);
            if (canBeBatched) {
                if (batchedJdbcMutations == null) {
                    batchedJdbcMutations = new ArrayList<PreparableMutationOperation>();
                }
                batchedJdbcMutations.add(0, preparableMutationOperation);
                this.statementLocationMap.put(tableDetails.getTableName(), StatementLocation.BATCHED);
                continue;
            }
            hasAnyNonBatchedJdbcOperations = true;
            if (nonBatchedJdbcMutations == null) {
                nonBatchedJdbcMutations = new ArrayList<PreparableMutationOperation>();
            }
            nonBatchedJdbcMutations.add(0, preparableMutationOperation);
            this.statementLocationMap.put(tableDetails.getTableName(), StatementLocation.NON_BATCHED);
        }
        if (batchedJdbcMutations == null || batchedJdbcMutations.isEmpty()) {
            this.batch = null;
        } else {
            ArrayList<PreparableMutationOperation> batchedMutationsRef = batchedJdbcMutations;
            this.batch = session.getJdbcCoordinator().getBatch(batchKey, batchSize, () -> ModelMutationHelper.toPreparedStatementGroup(mutationOperationGroup.getMutationType(), mutationOperationGroup.getMutationTarget(), batchedMutationsRef, session));
            assert (this.batch != null);
        }
        this.nonBatchedStatementGroup = ModelMutationHelper.toPreparedStatementGroup(mutationOperationGroup.getMutationType(), mutationOperationGroup.getMutationTarget(), nonBatchedJdbcMutations, session);
        this.selfExecutingMutations = selfExecutingMutations;
        this.valueBindings = new JdbcValueBindingsImpl(mutationOperationGroup.getMutationType(), mutationOperationGroup.getMutationTarget(), this::findJdbcValueDescriptor, session);
    }

    @Override
    public JdbcValueBindings getJdbcValueBindings() {
        return this.valueBindings;
    }

    private JdbcValueDescriptor findJdbcValueDescriptor(String tableName, String columnName, ParameterUsage usage) {
        return this.mutationOperationGroup.getOperation(tableName).findValueDescriptor(columnName, usage);
    }

    @Override
    public PreparedStatementDetails getPreparedStatementDetails(String tableName) {
        StatementLocation statementLocation = this.statementLocationMap.get(tableName);
        if (statementLocation == null) {
            return null;
        }
        if (statementLocation == StatementLocation.BATCHED) {
            assert (this.batch != null);
            return this.batch.getStatementGroup().getPreparedStatementDetails(tableName);
        }
        if (statementLocation == StatementLocation.NON_BATCHED) {
            assert (this.nonBatchedStatementGroup != null);
            return this.nonBatchedStatementGroup.getPreparedStatementDetails(tableName);
        }
        return null;
    }

    @Override
    public void release() {
        this.nonBatchedStatementGroup.release();
    }

    @Override
    protected void performNonBatchedOperations(ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, OperationResultChecker resultChecker, SharedSessionContractImplementor session) {
        if (this.nonBatchedStatementGroup == null || this.nonBatchedStatementGroup.getNumberOfStatements() <= 0) {
            return;
        }
        this.nonBatchedStatementGroup.forEachStatement((tableName, statementDetails) -> this.performNonBatchedMutation((PreparedStatementDetails)statementDetails, this.valueBindings, inclusionChecker, resultChecker, session));
    }

    @Override
    protected void performSelfExecutingOperations(ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, SharedSessionContractImplementor session) {
        if (this.selfExecutingMutations == null || this.selfExecutingMutations.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.selfExecutingMutations.size(); ++i) {
            SelfExecutingUpdateOperation operation = this.selfExecutingMutations.get(i);
            if (!inclusionChecker.include(operation.getTableDetails())) continue;
            operation.performMutation(this.valueBindings, valuesAnalysis, session);
        }
    }

    @Override
    protected void performBatchedOperations(ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker) {
        if (this.batch == null) {
            return;
        }
        this.batch.addToBatch(this.valueBindings, inclusionChecker);
    }

    public String toString() {
        return String.format(Locale.ROOT, "MutationExecutorStandard(`%s:%s`)", this.mutationOperationGroup.getMutationType().name(), this.mutationOperationGroup.getMutationTarget().getRolePath());
    }

    private static enum StatementLocation {
        BATCHED,
        NON_BATCHED;

    }
}

