/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import jakarta.persistence.FlushModeType;
import jakarta.persistence.TransactionRequiredException;
import java.util.Set;
import java.util.UUID;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.SharedSessionContract;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.cache.spi.CacheTransactionSynchronization;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.LobCreationContext;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.ExceptionConverter;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.spi.QueryProducerImplementor;
import org.hibernate.resource.jdbc.spi.JdbcSessionOwner;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public interface SharedSessionContractImplementor
extends SharedSessionContract,
JdbcSessionOwner,
TransactionCoordinatorBuilder.Options,
LobCreationContext,
WrapperOptions,
QueryProducerImplementor,
JavaType.CoercionContext {
    @Override
    public SessionFactoryImplementor getFactory();

    @Override
    default public SessionFactoryImplementor getSessionFactory() {
        return this.getFactory();
    }

    @Override
    default public TypeConfiguration getTypeConfiguration() {
        return this.getFactory().getTypeConfiguration();
    }

    public SessionEventListenerManager getEventListenerManager();

    public PersistenceContext getPersistenceContext();

    public JdbcCoordinator getJdbcCoordinator();

    public JdbcServices getJdbcServices();

    public UUID getSessionIdentifier();

    @Override
    default public SharedSessionContractImplementor getSession() {
        return this;
    }

    default public Object getSessionToken() {
        return this;
    }

    public boolean isClosed();

    default public boolean isOpenOrWaitingForAutoClose() {
        return !this.isClosed();
    }

    default public void checkOpen() {
        this.checkOpen(true);
    }

    public void checkOpen(boolean var1);

    public void prepareForQueryExecution(boolean var1);

    public void markForRollbackOnly();

    @Deprecated(forRemoval=true)
    public long getTransactionStartTimestamp();

    public CacheTransactionSynchronization getCacheTransactionSynchronization();

    public boolean isTransactionInProgress();

    default public void checkTransactionNeededForUpdateOperation(String exceptionMessage) {
        if (!this.isTransactionInProgress()) {
            throw new TransactionRequiredException(exceptionMessage);
        }
    }

    public Transaction accessTransaction();

    public EntityKey generateEntityKey(Object var1, EntityPersister var2);

    public Interceptor getInterceptor();

    @Deprecated(since="6")
    public void setAutoClear(boolean var1);

    public void initializeCollection(PersistentCollection<?> var1, boolean var2) throws HibernateException;

    public Object internalLoad(String var1, Object var2, boolean var3, boolean var4) throws HibernateException;

    public Object immediateLoad(String var1, Object var2) throws HibernateException;

    public EntityPersister getEntityPersister(String var1, Object var2) throws HibernateException;

    public Object getEntityUsingInterceptor(EntityKey var1) throws HibernateException;

    public Object getContextEntityIdentifier(Object var1);

    public String bestGuessEntityName(Object var1);

    public String guessEntityName(Object var1) throws HibernateException;

    public Object instantiate(String var1, Object var2) throws HibernateException;

    public Object instantiate(EntityPersister var1, Object var2) throws HibernateException;

    public boolean isDefaultReadOnly();

    @Override
    public CacheMode getCacheMode();

    public void setCacheMode(CacheMode var1);

    public void setCriteriaCopyTreeEnabled(boolean var1);

    public boolean isCriteriaCopyTreeEnabled();

    @Deprecated(since="6")
    public FlushModeType getFlushMode();

    public void setHibernateFlushMode(FlushMode var1);

    @Override
    public FlushMode getHibernateFlushMode();

    public void flush();

    default public boolean isEventSource() {
        return false;
    }

    default public EventSource asEventSource() {
        throw new ClassCastException("session is not an EventSource");
    }

    public void afterScrollOperation();

    @Deprecated(since="6")
    public boolean shouldAutoClose();

    @Deprecated(since="6")
    public boolean isAutoCloseSessionEnabled();

    public LoadQueryInfluencers getLoadQueryInfluencers();

    public ExceptionConverter getExceptionConverter();

    default public Integer getConfiguredJdbcBatchSize() {
        Integer sessionJdbcBatchSize = this.getJdbcBatchSize();
        return sessionJdbcBatchSize == null ? this.getFactory().getSessionFactoryOptions().getJdbcBatchSize() : sessionJdbcBatchSize.intValue();
    }

    public PersistenceContext getPersistenceContextInternal();

    public boolean autoFlushIfRequired(Set<String> var1) throws HibernateException;

    @Deprecated(since="6", forRemoval=true)
    default public boolean isEnforcingFetchGraph() {
        return false;
    }

    @Deprecated(since="6", forRemoval=true)
    default public void setEnforcingFetchGraph(boolean enforcingFetchGraph) {
    }

    public void afterOperation(boolean var1);

    default public SessionImplementor asSessionImplementor() {
        throw new ClassCastException("session is not a SessionImplementor");
    }

    default public boolean isSessionImplementor() {
        return false;
    }

    default public StatelessSession asStatelessSession() {
        throw new ClassCastException("session is not a StatelessSession");
    }

    default public boolean isStatelessSession() {
        return false;
    }
}

