/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.generator.internal;

import java.lang.reflect.Member;
import java.util.EnumSet;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.CurrentTimestamp;
import org.hibernate.annotations.SourceType;
import org.hibernate.annotations.UpdateTimestamp;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.generator.EventTypeSets;
import org.hibernate.generator.GeneratorCreationContext;
import org.hibernate.generator.OnExecutionGenerator;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.tuple.GenerationTiming;
import org.hibernate.tuple.TimestampGenerators;
import org.hibernate.tuple.ValueGenerator;

public class CurrentTimestampGeneration
implements BeforeExecutionGenerator,
OnExecutionGenerator {
    private final EnumSet<EventType> eventTypes;
    private final ValueGenerator<?> generator;

    public CurrentTimestampGeneration(CurrentTimestamp annotation, Member member, GeneratorCreationContext context) {
        this.generator = CurrentTimestampGeneration.getGenerator(annotation.source(), member);
        this.eventTypes = annotation.timing() == GenerationTiming.ALWAYS ? EventTypeSets.fromArray(annotation.event()) : annotation.timing().getEquivalent().eventTypes();
    }

    public CurrentTimestampGeneration(CreationTimestamp annotation, Member member, GeneratorCreationContext context) {
        this.generator = CurrentTimestampGeneration.getGenerator(annotation.source(), member);
        this.eventTypes = EventTypeSets.INSERT_ONLY;
    }

    public CurrentTimestampGeneration(UpdateTimestamp annotation, Member member, GeneratorCreationContext context) {
        this.generator = CurrentTimestampGeneration.getGenerator(annotation.source(), member);
        this.eventTypes = EventTypeSets.INSERT_AND_UPDATE;
    }

    private static ValueGenerator<?> getGenerator(SourceType source, Member member) {
        switch (source) {
            case VM: {
                return TimestampGenerators.get(ReflectHelper.getPropertyType(member));
            }
            case DB: {
                return null;
            }
        }
        throw new AssertionFailure("unknown source");
    }

    @Override
    public boolean generatedOnExecution() {
        return this.generator == null;
    }

    @Override
    public EnumSet<EventType> getEventTypes() {
        return this.eventTypes;
    }

    @Override
    public Object generate(SharedSessionContractImplementor session, Object owner, Object currentValue, EventType eventType) {
        return this.generator.generateValue(session.asSessionImplementor(), owner, currentValue);
    }

    @Override
    public boolean writePropertyValue() {
        return false;
    }

    @Override
    public boolean referenceColumnsInSql(Dialect dialect) {
        return true;
    }

    @Override
    public String[] getReferencedColumnValues(Dialect dialect) {
        return new String[]{dialect.currentTimestamp()};
    }
}

