/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.insert;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.insert.AbstractSelectingDelegate;
import org.hibernate.id.insert.IdentifierGeneratingInsert;
import org.hibernate.jdbc.Expectation;
import org.hibernate.metamodel.mapping.BasicEntityIdentifierMapping;
import org.hibernate.sql.model.ast.builder.TableInsertBuilder;
import org.hibernate.sql.model.ast.builder.TableInsertBuilderStandard;
import org.hibernate.type.Type;

public class UniqueKeySelectingDelegate
extends AbstractSelectingDelegate {
    private final PostInsertIdentityPersister persister;
    private final Dialect dialect;
    private final String[] uniqueKeyPropertyNames;
    private final Type[] uniqueKeyTypes;
    private final String idSelectString;

    public UniqueKeySelectingDelegate(PostInsertIdentityPersister persister, Dialect dialect, String[] uniqueKeyPropertyNames) {
        super(persister);
        this.persister = persister;
        this.dialect = dialect;
        this.uniqueKeyPropertyNames = uniqueKeyPropertyNames;
        this.idSelectString = persister.getSelectByUniqueKeyString(uniqueKeyPropertyNames);
        this.uniqueKeyTypes = new Type[uniqueKeyPropertyNames.length];
        for (int i = 0; i < uniqueKeyPropertyNames.length; ++i) {
            this.uniqueKeyTypes[i] = persister.getPropertyType(uniqueKeyPropertyNames[i]);
        }
    }

    @Override
    protected String getSelectSQL() {
        return this.idSelectString;
    }

    @Override
    @Deprecated
    public IdentifierGeneratingInsert prepareIdentifierGeneratingInsert(SqlStringGenerationContext context) {
        return new IdentifierGeneratingInsert(this.dialect);
    }

    @Override
    public TableInsertBuilder createTableInsertBuilder(BasicEntityIdentifierMapping identifierMapping, Expectation expectation, SessionFactoryImplementor factory) {
        return new TableInsertBuilderStandard(this.persister, this.persister.getIdentifierTableMapping(), factory);
    }

    @Override
    protected void bindParameters(Object entity, PreparedStatement ps, SharedSessionContractImplementor session) throws SQLException {
        int index = 1;
        for (int i = 0; i < this.uniqueKeyPropertyNames.length; ++i) {
            this.uniqueKeyTypes[i].nullSafeSet(ps, this.persister.getPropertyValue(entity, this.uniqueKeyPropertyNames[i]), index, session);
            index += this.uniqueKeyTypes[i].getColumnSpan(session.getFactory());
        }
    }
}

