/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import java.util.Arrays;

public class EmbeddableHelper {
    public static int[] determinePropertyMappingIndex(String[] propertyNames, String[] componentNames) {
        int[] index = new int[propertyNames.length];
        int i = 0;
        for (String componentName : componentNames) {
            int mappingIndex = Arrays.binarySearch(propertyNames, componentName);
            if (mappingIndex == -1) continue;
            index[i++] = mappingIndex;
        }
        return index;
    }

    public static boolean resolveIndex(String[] sortedComponentNames, String[] componentNames, int[] index) {
        boolean hasGaps = false;
        for (int i = 0; i < componentNames.length; ++i) {
            int newIndex;
            index[i] = newIndex = Arrays.binarySearch(sortedComponentNames, componentNames[i]);
            hasGaps = hasGaps || newIndex < 0;
        }
        return hasGaps;
    }
}

