/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.Locale;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Selectable;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.metamodel.mapping.internal.SqlTypedMappingImpl;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class SelectableMappingImpl
extends SqlTypedMappingImpl
implements SelectableMapping {
    private final String containingTableExpression;
    private final String selectionExpression;
    private final SelectablePath selectablePath;
    private final String customReadExpression;
    private final String customWriteExpression;
    private final boolean nullable;
    private final boolean insertable;
    private final boolean updateable;
    private final boolean partitioned;
    private final boolean isFormula;

    public SelectableMappingImpl(String containingTableExpression, String selectionExpression, SelectablePath selectablePath, String customReadExpression, String customWriteExpression, String columnDefinition, Long length, Integer precision, Integer scale, boolean nullable, boolean insertable, boolean updateable, boolean partitioned, boolean isFormula, JdbcMapping jdbcMapping) {
        super(columnDefinition, length, precision, scale, jdbcMapping);
        assert (selectionExpression != null);
        this.containingTableExpression = containingTableExpression == null ? null : containingTableExpression.intern();
        this.selectionExpression = selectionExpression.intern();
        this.selectablePath = selectablePath == null ? new SelectablePath(selectionExpression) : selectablePath;
        this.customReadExpression = customReadExpression == null ? null : customReadExpression.intern();
        this.customWriteExpression = customWriteExpression == null || isFormula ? null : customWriteExpression.intern();
        this.nullable = nullable;
        this.insertable = insertable;
        this.updateable = updateable;
        this.partitioned = partitioned;
        this.isFormula = isFormula;
    }

    public static SelectableMapping from(String containingTableExpression, Selectable selectable, JdbcMapping jdbcMapping, TypeConfiguration typeConfiguration, boolean insertable, boolean updateable, boolean partitioned, Dialect dialect, SqmFunctionRegistry sqmFunctionRegistry) {
        return SelectableMappingImpl.from(containingTableExpression, selectable, null, jdbcMapping, typeConfiguration, insertable, updateable, partitioned, dialect, sqmFunctionRegistry);
    }

    public static SelectableMapping from(String containingTableExpression, Selectable selectable, SelectablePath parentPath, JdbcMapping jdbcMapping, TypeConfiguration typeConfiguration, boolean insertable, boolean updateable, boolean partitioned, Dialect dialect, SqmFunctionRegistry sqmFunctionRegistry) {
        return SelectableMappingImpl.from(containingTableExpression, selectable, parentPath, selectable instanceof Column ? ((Column)selectable).getQuotedName(dialect) : selectable.getText(), jdbcMapping, typeConfiguration, insertable, updateable, partitioned, dialect, sqmFunctionRegistry);
    }

    public static SelectableMapping from(String containingTableExpression, Selectable selectable, SelectablePath parentPath, String selectableName, JdbcMapping jdbcMapping, TypeConfiguration typeConfiguration, boolean insertable, boolean updateable, boolean partitioned, Dialect dialect, SqmFunctionRegistry sqmFunctionRegistry) {
        boolean isNullable;
        Integer scale;
        Integer precision;
        Long length;
        String columnDefinition;
        String columnExpression;
        if (selectable.isFormula()) {
            columnExpression = selectable.getTemplate(dialect, typeConfiguration, sqmFunctionRegistry);
            columnDefinition = null;
            length = null;
            precision = null;
            scale = null;
            isNullable = true;
        } else {
            Column column = (Column)selectable;
            columnExpression = selectable.getText(dialect);
            columnDefinition = column.getSqlType();
            length = column.getLength();
            precision = column.getPrecision();
            scale = column.getScale();
            isNullable = column.isNullable();
        }
        return new SelectableMappingImpl(containingTableExpression, columnExpression, parentPath == null ? null : parentPath.append(selectableName), selectable.getCustomReadExpression(), selectable.getWriteExpr(jdbcMapping, dialect), columnDefinition, length, precision, scale, isNullable, insertable, updateable, partitioned, selectable.isFormula(), jdbcMapping);
    }

    public String toString() {
        return String.format(Locale.ROOT, "SelectableMapping(`%s`.`%s`)", this.containingTableExpression, this.selectionExpression);
    }

    @Override
    public String getContainingTableExpression() {
        return this.containingTableExpression;
    }

    @Override
    public String getSelectionExpression() {
        return this.selectionExpression;
    }

    @Override
    public String getSelectableName() {
        return this.selectablePath == null ? null : this.selectablePath.getSelectableName();
    }

    @Override
    public SelectablePath getSelectablePath() {
        return this.selectablePath;
    }

    @Override
    public String getCustomReadExpression() {
        return this.customReadExpression;
    }

    @Override
    public String getCustomWriteExpression() {
        return this.customWriteExpression;
    }

    @Override
    public String getWriteExpression() {
        return this.customWriteExpression;
    }

    @Override
    public boolean isFormula() {
        return this.isFormula;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public boolean isInsertable() {
        return this.insertable;
    }

    @Override
    public boolean isUpdateable() {
        return this.updateable;
    }

    @Override
    public boolean isPartitioned() {
        return this.partitioned;
    }
}

