/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection.mutation;

import java.util.Iterator;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.batch.internal.BasicBatchKey;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.MutationExecutor;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.engine.jdbc.mutation.spi.MutationExecutorService;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.mutation.AbstractUpdateRowsCoordinator;
import org.hibernate.persister.collection.mutation.CollectionMutationTarget;
import org.hibernate.persister.collection.mutation.RowMutationOperations;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.internal.MutationOperationGroupSingle;
import org.hibernate.sql.model.jdbc.JdbcMutationOperation;

public class UpdateRowsCoordinatorOneToMany
extends AbstractUpdateRowsCoordinator {
    private final RowMutationOperations rowMutationOperations;
    private MutationOperationGroupSingle deleteOperationGroup;
    private MutationOperationGroupSingle insertOperationGroup;

    public UpdateRowsCoordinatorOneToMany(CollectionMutationTarget mutationTarget, RowMutationOperations rowMutationOperations, SessionFactoryImplementor sessionFactory) {
        super(mutationTarget, sessionFactory);
        this.rowMutationOperations = rowMutationOperations;
    }

    @Override
    protected int doUpdate(Object key, PersistentCollection<?> collection, SharedSessionContractImplementor session) {
        if (this.rowMutationOperations.hasDeleteRow()) {
            this.deleteRows(key, collection, session);
        }
        if (this.rowMutationOperations.hasInsertRow()) {
            return this.insertRows(key, collection, session);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRows(Object key, PersistentCollection<?> collection, SharedSessionContractImplementor session) {
        MutationOperationGroupSingle operationGroup = this.resolveDeleteGroup();
        PluralAttributeMapping attributeMapping = this.getMutationTarget().getTargetPart();
        CollectionPersister collectionDescriptor = attributeMapping.getCollectionDescriptor();
        MutationExecutorService mutationExecutorService = session.getFactory().getServiceRegistry().getService(MutationExecutorService.class);
        MutationExecutor mutationExecutor = mutationExecutorService.createExecutor(() -> new BasicBatchKey(this.getMutationTarget().getRolePath() + "#UPDATE-DELETE"), operationGroup, session);
        try {
            JdbcValueBindings jdbcValueBindings = mutationExecutor.getJdbcValueBindings();
            Iterator<?> entries = collection.entries(collectionDescriptor);
            int entryPosition = -1;
            while (entries.hasNext()) {
                Object entry = entries.next();
                if (!collection.needsUpdating(entry, ++entryPosition, attributeMapping)) continue;
                this.rowMutationOperations.getDeleteRowRestrictions().applyRestrictions(collection, key, entry, entryPosition, session, (jdbcValue, jdbcValueMapping) -> jdbcValueBindings.bindValue(jdbcValue, jdbcValueMapping, ParameterUsage.RESTRICT));
                mutationExecutor.execute(entry, null, null, null, session);
            }
        }
        finally {
            mutationExecutor.release();
        }
    }

    private MutationOperationGroupSingle resolveDeleteGroup() {
        if (this.deleteOperationGroup == null) {
            JdbcMutationOperation operation = this.rowMutationOperations.getDeleteRowOperation();
            assert (operation != null);
            this.deleteOperationGroup = new MutationOperationGroupSingle(MutationType.DELETE, this.getMutationTarget(), operation);
        }
        return this.deleteOperationGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int insertRows(Object key, PersistentCollection<?> collection, SharedSessionContractImplementor session) {
        MutationOperationGroupSingle operationGroup = this.resolveInsertGroup();
        PluralAttributeMapping attributeMapping = this.getMutationTarget().getTargetPart();
        CollectionPersister collectionDescriptor = attributeMapping.getCollectionDescriptor();
        MutationExecutorService mutationExecutorService = session.getFactory().getServiceRegistry().getService(MutationExecutorService.class);
        MutationExecutor mutationExecutor = mutationExecutorService.createExecutor(() -> new BasicBatchKey(this.getMutationTarget().getRolePath() + "#UPDATE-INSERT"), operationGroup, session);
        try {
            JdbcValueBindings jdbcValueBindings = mutationExecutor.getJdbcValueBindings();
            Iterator<?> entries = collection.entries(collectionDescriptor);
            int entryPosition = -1;
            while (entries.hasNext()) {
                Object entry = entries.next();
                if (!collection.needsUpdating(entry, ++entryPosition, attributeMapping)) continue;
                this.rowMutationOperations.getInsertRowValues().applyValues(collection, key, entry, entryPosition, session, (jdbcValue, jdbcValueMapping, usage) -> jdbcValueBindings.bindValue(jdbcValue, jdbcValueMapping, usage));
                mutationExecutor.execute(entry, null, null, null, session);
            }
            int n = entryPosition;
            return n;
        }
        finally {
            mutationExecutor.release();
        }
    }

    private MutationOperationGroupSingle resolveInsertGroup() {
        if (this.insertOperationGroup == null) {
            JdbcMutationOperation operation = this.rowMutationOperations.getInsertRowOperation();
            assert (operation != null);
            this.insertOperationGroup = new MutationOperationGroupSingle(MutationType.INSERT, this.getMutationTarget(), operation);
        }
        return this.insertOperationGroup;
    }
}

