/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.function.Consumer;
import org.hibernate.Incubating;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.persister.internal.EmptyAttributeMappingsMap;
import org.hibernate.persister.internal.ImmutableAttributeMappingsMap;

@Incubating
public interface AttributeMappingsMap {
    public void forEachValue(Consumer<? super AttributeMapping> var1);

    public int size();

    public AttributeMapping get(String var1);

    public Iterable<AttributeMapping> valueIterator();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private LinkedHashMap<String, AttributeMapping> storage;

        private Builder() {
        }

        public void put(String name, AttributeMapping mapping) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(mapping);
            if (this.storage == null) {
                this.storage = new LinkedHashMap();
            }
            this.storage.put(name, mapping);
        }

        public AttributeMappingsMap build() {
            if (this.storage == null) {
                return EmptyAttributeMappingsMap.INSTANCE;
            }
            return new ImmutableAttributeMappingsMap(this.storage);
        }
    }
}

