/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity.mutation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.jdbc.batch.internal.BasicBatchKey;
import org.hibernate.engine.jdbc.batch.spi.BatchKey;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.MutationExecutor;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.engine.jdbc.mutation.internal.ModelMutationHelper;
import org.hibernate.engine.jdbc.mutation.internal.MutationQueryOptions;
import org.hibernate.engine.jdbc.mutation.spi.MutationExecutorService;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.generator.Generator;
import org.hibernate.generator.OnExecutionGenerator;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.EntityRowIdMapping;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SingularAttributeMapping;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.AttributeMappingsList;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.mutation.AbstractMutationCoordinator;
import org.hibernate.persister.entity.mutation.AttributeAnalysis;
import org.hibernate.persister.entity.mutation.EntityTableMapping;
import org.hibernate.persister.entity.mutation.UpdateCoordinator;
import org.hibernate.persister.entity.mutation.UpdateValuesAnalysis;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.ast.MutatingTableReference;
import org.hibernate.sql.model.ast.builder.MutationGroupBuilder;
import org.hibernate.sql.model.ast.builder.TableUpdateBuilder;
import org.hibernate.sql.model.ast.builder.TableUpdateBuilderSkipped;
import org.hibernate.sql.model.ast.builder.TableUpdateBuilderStandard;
import org.hibernate.sql.model.internal.MutationOperationGroupSingle;
import org.hibernate.sql.model.jdbc.JdbcMutationOperation;
import org.hibernate.tuple.entity.EntityMetamodel;

public class UpdateCoordinatorStandard
extends AbstractMutationCoordinator
implements UpdateCoordinator {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(AbstractEntityPersister.class);
    private final MutationOperationGroup staticUpdateGroup = this.buildStaticUpdateGroup();
    private final BatchKey batchKey;
    private final MutationOperationGroup versionUpdateGroup = this.buildVersionUpdateGroup();

    public UpdateCoordinatorStandard(AbstractEntityPersister entityPersister, SessionFactoryImplementor factory) {
        super(entityPersister, factory);
        this.batchKey = new BasicBatchKey(entityPersister.getEntityName() + "#UPDATE", null);
    }

    @Override
    public MutationOperationGroup getStaticUpdateGroup() {
        return this.staticUpdateGroup;
    }

    protected MutationOperationGroup getVersionUpdateGroup() {
        return this.versionUpdateGroup;
    }

    protected BatchKey getBatchKey() {
        return this.batchKey;
    }

    public final boolean isModifiableEntity(EntityEntry entry) {
        return entry == null ? this.entityPersister().isMutable() : entry.isModifiableEntity();
    }

    @Override
    public void forceVersionIncrement(Object id, Object currentVersion, Object nextVersion, SharedSessionContractImplementor session) {
        if (this.versionUpdateGroup == null) {
            throw new HibernateException("Cannot force version increment relative to sub-type; use the root type");
        }
        this.doVersionUpdate(null, id, nextVersion, currentVersion, session);
    }

    @Override
    public void coordinateUpdate(Object entity, Object id, Object rowId, Object[] values, Object oldVersion, Object[] incomingOldValues, int[] incomingDirtyAttributeIndexes, boolean hasDirtyCollection, SharedSessionContractImplementor session) {
        boolean forceDynamicUpdate;
        boolean[] attributeUpdateability;
        boolean isForcedVersionIncrement;
        EntityVersionMapping versionMapping = this.entityPersister().getVersionMapping();
        if (versionMapping != null && (isForcedVersionIncrement = this.handlePotentialImplicitForcedVersionIncrement(entity, id, values, oldVersion, incomingDirtyAttributeIndexes, session, versionMapping))) {
            return;
        }
        EntityEntry entry = session.getPersistenceContextInternal().getEntry(entity);
        if (entry == null && !this.entityPersister().isMutable()) {
            throw new IllegalStateException("Updating immutable entity that is not in session yet");
        }
        int[] preUpdateGeneratedAttributeIndexes = this.preUpdateInMemoryValueGeneration(entity, values, session);
        int[] dirtyAttributeIndexes = UpdateCoordinatorStandard.dirtyAttributeIndexes(incomingDirtyAttributeIndexes, preUpdateGeneratedAttributeIndexes);
        if (this.entityPersister().getEntityMetamodel().isDynamicUpdate() && dirtyAttributeIndexes != null) {
            attributeUpdateability = this.getPropertiesToUpdate(dirtyAttributeIndexes, hasDirtyCollection);
            forceDynamicUpdate = true;
        } else if (!this.isModifiableEntity(entry)) {
            attributeUpdateability = this.getPropertiesToUpdate(dirtyAttributeIndexes == null ? ArrayHelper.EMPTY_INT_ARRAY : dirtyAttributeIndexes, hasDirtyCollection);
            forceDynamicUpdate = true;
        } else if (dirtyAttributeIndexes != null && this.entityPersister().hasUninitializedLazyProperties(entity) && this.entityPersister().hasLazyDirtyFields(dirtyAttributeIndexes)) {
            forceDynamicUpdate = true;
            attributeUpdateability = this.getPropertiesToUpdate(dirtyAttributeIndexes, hasDirtyCollection);
            boolean[] propertyLaziness = this.entityPersister().getPropertyLaziness();
            for (int i = 0; i < propertyLaziness.length; ++i) {
                if (propertyLaziness[i]) continue;
                attributeUpdateability[i] = true;
            }
        } else {
            attributeUpdateability = this.getPropertyUpdateability(entity);
            forceDynamicUpdate = this.entityPersister().hasUninitializedLazyProperties(entity);
        }
        this.performUpdate(entity, id, rowId, values, oldVersion, incomingOldValues, hasDirtyCollection, session, versionMapping, dirtyAttributeIndexes, attributeUpdateability, forceDynamicUpdate);
    }

    private void performUpdate(Object entity, Object id, Object rowId, Object[] values, Object oldVersion, Object[] incomingOldValues, boolean hasDirtyCollection, SharedSessionContractImplementor session, EntityVersionMapping versionMapping, int[] dirtyAttributeIndexes, boolean[] attributeUpdateability, boolean forceDynamicUpdate) {
        InclusionChecker dirtinessChecker = (position, attribute) -> UpdateCoordinatorStandard.isDirty(hasDirtyCollection, versionMapping, dirtyAttributeIndexes, attributeUpdateability, position, attribute, this.entityPersister());
        InclusionChecker lockingChecker = (position, attribute) -> UpdateCoordinatorStandard.includedInLock(versionMapping, dirtinessChecker, position, attribute, this.entityPersister());
        InclusionChecker inclusionChecker = (position, attribute) -> this.isValueGenerationInSql(attribute.getGenerator(), this.dialect()) || attributeUpdateability[position];
        UpdateValuesAnalysisImpl valuesAnalysis = this.analyzeUpdateValues(values, oldVersion, incomingOldValues, dirtyAttributeIndexes, inclusionChecker, lockingChecker, dirtinessChecker, forceDynamicUpdate, session);
        if (!valuesAnalysis.tablesNeedingUpdate.isEmpty()) {
            if (valuesAnalysis.needsDynamicUpdate()) {
                this.doDynamicUpdate(entity, id, rowId, values, incomingOldValues, dirtinessChecker, valuesAnalysis, session);
            } else {
                this.doStaticUpdate(entity, id, rowId, values, incomingOldValues, valuesAnalysis, session);
            }
        }
    }

    private static int[] dirtyAttributeIndexes(int[] incomingDirtyIndexes, int[] preUpdateGeneratedIndexes) {
        if (preUpdateGeneratedIndexes.length == 0) {
            return incomingDirtyIndexes;
        }
        return incomingDirtyIndexes == null ? preUpdateGeneratedIndexes : ArrayHelper.join(incomingDirtyIndexes, preUpdateGeneratedIndexes);
    }

    private static boolean isDirty(boolean hasDirtyCollection, EntityVersionMapping versionMapping, int[] dirtyAttributeIndexes, boolean[] attributeUpdateability, int position, SingularAttributeMapping attribute, EntityPersister persister) {
        if (!attributeUpdateability[position]) {
            return false;
        }
        if (versionMapping != null && versionMapping.getVersionAttribute() == attribute) {
            return Versioning.isVersionIncrementRequired(dirtyAttributeIndexes, hasDirtyCollection, persister.getPropertyVersionability());
        }
        if (dirtyAttributeIndexes == null) {
            return true;
        }
        return ArrayHelper.contains(dirtyAttributeIndexes, position);
    }

    private static boolean includedInLock(EntityVersionMapping versionMapping, InclusionChecker dirtinessChecker, int position, SingularAttributeMapping attribute, EntityPersister persister) {
        switch (persister.optimisticLockStyle()) {
            case NONE: {
                return false;
            }
            case VERSION: {
                return versionMapping != null && versionMapping.getVersionAttribute() == attribute;
            }
            case ALL: {
                return attribute.getAttributeMetadata().isIncludedInOptimisticLocking();
            }
            case DIRTY: {
                return attribute.getAttributeMetadata().isIncludedInOptimisticLocking() && dirtinessChecker.include(position, attribute);
            }
        }
        throw new AssertionFailure("unknown OptimisticLockStyle");
    }

    private boolean handlePotentialImplicitForcedVersionIncrement(Object entity, Object id, Object[] values, Object oldVersion, int[] incomingDirtyAttributeIndexes, SharedSessionContractImplementor session, EntityVersionMapping versionMapping) {
        Object newVersion;
        boolean isSimpleVersionUpdate;
        if (incomingDirtyAttributeIndexes != null) {
            if (incomingDirtyAttributeIndexes.length == 1 && versionMapping.getVersionAttribute() == this.entityPersister().getAttributeMapping(incomingDirtyAttributeIndexes[0])) {
                isSimpleVersionUpdate = true;
                newVersion = values[incomingDirtyAttributeIndexes[0]];
            } else if (incomingDirtyAttributeIndexes.length == 0 && oldVersion != null) {
                isSimpleVersionUpdate = !versionMapping.areEqual(values[versionMapping.getVersionAttribute().getStateArrayPosition()], oldVersion, session);
                newVersion = values[versionMapping.getVersionAttribute().getStateArrayPosition()];
            } else {
                isSimpleVersionUpdate = false;
                newVersion = null;
            }
        } else {
            isSimpleVersionUpdate = false;
            newVersion = null;
        }
        if (isSimpleVersionUpdate) {
            assert (newVersion != null);
            this.doVersionUpdate(entity, id, newVersion, oldVersion, session);
            return true;
        }
        return false;
    }

    private boolean isValueGenerationInSql(Generator generator, Dialect dialect) {
        return generator != null && generator.generatesOnUpdate() && generator.generatedOnExecution() && ((OnExecutionGenerator)generator).referenceColumnsInSql(dialect);
    }

    private boolean isValueGenerationInSqlNoWrite(Generator generator, Dialect dialect) {
        return generator != null && generator.generatesOnUpdate() && generator.generatedOnExecution() && ((OnExecutionGenerator)generator).referenceColumnsInSql(dialect) && !((OnExecutionGenerator)generator).writePropertyValue();
    }

    public boolean[] getPropertyUpdateability(Object entity) {
        return this.entityPersister().hasUninitializedLazyProperties(entity) ? this.entityPersister().getNonLazyPropertyUpdateability() : this.entityPersister().getPropertyUpdateability();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doVersionUpdate(Object entity, Object id, Object version, Object oldVersion, SharedSessionContractImplementor session) {
        assert (this.versionUpdateGroup != null);
        EntityTableMapping mutatingTableDetails = (EntityTableMapping)this.versionUpdateGroup.getSingleOperation().getTableDetails();
        MutationExecutor mutationExecutor = this.executor(session, this.versionUpdateGroup);
        EntityVersionMapping versionMapping = this.entityPersister().getVersionMapping();
        mutationExecutor.getJdbcValueBindings().bindValue(version, mutatingTableDetails.getTableName(), versionMapping.getSelectionExpression(), ParameterUsage.SET);
        mutatingTableDetails.getKeyMapping().breakDownKeyJdbcValues(id, (jdbcValue, columnMapping) -> mutationExecutor.getJdbcValueBindings().bindValue(jdbcValue, mutatingTableDetails.getTableName(), columnMapping.getColumnName(), ParameterUsage.RESTRICT), session);
        mutationExecutor.getJdbcValueBindings().bindValue(oldVersion, mutatingTableDetails.getTableName(), versionMapping.getSelectionExpression(), ParameterUsage.RESTRICT);
        try {
            mutationExecutor.execute(entity, null, tableMapping -> tableMapping.getTableName().equals(this.entityPersister().getIdentifierTableName()), (statementDetails, affectedRowCount, batchPosition) -> ModelMutationHelper.identifiedResultsCheck(statementDetails, affectedRowCount, batchPosition, this.entityPersister(), id, this.factory()), session);
        }
        finally {
            mutationExecutor.release();
        }
    }

    private int[] preUpdateInMemoryValueGeneration(Object object, Object[] newValues, SharedSessionContractImplementor session) {
        EntityMetamodel entityMetamodel = this.entityPersister().getEntityMetamodel();
        if (!entityMetamodel.hasPreUpdateGeneratedValues()) {
            return ArrayHelper.EMPTY_INT_ARRAY;
        }
        Generator[] generators = entityMetamodel.getGenerators();
        if (generators.length != 0) {
            int[] fieldsPreUpdateNeeded = new int[generators.length];
            int count = 0;
            for (int i = 0; i < generators.length; ++i) {
                Generator generator = generators[i];
                if (generator == null || generator.generatedOnExecution() || !generator.generatesOnUpdate()) continue;
                newValues[i] = ((BeforeExecutionGenerator)generator).generate(session, object, newValues[i], EventType.UPDATE);
                this.entityPersister().setPropertyValue(object, i, newValues[i]);
                fieldsPreUpdateNeeded[count++] = i;
            }
            if (count > 0) {
                return ArrayHelper.trim(fieldsPreUpdateNeeded, count);
            }
        }
        return ArrayHelper.EMPTY_INT_ARRAY;
    }

    private boolean[] getPropertiesToUpdate(int[] dirtyProperties, boolean hasDirtyCollection) {
        boolean[] updateability = this.entityPersister().getPropertyUpdateability();
        if (dirtyProperties == null) {
            return updateability;
        }
        boolean[] propsToUpdate = new boolean[this.entityPersister().getNumberOfAttributeMappings()];
        for (int property : dirtyProperties) {
            if (!updateability[property]) continue;
            propsToUpdate[property] = true;
        }
        if (this.entityPersister().isVersioned() && this.entityPersister().getVersionMapping().getVersionAttribute().isUpdateable()) {
            int versionAttributeIndex = this.entityPersister().getVersionMapping().getVersionAttribute().getStateArrayPosition();
            propsToUpdate[versionAttributeIndex] = propsToUpdate[versionAttributeIndex] || Versioning.isVersionIncrementRequired(dirtyProperties, hasDirtyCollection, this.entityPersister().getPropertyVersionability());
        }
        return propsToUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateValuesAnalysisImpl analyzeUpdateValues(Object[] values, Object oldVersion, Object[] oldValues, int[] dirtyAttributeIndexes, InclusionChecker inclusionChecker, InclusionChecker lockingChecker, InclusionChecker dirtinessChecker, boolean forceDynamicUpdate, SharedSessionContractImplementor session) {
        AbstractEntityPersister persister = this.entityPersister();
        AttributeMappingsList attributeMappings = persister.getAttributeMappings();
        UpdateValuesAnalysisImpl analysis = new UpdateValuesAnalysisImpl(values, oldValues, dirtyAttributeIndexes, dirtinessChecker, forceDynamicUpdate);
        boolean[] propertyUpdateability = persister.getPropertyUpdateability();
        for (int attributeIndex = 0; attributeIndex < attributeMappings.size(); ++attributeIndex) {
            AttributeMapping attributeMapping = attributeMappings.get(attributeIndex);
            analysis.startingAttribute(attributeMapping);
            try {
                if (attributeMapping.getJdbcTypeCount() <= 0 || !(attributeMapping instanceof SingularAttributeMapping)) continue;
                SingularAttributeMapping asSingularAttributeMapping = (SingularAttributeMapping)attributeMapping;
                this.processAttribute(analysis, attributeIndex, asSingularAttributeMapping, oldVersion, oldValues, inclusionChecker, lockingChecker, session);
                if (analysis.currentAttributeAnalysis.getDirtynessStatus() != AttributeAnalysis.DirtynessStatus.DIRTY || propertyUpdateability[attributeIndex]) continue;
                LOG.ignoreImmutablePropertyModification(attributeMapping.getAttributeName(), persister.getEntityName());
                continue;
            }
            finally {
                analysis.finishedAttribute(attributeMapping);
            }
        }
        return analysis;
    }

    private void processAttribute(UpdateValuesAnalysisImpl analysis, int attributeIndex, SingularAttributeMapping attributeMapping, Object oldVersion, Object[] oldValues, InclusionChecker inclusionChecker, InclusionChecker lockingChecker, SharedSessionContractImplementor session) {
        if (inclusionChecker.include(attributeIndex, attributeMapping)) {
            int jdbcTypeCount = attributeMapping.getJdbcTypeCount();
            for (int i = 0; i < jdbcTypeCount; ++i) {
                this.processSet(analysis, attributeMapping.getSelectable(i));
            }
        }
        if (lockingChecker.include(attributeIndex, attributeMapping)) {
            Object attributeLockValue = this.attributeLockValue(attributeIndex, attributeMapping, oldVersion, oldValues);
            this.processLock(analysis, attributeMapping, session, attributeLockValue);
        }
    }

    private Object attributeLockValue(int attributeIndex, SingularAttributeMapping attributeMapping, Object oldVersion, Object[] oldValues) {
        if (this.entityPersister().getVersionMapping() != null && this.entityPersister().getVersionMapping().getVersionAttribute() == attributeMapping) {
            return oldVersion;
        }
        return oldValues == null ? null : oldValues[attributeIndex];
    }

    private void processSet(UpdateValuesAnalysisImpl analysis, SelectableMapping selectable) {
        if (selectable != null && !selectable.isFormula() && selectable.isUpdateable()) {
            EntityTableMapping tableMapping = this.entityPersister().getPhysicalTableMappingForMutation(selectable);
            analysis.registerColumnSet(tableMapping, selectable.getSelectionExpression(), selectable.getWriteExpression());
        }
    }

    private void processLock(UpdateValuesAnalysisImpl analysis, SingularAttributeMapping attributeMapping, SharedSessionContractImplementor session, Object attributeLockValue) {
        attributeMapping.decompose(attributeLockValue, (jdbcValue, columnMapping) -> {
            if (!columnMapping.isFormula()) {
                EntityTableMapping tableMapping = this.entityPersister().getPhysicalTableMappingForMutation(columnMapping);
                analysis.registerColumnOptLock(tableMapping, columnMapping.getSelectionExpression(), jdbcValue);
            }
        }, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStaticUpdate(Object entity, Object id, Object rowId, Object[] values, Object[] oldValues, UpdateValuesAnalysisImpl valuesAnalysis, SharedSessionContractImplementor session) {
        MutationExecutor mutationExecutor = this.executor(session, this.staticUpdateGroup);
        this.decomposeForUpdate(id, rowId, values, valuesAnalysis, mutationExecutor, this.staticUpdateGroup, (position, attribute) -> AttributeAnalysis.DirtynessStatus.CONSIDER_LIKE_DIRTY, session);
        this.bindPartitionColumnValueBindings(oldValues, session, mutationExecutor.getJdbcValueBindings());
        try {
            mutationExecutor.execute(entity, valuesAnalysis, valuesAnalysis.tablesNeedingUpdate::contains, (statementDetails, affectedRowCount, batchPosition) -> ModelMutationHelper.identifiedResultsCheck(statementDetails, affectedRowCount, batchPosition, this.entityPersister(), id, this.factory()), session);
        }
        finally {
            mutationExecutor.release();
        }
    }

    protected void decomposeForUpdate(Object id, Object rowId, Object[] values, UpdateValuesAnalysisImpl valuesAnalysis, MutationExecutor mutationExecutor, MutationOperationGroup jdbcOperationGroup, DirtinessChecker dirtinessChecker, SharedSessionContractImplementor session) {
        JdbcValueBindings jdbcValueBindings = mutationExecutor.getJdbcValueBindings();
        jdbcOperationGroup.forEachOperation((position, operation) -> {
            EntityTableMapping tableMapping = (EntityTableMapping)operation.getTableDetails();
            if (valuesAnalysis.tablesNeedingUpdate.contains(tableMapping)) {
                int[] attributeIndexes = tableMapping.getAttributeIndexes();
                for (int i = 0; i < attributeIndexes.length; ++i) {
                    this.decomposeAttributeForUpdate(values, valuesAnalysis, dirtinessChecker, session, jdbcValueBindings, tableMapping, attributeIndexes[i]);
                }
            }
        });
        jdbcOperationGroup.forEachOperation((position, operation) -> {
            EntityTableMapping tableMapping = (EntityTableMapping)operation.getTableDetails();
            this.breakDownKeyJdbcValues(id, rowId, session, jdbcValueBindings, tableMapping);
        });
    }

    private void decomposeAttributeForUpdate(Object[] values, UpdateValuesAnalysisImpl valuesAnalysis, DirtinessChecker dirtinessChecker, SharedSessionContractImplementor session, JdbcValueBindings jdbcValueBindings, EntityTableMapping tableMapping, int attributeIndex) {
        AttributeAnalysis attributeAnalysisRef;
        AttributeMapping attributeMapping = this.entityPersister().getAttributeMappings().get(attributeIndex);
        if (attributeMapping instanceof SingularAttributeMapping && !(attributeAnalysisRef = valuesAnalysis.attributeAnalyses.get(attributeIndex)).isSkipped()) {
            IncludedAttributeAnalysis attributeAnalysis = (IncludedAttributeAnalysis)attributeAnalysisRef;
            if (attributeAnalysis.includeInSet() && this.includeInSet(dirtinessChecker, attributeIndex, attributeMapping, attributeAnalysis)) {
                UpdateCoordinatorStandard.decomposeAttributeMapping(session, jdbcValueBindings, tableMapping, attributeMapping, values[attributeIndex]);
            }
            if (attributeAnalysis.includeInLocking()) {
                UpdateCoordinatorStandard.optimisticLock(session, jdbcValueBindings, tableMapping, attributeAnalysis);
            }
        }
    }

    private static void optimisticLock(SharedSessionContractImplementor session, JdbcValueBindings jdbcValueBindings, EntityTableMapping tableMapping, IncludedAttributeAnalysis attributeAnalysis) {
        attributeAnalysis.columnLockingAnalyses.forEach(columnLockingAnalysis -> {
            if (columnLockingAnalysis.getLockValue() != null) {
                jdbcValueBindings.bindValue(columnLockingAnalysis.getLockValue(), tableMapping.getTableName(), columnLockingAnalysis.getReadExpression(), ParameterUsage.RESTRICT);
            }
        });
    }

    private void breakDownKeyJdbcValues(Object id, Object rowId, SharedSessionContractImplementor session, JdbcValueBindings jdbcValueBindings, EntityTableMapping tableMapping) {
        if (tableMapping.isIdentifierTable() && this.entityPersister().hasRowId() && rowId != null) {
            jdbcValueBindings.bindValue(rowId, tableMapping.getTableName(), this.entityPersister().getRowIdMapping().getRowIdName(), ParameterUsage.RESTRICT);
        } else {
            tableMapping.getKeyMapping().breakDownKeyJdbcValues(id, (jdbcValue, columnMapping) -> jdbcValueBindings.bindValue(jdbcValue, tableMapping.getTableName(), columnMapping.getColumnName(), ParameterUsage.RESTRICT), session);
        }
    }

    private static void decomposeAttributeMapping(SharedSessionContractImplementor session, JdbcValueBindings jdbcValueBindings, EntityTableMapping tableMapping, AttributeMapping attributeMapping, Object values) {
        attributeMapping.decompose(values, (jdbcValue, jdbcMapping) -> {
            if (!jdbcMapping.isFormula() && jdbcMapping.isUpdateable()) {
                jdbcValueBindings.bindValue(jdbcValue, tableMapping.getTableName(), jdbcMapping.getSelectionExpression(), ParameterUsage.SET);
            }
        }, session);
    }

    private boolean includeInSet(DirtinessChecker dirtinessChecker, int attributeIndex, AttributeMapping attributeMapping, IncludedAttributeAnalysis attributeAnalysis) {
        if (this.isValueGenerationInSqlNoWrite(attributeMapping.getGenerator(), this.dialect())) {
            return false;
        }
        if (this.entityPersister().isVersioned() && this.entityPersister().getVersionMapping().getVersionAttribute() == attributeMapping) {
            return true;
        }
        if (this.entityPersister().getEntityMetamodel().isDynamicUpdate() && dirtinessChecker != null) {
            return attributeAnalysis.includeInSet() && dirtinessChecker.isDirty(attributeIndex, attributeMapping).isDirty();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDynamicUpdate(Object entity, Object id, Object rowId, Object[] values, Object[] oldValues, InclusionChecker dirtinessChecker, UpdateValuesAnalysisImpl valuesAnalysis, SharedSessionContractImplementor session) {
        MutationOperationGroup dynamicUpdateGroup = this.generateDynamicUpdateGroup(id, rowId, oldValues, valuesAnalysis, session);
        MutationExecutor mutationExecutor = this.executor(session, dynamicUpdateGroup);
        this.decomposeForUpdate(id, rowId, values, valuesAnalysis, mutationExecutor, dynamicUpdateGroup, (attributeIndex, attribute) -> dirtinessChecker.include(attributeIndex, (SingularAttributeMapping)attribute) ? AttributeAnalysis.DirtynessStatus.CONSIDER_LIKE_DIRTY : AttributeAnalysis.DirtynessStatus.NOT_DIRTY, session);
        this.bindPartitionColumnValueBindings(oldValues, session, mutationExecutor.getJdbcValueBindings());
        try {
            mutationExecutor.execute(entity, valuesAnalysis, tableMapping -> {
                if (tableMapping.isOptional() && !valuesAnalysis.tablesWithNonNullValues.contains(tableMapping)) {
                    return false;
                }
                return valuesAnalysis.tablesNeedingUpdate.contains(tableMapping);
            }, (statementDetails, affectedRowCount, batchPosition) -> ModelMutationHelper.identifiedResultsCheck(statementDetails, affectedRowCount, batchPosition, this.entityPersister(), id, this.factory()), session);
        }
        finally {
            mutationExecutor.release();
        }
    }

    private MutationExecutor executor(SharedSessionContractImplementor session, MutationOperationGroup group) {
        return session.getSessionFactory().getServiceRegistry().getService(MutationExecutorService.class).createExecutor(() -> this.batchKey, group, session);
    }

    protected MutationOperationGroup generateDynamicUpdateGroup(Object id, Object rowId, Object[] oldValues, UpdateValuesAnalysisImpl valuesAnalysis, SharedSessionContractImplementor session) {
        MutationGroupBuilder updateGroupBuilder = new MutationGroupBuilder(MutationType.UPDATE, this.entityPersister());
        this.entityPersister().forEachMutableTable(tableMapping -> {
            MutatingTableReference tableReference = new MutatingTableReference((TableMapping)tableMapping);
            TableUpdateBuilder tableUpdateBuilder = !valuesAnalysis.tablesNeedingUpdate.contains(tableReference.getTableMapping()) ? new TableUpdateBuilderSkipped(tableReference) : this.newTableUpdateBuilder((EntityTableMapping)tableMapping);
            updateGroupBuilder.addTableDetailsBuilder(tableUpdateBuilder);
        });
        this.applyTableUpdateDetails(rowId, updateGroupBuilder, oldValues, valuesAnalysis, (position, attribute) -> valuesAnalysis.getAttributeAnalyses().get(position).getDirtynessStatus(), session);
        return this.createOperationGroup(valuesAnalysis, updateGroupBuilder.buildMutationGroup());
    }

    private <O extends MutationOperation> TableUpdateBuilderStandard<O> newTableUpdateBuilder(EntityTableMapping tableMapping) {
        return new TableUpdateBuilderStandard(this.entityPersister(), tableMapping, this.factory());
    }

    private void applyTableUpdateDetails(Object rowId, MutationGroupBuilder updateGroupBuilder, Object[] oldValues, UpdateValuesAnalysisImpl updateValuesAnalysis, DirtinessChecker dirtinessChecker, SharedSessionContractImplementor session) {
        EntityVersionMapping versionMapping = this.entityPersister().getVersionMapping();
        EntityRowIdMapping rowIdMapping = this.entityPersister().getRowIdMapping();
        AttributeMappingsList attributeMappings = this.entityPersister().getAttributeMappings();
        boolean[] versionability = this.entityPersister().getPropertyVersionability();
        OptimisticLockStyle optimisticLockStyle = this.entityPersister().optimisticLockStyle();
        updateGroupBuilder.forEachTableMutationBuilder(builder -> {
            EntityTableMapping tableMapping = (EntityTableMapping)builder.getMutatingTable().getTableMapping();
            int[] attributeIndexes = tableMapping.getAttributeIndexes();
            for (int i = 0; i < attributeIndexes.length; ++i) {
                boolean includeRestriction;
                int attributeIndex = attributeIndexes[i];
                AttributeMapping attributeMapping = attributeMappings.get(attributeIndex);
                AttributeAnalysis attributeAnalysis = updateValuesAnalysis.attributeAnalyses.get(attributeIndex);
                if (attributeAnalysis.includeInSet()) {
                    assert (updateValuesAnalysis.tablesNeedingUpdate.contains(tableMapping));
                    this.applyAttributeUpdateDetails(updateGroupBuilder, dirtinessChecker, versionMapping, attributeIndex, attributeMapping, (TableUpdateBuilder)builder);
                }
                if (!attributeAnalysis.includeInLocking() || !(includeRestriction = UpdateCoordinatorStandard.includeInRestriction(dirtinessChecker, versionMapping, versionability, optimisticLockStyle, attributeIndex, attributeMapping, attributeAnalysis))) continue;
                UpdateCoordinatorStandard.applyAttributeLockingDetails(oldValues, session, attributeIndex, attributeMapping, (TableUpdateBuilder)builder);
            }
        });
        updateGroupBuilder.forEachTableMutationBuilder(builder -> {
            EntityTableMapping tableMapping = (EntityTableMapping)builder.getMutatingTable().getTableMapping();
            TableUpdateBuilder tableUpdateBuilder = (TableUpdateBuilder)builder;
            UpdateCoordinatorStandard.applyKeyRestriction(rowId, rowIdMapping, tableUpdateBuilder, tableMapping);
            this.applyPartictionKeyRestriction(tableUpdateBuilder);
        });
    }

    private void applyPartictionKeyRestriction(TableUpdateBuilder<?> tableUpdateBuilder) {
        AbstractEntityPersister persister = this.entityPersister();
        if (persister.hasPartitionedSelectionMapping()) {
            for (AttributeMapping attributeMapping : persister.getAttributeMappings()) {
                int jdbcTypeCount = attributeMapping.getJdbcTypeCount();
                for (int i = 0; i < jdbcTypeCount; ++i) {
                    SelectableMapping selectableMapping = attributeMapping.getSelectable(i);
                    if (!selectableMapping.isPartitioned()) continue;
                    tableUpdateBuilder.addKeyRestrictionLeniently(selectableMapping);
                }
            }
        }
    }

    private static void applyKeyRestriction(Object rowId, EntityRowIdMapping rowIdMapping, TableUpdateBuilder<?> tableUpdateBuilder, EntityTableMapping tableMapping) {
        if (rowIdMapping != null && rowId != null && tableMapping.isIdentifierTable()) {
            tableUpdateBuilder.addKeyRestrictionLeniently(rowIdMapping);
        } else {
            tableUpdateBuilder.addKeyRestrictions(tableMapping.getKeyMapping());
        }
    }

    private static void applyAttributeLockingDetails(Object[] oldValues, SharedSessionContractImplementor session, int attributeIndex, AttributeMapping attributeMapping, TableUpdateBuilder<?> tableUpdateBuilder) {
        if (oldValues == null) {
            tableUpdateBuilder.addOptimisticLockRestrictions(attributeMapping);
        } else if (tableUpdateBuilder.getOptimisticLockBindings() != null) {
            attributeMapping.decompose(oldValues[attributeIndex], tableUpdateBuilder.getOptimisticLockBindings(), session);
        }
    }

    private static boolean includeInRestriction(DirtinessChecker dirtinessChecker, EntityVersionMapping versionMapping, boolean[] versionability, OptimisticLockStyle optimisticLockStyle, int attributeIndex, AttributeMapping attributeMapping, AttributeAnalysis attributeAnalysis) {
        if (optimisticLockStyle == OptimisticLockStyle.VERSION && versionMapping != null && attributeMapping == versionMapping.getVersionAttribute()) {
            return true;
        }
        if (optimisticLockStyle == OptimisticLockStyle.ALL) {
            return versionability[attributeIndex];
        }
        if (optimisticLockStyle == OptimisticLockStyle.DIRTY) {
            if (dirtinessChecker == null) {
                return false;
            }
            return versionability[attributeIndex] && attributeAnalysis.includeInLocking() && dirtinessChecker.isDirty(attributeIndex, attributeMapping).isDirty();
        }
        return false;
    }

    private void applyAttributeUpdateDetails(MutationGroupBuilder updateGroupBuilder, DirtinessChecker dirtinessChecker, EntityVersionMapping versionMapping, int attributeIndex, AttributeMapping attributeMapping, TableUpdateBuilder<?> tableUpdateBuilder) {
        Generator generator = attributeMapping.getGenerator();
        if (this.isValueGenerationInSql(generator, this.dialect())) {
            this.handleValueGeneration(attributeMapping, updateGroupBuilder, (OnExecutionGenerator)generator);
        } else if (versionMapping != null && versionMapping.getVersionAttribute() == attributeMapping) {
            tableUpdateBuilder.addValueColumn(versionMapping.getVersionAttribute());
        } else {
            boolean includeInSet;
            boolean bl = includeInSet = !this.entityPersister().getEntityMetamodel().isDynamicUpdate() || dirtinessChecker == null || dirtinessChecker.isDirty(attributeIndex, attributeMapping).isDirty();
            if (includeInSet) {
                attributeMapping.forEachUpdatable(tableUpdateBuilder);
            }
        }
    }

    private MutationOperationGroup buildStaticUpdateGroup() {
        UpdateValuesAnalysisImpl valuesAnalysis = this.analyzeUpdateValues(null, null, null, null, (index, attribute) -> this.isValueGenerationInSql(attribute.getGenerator(), this.dialect()) || this.entityPersister().getPropertyUpdateability()[index], (index, attribute) -> {
            switch (this.entityPersister().optimisticLockStyle()) {
                case ALL: {
                    return true;
                }
                case VERSION: {
                    EntityVersionMapping versionMapping = this.entityPersister().getVersionMapping();
                    return versionMapping != null && attribute == versionMapping.getVersionAttribute();
                }
            }
            return false;
        }, (index, attribute) -> true, false, null);
        MutationGroupBuilder updateGroupBuilder = new MutationGroupBuilder(MutationType.UPDATE, this.entityPersister());
        this.entityPersister().forEachMutableTable(tableMapping -> updateGroupBuilder.addTableDetailsBuilder(this.newTableUpdateBuilder((EntityTableMapping)tableMapping)));
        this.applyTableUpdateDetails("", updateGroupBuilder, null, valuesAnalysis, (position, attribute) -> valuesAnalysis.getAttributeAnalyses().get(position).getDirtynessStatus(), null);
        return this.createOperationGroup(valuesAnalysis, updateGroupBuilder.buildMutationGroup());
    }

    private MutationOperationGroup buildVersionUpdateGroup() {
        EntityVersionMapping versionMapping = this.entityPersister().getVersionMapping();
        if (versionMapping == null || this.entityPersister().getSuperMappingType() != null) {
            return null;
        }
        TableUpdateBuilderStandard<JdbcMutationOperation> updateBuilder = this.newTableUpdateBuilder(this.entityPersister().getIdentifierTableMapping());
        updateBuilder.setSqlComment("forced version increment for " + this.entityPersister().getRolePath());
        updateBuilder.addValueColumn(versionMapping);
        updateBuilder.addKeyRestrictionsLeniently(this.entityPersister().getIdentifierMapping());
        updateBuilder.addOptimisticLockRestriction(versionMapping);
        this.addPartitionRestriction(updateBuilder);
        JdbcMutationOperation jdbcMutation = (JdbcMutationOperation)this.factory().getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildModelMutationTranslator(updateBuilder.buildMutation(), this.factory()).translate(null, MutationQueryOptions.INSTANCE);
        return new MutationOperationGroupSingle(MutationType.UPDATE, this.entityPersister(), jdbcMutation);
    }

    private void addPartitionRestriction(TableUpdateBuilderStandard<JdbcMutationOperation> updateBuilder) {
        AbstractEntityPersister persister = this.entityPersister();
        if (persister.hasPartitionedSelectionMapping()) {
            for (AttributeMapping attributeMapping : persister.getAttributeMappings()) {
                int jdbcTypeCount = attributeMapping.getJdbcTypeCount();
                for (int i = 0; i < jdbcTypeCount; ++i) {
                    SelectableMapping selectableMapping = attributeMapping.getSelectable(i);
                    if (!selectableMapping.isPartitioned()) continue;
                    updateBuilder.addKeyRestrictionLeniently(selectableMapping);
                }
            }
        }
    }

    public String toString() {
        return "UpdateCoordinatorStandard(" + this.entityPersister().getEntityName() + ")";
    }

    @FunctionalInterface
    protected static interface DirtinessChecker {
        public AttributeAnalysis.DirtynessStatus isDirty(int var1, AttributeMapping var2);
    }

    @FunctionalInterface
    protected static interface InclusionChecker {
        public boolean include(int var1, SingularAttributeMapping var2);
    }

    private static class ColumnLockingAnalysis {
        private final String readExpression;
        private final Object lockValue;

        public ColumnLockingAnalysis(String readExpression, Object lockValue) {
            assert (readExpression != null);
            assert (!readExpression.equals("?"));
            this.readExpression = readExpression;
            this.lockValue = lockValue;
        }

        public String getReadExpression() {
            return this.readExpression;
        }

        public Object getLockValue() {
            return this.lockValue;
        }
    }

    private static class ColumnSetAnalysis {
        private final String readExpression;
        private final String writeExpression;

        public ColumnSetAnalysis(String readExpression, String writeExpression) {
            this.readExpression = readExpression;
            this.writeExpression = writeExpression;
        }

        public String getReadExpression() {
            return this.readExpression;
        }

        public String getWriteExpression() {
            return this.writeExpression;
        }
    }

    private static class IncludedAttributeAnalysis
    implements AttributeAnalysisImplementor {
        private final SingularAttributeMapping attribute;
        private final List<ColumnSetAnalysis> columnValueAnalyses;
        private final List<ColumnLockingAnalysis> columnLockingAnalyses;
        private AttributeAnalysis.DirtynessStatus dirty = AttributeAnalysis.DirtynessStatus.NOT_DIRTY;

        public IncludedAttributeAnalysis(SingularAttributeMapping attribute) {
            this.attribute = attribute;
            this.columnValueAnalyses = CollectionHelper.arrayList(attribute.getJdbcTypeCount());
            this.columnLockingAnalyses = CollectionHelper.arrayList(attribute.getJdbcTypeCount());
        }

        @Override
        public SingularAttributeMapping getAttribute() {
            return this.attribute;
        }

        @Override
        public boolean includeInSet() {
            return !this.columnValueAnalyses.isEmpty();
        }

        @Override
        public boolean includeInLocking() {
            return !this.columnLockingAnalyses.isEmpty();
        }

        @Override
        public AttributeAnalysis.DirtynessStatus getDirtynessStatus() {
            return this.dirty;
        }

        @Override
        @Internal
        public void markDirty(boolean certain) {
            if (certain) {
                this.dirty = AttributeAnalysis.DirtynessStatus.DIRTY;
            } else if (this.dirty == AttributeAnalysis.DirtynessStatus.NOT_DIRTY) {
                this.dirty = AttributeAnalysis.DirtynessStatus.CONSIDER_LIKE_DIRTY;
            }
        }

        public String toString() {
            return String.format(Locale.ROOT, "IncludedAttributeAnalysis(`%s`)", this.attribute.getNavigableRole().getFullPath());
        }
    }

    private static class SkippedAttributeAnalysis
    implements AttributeAnalysisImplementor {
        private final AttributeMapping attributeMapping;

        public SkippedAttributeAnalysis(AttributeMapping attributeMapping) {
            this.attributeMapping = attributeMapping;
        }

        @Override
        public AttributeMapping getAttribute() {
            return this.attributeMapping;
        }

        @Override
        public boolean includeInSet() {
            return false;
        }

        @Override
        public boolean includeInLocking() {
            return false;
        }

        @Override
        public AttributeAnalysis.DirtynessStatus getDirtynessStatus() {
            return AttributeAnalysis.DirtynessStatus.NOT_DIRTY;
        }

        @Override
        public void markDirty(boolean certainty) {
        }

        public String toString() {
            return String.format(Locale.ROOT, "SkippedAttributeAnalysis(`%s`)", this.attributeMapping.getNavigableRole().getFullPath());
        }
    }

    private static interface AttributeAnalysisImplementor
    extends AttributeAnalysis {
        public void markDirty(boolean var1);
    }

    protected class UpdateValuesAnalysisImpl
    implements UpdateValuesAnalysis {
        private final Object[] values;
        private final int[] dirtyAttributeIndexes;
        private final InclusionChecker dirtinessChecker;
        private final Set<EntityTableMapping> tablesNeedingUpdate = new HashSet<EntityTableMapping>();
        private final Set<EntityTableMapping> tablesNeedingDynamicUpdate = new HashSet<EntityTableMapping>();
        private final Set<EntityTableMapping> tablesWithNonNullValues = new HashSet<EntityTableMapping>();
        private final Set<EntityTableMapping> tablesWithPreviousNonNullValues = new HashSet<EntityTableMapping>();
        private final List<AttributeAnalysis> attributeAnalyses = new ArrayList<AttributeAnalysis>();
        private AttributeAnalysisImplementor currentAttributeAnalysis;
        private boolean dirtyChecked = false;
        private boolean nullChecked = false;

        public UpdateValuesAnalysisImpl(Object[] values, Object[] oldValues, int[] dirtyAttributeIndexes, InclusionChecker dirtinessChecker, boolean forceDynamicUpdate) {
            this.values = values;
            this.dirtyAttributeIndexes = dirtyAttributeIndexes;
            this.dirtinessChecker = dirtinessChecker;
            UpdateCoordinatorStandard.this.entityPersister().forEachMutableTable(tableMapping -> {
                int attributeIndex;
                int i;
                if (values == null) {
                    this.tablesWithNonNullValues.add((EntityTableMapping)tableMapping);
                } else {
                    for (i = 0; i < tableMapping.getAttributeIndexes().length; ++i) {
                        attributeIndex = tableMapping.getAttributeIndexes()[i];
                        if (values[attributeIndex] == null) continue;
                        this.tablesWithNonNullValues.add((EntityTableMapping)tableMapping);
                        break;
                    }
                }
                if (dirtyAttributeIndexes == null && tableMapping.hasColumns()) {
                    this.tablesNeedingUpdate.add((EntityTableMapping)tableMapping);
                }
                if (oldValues == null) {
                    this.tablesWithPreviousNonNullValues.add((EntityTableMapping)tableMapping);
                } else {
                    for (i = 0; i < tableMapping.getAttributeIndexes().length; ++i) {
                        attributeIndex = tableMapping.getAttributeIndexes()[i];
                        if (oldValues[attributeIndex] == null) continue;
                        this.tablesWithPreviousNonNullValues.add((EntityTableMapping)tableMapping);
                        break;
                    }
                }
                if (tableMapping.getUpdateDetails().getCustomSql() == null) {
                    if (forceDynamicUpdate) {
                        this.tablesNeedingDynamicUpdate.add((EntityTableMapping)tableMapping);
                    } else if (dirtyAttributeIndexes != null && (UpdateCoordinatorStandard.this.entityPersister().getEntityMetamodel().isDynamicUpdate() || UpdateCoordinatorStandard.this.entityPersister().optimisticLockStyle() == OptimisticLockStyle.DIRTY)) {
                        this.tablesNeedingDynamicUpdate.add((EntityTableMapping)tableMapping);
                    }
                }
            });
        }

        @Override
        public Object[] getValues() {
            return this.values;
        }

        @Override
        public Set<EntityTableMapping> getTablesNeedingUpdate() {
            return this.tablesNeedingUpdate;
        }

        @Override
        public Set<EntityTableMapping> getTablesWithNonNullValues() {
            return this.tablesWithNonNullValues;
        }

        @Override
        public Set<EntityTableMapping> getTablesWithPreviousNonNullValues() {
            return this.tablesWithPreviousNonNullValues;
        }

        @Override
        public List<AttributeAnalysis> getAttributeAnalyses() {
            return this.attributeAnalyses;
        }

        public boolean needsDynamicUpdate() {
            return !this.tablesNeedingDynamicUpdate.isEmpty();
        }

        public void startingAttribute(AttributeMapping attribute) {
            if (attribute.getJdbcTypeCount() < 1 || !(attribute instanceof SingularAttributeMapping)) {
                this.currentAttributeAnalysis = new SkippedAttributeAnalysis(attribute);
            } else {
                this.currentAttributeAnalysis = new IncludedAttributeAnalysis((SingularAttributeMapping)attribute);
                if (this.dirtyAttributeIndexes == null || ArrayHelper.contains(this.dirtyAttributeIndexes, attribute.getStateArrayPosition())) {
                    this.currentAttributeAnalysis.markDirty(this.dirtyAttributeIndexes != null);
                }
            }
            this.attributeAnalyses.add(this.currentAttributeAnalysis);
        }

        public void finishedAttribute(AttributeMapping attribute) {
            assert (this.currentAttributeAnalysis.getAttribute() == attribute);
            this.currentAttributeAnalysis = null;
            this.dirtyChecked = false;
            this.nullChecked = false;
        }

        public void registerColumnSet(EntityTableMapping table, String readExpression, String writeExpression) {
            IncludedAttributeAnalysis includedAttributeAnalysis = (IncludedAttributeAnalysis)this.currentAttributeAnalysis;
            includedAttributeAnalysis.columnValueAnalyses.add(new ColumnSetAnalysis(readExpression, writeExpression));
            if (!this.dirtyChecked) {
                SingularAttributeMapping attribute = includedAttributeAnalysis.attribute;
                if (this.dirtinessChecker.include(attribute.getStateArrayPosition(), attribute)) {
                    this.tablesNeedingUpdate.add(table);
                }
                this.dirtyChecked = true;
            }
            if (this.values != null && !this.nullChecked) {
                int attributePosition = this.currentAttributeAnalysis.getAttribute().getStateArrayPosition();
                if (this.values[attributePosition] != null) {
                    this.tablesWithNonNullValues.add(table);
                }
                this.nullChecked = true;
            }
        }

        public void registerColumnOptLock(EntityTableMapping table, String readExpression, Object lockValue) {
            IncludedAttributeAnalysis attributeAnalysis = (IncludedAttributeAnalysis)this.currentAttributeAnalysis;
            attributeAnalysis.columnLockingAnalyses.add(new ColumnLockingAnalysis(readExpression, lockValue));
            if (this.dirtyAttributeIndexes != null && lockValue == null) {
                this.tablesNeedingDynamicUpdate.add(table);
            }
        }
    }
}

