/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.derived;

import java.util.function.BiConsumer;
import org.hibernate.Incubating;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.descriptor.java.JavaType;

@Incubating
public class AnonymousTupleBasicValuedModelPart
implements ModelPart,
MappingType,
BasicValuedModelPart {
    private static final FetchOptions FETCH_OPTIONS = FetchOptions.valueOf(FetchTiming.IMMEDIATE, FetchStyle.JOIN);
    private final String partName;
    private final String selectionExpression;
    private final SqmExpressible<?> expressible;
    private final JdbcMapping jdbcMapping;
    private final int fetchableIndex;

    public AnonymousTupleBasicValuedModelPart(String partName, String selectionExpression, SqmExpressible<?> expressible, JdbcMapping jdbcMapping, int fetchableIndex) {
        this.partName = partName;
        this.selectionExpression = selectionExpression;
        this.expressible = expressible;
        this.jdbcMapping = jdbcMapping;
        this.fetchableIndex = fetchableIndex;
    }

    @Override
    public MappingType getPartMappingType() {
        return this;
    }

    @Override
    public JavaType<?> getJavaType() {
        return this.expressible.getExpressibleJavaType();
    }

    @Override
    public JavaType<?> getMappedJavaType() {
        return this.expressible.getExpressibleJavaType();
    }

    @Override
    public String getPartName() {
        return this.partName;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return null;
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return null;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping;
    }

    @Override
    public String getContainingTableExpression() {
        return "";
    }

    @Override
    public String getSelectionExpression() {
        return this.selectionExpression;
    }

    @Override
    public String getCustomReadExpression() {
        return null;
    }

    @Override
    public String getCustomWriteExpression() {
        return null;
    }

    @Override
    public boolean isFormula() {
        return false;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isInsertable() {
        return true;
    }

    @Override
    public boolean isUpdateable() {
        return false;
    }

    @Override
    public boolean isPartitioned() {
        return false;
    }

    @Override
    public boolean hasPartitionedSelectionMapping() {
        return false;
    }

    @Override
    public String getColumnDefinition() {
        return null;
    }

    @Override
    public Long getLength() {
        return null;
    }

    @Override
    public Integer getPrecision() {
        return null;
    }

    @Override
    public Integer getScale() {
        return null;
    }

    @Override
    public MappingType getMappedType() {
        return this;
    }

    @Override
    public String getFetchableName() {
        return this.partName;
    }

    @Override
    public int getFetchableKey() {
        return this.fetchableIndex;
    }

    @Override
    public FetchOptions getMappedFetchOptions() {
        return FETCH_OPTIONS;
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        SqlSelection sqlSelection = this.resolveSqlSelection(navigablePath, tableGroup, null, creationState.getSqlAstCreationState());
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.jdbcMapping, navigablePath);
    }

    private SqlSelection resolveSqlSelection(NavigablePath navigablePath, TableGroup tableGroup, FetchParent fetchParent, SqlAstCreationState creationState) {
        SqlExpressionResolver expressionResolver = creationState.getSqlExpressionResolver();
        TableReference tableReference = tableGroup.resolveTableReference(navigablePath, this.getContainingTableExpression());
        Expression expression = expressionResolver.resolveSqlExpression(tableReference, this);
        return expressionResolver.resolveSqlSelection(expression, this.getJdbcMapping().getJdbcJavaType(), fetchParent, creationState.getCreationContext().getSessionFactory().getTypeConfiguration());
    }

    @Override
    public BasicFetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        TableGroup tableGroup = sqlAstCreationState.getFromClauseAccess().getTableGroup(fetchParent.getNavigablePath());
        assert (tableGroup != null);
        SqlSelection sqlSelection = this.resolveSqlSelection(fetchablePath, tableGroup, fetchParent, creationState.getSqlAstCreationState());
        return new BasicFetch(sqlSelection.getValuesArrayPosition(), fetchParent, fetchablePath, this, fetchTiming, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.resolveSqlSelection(navigablePath, tableGroup, null, creationState.getSqlAstCreationState());
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        selectionConsumer.accept(this.resolveSqlSelection(navigablePath, tableGroup, null, creationState.getSqlAstCreationState()), this.getJdbcMapping());
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, value, this.getJdbcMapping());
        return this.getJdbcTypeCount();
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(offset, this.getJdbcMapping());
        return this.getJdbcTypeCount();
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        valueConsumer.consume(domainValue, this);
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return value;
    }

    @Override
    public int forEachJdbcValue(Object value, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, value, this.getJdbcMapping());
        return this.getJdbcTypeCount();
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        consumer.accept(offset, this);
        return this.getJdbcTypeCount();
    }

    @Override
    public int forEachJdbcType(IndexedConsumer<JdbcMapping> action) {
        action.accept(0, this.getJdbcMapping());
        return this.getJdbcTypeCount();
    }
}

