/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.derived;

import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.Type;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.Incubating;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.BasicEntityIdentifierMapping;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.CompositeIdentifierMapping;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.NonAggregatedIdentifierMapping;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.internal.SingleAttributeIdentifierMapping;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.model.domain.SingularPersistentAttribute;
import org.hibernate.query.derived.AnonymousTupleBasicEntityIdentifierMapping;
import org.hibernate.query.derived.AnonymousTupleBasicValuedModelPart;
import org.hibernate.query.derived.AnonymousTupleEmbeddableValuedModelPart;
import org.hibernate.query.derived.AnonymousTupleEmbeddedEntityIdentifierMapping;
import org.hibernate.query.derived.AnonymousTupleEntityValuedModelPart;
import org.hibernate.query.derived.AnonymousTupleNonAggregatedEntityIdentifierMapping;
import org.hibernate.query.derived.AnonymousTupleType;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.LazyTableGroup;
import org.hibernate.sql.ast.tree.from.PluralTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.type.descriptor.java.JavaType;

@Incubating
public class AnonymousTupleTableGroupProducer
implements TableGroupProducer,
MappingType {
    private final String aliasStem;
    private final JavaType<?> javaTypeDescriptor;
    private final Map<String, ModelPart> modelParts;
    private final Set<String> compatibleTableExpressions;

    public AnonymousTupleTableGroupProducer(AnonymousTupleType<?> tupleType, String aliasStem, List<SqlSelection> sqlSelections, FromClauseAccess fromClauseAccess) {
        this.aliasStem = aliasStem;
        this.javaTypeDescriptor = tupleType.getExpressibleJavaType();
        HashSet<String> compatibleTableExpressions = new HashSet<String>();
        compatibleTableExpressions.add("");
        int componentCount = tupleType.componentCount();
        LinkedHashMap<String, ModelPart> modelParts = CollectionHelper.linkedMapOfSize(componentCount);
        int selectionIndex = 0;
        for (int i = 0; i < componentCount; ++i) {
            ModelPart modelPart;
            SqmSelectableNode<?> selectableNode = tupleType.getSelectableNode(i);
            String partName = tupleType.getComponentName(i);
            SqlSelection sqlSelection = sqlSelections.get(i);
            if (selectableNode instanceof SqmPath) {
                SqmPath sqmPath = (SqmPath)selectableNode;
                TableGroup tableGroup = fromClauseAccess.findTableGroup(sqmPath.getNavigablePath());
                modelPart = this.createModelPart(selectableNode.getExpressible(), sqmPath.getNodeType().getSqmPathType(), sqlSelections, selectionIndex, partName, partName, tableGroup == null ? null : this.getModelPart(tableGroup), compatibleTableExpressions, modelParts.size());
            } else {
                modelPart = new AnonymousTupleBasicValuedModelPart(partName, partName, selectableNode.getExpressible(), sqlSelection.getExpressionType().getSingleJdbcMapping(), modelParts.size());
            }
            modelParts.put(partName, modelPart);
            selectionIndex += modelPart.getJdbcTypeCount();
        }
        this.modelParts = modelParts;
        this.compatibleTableExpressions = compatibleTableExpressions;
    }

    private ModelPart getModelPart(TableGroup tableGroup) {
        if (tableGroup instanceof PluralTableGroup) {
            tableGroup = ((PluralTableGroup)tableGroup).getElementTableGroup();
        }
        if (tableGroup instanceof LazyTableGroup && ((LazyTableGroup)tableGroup).getUnderlyingTableGroup() != null) {
            return ((LazyTableGroup)tableGroup).getUnderlyingTableGroup().getModelPart();
        }
        return tableGroup.getModelPart();
    }

    private ModelPart createModelPart(SqmExpressible<?> sqmExpressible, DomainType<?> domainType, List<SqlSelection> sqlSelections, int selectionIndex, String selectionExpression, String partName, ModelPart existingModelPart, Set<String> compatibleTableExpressions, int fetchableIndex) {
        if (domainType instanceof EntityDomainType) {
            MappingType newIdentifierMapping;
            EntityValuedModelPart existingModelPartContainer = (EntityValuedModelPart)existingModelPart;
            EntityIdentifierMapping identifierMapping = existingModelPartContainer.getEntityMappingType().getIdentifierMapping();
            if (identifierMapping instanceof SingleAttributeIdentifierMapping) {
                String attributeName = identifierMapping.getAttributeName();
                if (identifierMapping.getPartMappingType() instanceof ManagedMappingType) {
                    Set attributes = ((ManagedDomainType)((EntityDomainType)domainType).getIdentifierDescriptor().getSqmPathType()).getAttributes();
                    LinkedHashMap<String, ModelPart> modelParts = CollectionHelper.linkedMapOfSize(attributes.size());
                    EmbeddableValuedModelPart modelPartContainer = (EmbeddableValuedModelPart)((Object)identifierMapping);
                    int index = 0;
                    for (Attribute attribute : attributes) {
                        if (!(attribute instanceof SingularPersistentAttribute)) {
                            throw new IllegalArgumentException("Only embeddables without collections are supported!");
                        }
                        Type attributeType = ((SingularPersistentAttribute)attribute).getType();
                        ModelPart modelPart = this.createModelPart(sqmExpressible, (DomainType<?>)attributeType, sqlSelections, selectionIndex, selectionExpression + "_" + attributeName + "_" + attribute.getName(), attribute.getName(), modelPartContainer.findSubPart(attribute.getName(), null), compatibleTableExpressions, index++);
                        modelParts.put(modelPart.getPartName(), modelPart);
                    }
                    newIdentifierMapping = new AnonymousTupleEmbeddedEntityIdentifierMapping(modelParts, domainType, attributeName, (CompositeIdentifierMapping)identifierMapping);
                } else {
                    newIdentifierMapping = new AnonymousTupleBasicEntityIdentifierMapping(selectionExpression + "_" + attributeName, sqmExpressible, sqlSelections.get(selectionIndex).getExpressionType().getSingleJdbcMapping(), (BasicEntityIdentifierMapping)identifierMapping);
                }
            } else {
                Set attributes = ((ManagedDomainType)((EntityDomainType)domainType).getIdentifierDescriptor().getSqmPathType()).getAttributes();
                LinkedHashMap<String, ModelPart> modelParts = CollectionHelper.linkedMapOfSize(attributes.size());
                EmbeddableValuedModelPart modelPartContainer = (EmbeddableValuedModelPart)((Object)identifierMapping);
                int index = 0;
                for (Attribute attribute : attributes) {
                    if (!(attribute instanceof SingularPersistentAttribute)) {
                        throw new IllegalArgumentException("Only embeddables without collections are supported!");
                    }
                    Type attributeType = ((SingularPersistentAttribute)attribute).getType();
                    ModelPart modelPart = this.createModelPart(sqmExpressible, (DomainType<?>)attributeType, sqlSelections, selectionIndex + index, selectionExpression + "_" + attribute.getName(), attribute.getName(), modelPartContainer.findSubPart(attribute.getName(), null), compatibleTableExpressions, index++);
                    modelParts.put(modelPart.getPartName(), modelPart);
                }
                newIdentifierMapping = new AnonymousTupleNonAggregatedEntityIdentifierMapping(modelParts, domainType, selectionExpression, (NonAggregatedIdentifierMapping)identifierMapping);
            }
            if (existingModelPartContainer instanceof ToOneAttributeMapping) {
                compatibleTableExpressions.add(((ToOneAttributeMapping)existingModelPart).getIdentifyingColumnsTableExpression());
            }
            return new AnonymousTupleEntityValuedModelPart((EntityIdentifierMapping)((Object)newIdentifierMapping), domainType, selectionExpression, existingModelPartContainer, fetchableIndex);
        }
        if (domainType instanceof ManagedDomainType) {
            Set attributes = ((ManagedDomainType)domainType).getAttributes();
            LinkedHashMap<String, ModelPart> modelParts = CollectionHelper.linkedMapOfSize(attributes.size());
            EmbeddableValuedModelPart modelPartContainer = (EmbeddableValuedModelPart)existingModelPart;
            int index = 0;
            for (Attribute attribute : attributes) {
                if (!(attribute instanceof SingularPersistentAttribute)) {
                    throw new IllegalArgumentException("Only embeddables without collections are supported");
                }
                Type attributeType = ((SingularPersistentAttribute)attribute).getType();
                ModelPart modelPart = this.createModelPart(sqmExpressible, (DomainType<?>)attributeType, sqlSelections, selectionIndex + index, selectionExpression + "_" + attribute.getName(), attribute.getName(), modelPartContainer.findSubPart(attribute.getName(), null), compatibleTableExpressions, index++);
                modelParts.put(modelPart.getPartName(), modelPart);
            }
            return new AnonymousTupleEmbeddableValuedModelPart(modelParts, domainType, selectionExpression, modelPartContainer, fetchableIndex);
        }
        return new AnonymousTupleBasicValuedModelPart(partName, selectionExpression, sqmExpressible, sqlSelections.get(selectionIndex).getExpressionType().getSingleJdbcMapping(), fetchableIndex);
    }

    public Set<String> getCompatibleTableExpressions() {
        return this.compatibleTableExpressions;
    }

    @Override
    public MappingType getPartMappingType() {
        return this;
    }

    @Override
    public JavaType<?> getMappedJavaType() {
        return this.javaTypeDescriptor;
    }

    @Override
    public String getPartName() {
        return null;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return null;
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return null;
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType treatTargetType) {
        return this.modelParts.get(name);
    }

    @Override
    public void forEachSubPart(IndexedConsumer<ModelPart> consumer, EntityMappingType treatTarget) {
        int i = 0;
        for (Map.Entry<String, ModelPart> entry : this.modelParts.entrySet()) {
            consumer.accept(i++, entry.getValue());
        }
    }

    @Override
    public void visitSubParts(Consumer<ModelPart> consumer, EntityMappingType treatTargetType) {
        for (ModelPart modelPart : this.modelParts.values()) {
            consumer.accept(modelPart);
        }
    }

    public Map<String, ModelPart> getModelParts() {
        return this.modelParts;
    }

    @Override
    public String getSqlAliasStem() {
        return this.aliasStem;
    }

    @Override
    public JavaType<?> getJavaType() {
        return this.javaTypeDescriptor;
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        int originalOffset = offset;
        for (ModelPart modelPart : this.modelParts.values()) {
            offset += modelPart.forEachSelectable(offset, consumer);
        }
        return offset - originalOffset;
    }

    @Override
    public boolean hasPartitionedSelectionMapping() {
        return false;
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

