/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.dynamic;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.results.DomainResultCreationStateImpl;
import org.hibernate.query.results.FetchBuilder;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.dynamic.DynamicFetchBuilder;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderContainer;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderStandard;
import org.hibernate.query.results.dynamic.DynamicResultBuilderEntityStandard;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.SqlAliasBaseConstant;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupJoinProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class DynamicFetchBuilderLegacy
implements DynamicFetchBuilder,
NativeQuery.FetchReturn,
DynamicFetchBuilderContainer {
    private static final String ELEMENT_PREFIX = CollectionPart.Nature.ELEMENT.getName() + ".";
    private static final String INDEX_PREFIX = CollectionPart.Nature.INDEX.getName() + ".";
    private final String tableAlias;
    private final String ownerTableAlias;
    private final String fetchableName;
    private final List<String> columnNames;
    private final Map<String, FetchBuilder> fetchBuilderMap;
    private final DynamicResultBuilderEntityStandard resultBuilderEntity;
    private LockMode lockMode;

    public DynamicFetchBuilderLegacy(String tableAlias, String ownerTableAlias, String fetchableName, List<String> columnNames, Map<String, FetchBuilder> fetchBuilderMap) {
        this(tableAlias, ownerTableAlias, fetchableName, columnNames, fetchBuilderMap, null);
    }

    public DynamicFetchBuilderLegacy(String tableAlias, String ownerTableAlias, String fetchableName, List<String> columnNames, Map<String, FetchBuilder> fetchBuilderMap, DynamicResultBuilderEntityStandard resultBuilderEntity) {
        this.tableAlias = tableAlias;
        this.ownerTableAlias = ownerTableAlias;
        this.fetchableName = fetchableName;
        this.columnNames = columnNames;
        this.fetchBuilderMap = fetchBuilderMap;
        this.resultBuilderEntity = resultBuilderEntity;
    }

    @Override
    public String getTableAlias() {
        return this.tableAlias;
    }

    @Override
    public String getOwnerAlias() {
        return this.ownerTableAlias;
    }

    @Override
    public String getFetchableName() {
        return this.fetchableName;
    }

    @Override
    public DynamicFetchBuilderLegacy cacheKeyInstance() {
        HashMap<String, FetchBuilder> fetchBuilderMap;
        if (this.fetchBuilderMap == null) {
            fetchBuilderMap = null;
        } else {
            fetchBuilderMap = new HashMap<String, FetchBuilder>(this.fetchBuilderMap.size());
            for (Map.Entry<String, FetchBuilder> entry : this.fetchBuilderMap.entrySet()) {
                fetchBuilderMap.put(entry.getKey(), entry.getValue().cacheKeyInstance());
            }
        }
        return new DynamicFetchBuilderLegacy(this.tableAlias, this.ownerTableAlias, this.fetchableName, this.columnNames == null ? null : List.copyOf(this.columnNames), fetchBuilderMap, this.resultBuilderEntity == null ? null : this.resultBuilderEntity.cacheKeyInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Fetch buildFetch(FetchParent parent, NavigablePath fetchPath, JdbcValuesMetadata jdbcResultsMetadata, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        TableGroup tableGroup;
        DomainResultCreationStateImpl creationState = ResultsHelper.impl(domainResultCreationState);
        TableGroup ownerTableGroup = creationState.getFromClauseAccess().findByAlias(this.ownerTableAlias);
        AttributeMapping attributeMapping = parent.getReferencedMappingContainer().findContainingEntityMapping().findDeclaredAttributeMapping(this.fetchableName);
        if (attributeMapping instanceof TableGroupJoinProducer) {
            SqlAliasBaseConstant sqlAliasBase = new SqlAliasBaseConstant(this.tableAlias);
            TableGroupJoin tableGroupJoin = ((TableGroupJoinProducer)((Object)attributeMapping)).createTableGroupJoin(fetchPath, ownerTableGroup, this.tableAlias, SqlAstJoinType.INNER, true, false, s -> sqlAliasBase, creationState.getSqlExpressionResolver(), creationState.getFromClauseAccess(), creationState.getCreationContext());
            ownerTableGroup.addTableGroupJoin(tableGroupJoin);
            tableGroup = tableGroupJoin.getJoinedGroup();
            creationState.getFromClauseAccess().registerTableGroup(fetchPath, tableGroup);
        } else {
            tableGroup = ownerTableGroup;
        }
        if (this.columnNames != null) {
            ForeignKeyDescriptor keyDescriptor;
            if (attributeMapping instanceof PluralAttributeMapping) {
                PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)attributeMapping;
                keyDescriptor = pluralAttributeMapping.getKeyDescriptor();
            } else {
                assert (attributeMapping instanceof ToOneAttributeMapping);
                ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)attributeMapping;
                keyDescriptor = toOneAttributeMapping.getForeignKeyDescriptor();
            }
            if (!this.columnNames.isEmpty()) {
                keyDescriptor.forEachSelectable((selectionIndex, selectableMapping) -> this.resolveSqlSelection(this.columnNames.get(selectionIndex), tableGroup.resolveTableReference(selectableMapping.getContainingTableExpression()), selectableMapping, jdbcResultsMetadata, domainResultCreationState));
            }
            if (this.resultBuilderEntity != null) {
                return this.resultBuilderEntity.buildFetch(parent, attributeMapping, jdbcResultsMetadata, creationState);
            }
        }
        try {
            Map.Entry<String, NavigablePath> currentRelativePath = creationState.getCurrentRelativePath();
            Object prefix = currentRelativePath == null ? "" : currentRelativePath.getKey().replace(ELEMENT_PREFIX, "").replace(INDEX_PREFIX, "") + ".";
            creationState.pushExplicitFetchMementoResolver(arg_0 -> this.lambda$buildFetch$2((String)prefix, arg_0));
            Fetch fetch = parent.generateFetchableFetch(attributeMapping, parent.resolveNavigablePath(attributeMapping), FetchTiming.IMMEDIATE, true, null, domainResultCreationState);
            return fetch;
        }
        finally {
            creationState.popExplicitFetchMementoResolver();
        }
    }

    private void resolveSqlSelection(String columnAlias, TableReference tableReference, SelectableMapping selectableMapping, JdbcValuesMetadata jdbcResultsMetadata, DomainResultCreationState domainResultCreationState) {
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(domainResultCreationState);
        creationStateImpl.resolveSqlSelection(ResultsHelper.resolveSqlExpression(creationStateImpl, jdbcResultsMetadata, tableReference, selectableMapping, columnAlias), selectableMapping.getJdbcMapping().getJdbcJavaType(), null, domainResultCreationState.getSqlAstCreationState().getCreationContext().getSessionFactory().getTypeConfiguration());
    }

    @Override
    public NativeQuery.ReturnProperty addColumnAlias(String columnAlias) {
        this.columnNames.add(columnAlias);
        return this;
    }

    @Override
    public List<String> getColumnAliases() {
        return this.columnNames;
    }

    @Override
    public NativeQuery.FetchReturn setLockMode(LockMode lockMode) {
        this.lockMode = lockMode;
        return this;
    }

    @Override
    public DynamicFetchBuilderLegacy addProperty(String propertyName, String columnAlias) {
        this.addProperty(propertyName).addColumnAlias(columnAlias);
        return this;
    }

    @Override
    public DynamicFetchBuilder addProperty(String propertyName) {
        DynamicFetchBuilderStandard fetchBuilder = new DynamicFetchBuilderStandard(propertyName);
        this.fetchBuilderMap.put(propertyName, fetchBuilder);
        return fetchBuilder;
    }

    @Override
    public FetchBuilder findFetchBuilder(String fetchableName) {
        return this.fetchBuilderMap.get(fetchableName);
    }

    @Override
    public DynamicFetchBuilderContainer addProperty(String propertyName, String ... columnAliases) {
        DynamicFetchBuilder fetchBuilder = this.addProperty(propertyName);
        for (String columnAlias : columnAliases) {
            fetchBuilder.addColumnAlias(columnAlias);
        }
        return this;
    }

    @Override
    public void addFetchBuilder(String propertyName, FetchBuilder fetchBuilder) {
        this.fetchBuilderMap.put(propertyName, fetchBuilder);
    }

    @Override
    public void visitFetchBuilders(BiConsumer<String, FetchBuilder> consumer) {
        this.fetchBuilderMap.forEach(consumer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicFetchBuilderLegacy that = (DynamicFetchBuilderLegacy)o;
        return this.tableAlias.equals(that.tableAlias) && this.ownerTableAlias.equals(that.ownerTableAlias) && this.fetchableName.equals(that.fetchableName) && Objects.equals(this.columnNames, that.columnNames) && Objects.equals(this.fetchBuilderMap, that.fetchBuilderMap) && Objects.equals(this.resultBuilderEntity, that.resultBuilderEntity);
    }

    public int hashCode() {
        int result = this.tableAlias.hashCode();
        result = 31 * result + this.ownerTableAlias.hashCode();
        result = 31 * result + this.fetchableName.hashCode();
        result = 31 * result + (this.columnNames != null ? this.columnNames.hashCode() : 0);
        result = 31 * result + (this.fetchBuilderMap != null ? this.fetchBuilderMap.hashCode() : 0);
        result = 31 * result + (this.resultBuilderEntity != null ? this.resultBuilderEntity.hashCode() : 0);
        return result;
    }

    private /* synthetic */ FetchBuilder lambda$buildFetch$2(String prefix, String relativePath) {
        if (relativePath.startsWith(prefix)) {
            return this.findFetchBuilder(relativePath.substring(prefix.length()));
        }
        return null;
    }
}

