/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sql.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.hibernate.action.internal.BulkOperationCleanupAction;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.NonSelectQueryPlan;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.sql.internal.SQLQueryParser;
import org.hibernate.query.sql.spi.ParameterOccurrence;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.JdbcOperationQueryMutationNative;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public class NativeNonSelectQueryPlanImpl
implements NonSelectQueryPlan {
    private final String sql;
    private final Set<String> affectedTableNames;
    private final List<ParameterOccurrence> parameterList;

    public NativeNonSelectQueryPlanImpl(String sql, Set<String> affectedTableNames, List<ParameterOccurrence> parameterList) {
        this.sql = sql;
        this.affectedTableNames = affectedTableNames;
        this.parameterList = parameterList;
    }

    @Override
    public int executeUpdate(DomainQueryExecutionContext executionContext) {
        JdbcParameterBindings jdbcParameterBindings;
        List<JdbcParameterBinder> jdbcParameterBinders;
        SharedSessionContractImplementor session = executionContext.getSession();
        session.autoFlushIfRequired(this.affectedTableNames);
        BulkOperationCleanupAction.schedule(session, this.affectedTableNames);
        QueryParameterBindings queryParameterBindings = executionContext.getQueryParameterBindings();
        if (this.parameterList == null || this.parameterList.isEmpty()) {
            jdbcParameterBinders = Collections.emptyList();
            jdbcParameterBindings = JdbcParameterBindings.NO_BINDINGS;
        } else {
            jdbcParameterBinders = new ArrayList(this.parameterList.size());
            jdbcParameterBindings = new JdbcParameterBindingsImpl(this.parameterList.size());
            jdbcParameterBindings.registerNativeQueryParameters(queryParameterBindings, this.parameterList, jdbcParameterBinders, session.getFactory());
        }
        SQLQueryParser parser = new SQLQueryParser(this.sql, null, session.getSessionFactory());
        JdbcOperationQueryMutationNative jdbcMutation = new JdbcOperationQueryMutationNative(parser.process(), jdbcParameterBinders, this.affectedTableNames);
        return session.getJdbcServices().getJdbcMutationExecutor().execute(jdbcMutation, jdbcParameterBindings, sql -> session.getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, SqmJdbcExecutionContextAdapter.usingLockingAndPaging(executionContext));
    }
}

