/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Parameter;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.TemporalType;
import jakarta.persistence.metamodel.Bindable;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.ScrollMode;
import org.hibernate.TypeMismatchException;
import org.hibernate.engine.query.spi.EntityGraphQueryHint;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.Generator;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.spi.AppliedGraph;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.id.BulkInsertionCapableIdentifierGenerator;
import org.hibernate.id.OptimizableGenerator;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.internal.SingleAttributeIdentifierMapping;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.BindableType;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.ImmutableEntityUpdateQueryHandlingMode;
import org.hibernate.query.QueryLogging;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.SemanticException;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.criteria.JpaQueryPart;
import org.hibernate.query.criteria.internal.NamedCriteriaQueryMementoImpl;
import org.hibernate.query.hql.internal.NamedHqlQueryMementoImpl;
import org.hibernate.query.hql.internal.QuerySplitter;
import org.hibernate.query.hql.spi.SqmQueryImplementor;
import org.hibernate.query.internal.DelegatingDomainQueryExecutionContext;
import org.hibernate.query.internal.ParameterMetadataImpl;
import org.hibernate.query.internal.QueryParameterBindingsImpl;
import org.hibernate.query.named.NamedQueryMemento;
import org.hibernate.query.spi.AbstractSelectionQuery;
import org.hibernate.query.spi.DelegatingQueryOptions;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.HqlInterpretation;
import org.hibernate.query.spi.MutableQueryOptions;
import org.hibernate.query.spi.NonSelectQueryPlan;
import org.hibernate.query.spi.ParameterMetadataImplementor;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.query.spi.SelectQueryPlan;
import org.hibernate.query.spi.SqlOmittingQueryOptions;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.internal.AggregatedNonSelectQueryPlanImpl;
import org.hibernate.query.sqm.internal.AggregatedSelectQueryPlanImpl;
import org.hibernate.query.sqm.internal.ConcreteSqmSelectQueryPlan;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.MultiTableDeleteQueryPlan;
import org.hibernate.query.sqm.internal.MultiTableInsertQueryPlan;
import org.hibernate.query.sqm.internal.MultiTableUpdateQueryPlan;
import org.hibernate.query.sqm.internal.SimpleDeleteQueryPlan;
import org.hibernate.query.sqm.internal.SimpleInsertQueryPlan;
import org.hibernate.query.sqm.internal.SimpleUpdateQueryPlan;
import org.hibernate.query.sqm.internal.SqmInterpretationsKey;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmQuery;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.JpaCriteriaParameter;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmJpaCriteriaParameterWrapper;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertValuesStatement;
import org.hibernate.query.sqm.tree.insert.SqmValues;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.update.SqmAssignment;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.sql.results.internal.TupleMetadata;
import org.hibernate.sql.results.spi.ListResultsConsumer;

public class QuerySqmImpl<R>
extends AbstractSelectionQuery<R>
implements SqmQueryImplementor<R>,
SqmInterpretationsKey.InterpretationsKeySource,
DomainQueryExecutionContext {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(QuerySqmImpl.class);
    private final String hql;
    private final SqmStatement<R> sqm;
    private final ParameterMetadataImplementor parameterMetadata;
    private final DomainParameterXref domainParameterXref;
    private final QueryParameterBindingsImpl parameterBindings;
    private final Class<R> resultType;
    private final TupleMetadata tupleMetadata;

    public QuerySqmImpl(NamedHqlQueryMementoImpl memento, Class<R> expectedResultType, SharedSessionContractImplementor session) {
        super(session);
        this.hql = memento.getHqlString();
        this.resultType = expectedResultType;
        SessionFactoryImplementor factory = session.getFactory();
        QueryEngine queryEngine = factory.getQueryEngine();
        QueryInterpretationCache interpretationCache = queryEngine.getInterpretationCache();
        HqlInterpretation hqlInterpretation = interpretationCache.resolveHqlInterpretation(this.hql, expectedResultType, s -> queryEngine.getHqlTranslator().translate(this.hql, expectedResultType));
        this.sqm = hqlInterpretation.getSqmStatement();
        this.parameterMetadata = hqlInterpretation.getParameterMetadata();
        this.domainParameterXref = hqlInterpretation.getDomainParameterXref();
        this.parameterBindings = QueryParameterBindingsImpl.from(this.parameterMetadata, session.getFactory());
        this.validateStatement(this.sqm, this.resultType);
        this.setComment(this.hql);
        this.applyOptions(memento);
        this.tupleMetadata = this.buildTupleMetadata(this.sqm, this.resultType);
    }

    public QuerySqmImpl(NamedCriteriaQueryMementoImpl memento, Class<R> resultType, SharedSessionContractImplementor session) {
        this(memento.getSqmStatement(), resultType, session);
        this.applyOptions(memento);
    }

    public QuerySqmImpl(String hql, HqlInterpretation hqlInterpretation, Class<R> resultType, SharedSessionContractImplementor session) {
        super(session);
        this.hql = hql;
        this.resultType = resultType;
        this.sqm = hqlInterpretation.getSqmStatement();
        this.parameterMetadata = hqlInterpretation.getParameterMetadata();
        this.domainParameterXref = hqlInterpretation.getDomainParameterXref();
        this.parameterBindings = QueryParameterBindingsImpl.from(this.parameterMetadata, session.getFactory());
        this.validateStatement(this.sqm, resultType);
        this.setComment(hql);
        this.tupleMetadata = this.buildTupleMetadata(this.sqm, resultType);
    }

    public QuerySqmImpl(SqmStatement<R> criteria, Class<R> resultType, SharedSessionContractImplementor producer) {
        super(producer);
        this.hql = "<criteria>";
        this.sqm = producer.isCriteriaCopyTreeEnabled() ? criteria.copy(SqmCopyContext.simpleContext()) : criteria;
        this.setComment(this.hql);
        this.domainParameterXref = DomainParameterXref.from(this.sqm);
        this.parameterMetadata = !this.domainParameterXref.hasParameters() ? ParameterMetadataImpl.EMPTY : new ParameterMetadataImpl(this.domainParameterXref.getQueryParameters());
        this.parameterBindings = QueryParameterBindingsImpl.from(this.parameterMetadata, producer.getFactory());
        for (SqmParameter<?> sqmParameter : this.domainParameterXref.getParameterResolutions().getSqmParameters()) {
            JpaCriteriaParameter jpaCriteriaParameter;
            Object value;
            if (!(sqmParameter instanceof SqmJpaCriteriaParameterWrapper) || (value = (jpaCriteriaParameter = ((SqmJpaCriteriaParameterWrapper)sqmParameter).getJpaCriteriaParameter()).getValue()) == null && jpaCriteriaParameter.getNodeType() != null) continue;
            this.getQueryParameterBindings().getBinding(jpaCriteriaParameter).setBindValue(value, jpaCriteriaParameter.getAnticipatedType());
        }
        if (this.sqm instanceof SqmSelectStatement) {
            SqmUtil.verifyIsSelectStatement(this.sqm, null);
            JpaQueryPart queryPart = ((SqmSelectStatement)this.sqm).getQueryPart();
            ((SqmQueryPart)queryPart).validateQueryStructureAndFetchOwners();
            this.visitQueryReturnType(queryPart, resultType, producer.getFactory());
        } else {
            if (resultType != null) {
                throw new IllegalQueryOperationException("Result type given for a non-SELECT Query", this.hql, null);
            }
            if (this.sqm instanceof SqmUpdateStatement) {
                SqmUpdateStatement updateStatement = (SqmUpdateStatement)this.sqm;
                this.verifyImmutableEntityUpdate("<criteria>", updateStatement, producer.getFactory());
                if (updateStatement.getSetClause() == null || updateStatement.getSetClause().getAssignments().isEmpty()) {
                    throw new IllegalArgumentException("No assignments specified as part of UPDATE criteria");
                }
            } else if (this.sqm instanceof SqmInsertStatement) {
                this.verifyInsertTypesMatch("<criteria>", (SqmInsertStatement)this.sqm);
            }
        }
        this.resultType = resultType;
        this.tupleMetadata = this.buildTupleMetadata(criteria, resultType);
    }

    private void validateStatement(SqmStatement<R> sqmStatement, Class<R> resultType) {
        if (sqmStatement instanceof SqmSelectStatement) {
            SqmUtil.verifyIsSelectStatement(sqmStatement, this.hql);
        } else {
            if (resultType != null) {
                throw new IllegalQueryOperationException("Result type given for a non-SELECT Query", this.hql, null);
            }
            if (sqmStatement instanceof SqmUpdateStatement) {
                SqmUpdateStatement updateStatement = (SqmUpdateStatement)sqmStatement;
                this.verifyImmutableEntityUpdate(this.hql, updateStatement, this.getSessionFactory());
                this.verifyUpdateTypesMatch(this.hql, updateStatement);
            } else if (sqmStatement instanceof SqmInsertStatement) {
                this.verifyInsertTypesMatch(this.hql, (SqmInsertStatement)sqmStatement);
            }
        }
    }

    private void verifyImmutableEntityUpdate(String hqlString, SqmUpdateStatement<R> sqmStatement, SessionFactoryImplementor factory) {
        EntityPersister entityDescriptor = factory.getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(((SqmRoot)sqmStatement.getTarget()).getEntityName());
        if (entityDescriptor.isMutable()) {
            return;
        }
        ImmutableEntityUpdateQueryHandlingMode immutableEntityUpdateQueryHandlingMode = factory.getSessionFactoryOptions().getImmutableEntityUpdateQueryHandlingMode();
        String querySpaces = Arrays.toString(entityDescriptor.getQuerySpaces());
        switch (immutableEntityUpdateQueryHandlingMode) {
            case WARNING: {
                LOG.immutableEntityUpdateQuery(hqlString, querySpaces);
                break;
            }
            case EXCEPTION: {
                throw new HibernateException("The query: [" + hqlString + "] attempts to update an immutable entity: " + querySpaces);
            }
            default: {
                throw new UnsupportedOperationException("The " + immutableEntityUpdateQueryHandlingMode + " is not supported");
            }
        }
    }

    private void verifyUpdateTypesMatch(String hqlString, SqmUpdateStatement<R> sqmStatement) {
        List<SqmAssignment<?>> assignments = sqmStatement.getSetClause().getAssignments();
        for (int i = 0; i < assignments.size(); ++i) {
            SqmAssignment<?> assignment = assignments.get(i);
            SqmPath<?> targetPath = assignment.getTargetPath();
            SqmExpression<?> expression = assignment.getValue();
            if (targetPath.getNodeJavaType() == null || expression.getNodeJavaType() == null || targetPath.getNodeJavaType() == expression.getNodeJavaType() || targetPath.getNodeJavaType().isWider(expression.getNodeJavaType())) continue;
            throw new SemanticException(String.format("The assignment expression type [%s] did not match the assignment path type [%s] for the path [%s]", expression.getNodeJavaType().getJavaType().getTypeName(), targetPath.getNodeJavaType().getJavaType().getTypeName(), targetPath.toHqlString()), hqlString, null);
        }
    }

    private void verifyInsertTypesMatch(String hqlString, SqmInsertStatement<R> sqmStatement) {
        List<SqmPath<?>> insertionTargetPaths = sqmStatement.getInsertionTargetPaths();
        if (sqmStatement instanceof SqmInsertValuesStatement) {
            SqmInsertValuesStatement statement = (SqmInsertValuesStatement)sqmStatement;
            for (SqmValues sqmValues : statement.getValuesList()) {
                this.verifyInsertTypesMatch(hqlString, insertionTargetPaths, sqmValues.getExpressions());
            }
        } else {
            SqmInsertSelectStatement statement = (SqmInsertSelectStatement)sqmStatement;
            List<SqmSelectableNode<?>> selections = statement.getSelectQueryPart().getFirstQuerySpec().getSelectClause().getSelectionItems();
            this.verifyInsertTypesMatch(hqlString, insertionTargetPaths, selections);
            statement.getSelectQueryPart().validateQueryStructureAndFetchOwners();
        }
    }

    private void verifyInsertTypesMatch(String hqlString, List<SqmPath<?>> insertionTargetPaths, List<? extends SqmTypedNode<?>> expressions) {
        int expressionsSize;
        int size = insertionTargetPaths.size();
        if (size != (expressionsSize = expressions.size())) {
            throw new SemanticException(String.format("Expected insert attribute count [%d] did not match Query selection count [%d]", size, expressionsSize), hqlString, null);
        }
        for (int i = 0; i < expressionsSize; ++i) {
            SqmTypedNode<?> expression = expressions.get(i);
            if (expression.getNodeJavaType() == null || insertionTargetPaths.get(i).getJavaTypeDescriptor() == expression.getNodeJavaType()) continue;
            throw new SemanticException(String.format("Expected insert attribute type [%s] did not match Query selection type [%s] at selection index [%d]", insertionTargetPaths.get(i).getJavaTypeDescriptor().getJavaType().getTypeName(), expression.getNodeJavaType().getJavaType().getTypeName(), i), hqlString, null);
        }
    }

    public TupleMetadata getTupleMetadata() {
        return this.tupleMetadata;
    }

    @Override
    public String getQueryString() {
        return this.hql;
    }

    @Override
    public SqmStatement getSqmStatement() {
        return this.sqm;
    }

    public DomainParameterXref getDomainParameterXref() {
        return this.domainParameterXref;
    }

    @Override
    public ParameterMetadataImplementor getParameterMetadata() {
        return this.parameterMetadata;
    }

    @Override
    public QueryParameterBindings getQueryParameterBindings() {
        return this.parameterBindings;
    }

    @Override
    public QueryParameterBindings getParameterBindings() {
        return this.getQueryParameterBindings();
    }

    public Class<R> getResultType() {
        return this.resultType;
    }

    @Override
    public LoadQueryInfluencers getLoadQueryInfluencers() {
        return this.getSession().getLoadQueryInfluencers();
    }

    @Override
    protected boolean resolveJdbcParameterTypeIfNecessary() {
        return false;
    }

    @Override
    public Supplier<Boolean> hasMultiValuedParameterBindingsChecker() {
        return this::hasMultiValuedParameterBindings;
    }

    protected boolean hasMultiValuedParameterBindings() {
        return this.getQueryParameterBindings().hasAnyMultiValuedBindings() || this.getParameterMetadata().hasAnyMatching(QueryParameter::allowsMultiValuedBinding);
    }

    @Override
    protected void prepareForExecution() {
        this.resetCallback();
    }

    protected void verifySelect() {
        try {
            SqmUtil.verifyIsSelectStatement(this.getSqmStatement(), this.hql);
        }
        catch (IllegalQueryOperationException e) {
            throw new IllegalStateException("Expecting a SELECT query : `" + this.hql + "`", (Throwable)((Object)e));
        }
    }

    @Override
    protected List<R> doList() {
        this.verifySelect();
        this.getSession().prepareForQueryExecution(this.requiresTxn(this.getQueryOptions().getLockOptions().findGreatestLockMode()));
        SqmSelectStatement sqmStatement = (SqmSelectStatement)this.getSqmStatement();
        boolean containsCollectionFetches = sqmStatement.containsCollectionFetches();
        boolean hasLimit = QuerySqmImpl.hasLimit(sqmStatement, (MutableQueryOptions)this.getQueryOptions());
        boolean needsDistinct = containsCollectionFetches && (sqmStatement.usesDistinct() || QuerySqmImpl.hasAppliedGraph((MutableQueryOptions)this.getQueryOptions()) || hasLimit);
        List<R> list = this.resolveSelectQueryPlan().performList(this.executionContextFordoList(containsCollectionFetches, hasLimit, needsDistinct));
        if (needsDistinct) {
            int max;
            int first = !hasLimit || this.getQueryOptions().getLimit().getFirstRow() == null ? this.getIntegerLiteral(sqmStatement.getOffset(), 0) : this.getQueryOptions().getLimit().getFirstRow().intValue();
            int n = max = !hasLimit || this.getQueryOptions().getLimit().getMaxRows() == null ? this.getMaxRows(sqmStatement, list.size()) : this.getQueryOptions().getLimit().getMaxRows().intValue();
            if (first > 0 || max != -1) {
                int resultSize = list.size();
                int toIndex = max != -1 ? first + max : resultSize;
                return list.subList(first, toIndex > resultSize ? resultSize : toIndex);
            }
        }
        return list;
    }

    protected DomainQueryExecutionContext executionContextFordoList(boolean containsCollectionFetches, boolean hasLimit, boolean needsDistinct) {
        DomainQueryExecutionContext executionContextToUse;
        if (hasLimit && containsCollectionFetches) {
            boolean fail = this.getSessionFactory().getSessionFactoryOptions().isFailOnPaginationOverCollectionFetchEnabled();
            if (fail) {
                throw new HibernateException("firstResult/maxResults specified with collection fetch. In memory pagination was about to be applied. Failing because 'Fail on pagination over collection fetch' is enabled.");
            }
            QueryLogging.QUERY_MESSAGE_LOGGER.firstOrMaxResultsSpecifiedWithCollectionFetch();
            QueryOptions originalQueryOptions = this.getQueryOptions();
            final QueryOptions normalizedQueryOptions = needsDistinct ? SqlOmittingQueryOptions.omitSqlQueryOptionsWithUniqueSemanticFilter(originalQueryOptions, true, false) : SqlOmittingQueryOptions.omitSqlQueryOptions(originalQueryOptions, true, false);
            executionContextToUse = originalQueryOptions == normalizedQueryOptions ? this : new DelegatingDomainQueryExecutionContext(this){

                @Override
                public QueryOptions getQueryOptions() {
                    return normalizedQueryOptions;
                }
            };
        } else {
            QueryOptions normalizedQueryOptions;
            QueryOptions originalQueryOptions;
            executionContextToUse = needsDistinct ? ((originalQueryOptions = this.getQueryOptions()) == (normalizedQueryOptions = QuerySqmImpl.uniqueSemanticQueryOptions(originalQueryOptions)) ? this : new DelegatingDomainQueryExecutionContext(this){

                @Override
                public QueryOptions getQueryOptions() {
                    return normalizedQueryOptions;
                }
            }) : this;
        }
        return executionContextToUse;
    }

    public static QueryOptions uniqueSemanticQueryOptions(QueryOptions originalOptions) {
        ListResultsConsumer.UniqueSemantic semantic = originalOptions.getUniqueSemantic();
        if (semantic == ListResultsConsumer.UniqueSemantic.FILTER) {
            return originalOptions;
        }
        return new UniqueSemanticFilterQueryOption(originalOptions);
    }

    @Override
    protected ScrollableResultsImplementor doScroll(ScrollMode scrollMode) {
        this.getSession().prepareForQueryExecution(this.requiresTxn(this.getQueryOptions().getLockOptions().findGreatestLockMode()));
        return this.resolveSelectQueryPlan().performScroll(scrollMode, this);
    }

    private SelectQueryPlan<R> resolveSelectQueryPlan() {
        SqmInterpretationsKey cacheKey = SqmInterpretationsKey.createInterpretationsKey(this);
        if (cacheKey != null) {
            return this.getSession().getFactory().getQueryEngine().getInterpretationCache().resolveSelectQueryPlan(cacheKey, this::buildSelectQueryPlan);
        }
        return this.buildSelectQueryPlan();
    }

    private SelectQueryPlan<R> buildSelectQueryPlan() {
        SqmSelectStatement<R>[] concreteSqmStatements = QuerySplitter.split((SqmSelectStatement)this.getSqmStatement(), this.getSession().getFactory());
        if (concreteSqmStatements.length > 1) {
            return this.buildAggregatedSelectQueryPlan(concreteSqmStatements);
        }
        return this.buildConcreteSelectQueryPlan(concreteSqmStatements[0], this.getResultType(), this.getQueryOptions());
    }

    private SelectQueryPlan<R> buildAggregatedSelectQueryPlan(SqmSelectStatement<?>[] concreteSqmStatements) {
        SelectQueryPlan[] aggregatedQueryPlans = new SelectQueryPlan[concreteSqmStatements.length];
        int x = concreteSqmStatements.length;
        for (int i = 0; i < x; ++i) {
            aggregatedQueryPlans[i] = this.buildConcreteSelectQueryPlan(concreteSqmStatements[i], this.getResultType(), this.getQueryOptions());
        }
        return new AggregatedSelectQueryPlanImpl(aggregatedQueryPlans);
    }

    private <T> SelectQueryPlan<T> buildConcreteSelectQueryPlan(SqmSelectStatement<?> concreteSqmStatement, Class<T> resultType, QueryOptions queryOptions) {
        return new ConcreteSqmSelectQueryPlan<T>(concreteSqmStatement, this.getQueryString(), this.getDomainParameterXref(), resultType, this.tupleMetadata, queryOptions);
    }

    @Override
    public int executeUpdate() {
        this.verifyUpdate();
        this.getSession().checkTransactionNeededForUpdateOperation("Executing an update/delete query");
        this.beforeQuery();
        boolean success = false;
        try {
            int result = this.doExecuteUpdate();
            success = true;
            int n = result;
            return n;
        }
        catch (IllegalQueryOperationException e) {
            throw new IllegalStateException((Throwable)((Object)e));
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException((Throwable)((Object)e));
        }
        catch (HibernateException e) {
            throw this.getSession().getExceptionConverter().convert(e);
        }
        finally {
            this.afterQuery(success);
        }
    }

    protected void verifyUpdate() {
        try {
            SqmUtil.verifyIsNonSelectStatement(this.getSqmStatement(), this.hql);
        }
        catch (IllegalQueryOperationException e) {
            throw new IllegalStateException("Expecting a non-SELECT query : `" + this.hql + "`", (Throwable)((Object)e));
        }
    }

    protected int doExecuteUpdate() {
        this.getSession().prepareForQueryExecution(true);
        return this.resolveNonSelectQueryPlan().executeUpdate(this);
    }

    private NonSelectQueryPlan resolveNonSelectQueryPlan() {
        NonSelectQueryPlan queryPlan = null;
        QueryInterpretationCache.Key cacheKey = SqmInterpretationsKey.generateNonSelectKey(this);
        if (cacheKey != null) {
            queryPlan = this.getSession().getFactory().getQueryEngine().getInterpretationCache().getNonSelectQueryPlan(cacheKey);
        }
        if (queryPlan == null) {
            queryPlan = this.buildNonSelectQueryPlan();
            if (cacheKey != null) {
                this.getSession().getFactory().getQueryEngine().getInterpretationCache().cacheNonSelectQueryPlan(cacheKey, queryPlan);
            }
        }
        return queryPlan;
    }

    private NonSelectQueryPlan buildNonSelectQueryPlan() {
        if (this.getSqmStatement() instanceof SqmDeleteStatement) {
            return this.buildDeleteQueryPlan();
        }
        if (this.getSqmStatement() instanceof SqmUpdateStatement) {
            return this.buildUpdateQueryPlan();
        }
        if (this.getSqmStatement() instanceof SqmInsertStatement) {
            return this.buildInsertQueryPlan();
        }
        throw new UnsupportedOperationException("Query#executeUpdate for Statements of type [" + this.getSqmStatement() + "] not supported");
    }

    private NonSelectQueryPlan buildDeleteQueryPlan() {
        SqmDeleteStatement[] concreteSqmStatements = QuerySplitter.split((SqmDeleteStatement)this.getSqmStatement(), this.getSessionFactory());
        if (concreteSqmStatements.length > 1) {
            return this.buildAggregatedDeleteQueryPlan(concreteSqmStatements);
        }
        return this.buildConcreteDeleteQueryPlan(concreteSqmStatements[0]);
    }

    private NonSelectQueryPlan buildConcreteDeleteQueryPlan(SqmDeleteStatement sqmDelete) {
        Bindable entityDomainType = ((SqmRoot)sqmDelete.getTarget()).getModel();
        String entityNameToDelete = entityDomainType.getHibernateEntityName();
        EntityPersister entityDescriptor = this.getSessionFactory().getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entityNameToDelete);
        SqmMultiTableMutationStrategy multiTableStrategy = entityDescriptor.getSqmMultiTableMutationStrategy();
        if (multiTableStrategy == null) {
            return new SimpleDeleteQueryPlan(entityDescriptor, sqmDelete, this.domainParameterXref);
        }
        return new MultiTableDeleteQueryPlan(sqmDelete, this.domainParameterXref, multiTableStrategy);
    }

    private NonSelectQueryPlan buildAggregatedDeleteQueryPlan(SqmDeleteStatement[] concreteSqmStatements) {
        NonSelectQueryPlan[] aggregatedQueryPlans = new NonSelectQueryPlan[concreteSqmStatements.length];
        int x = concreteSqmStatements.length;
        for (int i = 0; i < x; ++i) {
            aggregatedQueryPlans[i] = this.buildConcreteDeleteQueryPlan(concreteSqmStatements[i]);
        }
        return new AggregatedNonSelectQueryPlanImpl(aggregatedQueryPlans);
    }

    private NonSelectQueryPlan buildUpdateQueryPlan() {
        SqmUpdateStatement sqmUpdate = (SqmUpdateStatement)this.getSqmStatement();
        String entityNameToUpdate = ((SqmRoot)sqmUpdate.getTarget()).getModel().getHibernateEntityName();
        EntityPersister entityDescriptor = this.getSessionFactory().getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entityNameToUpdate);
        SqmMultiTableMutationStrategy multiTableStrategy = entityDescriptor.getSqmMultiTableMutationStrategy();
        if (multiTableStrategy == null) {
            return new SimpleUpdateQueryPlan(sqmUpdate, this.domainParameterXref);
        }
        return new MultiTableUpdateQueryPlan(sqmUpdate, this.domainParameterXref, multiTableStrategy);
    }

    private NonSelectQueryPlan buildInsertQueryPlan() {
        Optimizer optimizer;
        Generator identifierGenerator;
        SqmInsertStatement sqmInsert = (SqmInsertStatement)this.getSqmStatement();
        String entityNameToInsert = ((SqmRoot)sqmInsert.getTarget()).getModel().getHibernateEntityName();
        AbstractEntityPersister entityDescriptor = (AbstractEntityPersister)this.getSessionFactory().getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entityNameToInsert);
        boolean useMultiTableInsert = entityDescriptor.isMultiTable();
        if (!useMultiTableInsert && !this.isSimpleValuesInsert(sqmInsert, entityDescriptor) && (identifierGenerator = entityDescriptor.getGenerator()) instanceof BulkInsertionCapableIdentifierGenerator && identifierGenerator instanceof OptimizableGenerator && (optimizer = ((OptimizableGenerator)identifierGenerator).getOptimizer()) != null && optimizer.getIncrementSize() > 1) {
            boolean bl = useMultiTableInsert = !this.hasIdentifierAssigned(sqmInsert, entityDescriptor);
        }
        if (!useMultiTableInsert) {
            return new SimpleInsertQueryPlan(sqmInsert, this.domainParameterXref);
        }
        return new MultiTableInsertQueryPlan(sqmInsert, this.domainParameterXref, entityDescriptor.getSqmMultiTableInsertStrategy());
    }

    protected boolean hasIdentifierAssigned(SqmInsertStatement<?> sqmInsert, EntityPersister entityDescriptor) {
        EntityIdentifierMapping identifierMapping = entityDescriptor.getIdentifierMapping();
        String partName = identifierMapping instanceof SingleAttributeIdentifierMapping ? ((SingleAttributeIdentifierMapping)identifierMapping).getAttributeName() : "{id}";
        for (SqmPath<?> insertionTargetPath : sqmInsert.getInsertionTargetPaths()) {
            SqmPathSource<?> referencedPathSource;
            JpaPath lhs = insertionTargetPath.getLhs();
            if (!(lhs instanceof SqmRoot) || !(referencedPathSource = insertionTargetPath.getReferencedPathSource()).getPathName().equals(partName)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSimpleValuesInsert(SqmInsertStatement<?> sqmInsert, EntityPersister entityDescriptor) {
        return sqmInsert instanceof SqmInsertValuesStatement && entityDescriptor.getSqmMultiTableMutationStrategy() == null;
    }

    @Override
    public SqmQueryImplementor<R> addQueryHint(String hint) {
        this.getQueryOptions().addDatabaseHint(hint);
        return this;
    }

    @Override
    public LockOptions getLockOptions() {
        return this.getQueryOptions().getLockOptions();
    }

    @Override
    public SqmQueryImplementor<R> setLockOptions(LockOptions lockOptions) {
        this.getQueryOptions().getLockOptions().overlay(lockOptions);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setLockMode(String alias, LockMode lockMode) {
        super.setLockMode(alias, lockMode);
        return this;
    }

    @Override
    public <T> SqmQueryImplementor<T> setTupleTransformer(TupleTransformer<T> transformer) {
        this.applyTupleTransformer(transformer);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setResultListTransformer(ResultListTransformer transformer) {
        this.applyResultListTransformer(transformer);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setMaxResults(int maxResult) {
        this.applyMaxResults(maxResult);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setFirstResult(int startPosition) {
        this.applyFirstResult(startPosition);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setHibernateFlushMode(FlushMode flushMode) {
        super.setHibernateFlushMode(flushMode);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setFlushMode(FlushModeType flushMode) {
        this.applyJpaFlushMode(flushMode);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setLockMode(LockModeType lockMode) {
        if (lockMode != LockModeType.NONE) {
            this.verifySelect();
        }
        this.getSession().checkOpen(false);
        this.getQueryOptions().getLockOptions().setLockMode(LockMode.fromJpaLockMode(lockMode));
        return this;
    }

    @Override
    public LockModeType getLockMode() {
        this.verifySelect();
        this.getSession().checkOpen(false);
        return this.getLockOptions().getLockMode().toJpaLockMode();
    }

    @Override
    public FlushModeType getFlushMode() {
        return this.getJpaFlushMode();
    }

    @Override
    protected void collectHints(Map<String, Object> hints) {
        AppliedGraph appliedGraph;
        super.collectHints(hints);
        if (this.isReadOnly()) {
            hints.put("org.hibernate.readOnly", true);
        }
        this.putIfNotNull(hints, "org.hibernate.fetchSize", this.getFetchSize());
        if (this.isCacheable()) {
            hints.put("org.hibernate.cacheable", true);
            this.putIfNotNull(hints, "org.hibernate.cacheRegion", this.getCacheRegion());
            this.putIfNotNull(hints, "org.hibernate.cacheMode", this.getCacheMode());
            this.putIfNotNull(hints, "jakarta.persistence.cache.retrieveMode", (Enum<?>)this.getQueryOptions().getCacheRetrieveMode());
            this.putIfNotNull(hints, "jakarta.persistence.cache.storeMode", (Enum<?>)this.getQueryOptions().getCacheStoreMode());
            this.putIfNotNull(hints, "javax.persistence.cache.retrieveMode", (Enum<?>)this.getQueryOptions().getCacheRetrieveMode());
            this.putIfNotNull(hints, "javax.persistence.cache.storeMode", (Enum<?>)this.getQueryOptions().getCacheStoreMode());
        }
        if ((appliedGraph = this.getQueryOptions().getAppliedGraph()) != null && appliedGraph.getSemantic() != null) {
            hints.put(appliedGraph.getSemantic().getJakartaHintName(), appliedGraph);
            hints.put(appliedGraph.getSemantic().getJpaHintName(), appliedGraph);
        }
        this.putIfNotNull(hints, "hibernate.query.followOnLocking", this.getQueryOptions().getLockOptions().getFollowOnLocking());
    }

    @Override
    public SqmQueryImplementor<R> setHint(String hintName, Object value) {
        this.applyHint(hintName, value);
        return this;
    }

    @Override
    protected void applyLockTimeoutHint(Integer timeout) {
        if (SqmUtil.isSelect(this.sqm)) {
            super.applyLockTimeoutHint(timeout);
        }
    }

    @Override
    protected void applyLockTimeoutHint(int timeout) {
        if (SqmUtil.isSelect(this.sqm)) {
            super.applyLockTimeoutHint(timeout);
        }
    }

    @Override
    protected void applyHibernateLockMode(LockMode value) {
        if (SqmUtil.isSelect(this.sqm)) {
            super.applyHibernateLockMode(value);
        }
    }

    @Override
    protected void applyLockModeType(LockModeType value) {
        if (SqmUtil.isSelect(this.sqm)) {
            super.applyLockModeType(value);
        }
    }

    @Override
    protected void applyAliasSpecificLockModeHint(String hintName, Object value) {
        if (SqmUtil.isSelect(this.sqm)) {
            super.applyAliasSpecificLockModeHint(hintName, value);
        }
    }

    @Override
    protected void applyFollowOnLockingHint(Boolean followOnLocking) {
        if (SqmUtil.isSelect(this.sqm)) {
            super.applyFollowOnLockingHint(followOnLocking);
        }
    }

    @Override
    public SqmQueryImplementor<R> applyGraph(RootGraph graph, GraphSemantic semantic) {
        this.getQueryOptions().applyGraph((RootGraphImplementor)graph, semantic);
        return this;
    }

    @Override
    public List<R> list() {
        return super.list();
    }

    @Override
    public ScrollableResultsImplementor<R> scroll() {
        return super.scroll();
    }

    @Override
    public ScrollableResultsImplementor<R> scroll(ScrollMode scrollMode) {
        return super.scroll(scrollMode);
    }

    @Override
    public Stream<R> stream() {
        return super.stream();
    }

    @Override
    public R uniqueResult() {
        return super.uniqueResult();
    }

    @Override
    public R getSingleResult() {
        return super.getSingleResult();
    }

    @Override
    public Optional<R> uniqueResultOptional() {
        return super.uniqueResultOptional();
    }

    @Override
    public NamedQueryMemento toMemento(String name) {
        if ("<criteria>".equals(this.getQueryString())) {
            SqmQuery sqmStatement = !this.getSession().isCriteriaCopyTreeEnabled() ? this.getSqmStatement().copy(SqmCopyContext.simpleContext()) : this.getSqmStatement();
            return new NamedCriteriaQueryMementoImpl(name, (SqmStatement)sqmStatement, this.getFirstResult(), this.getMaxResults(), this.isCacheable(), this.getCacheRegion(), this.getCacheMode(), this.getHibernateFlushMode(), this.isReadOnly(), this.getLockOptions(), this.getTimeout(), this.getFetchSize(), this.getComment(), Collections.emptyMap(), this.getHints());
        }
        return new NamedHqlQueryMementoImpl(name, this.getQueryString(), this.getFirstResult(), this.getMaxResults(), this.isCacheable(), this.getCacheRegion(), this.getCacheMode(), this.getHibernateFlushMode(), this.isReadOnly(), this.getLockOptions(), this.getTimeout(), this.getFetchSize(), this.getComment(), Collections.emptyMap(), this.getHints());
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls.isInstance(this)) {
            return (T)this;
        }
        if (cls.isInstance(this.parameterMetadata)) {
            return (T)this.parameterMetadata;
        }
        if (cls.isInstance(this.parameterBindings)) {
            return (T)this.parameterBindings;
        }
        if (cls.isInstance(this.sqm)) {
            return (T)this.sqm;
        }
        if (cls.isInstance(this.getQueryOptions())) {
            return (T)this.getQueryOptions();
        }
        if (cls.isInstance(this.getQueryOptions().getAppliedGraph())) {
            return (T)this.getQueryOptions().getAppliedGraph();
        }
        if (EntityGraphQueryHint.class.isAssignableFrom(cls)) {
            return (T)new EntityGraphQueryHint(this.getQueryOptions().getAppliedGraph());
        }
        throw new PersistenceException("Unrecognized unwrap type [" + cls.getName() + "]");
    }

    @Override
    public SqmQueryImplementor<R> setComment(String comment) {
        super.setComment(comment);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setCacheMode(CacheMode cacheMode) {
        super.setCacheMode(cacheMode);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setCacheRetrieveMode(CacheRetrieveMode cacheRetrieveMode) {
        super.setCacheRetrieveMode(cacheRetrieveMode);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setCacheStoreMode(CacheStoreMode cacheStoreMode) {
        super.setCacheStoreMode(cacheStoreMode);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setCacheable(boolean cacheable) {
        super.setCacheable(cacheable);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setCacheRegion(String cacheRegion) {
        super.setCacheRegion(cacheRegion);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setTimeout(int timeout) {
        super.setTimeout(timeout);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setFetchSize(int fetchSize) {
        super.setFetchSize(fetchSize);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setProperties(Object bean) {
        super.setProperties(bean);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setProperties(Map bean) {
        super.setProperties(bean);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setParameter(String name, Object value) {
        super.setParameter(name, value);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameter(String name, P value, Class<P> javaType) {
        super.setParameter(name, (Object)value, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameter(String name, P value, BindableType<P> type) {
        super.setParameter(name, (Object)value, (BindableType)type);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setParameter(String name, Instant value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setParameter(int position, Object value) {
        super.setParameter(position, value);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameter(int position, P value, Class<P> javaType) {
        super.setParameter(position, (Object)value, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameter(int position, P value, BindableType<P> type) {
        super.setParameter(position, (Object)value, (BindableType)type);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setParameter(int position, Instant value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameter(QueryParameter<P> parameter, P value) {
        super.setParameter((QueryParameter)parameter, (Object)value);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameter(QueryParameter<P> parameter, P value, Class<P> javaType) {
        super.setParameter((QueryParameter)parameter, (Object)value, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameter(QueryParameter<P> parameter, P value, BindableType<P> type) {
        super.setParameter((QueryParameter)parameter, (Object)value, (BindableType)type);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameter(Parameter<P> parameter, P value) {
        super.setParameter((Parameter)parameter, (Object)value);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        super.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        super.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setParameter(String name, Calendar value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setParameter(String name, Date value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setParameter(int position, Calendar value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setParameter(int position, Date value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setParameterList(String name, Collection values) {
        super.setParameterList(name, values);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameterList(String name, Collection<? extends P> values, Class<P> javaType) {
        super.setParameterList(name, (Collection)values, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameterList(String name, Collection<? extends P> values, BindableType<P> type) {
        super.setParameterList(name, (Collection)values, (BindableType)type);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setParameterList(String name, Object[] values) {
        super.setParameterList(name, values);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameterList(String name, P[] values, Class<P> javaType) {
        super.setParameterList(name, (Object[])values, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameterList(String name, P[] values, BindableType<P> type) {
        super.setParameterList(name, (Object[])values, (BindableType)type);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setParameterList(int position, Collection values) {
        super.setParameterList(position, values);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameterList(int position, Collection<? extends P> values, Class<P> javaType) {
        super.setParameterList(position, (Collection)values, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameterList(int position, Collection<? extends P> values, BindableType<P> type) {
        super.setParameterList(position, (Collection)values, (BindableType)type);
        return this;
    }

    @Override
    public SqmQueryImplementor<R> setParameterList(int position, Object[] values) {
        super.setParameterList(position, values);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameterList(int position, P[] values, Class<P> javaType) {
        super.setParameterList(position, (Object[])values, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameterList(int position, P[] values, BindableType<P> type) {
        super.setParameterList(position, (Object[])values, (BindableType)type);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values) {
        super.setParameterList((QueryParameter)parameter, (Collection)values);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values, Class<P> javaType) {
        super.setParameterList((QueryParameter)parameter, (Collection)values, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values, BindableType<P> type) {
        super.setParameterList((QueryParameter)parameter, (Collection)values, (BindableType)type);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameterList(QueryParameter<P> parameter, P[] values) {
        super.setParameterList((QueryParameter)parameter, (Object[])values);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameterList(QueryParameter<P> parameter, P[] values, Class<P> javaType) {
        super.setParameterList((QueryParameter)parameter, (Object[])values, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmQueryImplementor<R> setParameterList(QueryParameter<P> parameter, P[] values, BindableType<P> type) {
        super.setParameterList((QueryParameter)parameter, (Object[])values, (BindableType)type);
        return this;
    }

    @Override
    public void setOptionalId(Serializable id) {
        throw new UnsupportedOperationException("Not sure yet how to handle this in SQM based queries, but for sure it will be different");
    }

    @Override
    public void setOptionalEntityName(String entityName) {
        throw new UnsupportedOperationException("Not sure yet how to handle this in SQM based queries, but for sure it will be different");
    }

    @Override
    public void setOptionalObject(Object optionalObject) {
        throw new UnsupportedOperationException("Not sure yet how to handle this in SQM based queries, but for sure it will be different");
    }

    public static class UniqueSemanticFilterQueryOption
    extends DelegatingQueryOptions {
        public UniqueSemanticFilterQueryOption(QueryOptions queryOptions) {
            super(queryOptions);
        }

        @Override
        public ListResultsConsumer.UniqueSemantic getUniqueSemantic() {
            return ListResultsConsumer.UniqueSemantic.FILTER;
        }
    }
}

