/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityAssociationMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.IllegalSelectQueryException;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.spi.JdbcParameterBySqmParameterAccess;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.tree.SqmDmlStatement;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.expression.JpaCriteriaParameter;
import org.hibernate.query.sqm.tree.expression.SqmJpaCriteriaParameterWrapper;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.jpa.ParameterCollector;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlTreeCreationException;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.spi.TypeConfiguration;

public class SqmUtil {
    private SqmUtil() {
    }

    public static boolean isSelect(SqmStatement<?> sqm) {
        return sqm instanceof SqmSelectStatement;
    }

    public static boolean isMutation(SqmStatement<?> sqm) {
        return sqm instanceof SqmDmlStatement;
    }

    public static void verifyIsSelectStatement(SqmStatement<?> sqm, String hqlString) {
        if (!SqmUtil.isSelect(sqm)) {
            throw new IllegalSelectQueryException(String.format(Locale.ROOT, "Expecting a SELECT Query [%s], but found %s", SqmSelectStatement.class.getName(), sqm.getClass().getName()), hqlString);
        }
    }

    public static void verifyIsNonSelectStatement(SqmStatement<?> sqm, String hqlString) {
        if (!SqmUtil.isMutation(sqm)) {
            throw SqmUtil.expectingNonSelect(sqm, hqlString);
        }
    }

    public static IllegalQueryOperationException expectingNonSelect(SqmStatement<?> sqm, String hqlString) {
        return new IllegalQueryOperationException(String.format(Locale.ROOT, "Expecting a non-SELECT Query [%s], but found %s", SqmDmlStatement.class.getName(), sqm.getClass().getName()), hqlString, null);
    }

    public static Map<QueryParameterImplementor<?>, Map<SqmParameter<?>, List<List<JdbcParameter>>>> generateJdbcParamsXref(DomainParameterXref domainParameterXref, JdbcParameterBySqmParameterAccess jdbcParameterBySqmParameterAccess) {
        if (domainParameterXref == null || !domainParameterXref.hasParameters()) {
            return Collections.emptyMap();
        }
        int queryParameterCount = domainParameterXref.getQueryParameterCount();
        IdentityHashMap result = new IdentityHashMap(queryParameterCount);
        for (Map.Entry<QueryParameterImplementor<?>, List<SqmParameter<?>>> entry : domainParameterXref.getSqmParamByQueryParam().entrySet()) {
            QueryParameterImplementor<?> queryParam = entry.getKey();
            List<SqmParameter<?>> sqmParams = entry.getValue();
            Map sqmParamMap = result.computeIfAbsent(queryParam, qp -> new IdentityHashMap(sqmParams.size()));
            for (SqmParameter<?> sqmParam : sqmParams) {
                sqmParamMap.put(sqmParam, jdbcParameterBySqmParameterAccess.getJdbcParamsBySqmParam().get(sqmParam));
                List<SqmParameter<?>> expansions = domainParameterXref.getExpansions(sqmParam);
                if (expansions.isEmpty()) continue;
                for (SqmParameter<?> expansion : expansions) {
                    sqmParamMap.put(expansion, jdbcParameterBySqmParameterAccess.getJdbcParamsBySqmParam().get(expansion));
                    result.put(queryParam, sqmParamMap);
                }
            }
        }
        return result;
    }

    public static JdbcParameterBindings createJdbcParameterBindings(QueryParameterBindings domainParamBindings, DomainParameterXref domainParameterXref, Map<QueryParameterImplementor<?>, Map<SqmParameter<?>, List<List<JdbcParameter>>>> jdbcParamXref, MappingMetamodel domainModel, Function<NavigablePath, TableGroup> tableGroupLocator, SqmParameterMappingModelResolutionAccess mappingModelResolutionAccess, SharedSessionContractImplementor session) {
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(domainParameterXref.getSqmParameterCount());
        for (Map.Entry<QueryParameterImplementor<?>, List<SqmParameter<?>>> entry : domainParameterXref.getSqmParamByQueryParam().entrySet()) {
            QueryParameterImplementor<?> queryParam = entry.getKey();
            List<SqmParameter<?>> sqmParameters = entry.getValue();
            QueryParameterBinding<?> domainParamBinding = domainParamBindings.getBinding(queryParam);
            Map<SqmParameter<?>, List<List<JdbcParameter>>> jdbcParamMap = jdbcParamXref.get(queryParam);
            for (SqmParameter<?> sqmParameter : sqmParameters) {
                List<JdbcParameter> jdbcParams;
                int i;
                BasicValueConverter valueConverter;
                List<JdbcParameter> jdbcParams2;
                MappingModelExpressible<?> resolvedMappingModelType = mappingModelResolutionAccess.getResolvedMappingModelType(sqmParameter);
                if (resolvedMappingModelType != null) {
                    domainParamBinding.setType(resolvedMappingModelType);
                }
                Bindable parameterType = SqmUtil.determineParameterType(domainParamBinding, queryParam, sqmParameters, mappingModelResolutionAccess, session.getFactory());
                List<List<JdbcParameter>> jdbcParamsBinds = jdbcParamMap.get(sqmParameter);
                if (jdbcParamsBinds == null) continue;
                if (!domainParamBinding.isBound()) {
                    for (int i2 = 0; i2 < jdbcParamsBinds.size(); ++i2) {
                        jdbcParams2 = jdbcParamsBinds.get(i2);
                        parameterType.forEachJdbcType((position, jdbcMapping) -> jdbcParameterBindings.addBinding((JdbcParameter)jdbcParams2.get(position), new JdbcParameterBindingImpl((JdbcMapping)jdbcMapping, null)));
                    }
                    continue;
                }
                if (domainParamBinding.isMultiValued()) {
                    Collection<?> bindValues = domainParamBinding.getBindValues();
                    Iterator<?> valueItr = bindValues.iterator();
                    for (int i3 = 0; i3 < jdbcParamsBinds.size(); ++i3) {
                        List<JdbcParameter> jdbcParams3 = jdbcParamsBinds.get(i3);
                        SqmUtil.createValueBindings(jdbcParameterBindings, queryParam, domainParamBinding, parameterType, jdbcParams3, valueItr.next(), tableGroupLocator, session);
                    }
                    List<SqmParameter<?>> expansions = domainParameterXref.getExpansions(sqmParameter);
                    assert (expansions.size() == bindValues.size() - 1);
                    int expansionPosition = 0;
                    while (valueItr.hasNext()) {
                        SqmParameter<?> expansionSqmParam = expansions.get(expansionPosition++);
                        List<List<JdbcParameter>> jdbcParamBinds = jdbcParamMap.get(expansionSqmParam);
                        for (int i4 = 0; i4 < jdbcParamBinds.size(); ++i4) {
                            List<JdbcParameter> expansionJdbcParams = jdbcParamBinds.get(i4);
                            SqmUtil.createValueBindings(jdbcParameterBindings, queryParam, domainParamBinding, parameterType, expansionJdbcParams, valueItr.next(), tableGroupLocator, session);
                        }
                    }
                    continue;
                }
                if (domainParamBinding.getBindValue() == null) {
                    for (int i5 = 0; i5 < jdbcParamsBinds.size(); ++i5) {
                        jdbcParams2 = jdbcParamsBinds.get(i5);
                        for (int j = 0; j < jdbcParams2.size(); ++j) {
                            JdbcParameter jdbcParameter = jdbcParams2.get(j);
                            jdbcParameterBindings.addBinding(jdbcParameter, new JdbcParameterBindingImpl(null, null));
                        }
                    }
                    continue;
                }
                JdbcMapping jdbcMapping2 = domainParamBinding.getType() instanceof JdbcMapping ? (JdbcMapping)((Object)domainParamBinding.getType()) : (domainParamBinding.getBindType() instanceof BasicValuedModelPart ? ((BasicValuedModelPart)domainParamBinding.getType()).getJdbcMapping() : null);
                BasicValueConverter basicValueConverter = valueConverter = jdbcMapping2 == null ? null : jdbcMapping2.getValueConverter();
                if (valueConverter != null) {
                    Object convertedValue = valueConverter.toRelationalValue(domainParamBinding.getBindValue());
                    for (i = 0; i < jdbcParamsBinds.size(); ++i) {
                        jdbcParams = jdbcParamsBinds.get(i);
                        assert (jdbcParams.size() == 1);
                        JdbcParameter jdbcParameter = jdbcParams.get(0);
                        jdbcParameterBindings.addBinding(jdbcParameter, new JdbcParameterBindingImpl(jdbcMapping2, convertedValue));
                    }
                    continue;
                }
                Object bindValue = domainParamBinding.getBindValue();
                for (i = 0; i < jdbcParamsBinds.size(); ++i) {
                    jdbcParams = jdbcParamsBinds.get(i);
                    SqmUtil.createValueBindings(jdbcParameterBindings, queryParam, domainParamBinding, parameterType, jdbcParams, bindValue, tableGroupLocator, session);
                }
            }
        }
        return jdbcParameterBindings;
    }

    private static void createValueBindings(JdbcParameterBindings jdbcParameterBindings, QueryParameterImplementor<?> domainParam, QueryParameterBinding<?> domainParamBinding, Bindable parameterType, List<JdbcParameter> jdbcParams, Object bindValue, Function<NavigablePath, TableGroup> tableGroupLocator, SharedSessionContractImplementor session) {
        EntityIdentifierMapping identifierMapping;
        if (parameterType == null) {
            throw new SqlTreeCreationException("Unable to interpret mapping-model type for Query parameter : " + domainParam);
        }
        if (parameterType instanceof PluralAttributeMapping) {
            parameterType = ((PluralAttributeMapping)parameterType).getElementDescriptor();
        }
        if (parameterType instanceof EntityIdentifierMapping) {
            identifierMapping = (EntityIdentifierMapping)parameterType;
            EntityMappingType entityMapping = identifierMapping.findContainingEntityMapping();
            if (entityMapping.getRepresentationStrategy().getInstantiator().isInstance(bindValue, session.getFactory())) {
                bindValue = identifierMapping.getIdentifierIfNotUnsaved(bindValue, session);
            }
        } else if (parameterType instanceof EntityMappingType) {
            identifierMapping = ((EntityMappingType)parameterType).getIdentifierMapping();
            EntityMappingType entityMapping = identifierMapping.findContainingEntityMapping();
            parameterType = identifierMapping;
            if (entityMapping.getRepresentationStrategy().getInstantiator().isInstance(bindValue, session.getFactory())) {
                bindValue = identifierMapping.getIdentifierIfNotUnsaved(bindValue, session);
            }
        } else if (parameterType instanceof EntityAssociationMapping) {
            EntityAssociationMapping association = (EntityAssociationMapping)parameterType;
            if (association.getSideNature() == ForeignKeyDescriptor.Nature.TARGET) {
                bindValue = association.getAssociatedEntityMappingType().getIdentifierMapping().getIdentifier(bindValue);
                parameterType = association.getAssociatedEntityMappingType().getIdentifierMapping();
            } else {
                bindValue = association.getForeignKeyDescriptor().getAssociationKeyFromSide(bindValue, association.getSideNature().inverse(), session);
                parameterType = association.getForeignKeyDescriptor();
            }
        }
        int offset = jdbcParameterBindings.registerParametersForEachJdbcValue(bindValue, Clause.IRRELEVANT, parameterType, jdbcParams, session);
        assert (offset == jdbcParams.size());
    }

    public static Bindable determineParameterType(QueryParameterBinding<?> binding, QueryParameterImplementor<?> parameter, List<SqmParameter<?>> sqmParameters, SqmParameterMappingModelResolutionAccess mappingModelResolutionAccess, SessionFactoryImplementor sessionFactory) {
        if (binding.getBindType() instanceof Bindable) {
            return (Bindable)((Object)binding.getBindType());
        }
        if (parameter.getHibernateType() instanceof Bindable) {
            return (Bindable)((Object)parameter.getHibernateType());
        }
        if (binding.getType() != null) {
            return binding.getType();
        }
        for (int i = 0; i < sqmParameters.size(); ++i) {
            MappingModelExpressible<?> mappingModelType = mappingModelResolutionAccess.getResolvedMappingModelType(sqmParameters.get(i));
            if (mappingModelType == null) continue;
            return mappingModelType;
        }
        TypeConfiguration typeConfiguration = sessionFactory.getTypeConfiguration();
        return typeConfiguration.standardBasicTypeForJavaType(parameter.getParameterType());
    }

    public static SqmStatement.ParameterResolutions resolveParameters(final SqmStatement<?> statement) {
        if (statement.getQuerySource() == SqmQuerySource.CRITERIA) {
            CriteriaParameterCollector parameterCollector = new CriteriaParameterCollector();
            ParameterCollector.collectParameters(statement, parameterCollector::process, statement.nodeBuilder().getServiceRegistry());
            return parameterCollector.makeResolution();
        }
        return new SqmStatement.ParameterResolutions(){

            @Override
            public Set<SqmParameter<?>> getSqmParameters() {
                return statement.getSqmParameters();
            }

            @Override
            public Map<JpaCriteriaParameter<?>, SqmJpaCriteriaParameterWrapper<?>> getJpaCriteriaParamResolutions() {
                return Collections.emptyMap();
            }
        };
    }

    private static class ParameterResolutionsImpl
    implements SqmStatement.ParameterResolutions {
        private final Set<SqmParameter<?>> sqmParameters;
        private final Map<JpaCriteriaParameter<?>, SqmJpaCriteriaParameterWrapper<?>> jpaCriteriaParamResolutions;

        public ParameterResolutionsImpl(Set<SqmParameter<?>> sqmParameters, Map<JpaCriteriaParameter<?>, List<SqmJpaCriteriaParameterWrapper<?>>> jpaCriteriaParamResolutions) {
            this.sqmParameters = sqmParameters;
            if (jpaCriteriaParamResolutions == null || jpaCriteriaParamResolutions.isEmpty()) {
                this.jpaCriteriaParamResolutions = Collections.emptyMap();
            } else {
                this.jpaCriteriaParamResolutions = new IdentityHashMap(CollectionHelper.determineProperSizing(jpaCriteriaParamResolutions));
                for (Map.Entry<JpaCriteriaParameter<?>, List<SqmJpaCriteriaParameterWrapper<?>>> entry : jpaCriteriaParamResolutions.entrySet()) {
                    Iterator<SqmJpaCriteriaParameterWrapper<?>> itr = entry.getValue().iterator();
                    if (!itr.hasNext()) {
                        throw new IllegalStateException("SqmJpaCriteriaParameterWrapper references for JpaCriteriaParameter [" + entry.getKey() + "] already exhausted");
                    }
                    this.jpaCriteriaParamResolutions.put(entry.getKey(), itr.next());
                }
            }
        }

        @Override
        public Set<SqmParameter<?>> getSqmParameters() {
            return this.sqmParameters;
        }

        @Override
        public Map<JpaCriteriaParameter<?>, SqmJpaCriteriaParameterWrapper<?>> getJpaCriteriaParamResolutions() {
            return this.jpaCriteriaParamResolutions;
        }
    }

    private static class CriteriaParameterCollector {
        private Set<SqmParameter<?>> sqmParameters;
        private Map<JpaCriteriaParameter<?>, List<SqmJpaCriteriaParameterWrapper<?>>> jpaCriteriaParamResolutions;

        private CriteriaParameterCollector() {
        }

        public void process(SqmParameter<?> parameter) {
            if (this.sqmParameters == null) {
                this.sqmParameters = new HashSet();
            }
            if (parameter instanceof SqmJpaCriteriaParameterWrapper) {
                if (this.jpaCriteriaParamResolutions == null) {
                    this.jpaCriteriaParamResolutions = new IdentityHashMap();
                }
                SqmJpaCriteriaParameterWrapper wrapper = (SqmJpaCriteriaParameterWrapper)parameter;
                JpaCriteriaParameter criteriaParameter = wrapper.getJpaCriteriaParameter();
                List sqmParametersForCriteriaParameter = this.jpaCriteriaParamResolutions.computeIfAbsent(criteriaParameter, jcp -> new ArrayList());
                sqmParametersForCriteriaParameter.add(wrapper);
                this.sqmParameters.add(wrapper);
            } else {
                if (parameter instanceof JpaCriteriaParameter) {
                    throw new UnsupportedOperationException();
                }
                this.sqmParameters.add(parameter);
            }
        }

        private SqmStatement.ParameterResolutions makeResolution() {
            return new ParameterResolutionsImpl(this.sqmParameters == null ? Collections.emptySet() : this.sqmParameters, this.jpaCriteriaParamResolutions == null ? Collections.emptyMap() : this.jpaCriteriaParamResolutions);
        }
    }
}

