/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal;

import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.sql.BaseSqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.internal.SqlAstProcessingStateImpl;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.query.sqm.tree.update.SqmSetClause;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstHelper;
import org.hibernate.sql.ast.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.update.Assignable;
import org.hibernate.sql.ast.tree.update.Assignment;

public class MultiTableSqmMutationConverter
extends BaseSqmToSqlAstConverter<Statement> {
    private final EntityMappingType mutatingEntityDescriptor;
    private final TableGroup mutatingTableGroup;
    private Predicate discriminatorPredicate;
    private SqmParameterResolutionConsumer parameterResolutionConsumer;

    public MultiTableSqmMutationConverter(EntityMappingType mutatingEntityDescriptor, SqmStatement<?> statement, SqmRoot<?> sqmRoot, DomainParameterXref domainParameterXref, QueryOptions queryOptions, LoadQueryInfluencers loadQueryInfluencers, QueryParameterBindings domainParameterBindings, SqlAstCreationContext creationContext) {
        this(mutatingEntityDescriptor, statement, sqmRoot, sqmRoot.getExplicitAlias(), domainParameterXref, queryOptions, loadQueryInfluencers, domainParameterBindings, creationContext);
    }

    public MultiTableSqmMutationConverter(EntityMappingType mutatingEntityDescriptor, SqmStatement<?> statement, SqmRoot<?> sqmRoot, String sourceAlias, DomainParameterXref domainParameterXref, QueryOptions queryOptions, LoadQueryInfluencers loadQueryInfluencers, QueryParameterBindings domainParameterBindings, SqlAstCreationContext creationContext) {
        super(creationContext, statement, queryOptions, loadQueryInfluencers, domainParameterXref, domainParameterBindings, false);
        this.mutatingEntityDescriptor = mutatingEntityDescriptor;
        SqlAstProcessingStateImpl rootProcessingState = new SqlAstProcessingStateImpl(null, this, this.getCurrentClauseStack()::getCurrent);
        this.pushProcessingState(rootProcessingState);
        this.mutatingTableGroup = mutatingEntityDescriptor.createRootTableGroup(true, sqmRoot.getNavigablePath(), sourceAlias, () -> predicate -> {
            this.discriminatorPredicate = predicate;
        }, this, creationContext.getSessionFactory());
        this.getFromClauseAccess().registerTableGroup(sqmRoot.getNavigablePath(), this.mutatingTableGroup);
    }

    @Override
    public void pruneTableGroupJoins() {
        super.pruneTableGroupJoins();
    }

    public EntityMappingType getMutatingEntityDescriptor() {
        return this.mutatingEntityDescriptor;
    }

    public TableGroup getMutatingTableGroup() {
        return this.mutatingTableGroup;
    }

    @Override
    public Stack<SqlAstProcessingState> getProcessingStateStack() {
        return super.getProcessingStateStack();
    }

    public void visitSetClause(SqmSetClause setClause, Consumer<Assignment> assignmentConsumer, SqmParameterResolutionConsumer parameterResolutionConsumer) {
        this.parameterResolutionConsumer = parameterResolutionConsumer;
        Iterator iterator = super.visitSetClause(setClause).iterator();
        while (iterator.hasNext()) {
            Assignment assignment = (Assignment)iterator.next();
            assignmentConsumer.accept(assignment);
        }
    }

    @Override
    public List<Assignment> visitSetClause(SqmSetClause setClause) {
        throw new UnsupportedOperationException();
    }

    public BaseSqmToSqlAstConverter.AdditionalInsertValues visitInsertionTargetPaths(BiConsumer<Assignable, List<ColumnReference>> targetColumnReferenceConsumer, SqmInsertStatement<?> sqmStatement, EntityPersister entityDescriptor, TableGroup tableGroup, SqmParameterResolutionConsumer parameterResolutionConsumer) {
        this.parameterResolutionConsumer = parameterResolutionConsumer;
        return this.visitInsertionTargetPaths(targetColumnReferenceConsumer, sqmStatement, entityDescriptor, tableGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Predicate visitWhereClause(SqmWhereClause sqmWhereClause, final Consumer<ColumnReference> restrictionColumnReferenceConsumer, SqmParameterResolutionConsumer parameterResolutionConsumer) {
        this.parameterResolutionConsumer = parameterResolutionConsumer;
        if (sqmWhereClause == null || sqmWhereClause.getPredicate() == null) {
            return null;
        }
        final SqlAstProcessingState rootProcessingState = this.getCurrentProcessingState();
        SqlAstProcessingStateImpl restrictionProcessingState = new SqlAstProcessingStateImpl(rootProcessingState, this, this.getCurrentClauseStack()::getCurrent){

            @Override
            public SqlExpressionResolver getSqlExpressionResolver() {
                return this;
            }

            @Override
            public Expression resolveSqlExpression(SqlExpressionResolver.ColumnReferenceKey key, Function<SqlAstProcessingState, Expression> creator) {
                Expression expression = rootProcessingState.getSqlExpressionResolver().resolveSqlExpression(key, creator);
                if (expression instanceof ColumnReference) {
                    restrictionColumnReferenceConsumer.accept((ColumnReference)expression);
                }
                return expression;
            }
        };
        this.pushProcessingState(restrictionProcessingState, this.getFromClauseIndex());
        try {
            Predicate predicate = SqlAstHelper.combinePredicates((Predicate)sqmWhereClause.getPredicate().accept(this), this.discriminatorPredicate);
            return predicate;
        }
        finally {
            this.popProcessingStateStack();
            this.parameterResolutionConsumer = null;
        }
    }

    @Override
    public Predicate visitWhereClause(SqmWhereClause whereClause) {
        return (Predicate)super.visitWhereClause(whereClause);
    }

    @Override
    protected Expression consumeSqmParameter(SqmParameter<?> sqmParameter, MappingModelExpressible<?> valueMapping, BiConsumer<Integer, JdbcParameter> jdbcParameterConsumer) {
        assert (this.parameterResolutionConsumer != null);
        Expression expression = super.consumeSqmParameter(sqmParameter, valueMapping, jdbcParameterConsumer);
        List<List<JdbcParameter>> jdbcParameters = this.getJdbcParamsBySqmParam().get(sqmParameter);
        MappingModelExpressible<?> mappingType = this.getSqmParameterMappingModelExpressibleResolutions().get(sqmParameter);
        this.parameterResolutionConsumer.accept(sqmParameter, mappingType, jdbcParameters.get(jdbcParameters.size() - 1));
        return expression;
    }

    public static interface SqmParameterResolutionConsumer {
        public void accept(SqmParameter<?> var1, MappingModelExpressible<?> var2, List<JdbcParameter> var3);
    }
}

