/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import java.util.List;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.persister.entity.DiscriminatorType;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.JavaTypedExpressible;

public class EntityTypeLiteral
implements Expression,
MappingModelExpressible<Object>,
DomainResultProducer<Object>,
JavaTypedExpressible<Object> {
    private final EntityPersister entityTypeDescriptor;
    private final DiscriminatorType<?> discriminatorType;

    public EntityTypeLiteral(EntityPersister entityTypeDescriptor) {
        this.entityTypeDescriptor = entityTypeDescriptor;
        this.discriminatorType = (DiscriminatorType)((Queryable)entityTypeDescriptor).getTypeDiscriminatorMetadata().getResolutionType();
    }

    public EntityPersister getEntityTypeDescriptor() {
        return this.entityTypeDescriptor;
    }

    @Override
    public MappingModelExpressible getExpressionType() {
        return this;
    }

    @Override
    public int getJdbcTypeCount() {
        return this.discriminatorType.getJdbcTypeCount();
    }

    @Override
    public List<JdbcMapping> getJdbcMappings() {
        return this.discriminatorType.getJdbcMappings();
    }

    @Override
    public JdbcMapping getJdbcMapping(int index) {
        return this.discriminatorType.getJdbcMapping(index);
    }

    @Override
    public JdbcMapping getSingleJdbcMapping() {
        return this.discriminatorType.getSingleJdbcMapping();
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        return this.discriminatorType.forEachJdbcType(offset, action);
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.discriminatorType.disassemble(value, session);
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        return this.discriminatorType.forEachDisassembledJdbcValue(value, offset, valuesConsumer, session);
    }

    @Override
    public int forEachJdbcValue(Object value, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        return this.discriminatorType.forEachJdbcValue(value, offset, valuesConsumer, session);
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        this.createSqlSelection(creationState);
    }

    @Override
    public DomainResult<Object> createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        return new BasicResult<Object>(this.createSqlSelection(creationState).getValuesArrayPosition(), resultVariable, this.discriminatorType);
    }

    private SqlSelection createSqlSelection(DomainResultCreationState creationState) {
        return creationState.getSqlAstCreationState().getSqlExpressionResolver().resolveSqlSelection(this, this.discriminatorType.getJdbcJavaType(), null, creationState.getSqlAstCreationState().getCreationContext().getMappingMetamodel().getTypeConfiguration());
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitEntityTypeLiteral(this);
    }

    @Override
    public JavaType getExpressibleJavaType() {
        return this.discriminatorType.getExpressibleJavaType();
    }
}

