/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.model.ast.builder;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.ast.ColumnValueBinding;
import org.hibernate.sql.model.ast.ColumnValueParameter;
import org.hibernate.sql.model.ast.ColumnValueParameterList;
import org.hibernate.sql.model.ast.ColumnWriteFragment;
import org.hibernate.sql.model.ast.MutatingTableReference;
import org.hibernate.sql.model.ast.TableMutation;
import org.hibernate.sql.model.ast.builder.TableMutationBuilder;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public abstract class AbstractTableMutationBuilder<M extends TableMutation<?>>
implements TableMutationBuilder<M> {
    private final SessionFactoryImplementor sessionFactory;
    private final MutationType mutationType;
    private final MutationTarget<?> mutationTarget;
    private final MutatingTableReference mutatingTable;
    private final ColumnValueParameterList parameters;

    public AbstractTableMutationBuilder(MutationType mutationType, MutationTarget<?> mutationTarget, TableMapping table, SessionFactoryImplementor sessionFactory) {
        this(mutationType, mutationTarget, new MutatingTableReference(table), sessionFactory);
    }

    public AbstractTableMutationBuilder(MutationType mutationType, MutationTarget<?> mutationTarget, MutatingTableReference mutatingTable, SessionFactoryImplementor sessionFactory) {
        this.mutationType = mutationType;
        this.mutationTarget = mutationTarget;
        this.sessionFactory = sessionFactory;
        this.mutatingTable = mutatingTable;
        this.parameters = new ColumnValueParameterList(mutatingTable, null, 0);
    }

    protected MutationTarget<?> getMutationTarget() {
        return this.mutationTarget;
    }

    @Override
    public MutatingTableReference getMutatingTable() {
        return this.mutatingTable;
    }

    protected ColumnValueParameterList getParameters() {
        return this.parameters;
    }

    protected SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    protected JdbcServices getJdbcServices() {
        return this.sessionFactory.getJdbcServices();
    }

    protected void addColumn(String columnName, String columnWriteFragment, JdbcMapping jdbcMapping, List<ColumnValueBinding> list) {
        ColumnValueBinding valueBinding = this.createValueBinding(columnName, columnWriteFragment, jdbcMapping);
        list.add(valueBinding);
    }

    protected void addColumn(String columnName, String columnWriteFragment, JdbcMapping jdbcMapping, ParameterUsage parameterUsage, List<ColumnValueBinding> list) {
        ColumnValueBinding valueBinding = this.createValueBinding(columnName, columnWriteFragment, jdbcMapping, parameterUsage);
        list.add(valueBinding);
    }

    protected ColumnValueBinding createValueBinding(String columnName, String columnWriteFragment, JdbcMapping jdbcMapping) {
        return this.createValueBinding(columnName, columnWriteFragment, jdbcMapping, ParameterUsage.SET);
    }

    protected ColumnValueBinding createValueBinding(String columnName, String customWriteExpression, JdbcMapping jdbcMapping, ParameterUsage parameterUsage) {
        ColumnWriteFragment columnWriteFragment;
        ColumnReference columnReference = new ColumnReference(this.mutatingTable, columnName, jdbcMapping);
        if (customWriteExpression.contains("?")) {
            EmbeddableMappingType aggregateMappingType;
            JdbcType jdbcType = jdbcMapping.getJdbcType();
            EmbeddableMappingType embeddableMappingType = aggregateMappingType = jdbcType instanceof AggregateJdbcType ? ((AggregateJdbcType)jdbcType).getEmbeddableMappingType() : null;
            if (aggregateMappingType != null && !aggregateMappingType.shouldBindAggregateMapping()) {
                ColumnValueParameterList parameters = new ColumnValueParameterList(this.getMutatingTable(), parameterUsage, aggregateMappingType.getJdbcTypeCount());
                aggregateMappingType.forEachSelectable(parameters);
                this.parameters.addAll(parameters);
                columnWriteFragment = new ColumnWriteFragment(customWriteExpression, parameters, jdbcMapping);
            } else {
                ColumnValueParameter parameter = new ColumnValueParameter(columnReference, parameterUsage);
                this.parameters.add(parameter);
                columnWriteFragment = new ColumnWriteFragment(customWriteExpression, parameter, jdbcMapping);
            }
        } else {
            columnWriteFragment = new ColumnWriteFragment(customWriteExpression, jdbcMapping);
        }
        return new ColumnValueBinding(columnReference, columnWriteFragment);
    }

    @SafeVarargs
    protected final <T> List<T> combine(List<T> list1, List<T> ... additionalLists) {
        ArrayList<T> combined;
        ArrayList<T> arrayList = combined = list1 == null ? new ArrayList<T>() : new ArrayList<T>(list1);
        if (additionalLists != null) {
            for (int i = 0; i < additionalLists.length; ++i) {
                if (additionalLists[i] == null) continue;
                combined.addAll(additionalLists[i]);
            }
        }
        return combined;
    }

    public String toString() {
        return "TableMutationBuilder( " + this.mutationType + " - `" + this.mutatingTable.getTableName() + "`)";
    }
}

