/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import java.util.HashSet;
import java.util.Set;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.entity.LoadingEntityEntry;
import org.hibernate.sql.results.graph.entity.internal.AbstractBatchEntitySelectFetchInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class BatchInitializeEntitySelectFetchInitializer
extends AbstractBatchEntitySelectFetchInitializer {
    private final Set<EntityKey> toBatchLoad = new HashSet<EntityKey>();
    private State state = State.UNINITIALIZED;

    public BatchInitializeEntitySelectFetchInitializer(FetchParentAccess parentAccess, ToOneAttributeMapping referencedModelPart, NavigablePath fetchedNavigable, EntityPersister concreteDescriptor, DomainResultAssembler<?> identifierAssembler) {
        super(parentAccess, referencedModelPart, fetchedNavigable, concreteDescriptor, identifierAssembler);
    }

    @Override
    protected void registerResolutionListener() {
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
        if (this.state != State.UNINITIALIZED) {
            return;
        }
        super.resolveKey(rowProcessingState);
        this.state = this.entityKey == null ? State.MISSING : State.KEY_RESOLVED;
    }

    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
        if (this.state != State.KEY_RESOLVED) {
            return;
        }
        this.state = State.INITIALIZED;
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        this.entityInstance = session.getPersistenceContext().getEntity(this.entityKey);
        if (this.entityInstance == null) {
            LoadingEntityEntry loadingEntityEntry = rowProcessingState.getJdbcValuesSourceProcessingState().findLoadingEntityLocally(this.entityKey);
            if (loadingEntityEntry != null) {
                loadingEntityEntry.getEntityInitializer().resolveInstance(rowProcessingState);
                this.entityInstance = loadingEntityEntry.getEntityInstance();
            } else if (this.entityInstance == null) {
                this.entityInstance = session.internalLoad(this.entityKey.getEntityName(), this.entityKey.getIdentifier(), false, false);
                this.toBatchLoad.add(this.entityKey);
            }
        }
    }

    @Override
    public boolean isEntityInitialized() {
        return this.state == State.INITIALIZED;
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        super.finishUpRow(rowProcessingState);
        this.state = State.UNINITIALIZED;
    }

    @Override
    public void endLoading(ExecutionContext context) {
        SharedSessionContractImplementor session = context.getSession();
        for (EntityKey key : this.toBatchLoad) {
            BatchInitializeEntitySelectFetchInitializer.loadInstance(key, this.referencedModelPart, session);
        }
        this.toBatchLoad.clear();
        this.parentAccess = null;
    }

    public String toString() {
        return "BatchInitializeEntitySelectFetchInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }

    static enum State {
        UNINITIALIZED,
        MISSING,
        KEY_RESOLVED,
        INITIALIZED;

    }
}

