/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.spi;

import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.StandardStack;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.collection.LoadingCollectionEntry;
import org.hibernate.sql.results.graph.entity.LoadingEntityEntry;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingState;

public class LoadContexts {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(LoadContexts.class);
    private final PersistenceContext persistenceContext;
    private final StandardStack<JdbcValuesSourceProcessingState> jdbcValuesSourceProcessingStateStack = new StandardStack<JdbcValuesSourceProcessingState>(JdbcValuesSourceProcessingState.class);

    public LoadContexts(PersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    public void register(JdbcValuesSourceProcessingState state) {
        this.jdbcValuesSourceProcessingStateStack.push(state);
    }

    public void deregister(JdbcValuesSourceProcessingState state) {
        JdbcValuesSourceProcessingState previous = this.jdbcValuesSourceProcessingStateStack.pop();
        if (previous != state) {
            throw new IllegalStateException("Illegal pop() with non-matching JdbcValuesSourceProcessingState");
        }
    }

    public LoadingEntityEntry findLoadingEntityEntry(EntityKey entityKey) {
        return this.jdbcValuesSourceProcessingStateStack.findCurrentFirstWithParameter(entityKey, JdbcValuesSourceProcessingState::findLoadingEntityLocally);
    }

    public LoadingCollectionEntry findLoadingCollectionEntry(CollectionKey collectionKey) {
        return this.jdbcValuesSourceProcessingStateStack.findCurrentFirstWithParameter(collectionKey, JdbcValuesSourceProcessingState::findLoadingCollectionLocally);
    }

    public Initializer findInitializer(EntityUniqueKey key) {
        return this.jdbcValuesSourceProcessingStateStack.findCurrentFirstWithParameter(key, JdbcValuesSourceProcessingState::findInitializer);
    }

    public PersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    public void cleanup() {
        if (!this.jdbcValuesSourceProcessingStateStack.isEmpty()) {
            log.debug("LoadContexts still contained JdbcValuesSourceProcessingState registrations on cleanup");
        }
        this.jdbcValuesSourceProcessingStateStack.clear();
    }
}

