/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Internal;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.AuxiliaryDatabaseObject;
import org.hibernate.boot.model.relational.ContributableDatabaseObject;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.Exportable;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.boot.model.relational.internal.SqlStringGenerationContextImpl;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.internal.Formatter;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UserDefinedType;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.tool.schema.SourceType;
import org.hibernate.tool.schema.internal.DefaultSchemaFilter;
import org.hibernate.tool.schema.internal.ExceptionHandlerLoggedImpl;
import org.hibernate.tool.schema.internal.Helper;
import org.hibernate.tool.schema.internal.HibernateSchemaManagementTool;
import org.hibernate.tool.schema.internal.exec.GenerationTarget;
import org.hibernate.tool.schema.internal.exec.GenerationTargetToDatabase;
import org.hibernate.tool.schema.internal.exec.JdbcContext;
import org.hibernate.tool.schema.spi.CommandAcceptanceException;
import org.hibernate.tool.schema.spi.ContributableMatcher;
import org.hibernate.tool.schema.spi.DelayedDropAction;
import org.hibernate.tool.schema.spi.ExceptionHandler;
import org.hibernate.tool.schema.spi.ExecutionOptions;
import org.hibernate.tool.schema.spi.SchemaDropper;
import org.hibernate.tool.schema.spi.SchemaFilter;
import org.hibernate.tool.schema.spi.SchemaManagementException;
import org.hibernate.tool.schema.spi.SchemaManagementTool;
import org.hibernate.tool.schema.spi.ScriptSourceInput;
import org.hibernate.tool.schema.spi.SourceDescriptor;
import org.hibernate.tool.schema.spi.SqlScriptCommandExtractor;
import org.hibernate.tool.schema.spi.TargetDescriptor;
import org.jboss.logging.Logger;

public class SchemaDropperImpl
implements SchemaDropper {
    private static final Logger log = Logger.getLogger(SchemaDropperImpl.class);
    private final HibernateSchemaManagementTool tool;
    private final SchemaFilter schemaFilter;

    public SchemaDropperImpl(HibernateSchemaManagementTool tool) {
        this(tool, (SchemaFilter)DefaultSchemaFilter.INSTANCE);
    }

    public SchemaDropperImpl(HibernateSchemaManagementTool tool, SchemaFilter schemaFilter) {
        this.tool = tool;
        this.schemaFilter = schemaFilter;
    }

    public SchemaDropperImpl(ServiceRegistry serviceRegistry) {
        this(serviceRegistry, (SchemaFilter)DefaultSchemaFilter.INSTANCE);
    }

    public SchemaDropperImpl(ServiceRegistry serviceRegistry, SchemaFilter schemaFilter) {
        SchemaManagementTool smt = serviceRegistry.getService(SchemaManagementTool.class);
        if (!(smt instanceof HibernateSchemaManagementTool)) {
            smt = new HibernateSchemaManagementTool();
            ((HibernateSchemaManagementTool)smt).injectServices((ServiceRegistryImplementor)serviceRegistry);
        }
        this.tool = (HibernateSchemaManagementTool)smt;
        this.schemaFilter = schemaFilter;
    }

    @Override
    public void doDrop(Metadata metadata, ExecutionOptions options, ContributableMatcher inclusionFilter, SourceDescriptor sourceDescriptor, TargetDescriptor targetDescriptor) {
        if (!targetDescriptor.getTargetTypes().isEmpty()) {
            Map<String, Object> configuration = options.getConfigurationValues();
            JdbcContext jdbcContext = this.tool.resolveJdbcContext(configuration);
            this.doDrop(metadata, options, inclusionFilter, jdbcContext.getDialect(), sourceDescriptor, this.tool.buildGenerationTargets(targetDescriptor, jdbcContext, configuration, true));
        }
    }

    @Internal
    public void doDrop(Metadata metadata, ExecutionOptions options, Dialect dialect, SourceDescriptor sourceDescriptor, GenerationTarget ... targets) {
        this.doDrop(metadata, options, (ContributableDatabaseObject contributed) -> true, dialect, sourceDescriptor, targets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public void doDrop(Metadata metadata, ExecutionOptions options, ContributableMatcher inclusionFilter, Dialect dialect, SourceDescriptor sourceDescriptor, GenerationTarget ... targets) {
        for (GenerationTarget target : targets) {
            target.prepare();
        }
        try {
            this.performDrop(metadata, options, inclusionFilter, dialect, sourceDescriptor, targets);
        }
        finally {
            for (GenerationTarget target : targets) {
                try {
                    target.release();
                }
                catch (Exception e) {
                    log.debugf("Problem releasing GenerationTarget [%s] : %s", (Object)target, (Object)e.getMessage());
                }
            }
        }
    }

    private void performDrop(Metadata metadata, ExecutionOptions options, ContributableMatcher inclusionFilter, Dialect dialect, SourceDescriptor sourceDescriptor, GenerationTarget ... targets) {
        SqlScriptCommandExtractor commandExtractor = this.getCommandExtractor();
        boolean format = Helper.interpretFormattingEnabled(options.getConfigurationValues());
        Formatter formatter = format ? FormatStyle.DDL.getFormatter() : FormatStyle.NONE.getFormatter();
        switch (sourceDescriptor.getSourceType()) {
            case SCRIPT: {
                this.dropFromScript(sourceDescriptor.getScriptSourceInput(), commandExtractor, formatter, dialect, options, targets);
                break;
            }
            case METADATA: {
                this.dropFromMetadata(metadata, options, inclusionFilter, dialect, formatter, targets);
                break;
            }
            case METADATA_THEN_SCRIPT: {
                this.dropFromMetadata(metadata, options, inclusionFilter, dialect, formatter, targets);
                this.dropFromScript(sourceDescriptor.getScriptSourceInput(), commandExtractor, formatter, dialect, options, targets);
                break;
            }
            case SCRIPT_THEN_METADATA: {
                this.dropFromScript(sourceDescriptor.getScriptSourceInput(), commandExtractor, formatter, dialect, options, targets);
                this.dropFromMetadata(metadata, options, inclusionFilter, dialect, formatter, targets);
            }
        }
    }

    private SqlScriptCommandExtractor getCommandExtractor() {
        return this.tool.getServiceRegistry().getService(SqlScriptCommandExtractor.class);
    }

    private void dropFromScript(ScriptSourceInput scriptSourceInput, SqlScriptCommandExtractor commandExtractor, Formatter formatter, Dialect dialect, ExecutionOptions options, GenerationTarget ... targets) {
        List<String> commands = scriptSourceInput.extract(reader -> commandExtractor.extractCommands((Reader)reader, dialect));
        for (String command : commands) {
            SchemaDropperImpl.applySqlString(command, formatter, options, targets);
        }
    }

    private static SqlStringGenerationContext createSqlStringGenerationContext(ExecutionOptions options, Metadata metadata) {
        Database database = metadata.getDatabase();
        return SqlStringGenerationContextImpl.fromConfigurationMap(database.getJdbcEnvironment(), database, options.getConfigurationValues());
    }

    private void dropFromMetadata(Metadata metadata, ExecutionOptions options, ContributableMatcher inclusionFilter, Dialect dialect, Formatter formatter, GenerationTarget ... targets) {
        SqlStringGenerationContext context = SchemaDropperImpl.createSqlStringGenerationContext(options, metadata);
        SchemaDropperImpl.dropAuxiliaryObjectsBeforeTables(metadata, options, dialect, formatter, context, targets);
        this.dropConstraintsTablesSequences(metadata, options, inclusionFilter, dialect, formatter, context, targets);
        SchemaDropperImpl.dropAuxiliaryObjectsAfterTables(metadata, options, dialect, formatter, context, targets);
        SchemaDropperImpl.dropUserDefinedTypes(metadata, options, dialect, formatter, context, targets);
        SchemaDropperImpl.dropSchemasAndCatalogs(metadata, options, dialect, formatter, targets);
    }

    private void dropConstraintsTablesSequences(Metadata metadata, ExecutionOptions options, ContributableMatcher inclusionFilter, Dialect dialect, Formatter formatter, SqlStringGenerationContext context, GenerationTarget[] targets) {
        HashSet<String> exportIdentifiers = CollectionHelper.setOfSize(50);
        for (Namespace namespace : metadata.getDatabase().getNamespaces()) {
            if (!options.getSchemaFilter().includeNamespace(namespace)) continue;
            this.applyConstraintDropping(namespace, metadata, formatter, options, context, inclusionFilter, targets);
            SchemaDropperImpl.dropTables(metadata, options, inclusionFilter, dialect, formatter, exportIdentifiers, context, namespace, targets);
            SchemaDropperImpl.dropSequences(metadata, options, inclusionFilter, dialect, formatter, exportIdentifiers, context, namespace, targets);
        }
    }

    private static void dropAuxiliaryObjectsBeforeTables(Metadata metadata, ExecutionOptions options, Dialect dialect, Formatter formatter, SqlStringGenerationContext context, GenerationTarget[] targets) {
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : SchemaDropperImpl.reverse(metadata.getDatabase().getAuxiliaryDatabaseObjects())) {
            if (auxiliaryDatabaseObject.beforeTablesOnCreation() || !auxiliaryDatabaseObject.appliesToDialect(dialect)) continue;
            SchemaDropperImpl.applySqlStrings(dialect.getAuxiliaryDatabaseObjectExporter().getSqlDropStrings(auxiliaryDatabaseObject, metadata, context), formatter, options, targets);
        }
    }

    private static void dropAuxiliaryObjectsAfterTables(Metadata metadata, ExecutionOptions options, Dialect dialect, Formatter formatter, SqlStringGenerationContext context, GenerationTarget[] targets) {
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : SchemaDropperImpl.reverse(metadata.getDatabase().getAuxiliaryDatabaseObjects())) {
            if (!auxiliaryDatabaseObject.beforeTablesOnCreation() || !auxiliaryDatabaseObject.appliesToDialect(dialect)) continue;
            SchemaDropperImpl.applySqlStrings(auxiliaryDatabaseObject.sqlDropStrings(context), formatter, options, targets);
        }
    }

    private static void dropSequences(Metadata metadata, ExecutionOptions options, ContributableMatcher inclusionFilter, Dialect dialect, Formatter formatter, Set<String> exportIdentifiers, SqlStringGenerationContext context, Namespace namespace, GenerationTarget[] targets) {
        for (Sequence sequence : namespace.getSequences()) {
            if (!options.getSchemaFilter().includeSequence(sequence) || !inclusionFilter.matches(sequence)) continue;
            SchemaDropperImpl.checkExportIdentifier(sequence, exportIdentifiers);
            SchemaDropperImpl.applySqlStrings(dialect.getSequenceExporter().getSqlDropStrings(sequence, metadata, context), formatter, options, targets);
        }
    }

    private static void dropTables(Metadata metadata, ExecutionOptions options, ContributableMatcher inclusionFilter, Dialect dialect, Formatter formatter, Set<String> exportIdentifiers, SqlStringGenerationContext context, Namespace namespace, GenerationTarget[] targets) {
        for (Table table : namespace.getTables()) {
            if (!table.isPhysicalTable() || !options.getSchemaFilter().includeTable(table) || !inclusionFilter.matches(table)) continue;
            SchemaDropperImpl.checkExportIdentifier(table, exportIdentifiers);
            SchemaDropperImpl.applySqlStrings(dialect.getTableExporter().getSqlDropStrings(table, metadata, context), formatter, options, targets);
        }
    }

    private static void dropUserDefinedTypes(Metadata metadata, ExecutionOptions options, Dialect dialect, Formatter formatter, SqlStringGenerationContext context, GenerationTarget[] targets) {
        for (Namespace namespace : metadata.getDatabase().getNamespaces()) {
            if (!options.getSchemaFilter().includeNamespace(namespace)) continue;
            List<UserDefinedType> dependencyOrderedUserDefinedTypes = namespace.getDependencyOrderedUserDefinedTypes();
            Collections.reverse(dependencyOrderedUserDefinedTypes);
            for (UserDefinedType userDefinedType : dependencyOrderedUserDefinedTypes) {
                SchemaDropperImpl.applySqlStrings(dialect.getUserDefinedTypeExporter().getSqlDropStrings(userDefinedType, metadata, context), formatter, options, targets);
            }
        }
    }

    private static void dropSchemasAndCatalogs(Metadata metadata, ExecutionOptions options, Dialect dialect, Formatter formatter, GenerationTarget[] targets) {
        boolean tryToDropSchemas;
        boolean tryToDropCatalogs = options.shouldManageNamespaces() && dialect.canCreateCatalog();
        boolean bl = tryToDropSchemas = options.shouldManageNamespaces() && dialect.canCreateSchema();
        if (tryToDropCatalogs || tryToDropSchemas) {
            HashSet<Identifier> exportedCatalogs = new HashSet<Identifier>();
            for (Namespace namespace : metadata.getDatabase().getNamespaces()) {
                if (!options.getSchemaFilter().includeNamespace(namespace)) continue;
                if (tryToDropSchemas && namespace.getPhysicalName().getSchema() != null) {
                    String schemaName = namespace.getPhysicalName().getSchema().render(dialect);
                    SchemaDropperImpl.applySqlStrings(dialect.getDropSchemaCommand(schemaName), formatter, options, targets);
                }
                if (!tryToDropCatalogs) continue;
                Identifier catalogLogicalName = namespace.getName().getCatalog();
                Identifier catalogPhysicalName = namespace.getPhysicalName().getCatalog();
                if (catalogPhysicalName == null || exportedCatalogs.contains(catalogLogicalName)) continue;
                String catalogName = catalogPhysicalName.render(dialect);
                SchemaDropperImpl.applySqlStrings(dialect.getDropCatalogCommand(catalogName), formatter, options, targets);
                exportedCatalogs.add(catalogLogicalName);
            }
        }
    }

    private static Collection<AuxiliaryDatabaseObject> reverse(Collection<AuxiliaryDatabaseObject> auxiliaryDatabaseObjects) {
        ArrayList<AuxiliaryDatabaseObject> list = new ArrayList<AuxiliaryDatabaseObject>(auxiliaryDatabaseObjects);
        Collections.reverse(list);
        return list;
    }

    private void applyConstraintDropping(Namespace namespace, Metadata metadata, Formatter formatter, ExecutionOptions options, SqlStringGenerationContext context, ContributableMatcher inclusionFilter, GenerationTarget ... targets) {
        Dialect dialect = metadata.getDatabase().getJdbcEnvironment().getDialect();
        if (dialect.dropConstraints()) {
            for (Table table : namespace.getTables()) {
                if (!table.isPhysicalTable() || !options.getSchemaFilter().includeTable(table) || !inclusionFilter.matches(table)) continue;
                for (ForeignKey foreignKey : table.getForeignKeys().values()) {
                    SchemaDropperImpl.applySqlStrings(dialect.getForeignKeyExporter().getSqlDropStrings(foreignKey, metadata, context), formatter, options, targets);
                }
            }
        }
    }

    private static void checkExportIdentifier(Exportable exportable, Set<String> exportIdentifiers) {
        String exportIdentifier = exportable.getExportIdentifier();
        if (exportIdentifiers.contains(exportIdentifier)) {
            throw new SchemaManagementException("SQL strings added more than once for: " + exportIdentifier);
        }
        exportIdentifiers.add(exportIdentifier);
    }

    private static void applySqlStrings(String[] sqlStrings, Formatter formatter, ExecutionOptions options, GenerationTarget ... targets) {
        if (sqlStrings != null) {
            for (String sqlString : sqlStrings) {
                SchemaDropperImpl.applySqlString(sqlString, formatter, options, targets);
            }
        }
    }

    private static void applySqlString(String sqlString, Formatter formatter, ExecutionOptions options, GenerationTarget ... targets) {
        if (StringHelper.isNotEmpty(sqlString)) {
            String sqlStringFormatted = formatter.format(sqlString);
            for (GenerationTarget target : targets) {
                try {
                    target.accept(sqlStringFormatted);
                }
                catch (CommandAcceptanceException e) {
                    options.getExceptionHandler().handleException(e);
                }
            }
        }
    }

    @Override
    public DelayedDropAction buildDelayedAction(Metadata metadata, ExecutionOptions options, ContributableMatcher inclusionFilter, SourceDescriptor sourceDescriptor) {
        JournalingGenerationTarget target = new JournalingGenerationTarget();
        Dialect dialect = this.tool.getServiceRegistry().getService(JdbcEnvironment.class).getDialect();
        this.doDrop(metadata, options, inclusionFilter, dialect, sourceDescriptor, target);
        return new DelayedDropActionImpl(target.commands, this.tool.getCustomDatabaseGenerationTarget());
    }

    public void doDrop(Metadata metadata, boolean manageNamespaces, GenerationTarget ... targets) {
        StandardServiceRegistry serviceRegistry = ((MetadataImplementor)metadata).getMetadataBuildingOptions().getServiceRegistry();
        this.doDrop(metadata, serviceRegistry, serviceRegistry.getService(ConfigurationService.class).getSettings(), manageNamespaces, targets);
    }

    public void doDrop(Metadata metadata, ServiceRegistry serviceRegistry, final Map<String, Object> settings, final boolean manageNamespaces, GenerationTarget ... targets) {
        if (targets == null || targets.length == 0) {
            JdbcContext jdbcContext = this.tool.resolveJdbcContext(settings);
            targets = new GenerationTarget[]{new GenerationTargetToDatabase(serviceRegistry.getService(TransactionCoordinatorBuilder.class).buildDdlTransactionIsolator(jdbcContext), true)};
        }
        this.doDrop(metadata, new ExecutionOptions(){

            @Override
            public boolean shouldManageNamespaces() {
                return manageNamespaces;
            }

            @Override
            public Map<String, Object> getConfigurationValues() {
                return settings;
            }

            @Override
            public ExceptionHandler getExceptionHandler() {
                return ExceptionHandlerLoggedImpl.INSTANCE;
            }

            @Override
            public SchemaFilter getSchemaFilter() {
                return SchemaDropperImpl.this.schemaFilter;
            }
        }, (ContributableDatabaseObject contributed) -> true, serviceRegistry.getService(JdbcEnvironment.class).getDialect(), new SourceDescriptor(){

            @Override
            public SourceType getSourceType() {
                return SourceType.METADATA;
            }

            @Override
            public ScriptSourceInput getScriptSourceInput() {
                return null;
            }
        }, targets);
    }

    private static class DelayedDropActionImpl
    implements DelayedDropAction,
    Serializable {
        private static final CoreMessageLogger log = CoreLogging.messageLogger(DelayedDropActionImpl.class);
        private final ArrayList<String> commands;
        private GenerationTarget target;

        public DelayedDropActionImpl(ArrayList<String> commands, GenerationTarget target) {
            this.commands = commands;
            this.target = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void perform(ServiceRegistry serviceRegistry) {
            log.startingDelayedSchemaDrop();
            JdbcContextDelayedDropImpl jdbcContext = new JdbcContextDelayedDropImpl(serviceRegistry);
            if (this.target == null) {
                this.target = new GenerationTargetToDatabase(serviceRegistry.getService(TransactionCoordinatorBuilder.class).buildDdlTransactionIsolator(jdbcContext), true);
            }
            this.target.prepare();
            try {
                for (String command : this.commands) {
                    try {
                        this.target.accept(command);
                    }
                    catch (CommandAcceptanceException e) {
                        log.unsuccessfulSchemaManagementCommand(command);
                        log.debugf((Throwable)((Object)e), "Error performing delayed DROP command [%s]", command);
                    }
                }
            }
            finally {
                this.target.release();
            }
        }

        private static class JdbcContextDelayedDropImpl
        implements JdbcContext {
            private final ServiceRegistry serviceRegistry;
            private final JdbcServices jdbcServices;
            private final JdbcConnectionAccess jdbcConnectionAccess;

            public JdbcContextDelayedDropImpl(ServiceRegistry serviceRegistry) {
                this.serviceRegistry = serviceRegistry;
                this.jdbcServices = serviceRegistry.getService(JdbcServices.class);
                this.jdbcConnectionAccess = this.jdbcServices.getBootstrapJdbcConnectionAccess();
                if (this.jdbcConnectionAccess == null) {
                    throw new SchemaManagementException("Could not build JDBC Connection context to drop schema on SessionFactory close");
                }
            }

            @Override
            public JdbcConnectionAccess getJdbcConnectionAccess() {
                return this.jdbcConnectionAccess;
            }

            @Override
            public Dialect getDialect() {
                return this.jdbcServices.getJdbcEnvironment().getDialect();
            }

            @Override
            public SqlStatementLogger getSqlStatementLogger() {
                return this.jdbcServices.getSqlStatementLogger();
            }

            @Override
            public SqlExceptionHelper getSqlExceptionHelper() {
                return this.jdbcServices.getSqlExceptionHelper();
            }

            @Override
            public ServiceRegistry getServiceRegistry() {
                return this.serviceRegistry;
            }
        }
    }

    private static class JournalingGenerationTarget
    implements GenerationTarget {
        private final ArrayList<String> commands = new ArrayList();

        private JournalingGenerationTarget() {
        }

        @Override
        public void prepare() {
        }

        @Override
        public void accept(String command) {
            this.commands.add(command);
        }

        @Override
        public void release() {
        }
    }
}

