/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.SQLException;
import org.hibernate.dialect.JsonHelper;
import org.hibernate.dialect.PostgreSQLPGObjectJdbcType;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;

public abstract class AbstractPostgreSQLJsonJdbcType
extends PostgreSQLPGObjectJdbcType
implements AggregateJdbcType {
    private final EmbeddableMappingType embeddableMappingType;

    public AbstractPostgreSQLJsonJdbcType(EmbeddableMappingType embeddableMappingType, String typeName) {
        super(typeName, 3001);
        this.embeddableMappingType = embeddableMappingType;
    }

    @Override
    public EmbeddableMappingType getEmbeddableMappingType() {
        return this.embeddableMappingType;
    }

    @Override
    protected <X> X fromString(String string, JavaType<X> javaType, WrapperOptions options) throws SQLException {
        if (this.embeddableMappingType != null) {
            return JsonHelper.fromString(this.embeddableMappingType, string, javaType.getJavaTypeClass() != Object[].class, options);
        }
        return options.getSessionFactory().getFastSessionServices().getJsonFormatMapper().fromString(string, javaType, options);
    }

    @Override
    protected <X> String toString(X value, JavaType<X> javaType, WrapperOptions options) {
        if (this.embeddableMappingType != null) {
            return JsonHelper.toString(this.embeddableMappingType, value, options);
        }
        return options.getSessionFactory().getFastSessionServices().getJsonFormatMapper().toString(value, javaType, options);
    }

    @Override
    public Object createJdbcValue(Object domainValue, WrapperOptions options) throws SQLException {
        assert (this.embeddableMappingType != null);
        return JsonHelper.toString(this.embeddableMappingType, domainValue, options);
    }

    @Override
    public Object[] extractJdbcValues(Object rawJdbcValue, WrapperOptions options) throws SQLException {
        assert (this.embeddableMappingType != null);
        return (Object[])JsonHelper.fromString(this.embeddableMappingType, (String)rawJdbcValue, false, options);
    }
}

