/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import org.hibernate.HibernateException;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.AdjustableJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;

public class PostgreSQLIntervalSecondJdbcType
implements AdjustableJdbcType {
    public static final PostgreSQLIntervalSecondJdbcType INSTANCE;
    private static final Class<?> PG_INTERVAL_CLASS;
    private static final Constructor<Object> PG_INTERVAL_CONSTRUCTOR;
    private static final Method PG_INTERVAL_GET_DAYS;
    private static final Method PG_INTERVAL_GET_HOURS;
    private static final Method PG_INTERVAL_GET_MINUTES;
    private static final Method PG_INTERVAL_GET_SECONDS;
    private static final Method PG_INTERVAL_GET_MICRO_SECONDS;
    private static final long SECONDS_PER_DAY = 86400L;
    private static final long SECONDS_PER_HOUR = 3600L;
    private static final long SECONDS_PER_MINUTE = 60L;

    @Override
    public int getJdbcTypeCode() {
        return 1111;
    }

    @Override
    public int getDefaultSqlTypeCode() {
        return 3100;
    }

    @Override
    public Class<?> getPreferredJavaTypeClass(WrapperOptions options) {
        return Duration.class;
    }

    @Override
    public JdbcType resolveIndicatedType(JdbcTypeIndicators indicators, JavaType<?> domainJtd) {
        int scale = indicators.getColumnScale() == -1 ? domainJtd.getDefaultSqlScale(indicators.getDialect(), this) : indicators.getColumnScale();
        if (scale > 6) {
            return indicators.getJdbcType(indicators.resolveJdbcTypeCode(2));
        }
        return this;
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaType) {
        return (appender, value, dialect, wrapperOptions) -> dialect.appendIntervalLiteral(appender, javaType.unwrap(value, Duration.class, wrapperOptions));
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                Duration duration = this.getJavaType().unwrap(value, Duration.class, options);
                st.setObject(index, this.constructInterval(duration));
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                Duration duration = this.getJavaType().unwrap(value, Duration.class, options);
                st.setObject(name, this.constructInterval(duration));
            }

            private Object constructInterval(Duration d) {
                long secondsLong = d.getSeconds();
                long minutesLong = secondsLong / 60L;
                long hoursLong = minutesLong / 60L;
                long daysLong = hoursLong / 24L;
                int days = Math.toIntExact(daysLong);
                int hours = (int)(hoursLong - daysLong * 24L);
                int minutes = (int)(minutesLong - hoursLong * 60L);
                double seconds = (double)(secondsLong - minutesLong * 60L) + (double)d.getNano() / 1.0E9;
                try {
                    return PG_INTERVAL_CONSTRUCTOR.newInstance(0, 0, days, hours, minutes, seconds);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(this.getValue(rs.getObject(paramIndex)), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(this.getValue(statement.getObject(index)), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(this.getValue(statement.getObject(name)), options);
            }

            private Object getValue(Object value) {
                if (PG_INTERVAL_CLASS.isInstance(value)) {
                    try {
                        long seconds = (long)((Integer)PG_INTERVAL_GET_SECONDS.invoke(value, new Object[0])).intValue() + 86400L * (long)((Integer)PG_INTERVAL_GET_DAYS.invoke(value, new Object[0])).intValue() + 3600L * (long)((Integer)PG_INTERVAL_GET_HOURS.invoke(value, new Object[0])).intValue() + 60L * (long)((Integer)PG_INTERVAL_GET_MINUTES.invoke(value, new Object[0])).intValue();
                        long nanos = 1000L * (long)((Integer)PG_INTERVAL_GET_MICRO_SECONDS.invoke(value, new Object[0])).intValue();
                        return Duration.ofSeconds(seconds, nanos);
                    }
                    catch (Exception e) {
                        throw new HibernateException("Couldn't create Duration from interval", e);
                    }
                }
                return value;
            }
        };
    }

    static {
        Method pgIntervalGetMicroSeconds;
        Method pgIntervalGetSeconds;
        Method pgIntervalGetMinutes;
        Method pgIntervalGetHours;
        Method pgIntervalGetDays;
        Constructor constructor;
        Class pgIntervalClass;
        INSTANCE = new PostgreSQLIntervalSecondJdbcType();
        try {
            pgIntervalClass = ReflectHelper.classForName("org.postgresql.util.PGInterval", PostgreSQLIntervalSecondJdbcType.class);
            constructor = pgIntervalClass.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Double.TYPE);
            pgIntervalGetDays = pgIntervalClass.getDeclaredMethod("getDays", new Class[0]);
            pgIntervalGetHours = pgIntervalClass.getDeclaredMethod("getHours", new Class[0]);
            pgIntervalGetMinutes = pgIntervalClass.getDeclaredMethod("getMinutes", new Class[0]);
            pgIntervalGetSeconds = pgIntervalClass.getDeclaredMethod("getWholeSeconds", new Class[0]);
            pgIntervalGetMicroSeconds = pgIntervalClass.getDeclaredMethod("getMicroSeconds", new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize PostgreSQLPGObjectJdbcType", e);
        }
        PG_INTERVAL_CLASS = pgIntervalClass;
        PG_INTERVAL_CONSTRUCTOR = constructor;
        PG_INTERVAL_GET_DAYS = pgIntervalGetDays;
        PG_INTERVAL_GET_HOURS = pgIntervalGetHours;
        PG_INTERVAL_GET_MINUTES = pgIntervalGetMinutes;
        PG_INTERVAL_GET_SECONDS = pgIntervalGetSeconds;
        PG_INTERVAL_GET_MICRO_SECONDS = pgIntervalGetMicroSeconds;
    }
}

