/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.Arrays;
import java.util.Date;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.AvgFunction;
import org.hibernate.dialect.function.ConcatPipeFunction;
import org.hibernate.dialect.function.CountFunction;
import org.hibernate.dialect.function.EveryAnyEmulation;
import org.hibernate.dialect.function.FormatFunction;
import org.hibernate.dialect.function.HypotheticalSetFunction;
import org.hibernate.dialect.function.HypotheticalSetWindowEmulation;
import org.hibernate.dialect.function.InverseDistributionFunction;
import org.hibernate.dialect.function.InverseDistributionWindowEmulation;
import org.hibernate.dialect.function.LengthFunction;
import org.hibernate.dialect.function.ListaggFunction;
import org.hibernate.dialect.function.ListaggGroupConcatEmulation;
import org.hibernate.dialect.function.ListaggStringAggEmulation;
import org.hibernate.dialect.function.MinMaxCaseEveryAnyEmulation;
import org.hibernate.dialect.function.SQLServerEveryAnyEmulation;
import org.hibernate.dialect.function.SumReturnTypeResolver;
import org.hibernate.dialect.function.TruncFunction;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;

public class CommonFunctionFactory {
    private final BasicType<Boolean> booleanType;
    private final BasicType<Character> characterType;
    private final BasicType<String> stringType;
    private final BasicType<Integer> integerType;
    private final BasicType<Long> longType;
    private final BasicType<Double> doubleType;
    private final BasicType<Date> dateType;
    private final BasicType<Date> timeType;
    private final BasicType<Date> timestampType;
    private final SqmFunctionRegistry functionRegistry;
    private final TypeConfiguration typeConfiguration;
    private static final String VAR_SAMP_SUM_COUNT_PATTERN = "(sum(power(?1,2))-(power(sum(?1),2)/count(?1)))/nullif(count(?1)-1,0)";

    public CommonFunctionFactory(FunctionContributions functionContributions) {
        this.functionRegistry = functionContributions.getFunctionRegistry();
        this.typeConfiguration = functionContributions.getTypeConfiguration();
        BasicTypeRegistry basicTypeRegistry = this.typeConfiguration.getBasicTypeRegistry();
        this.dateType = basicTypeRegistry.resolve(StandardBasicTypes.DATE);
        this.timeType = basicTypeRegistry.resolve(StandardBasicTypes.TIME);
        this.timestampType = basicTypeRegistry.resolve(StandardBasicTypes.TIMESTAMP);
        this.longType = basicTypeRegistry.resolve(StandardBasicTypes.LONG);
        this.characterType = basicTypeRegistry.resolve(StandardBasicTypes.CHARACTER);
        this.booleanType = basicTypeRegistry.resolve(StandardBasicTypes.BOOLEAN);
        this.stringType = basicTypeRegistry.resolve(StandardBasicTypes.STRING);
        this.integerType = basicTypeRegistry.resolve(StandardBasicTypes.INTEGER);
        this.doubleType = basicTypeRegistry.resolve(StandardBasicTypes.DOUBLE);
    }

    public void cot() {
        this.functionRegistry.namedDescriptorBuilder("cot").setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).setInvariantType(this.doubleType).register();
    }

    public void log() {
        this.functionRegistry.namedDescriptorBuilder("log").setArgumentCountBetween(1, 2).setParameterTypes(FunctionParameterType.NUMERIC, FunctionParameterType.NUMERIC).setInvariantType(this.doubleType).register();
    }

    public void log_ln() {
        this.functionRegistry.patternDescriptorBuilder("log", "ln(?2)/ln(?1)").setExactArgumentCount(2).setParameterTypes(FunctionParameterType.NUMERIC, FunctionParameterType.NUMERIC).setInvariantType(this.doubleType).setArgumentListSignature("(NUMERIC base, NUMERIC arg)").register();
    }

    public void log_log() {
        this.functionRegistry.patternDescriptorBuilder("log", "log(?2,?1)").setExactArgumentCount(2).setParameterTypes(FunctionParameterType.NUMERIC, FunctionParameterType.NUMERIC).setInvariantType(this.doubleType).setArgumentListSignature("(NUMERIC base, NUMERIC arg)").register();
    }

    public void log_loglog() {
        this.functionRegistry.patternDescriptorBuilder("log", "log(?2)/log(?1)").setExactArgumentCount(2).setParameterTypes(FunctionParameterType.NUMERIC, FunctionParameterType.NUMERIC).setInvariantType(this.doubleType).setArgumentListSignature("(NUMERIC base, NUMERIC arg)").register();
    }

    public void ln_log() {
        this.functionRegistry.namedDescriptorBuilder("ln", "log").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
    }

    public void log10() {
        this.functionRegistry.namedDescriptorBuilder("log10").setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).setInvariantType(this.doubleType).register();
    }

    public void log10_log() {
        this.functionRegistry.patternDescriptorBuilder("log10", "log(10,?1)").setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).setInvariantType(this.doubleType).register();
    }

    public void log2() {
        this.functionRegistry.namedDescriptorBuilder("log2").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
    }

    public void radians() {
        this.functionRegistry.namedDescriptorBuilder("radians").setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).setInvariantType(this.doubleType).register();
    }

    public void radians_acos() {
        this.functionRegistry.patternDescriptorBuilder("radians", "(?1*acos(-1)/180)").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
    }

    public void degrees() {
        this.functionRegistry.namedDescriptorBuilder("degrees").setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).setInvariantType(this.doubleType).register();
    }

    public void degrees_acos() {
        this.functionRegistry.patternDescriptorBuilder("degrees", "(?1/acos(-1)*180)").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
    }

    public void sinh() {
        this.functionRegistry.namedDescriptorBuilder("sinh").setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).setInvariantType(this.doubleType).register();
    }

    public void sinh_exp() {
        this.functionRegistry.patternDescriptorBuilder("sinh", "((exp(?1)-exp(-?1))/2)").setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).setInvariantType(this.doubleType).register();
    }

    public void cosh() {
        this.functionRegistry.namedDescriptorBuilder("cosh").setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).setInvariantType(this.doubleType).register();
    }

    public void cosh_exp() {
        this.functionRegistry.patternDescriptorBuilder("cosh", "((exp(?1)+exp(-?1))/2)").setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).setInvariantType(this.doubleType).register();
    }

    public void tanh() {
        this.functionRegistry.namedDescriptorBuilder("tanh").setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).setInvariantType(this.doubleType).register();
    }

    public void tanh_exp() {
        this.functionRegistry.patternDescriptorBuilder("tanh", "((exp(2*?1)-1)/(exp(2*?1)+1))").setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).setInvariantType(this.doubleType).register();
    }

    public void moreHyperbolic() {
        this.functionRegistry.namedDescriptorBuilder("acosh").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
        this.functionRegistry.namedDescriptorBuilder("asinh").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
        this.functionRegistry.namedDescriptorBuilder("atanh").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
    }

    private void trunc(String truncPattern, String twoArgTruncPattern, TruncFunction.DatetimeTrunc datetimeTrunc, String toDateFunction) {
        this.functionRegistry.register("trunc", new TruncFunction(truncPattern, twoArgTruncPattern, datetimeTrunc, toDateFunction, this.typeConfiguration));
        this.functionRegistry.registerAlternateKey("truncate", "trunc");
    }

    private void trunc(TruncFunction.DatetimeTrunc datetimeTrunc) {
        this.trunc("trunc(?1)", "trunc(?1,?2)", datetimeTrunc, null);
    }

    public void trunc() {
        this.trunc(null);
    }

    public void trunc_dateTrunc() {
        this.trunc(TruncFunction.DatetimeTrunc.DATE_TRUNC);
    }

    public void trunc_dateTrunc_trunc() {
        this.trunc(TruncFunction.DatetimeTrunc.TRUNC);
    }

    public void trunc_truncate() {
        this.trunc("truncate(?1,0)", "truncate(?1,?2)", TruncFunction.DatetimeTrunc.FORMAT, "str_to_date");
    }

    public void trunc_round_datetrunc() {
        this.trunc("round(?1,0,1)", "round(?1,?2,1)", TruncFunction.DatetimeTrunc.DATETRUNC, "convert");
    }

    public void trunc_floor() {
        this.trunc("sign(?1)*floor(abs(?1))", "sign(?1)*floor(abs(?1)*1e?2)/1e?2", null, null);
    }

    public void trunc_roundMode() {
        this.trunc("round(?1,0,round_down)", "round(?1,?2,round_down)", TruncFunction.DatetimeTrunc.FORMAT, "to_date");
    }

    public void rand() {
        this.functionRegistry.namedDescriptorBuilder("rand").setArgumentCountBetween(0, 1).setParameterTypes(FunctionParameterType.INTEGER).setUseParenthesesWhenNoArgs(true).setInvariantType(this.doubleType).setArgumentListSignature("([INTEGER seed])").register();
    }

    public void median() {
        this.functionRegistry.namedAggregateDescriptorBuilder("median").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
    }

    public void median_percentileCont(boolean over) {
        this.functionRegistry.patternDescriptorBuilder("median", "percentile_cont(0.5) within group (order by ?1)" + (over ? " over()" : "")).setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
    }

    public void median_percentileCont_castDouble() {
        this.functionRegistry.patternDescriptorBuilder("median", "percentile_cont(0.5) within group (order by cast(?1 as double precision))").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
    }

    public void stddev() {
        this.functionRegistry.namedAggregateDescriptorBuilder("stddev").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
    }

    public void variance() {
        this.functionRegistry.namedAggregateDescriptorBuilder("variance").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
    }

    public void stddevPopSamp() {
        this.functionRegistry.namedAggregateDescriptorBuilder("stddev_pop").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
        this.functionRegistry.namedAggregateDescriptorBuilder("stddev_samp").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
    }

    public void varPopSamp() {
        this.functionRegistry.namedAggregateDescriptorBuilder("var_pop").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
        this.functionRegistry.namedAggregateDescriptorBuilder("var_samp").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
    }

    public void covarPopSamp() {
        this.functionRegistry.namedAggregateDescriptorBuilder("covar_pop").setInvariantType(this.doubleType).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.NUMERIC, FunctionParameterType.NUMERIC).register();
        this.functionRegistry.namedAggregateDescriptorBuilder("covar_samp").setInvariantType(this.doubleType).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.NUMERIC, FunctionParameterType.NUMERIC).register();
    }

    public void corr() {
        this.functionRegistry.namedAggregateDescriptorBuilder("corr").setInvariantType(this.doubleType).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.NUMERIC, FunctionParameterType.NUMERIC).register();
    }

    public void regrLinearRegressionAggregates() {
        Arrays.asList("regr_avgx", "regr_avgy", "regr_count", "regr_intercept", "regr_r2", "regr_slope", "regr_sxx", "regr_sxy", "regr_syy").forEach(fnName -> this.functionRegistry.namedAggregateDescriptorBuilder((String)fnName).setInvariantType(this.doubleType).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.NUMERIC, FunctionParameterType.NUMERIC).register());
    }

    public void varianceSamp() {
        this.functionRegistry.namedAggregateDescriptorBuilder("variance_samp").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
    }

    public void varSamp_sumCount() {
        this.functionRegistry.patternAggregateDescriptorBuilder("var_samp", VAR_SAMP_SUM_COUNT_PATTERN).setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
    }

    public void stddevSamp_sumCount() {
        this.functionRegistry.patternAggregateDescriptorBuilder("stddev_samp", "sqrt((sum(power(?1,2))-(power(sum(?1),2)/count(?1)))/nullif(count(?1)-1,0))").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
    }

    public void stddevPopSamp_stdevp() {
        this.functionRegistry.namedAggregateDescriptorBuilder("stdev").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
        this.functionRegistry.namedAggregateDescriptorBuilder("stdevp").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
        this.functionRegistry.registerAlternateKey("stddev_samp", "stdev");
        this.functionRegistry.registerAlternateKey("stddev_pop", "stdevp");
    }

    public void varPopSamp_varp() {
        this.functionRegistry.namedAggregateDescriptorBuilder("var").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
        this.functionRegistry.namedAggregateDescriptorBuilder("varp").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
        this.functionRegistry.registerAlternateKey("var_samp", "var");
        this.functionRegistry.registerAlternateKey("var_pop", "varp");
    }

    public void pi() {
        this.functionRegistry.noArgsBuilder("pi").setInvariantType(this.doubleType).setUseParenthesesWhenNoArgs(true).setArgumentListSignature("").register();
    }

    public void pi_acos() {
        this.functionRegistry.patternDescriptorBuilder("pi", "acos(-1)").setInvariantType(this.doubleType).setExactArgumentCount(0).setArgumentListSignature("").register();
    }

    public void soundex() {
        this.functionRegistry.namedDescriptorBuilder("soundex").setExactArgumentCount(1).setInvariantType(this.stringType).register();
    }

    public void trim2() {
        this.functionRegistry.namedDescriptorBuilder("ltrim").setInvariantType(this.stringType).setArgumentCountBetween(1, 2).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.STRING).setArgumentListSignature("(STRING string[, STRING characters])").register();
        this.functionRegistry.namedDescriptorBuilder("rtrim").setInvariantType(this.stringType).setArgumentCountBetween(1, 2).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.STRING).setArgumentListSignature("(STRING string[, STRING characters])").register();
    }

    public void trim1() {
        this.functionRegistry.namedDescriptorBuilder("ltrim").setInvariantType(this.stringType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.STRING).setArgumentListSignature("(STRING string)").register();
        this.functionRegistry.namedDescriptorBuilder("rtrim").setInvariantType(this.stringType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.STRING).setArgumentListSignature("(STRING string)").register();
    }

    public void pad() {
        this.functionRegistry.namedDescriptorBuilder("lpad").setInvariantType(this.stringType).setArgumentCountBetween(2, 3).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.INTEGER, FunctionParameterType.STRING).setArgumentListSignature("(STRING string, INTEGER length[, STRING padding])").register();
        this.functionRegistry.namedDescriptorBuilder("rpad").setInvariantType(this.stringType).setArgumentCountBetween(2, 3).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.INTEGER, FunctionParameterType.STRING).setArgumentListSignature("(STRING string, INTEGER length[, STRING padding])").register();
    }

    public void pad_space() {
        this.functionRegistry.registerBinaryTernaryPattern("lpad", this.stringType, "lpad(?1,?2,' ')", "lpad(?1,?2,?3)", FunctionParameterType.STRING, FunctionParameterType.INTEGER, FunctionParameterType.STRING, this.typeConfiguration).setArgumentListSignature("(string, length[, padding])");
        this.functionRegistry.registerBinaryTernaryPattern("rpad", this.stringType, "rpad(?1,?2,' ')", "rpad(?1,?2,?3)", FunctionParameterType.STRING, FunctionParameterType.INTEGER, FunctionParameterType.STRING, this.typeConfiguration).setArgumentListSignature("(string, length[, padding])");
    }

    public void pad_replicate() {
        this.functionRegistry.registerBinaryTernaryPattern("lpad", this.stringType, "(space(?2-len(?1))+?1)", "(replicate(?3,?2-len(?1))+?1)", FunctionParameterType.STRING, FunctionParameterType.INTEGER, FunctionParameterType.STRING, this.typeConfiguration).setArgumentListSignature("(string, length[, padding])");
        this.functionRegistry.registerBinaryTernaryPattern("rpad", this.stringType, "(?1+space(?2-len(?1)))", "(?1+replicate(?3,?2-len(?1)))", FunctionParameterType.STRING, FunctionParameterType.INTEGER, FunctionParameterType.STRING, this.typeConfiguration).setArgumentListSignature("(string, length[, padding])");
    }

    public void pad_repeat() {
        this.functionRegistry.registerBinaryTernaryPattern("lpad", this.stringType, "(repeat(' ',?2-character_length(?1))||?1)", "(repeat(?3,?2-character_length(?1))||?1)", FunctionParameterType.STRING, FunctionParameterType.INTEGER, FunctionParameterType.STRING, this.typeConfiguration).setArgumentListSignature("(string, length[, padding])");
        this.functionRegistry.registerBinaryTernaryPattern("rpad", this.stringType, "(?1||repeat(' ',?2-character_length(?1)))", "(?1||repeat(?3,?2-character_length(?1)))", FunctionParameterType.STRING, FunctionParameterType.INTEGER, FunctionParameterType.STRING, this.typeConfiguration).setArgumentListSignature("(string, length[, padding])");
    }

    public void pad_fill() {
        this.functionRegistry.registerBinaryTernaryPattern("lpad", this.stringType, "lfill(?1,' ',?2)", "lfill(?1,?3,?2)", FunctionParameterType.STRING, FunctionParameterType.INTEGER, FunctionParameterType.STRING, this.typeConfiguration).setArgumentListSignature("(string, length[, padding])");
        this.functionRegistry.registerBinaryTernaryPattern("rpad", this.stringType, "rfill(?1,' ',?2)", "rfill(?1,?3,?2)", FunctionParameterType.STRING, FunctionParameterType.INTEGER, FunctionParameterType.STRING, this.typeConfiguration).setArgumentListSignature("(string, length[, padding])");
    }

    public void reverse() {
        this.functionRegistry.namedDescriptorBuilder("reverse").setInvariantType(this.stringType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.STRING).register();
    }

    public void space() {
        this.functionRegistry.namedDescriptorBuilder("space").setInvariantType(this.stringType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.INTEGER).register();
    }

    public void repeat() {
        this.functionRegistry.namedDescriptorBuilder("repeat").setInvariantType(this.stringType).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.INTEGER).setArgumentListSignature("(STRING string, INTEGER times)").register();
    }

    public void leftRight() {
        this.functionRegistry.namedDescriptorBuilder("left").setInvariantType(this.stringType).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.INTEGER).setArgumentListSignature("(STRING string, INTEGER length)").register();
        this.functionRegistry.namedDescriptorBuilder("right").setInvariantType(this.stringType).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.INTEGER).setArgumentListSignature("(STRING string, INTEGER length)").register();
    }

    public void leftRight_substr() {
        this.functionRegistry.patternDescriptorBuilder("left", "substr(?1,1,?2)").setInvariantType(this.stringType).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.INTEGER).setArgumentListSignature("(STRING string, INTEGER length)").register();
        this.functionRegistry.patternDescriptorBuilder("right", "substr(?1,-?2)").setInvariantType(this.stringType).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.INTEGER).setArgumentListSignature("(STRING string, INTEGER length)").register();
    }

    public void leftRight_substrLength() {
        this.functionRegistry.patternDescriptorBuilder("left", "substr(?1,1,?2)").setInvariantType(this.stringType).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.INTEGER).setArgumentListSignature("(STRING string, INTEGER length)").register();
        this.functionRegistry.patternDescriptorBuilder("right", "substr(?1,length(?1)-?2+1)").setInvariantType(this.stringType).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.INTEGER).setArgumentListSignature("(STRING string, INTEGER length)").register();
    }

    public void repeat_replicate() {
        this.functionRegistry.namedDescriptorBuilder("replicate").setInvariantType(this.stringType).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.INTEGER).setArgumentListSignature("(STRING string, INTEGER times)").register();
        this.functionRegistry.registerAlternateKey("repeat", "replicate");
    }

    public void md5() {
        this.functionRegistry.namedDescriptorBuilder("md5").setInvariantType(this.stringType).setExactArgumentCount(1).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.IMPLIED_RESULT_TYPE).register();
    }

    public void initcap() {
        this.functionRegistry.namedDescriptorBuilder("initcap").setInvariantType(this.stringType).setExactArgumentCount(1).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.IMPLIED_RESULT_TYPE).register();
    }

    public void instr() {
        this.functionRegistry.namedDescriptorBuilder("instr").setInvariantType(this.integerType).setArgumentCountBetween(2, 4).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.STRING, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER).setArgumentListSignature("(STRING string, STRING pattern[, INTEGER start[, INTEGER occurrence]])").register();
    }

    public void substr() {
        this.functionRegistry.namedDescriptorBuilder("substr").setInvariantType(this.stringType).setArgumentCountBetween(2, 3).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER).setArgumentListSignature("(STRING string, INTEGER start[, INTEGER length])").register();
    }

    public void translate() {
        this.functionRegistry.namedDescriptorBuilder("translate").setInvariantType(this.stringType).setExactArgumentCount(3).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.STRING, FunctionParameterType.STRING).register();
    }

    public void bitand() {
        this.functionRegistry.namedDescriptorBuilder("bitand").setExactArgumentCount(2).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
    }

    public void bitor() {
        this.functionRegistry.namedDescriptorBuilder("bitor").setExactArgumentCount(2).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
    }

    public void bitxor() {
        this.functionRegistry.namedDescriptorBuilder("bitxor").setExactArgumentCount(2).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
    }

    public void bitnot() {
        this.functionRegistry.namedDescriptorBuilder("bitnot").setExactArgumentCount(1).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.IMPLIED_RESULT_TYPE).register();
    }

    public void bitandorxornot_bitAndOrXorNot() {
        this.functionRegistry.namedDescriptorBuilder("bit_and").setExactArgumentCount(2).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
        this.functionRegistry.registerAlternateKey("bitand", "bit_and");
        this.functionRegistry.namedDescriptorBuilder("bit_or").setExactArgumentCount(2).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
        this.functionRegistry.registerAlternateKey("bitor", "bit_or");
        this.functionRegistry.namedDescriptorBuilder("bit_xor").setExactArgumentCount(2).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
        this.functionRegistry.registerAlternateKey("bitxor", "bit_xor");
        this.functionRegistry.namedDescriptorBuilder("bit_not").setExactArgumentCount(1).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.IMPLIED_RESULT_TYPE).register();
        this.functionRegistry.registerAlternateKey("bitnot", "bit_not");
    }

    public void bitandorxornot_binAndOrXorNot() {
        this.functionRegistry.namedDescriptorBuilder("bin_and").setMinArgumentCount(1).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
        this.functionRegistry.registerAlternateKey("bitand", "bin_and");
        this.functionRegistry.namedDescriptorBuilder("bin_or").setMinArgumentCount(1).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
        this.functionRegistry.registerAlternateKey("bitor", "bin_or");
        this.functionRegistry.namedDescriptorBuilder("bin_xor").setMinArgumentCount(1).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
        this.functionRegistry.registerAlternateKey("bitxor", "bin_xor");
        this.functionRegistry.namedDescriptorBuilder("bin_not").setExactArgumentCount(1).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.IMPLIED_RESULT_TYPE).register();
        this.functionRegistry.registerAlternateKey("bitnot", "bin_not");
    }

    public void bitandorxornot_operator() {
        this.functionRegistry.patternDescriptorBuilder("bitand", "(?1&?2)").setExactArgumentCount(2).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
        this.functionRegistry.patternDescriptorBuilder("bitor", "(?1|?2)").setExactArgumentCount(2).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
        this.functionRegistry.patternDescriptorBuilder("bitxor", "(?1^?2)").setExactArgumentCount(2).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
        this.functionRegistry.patternDescriptorBuilder("bitnot", "~?1").setExactArgumentCount(1).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.IMPLIED_RESULT_TYPE).register();
    }

    public void bitAndOr() {
        this.functionRegistry.namedAggregateDescriptorBuilder("bit_and").setExactArgumentCount(1).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
        this.functionRegistry.namedAggregateDescriptorBuilder("bit_or").setExactArgumentCount(1).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
    }

    public void everyAny() {
        this.functionRegistry.namedAggregateDescriptorBuilder("every").setExactArgumentCount(1).setInvariantType(this.booleanType).setParameterTypes(FunctionParameterType.BOOLEAN).setArgumentListSignature("(BOOLEAN predicate)").register();
        this.functionRegistry.namedAggregateDescriptorBuilder("any").setExactArgumentCount(1).setInvariantType(this.booleanType).setParameterTypes(FunctionParameterType.BOOLEAN).setArgumentListSignature("(BOOLEAN predicate)").register();
    }

    public void everyAny_boolAndOr() {
        this.functionRegistry.namedAggregateDescriptorBuilder("bool_and").setExactArgumentCount(1).setParameterTypes(FunctionParameterType.BOOLEAN).setInvariantType(this.booleanType).setArgumentListSignature("(BOOLEAN predicate)").register();
        this.functionRegistry.registerAlternateKey("every", "bool_and");
        this.functionRegistry.namedAggregateDescriptorBuilder("bool_or").setExactArgumentCount(1).setParameterTypes(FunctionParameterType.BOOLEAN).setInvariantType(this.booleanType).setArgumentListSignature("(BOOLEAN predicate)").register();
        this.functionRegistry.registerAlternateKey("any", "bool_or");
    }

    public void everyAny_sumCase(boolean supportsPredicateAsExpression) {
        this.functionRegistry.register("every", new EveryAnyEmulation(this.typeConfiguration, true, supportsPredicateAsExpression));
        this.functionRegistry.register("any", new EveryAnyEmulation(this.typeConfiguration, false, supportsPredicateAsExpression));
    }

    public void everyAny_minMaxIif() {
        this.functionRegistry.register("every", new SQLServerEveryAnyEmulation(this.typeConfiguration, true));
        this.functionRegistry.register("any", new SQLServerEveryAnyEmulation(this.typeConfiguration, false));
    }

    public void everyAny_minMaxCase() {
        this.functionRegistry.register("every", new MinMaxCaseEveryAnyEmulation(this.typeConfiguration, true));
        this.functionRegistry.register("any", new MinMaxCaseEveryAnyEmulation(this.typeConfiguration, false));
    }

    public void yearMonthDay() {
        this.functionRegistry.namedDescriptorBuilder("day").setInvariantType(this.integerType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.DATE).register();
        this.functionRegistry.namedDescriptorBuilder("month").setInvariantType(this.integerType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.DATE).register();
        this.functionRegistry.namedDescriptorBuilder("year").setInvariantType(this.integerType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.DATE).register();
    }

    public void hourMinuteSecond() {
        this.functionRegistry.namedDescriptorBuilder("hour").setInvariantType(this.integerType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.TIME).register();
        this.functionRegistry.namedDescriptorBuilder("minute").setInvariantType(this.integerType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.TIME).register();
        this.functionRegistry.namedDescriptorBuilder("second").setInvariantType(this.integerType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.TIME).register();
        this.functionRegistry.namedDescriptorBuilder("microsecond").setInvariantType(this.integerType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.TIME).register();
    }

    public void dayofweekmonthyear() {
        this.functionRegistry.namedDescriptorBuilder("dayofweek").setInvariantType(this.integerType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.DATE).register();
        this.functionRegistry.namedDescriptorBuilder("dayofmonth").setInvariantType(this.integerType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.DATE).register();
        this.functionRegistry.registerAlternateKey("day", "dayofmonth");
        this.functionRegistry.namedDescriptorBuilder("dayofyear").setInvariantType(this.integerType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.DATE).register();
    }

    public void dayOfWeekMonthYear() {
        this.functionRegistry.namedDescriptorBuilder("day_of_week").setInvariantType(this.integerType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.DATE).register();
        this.functionRegistry.namedDescriptorBuilder("day_of_month").setInvariantType(this.integerType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.DATE).register();
        this.functionRegistry.registerAlternateKey("day", "day_of_month");
        this.functionRegistry.namedDescriptorBuilder("day_of_year").setInvariantType(this.integerType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.DATE).register();
    }

    public void daynameMonthname() {
        this.functionRegistry.namedDescriptorBuilder("monthname").setInvariantType(this.stringType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.DATE).register();
        this.functionRegistry.namedDescriptorBuilder("dayname").setInvariantType(this.stringType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.DATE).register();
    }

    public void weekQuarter() {
        this.functionRegistry.namedDescriptorBuilder("week").setInvariantType(this.integerType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.DATE).register();
        this.functionRegistry.namedDescriptorBuilder("quarter").setExactArgumentCount(1).setParameterTypes(FunctionParameterType.DATE).setInvariantType(this.integerType).register();
    }

    public void lastDay() {
        this.functionRegistry.namedDescriptorBuilder("last_day").setInvariantType(this.dateType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.DATE).register();
    }

    public void lastDay_eomonth() {
        this.functionRegistry.namedDescriptorBuilder("eomonth").setInvariantType(this.dateType).setArgumentCountBetween(1, 2).setParameterTypes(FunctionParameterType.DATE, FunctionParameterType.INTEGER).register();
        this.functionRegistry.registerAlternateKey("last_date", "eomonth");
    }

    public void ceiling_ceil() {
        this.functionRegistry.namedDescriptorBuilder("ceil").setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).setReturnTypeResolver(StandardFunctionReturnTypeResolvers.useArgType(1)).register();
        this.functionRegistry.registerAlternateKey("ceiling", "ceil");
    }

    public void toCharNumberDateTimestamp() {
        this.functionRegistry.namedDescriptorBuilder("to_number").setArgumentCountBetween(1, 3).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.STRING, FunctionParameterType.STRING).setInvariantType(this.doubleType).register();
        this.functionRegistry.namedDescriptorBuilder("to_char").setArgumentCountBetween(1, 3).setParameterTypes(FunctionParameterType.ANY, FunctionParameterType.STRING, FunctionParameterType.STRING).setInvariantType(this.stringType).register();
        this.functionRegistry.namedDescriptorBuilder("to_date").setArgumentCountBetween(1, 3).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.STRING, FunctionParameterType.STRING).setInvariantType(this.dateType).register();
        this.functionRegistry.namedDescriptorBuilder("to_timestamp").setArgumentCountBetween(1, 3).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.STRING, FunctionParameterType.STRING).setInvariantType(this.timestampType).register();
    }

    public void dateTimeTimestamp() {
        this.date();
        this.time();
        this.timestamp();
    }

    public void timestamp() {
        this.functionRegistry.namedDescriptorBuilder("timestamp").setArgumentCountBetween(1, 2).setInvariantType(this.timestampType).register();
    }

    public void time() {
        this.functionRegistry.namedDescriptorBuilder("time").setExactArgumentCount(1).setInvariantType(this.timeType).register();
    }

    public void date() {
        this.functionRegistry.namedDescriptorBuilder("date").setExactArgumentCount(1).setInvariantType(this.dateType).register();
    }

    public void utcDateTimeTimestamp() {
        this.functionRegistry.noArgsBuilder("utc_date").setUseParenthesesWhenNoArgs(false).setInvariantType(this.dateType).register();
        this.functionRegistry.noArgsBuilder("utc_time").setUseParenthesesWhenNoArgs(false).setInvariantType(this.timeType).register();
        this.functionRegistry.noArgsBuilder("utc_timestamp").setUseParenthesesWhenNoArgs(false).setInvariantType(this.timestampType).register();
    }

    public void currentUtcdatetimetimestamp() {
        this.functionRegistry.noArgsBuilder("current_utcdate").setUseParenthesesWhenNoArgs(false).setInvariantType(this.dateType).register();
        this.functionRegistry.noArgsBuilder("current_utctime").setUseParenthesesWhenNoArgs(false).setInvariantType(this.timeType).register();
        this.functionRegistry.noArgsBuilder("current_utctimestamp").setUseParenthesesWhenNoArgs(false).setInvariantType(this.timestampType).register();
    }

    public void week_weekofyear() {
        this.functionRegistry.namedDescriptorBuilder("weekofyear").setInvariantType(this.integerType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.DATE).register();
        this.functionRegistry.registerAlternateKey("week", "weekofyear");
    }

    public void concat_pipeOperator() {
        this.functionRegistry.patternDescriptorBuilder("concat", "(?1||?2...)").setInvariantType(this.stringType).setMinArgumentCount(1).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.impliedOrInvariant(this.typeConfiguration, FunctionParameterType.STRING)).setArgumentListSignature("(STRING string0[, STRING string1[, ...]])").register();
    }

    public void concat_pipeOperator(String clobPattern) {
        this.functionRegistry.register("concat", new ConcatPipeFunction(clobPattern, this.typeConfiguration));
    }

    public void rownumRowid() {
        this.functionRegistry.noArgsBuilder("rowid").setInvariantType(this.longType).setUseParenthesesWhenNoArgs(false).register();
        this.functionRegistry.noArgsBuilder("rownum").setInvariantType(this.longType).setUseParenthesesWhenNoArgs(false).register();
    }

    public void rownum() {
        this.functionRegistry.noArgsBuilder("rownum").setInvariantType(this.longType).setUseParenthesesWhenNoArgs(true).register();
    }

    public void rownumInstOrderbyGroupbyNum() {
        this.functionRegistry.noArgsBuilder("rownum").setInvariantType(this.integerType).setUseParenthesesWhenNoArgs(false).register();
        this.functionRegistry.noArgsBuilder("inst_num").setInvariantType(this.integerType).setUseParenthesesWhenNoArgs(true).register();
        this.functionRegistry.noArgsBuilder("orderby_num").setInvariantType(this.integerType).setUseParenthesesWhenNoArgs(true).register();
        this.functionRegistry.noArgsBuilder("groupby_num").setInvariantType(this.integerType).setUseParenthesesWhenNoArgs(true).register();
    }

    public void makedateMaketime() {
        this.functionRegistry.namedDescriptorBuilder("makedate").setInvariantType(this.dateType).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.INTEGER, FunctionParameterType.INTEGER).setArgumentListSignature("(INTEGER year, INTEGER dayofyear)").register();
        this.functionRegistry.namedDescriptorBuilder("maketime").setInvariantType(this.timeType).setExactArgumentCount(3).setParameterTypes(FunctionParameterType.INTEGER, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER).setArgumentListSignature("(INTEGER hour, INTEGER min, INTEGER sec)").register();
    }

    public void makeDateTimeTimestamp() {
        this.functionRegistry.namedDescriptorBuilder("make_date").setInvariantType(this.dateType).setExactArgumentCount(3).setParameterTypes(FunctionParameterType.INTEGER, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER).register();
        this.functionRegistry.namedDescriptorBuilder("make_time").setInvariantType(this.timeType).setExactArgumentCount(3).setParameterTypes(FunctionParameterType.INTEGER, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER).register();
        this.functionRegistry.namedDescriptorBuilder("make_timestamp").setInvariantType(this.timestampType).setExactArgumentCount(6).setParameterTypes(FunctionParameterType.INTEGER, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER).register();
        this.functionRegistry.namedDescriptorBuilder("make_timestamptz").setInvariantType(this.timestampType).setArgumentCountBetween(6, 7).setParameterTypes(FunctionParameterType.INTEGER, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER).register();
    }

    public void sysdate() {
        this.functionRegistry.noArgsBuilder("sysdate").setInvariantType(this.timestampType).setUseParenthesesWhenNoArgs(false).register();
    }

    public void sysdateParens() {
        this.functionRegistry.noArgsBuilder("sysdate").setInvariantType(this.timestampType).setUseParenthesesWhenNoArgs(true).register();
    }

    public void sysdateExplicitMicros() {
        this.functionRegistry.patternDescriptorBuilder("sysdate", "sysdate(6)").setInvariantType(this.timestampType).setExactArgumentCount(0).register();
    }

    public void systimestamp() {
        this.functionRegistry.noArgsBuilder("systimestamp").setInvariantType(this.timestampType).setUseParenthesesWhenNoArgs(false).register();
    }

    public void localtimeLocaltimestamp() {
        this.functionRegistry.noArgsBuilder("localtime").setInvariantType(this.timeType).setUseParenthesesWhenNoArgs(false).register();
        this.functionRegistry.noArgsBuilder("localtimestamp").setInvariantType(this.timestampType).setUseParenthesesWhenNoArgs(false).register();
        BasicTypeRegistry basicTypeRegistry = this.typeConfiguration.getBasicTypeRegistry();
        this.functionRegistry.noArgsBuilder("local_time", "localtime").setInvariantType(basicTypeRegistry.resolve(StandardBasicTypes.LOCAL_TIME)).setUseParenthesesWhenNoArgs(false).register();
        this.functionRegistry.noArgsBuilder("local_datetime", "localtimestamp").setInvariantType(basicTypeRegistry.resolve(StandardBasicTypes.LOCAL_DATE_TIME)).setUseParenthesesWhenNoArgs(false).register();
    }

    public void trigonometry() {
        this.functionRegistry.namedDescriptorBuilder("sin").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
        this.functionRegistry.namedDescriptorBuilder("cos").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
        this.functionRegistry.namedDescriptorBuilder("tan").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
        this.functionRegistry.namedDescriptorBuilder("asin").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
        this.functionRegistry.namedDescriptorBuilder("acos").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
        this.functionRegistry.namedDescriptorBuilder("atan").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
        this.functionRegistry.namedDescriptorBuilder("atan2").setInvariantType(this.doubleType).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.NUMERIC, FunctionParameterType.NUMERIC).register();
    }

    public void atan2_atn2() {
        this.functionRegistry.namedDescriptorBuilder("atan2", "atn2").setInvariantType(this.doubleType).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.NUMERIC, FunctionParameterType.NUMERIC).register();
    }

    public void coalesce() {
        this.functionRegistry.namedDescriptorBuilder("coalesce").setMinArgumentCount(1).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
    }

    public void coalesce_value() {
        this.functionRegistry.namedDescriptorBuilder("value").setMinArgumentCount(1).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
        this.functionRegistry.registerAlternateKey("coalesce", "value");
    }

    public void nullif() {
        this.functionRegistry.namedDescriptorBuilder("nullif").setExactArgumentCount(2).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
    }

    public void length_characterLength() {
        this.functionRegistry.namedDescriptorBuilder("character_length").setInvariantType(this.integerType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.STRING_OR_CLOB).register();
        this.functionRegistry.registerAlternateKey("length", "character_length");
    }

    public void length_characterLength_pattern(String clobPattern) {
        this.functionRegistry.register("character_length", new LengthFunction("character_length", "character_length(?1)", clobPattern, this.typeConfiguration));
        this.functionRegistry.registerAlternateKey("length", "character_length");
    }

    public void characterLength_len() {
        this.functionRegistry.namedDescriptorBuilder("len").setInvariantType(this.integerType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.STRING_OR_CLOB).register();
        this.functionRegistry.registerAlternateKey("character_length", "len");
        this.functionRegistry.registerAlternateKey("length", "len");
    }

    public void characterLength_length(SqlAstNodeRenderingMode argumentRenderingMode) {
        this.functionRegistry.namedDescriptorBuilder("length").setInvariantType(this.integerType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.STRING_OR_CLOB).setArgumentRenderingMode(argumentRenderingMode).register();
        this.functionRegistry.registerAlternateKey("character_length", "length");
    }

    public void characterLength_length(String clobPattern) {
        this.functionRegistry.register("length", new LengthFunction("length", "length(?1)", clobPattern, this.typeConfiguration));
        this.functionRegistry.registerAlternateKey("character_length", "length");
    }

    public void octetLength() {
        this.functionRegistry.namedDescriptorBuilder("octet_length").setInvariantType(this.integerType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.STRING_OR_CLOB).register();
    }

    public void octetLength_pattern(String pattern) {
        this.functionRegistry.patternDescriptorBuilder("octet_length", pattern).setInvariantType(this.integerType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.STRING_OR_CLOB).register();
    }

    public void octetLength_pattern(String pattern, String clobPattern) {
        this.functionRegistry.register("octet_length", new LengthFunction("octet_length", pattern, clobPattern, this.typeConfiguration));
    }

    public void bitLength() {
        this.functionRegistry.namedDescriptorBuilder("bit_length").setInvariantType(this.integerType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.STRING_OR_CLOB).register();
    }

    public void bitLength_pattern(String pattern) {
        this.functionRegistry.patternDescriptorBuilder("bit_length", pattern).setInvariantType(this.integerType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.STRING_OR_CLOB).register();
    }

    public void bitLength_pattern(String pattern, String clobPattern) {
        this.functionRegistry.register("bit_length", new LengthFunction("bit_length", pattern, clobPattern, this.typeConfiguration));
    }

    public void position() {
        this.functionRegistry.patternDescriptorBuilder("position", "position(?1 in ?2)").setInvariantType(this.integerType).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.STRING).setArgumentListSignature("(STRING pattern in STRING string)").register();
    }

    public void locate() {
        this.functionRegistry.namedDescriptorBuilder("locate").setInvariantType(this.integerType).setArgumentCountBetween(2, 3).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.STRING, FunctionParameterType.INTEGER).setArgumentListSignature("(STRING pattern, STRING string[, INTEGER start])").register();
    }

    public void locate_charindex() {
        this.functionRegistry.namedDescriptorBuilder("charindex").setInvariantType(this.integerType).setArgumentCountBetween(2, 3).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.STRING, FunctionParameterType.INTEGER).setArgumentListSignature("(STRING pattern, STRING string[, INTEGER start])").register();
        this.functionRegistry.registerAlternateKey("locate", "charindex");
    }

    public void locate_positionSubstring() {
        this.functionRegistry.registerBinaryTernaryPattern("locate", this.integerType, "position(?1 in ?2)", "(position(?1 in substring(?2 from ?3))+(?3)-1)", FunctionParameterType.STRING, FunctionParameterType.STRING, FunctionParameterType.INTEGER, this.typeConfiguration).setArgumentListSignature("(STRING pattern, STRING string[, INTEGER start])");
    }

    public void substringFromFor() {
        this.functionRegistry.registerBinaryTernaryPattern("substring", this.stringType, "substring(?1 from ?2)", "substring(?1 from ?2 for ?3)", FunctionParameterType.STRING, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER, this.typeConfiguration).setArgumentListSignature("(STRING string{ from|,} INTEGER start[{ for|,} INTEGER length])");
    }

    public void substring() {
        this.functionRegistry.namedDescriptorBuilder("substring").setInvariantType(this.stringType).setArgumentCountBetween(2, 3).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER).setArgumentListSignature("(STRING string{ from|,} INTEGER start[{ for|,} INTEGER length])").register();
    }

    public void substring_substringLen() {
        this.functionRegistry.registerBinaryTernaryPattern("substring", this.stringType, "substring(?1,?2,len(?1)-?2+1)", "substring(?1,?2,?3)", FunctionParameterType.STRING, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER, this.typeConfiguration).setArgumentListSignature("(STRING string{ from|,} INTEGER start[{ for|,} INTEGER length])");
    }

    public void substring_substr() {
        this.functionRegistry.namedDescriptorBuilder("substring", "substr").setArgumentListSignature("(STRING string{ from|,} INTEGER start[{ for|,} INTEGER length])").setInvariantType(this.stringType).setArgumentCountBetween(2, 3).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER).register();
    }

    public void insert() {
        this.functionRegistry.namedDescriptorBuilder("insert").setInvariantType(this.stringType).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER, FunctionParameterType.STRING).setArgumentListSignature("(STRING string, INTEGER start, INTEGER length, STRING replacement)").register();
    }

    public void insert_overlay() {
        this.functionRegistry.patternDescriptorBuilder("insert", "overlay(?1 placing ?4 from ?2 for ?3)").setInvariantType(this.stringType).setExactArgumentCount(4).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER, FunctionParameterType.STRING).setArgumentListSignature("(STRING string, INTEGER start, INTEGER length, STRING replacement)").register();
    }

    public void overlay() {
        this.functionRegistry.registerTernaryQuaternaryPattern("overlay", this.stringType, "overlay(?1 placing ?2 from ?3)", "overlay(?1 placing ?2 from ?3 for ?4)", FunctionParameterType.STRING, FunctionParameterType.STRING, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER, this.typeConfiguration).setArgumentListSignature("(string placing replacement from start[ for length])");
    }

    public void overlayLength_overlay(boolean withCodeUnits) {
        String codeUnits = withCodeUnits ? " using codeunits32" : "";
        this.functionRegistry.registerTernaryQuaternaryPattern("overlay", this.stringType, "overlay(?1 placing ?2 from ?3 for character_length(?2" + (withCodeUnits ? ",codeunits32" : "") + ")" + codeUnits + ")", "overlay(?1 placing ?2 from ?3 for ?4" + codeUnits + ")", FunctionParameterType.STRING, FunctionParameterType.STRING, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER, this.typeConfiguration).setArgumentListSignature("(string placing replacement from start[ for length])");
    }

    public void replace() {
        this.functionRegistry.namedDescriptorBuilder("replace").setInvariantType(this.stringType).setExactArgumentCount(3).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.STRING, FunctionParameterType.STRING).setArgumentListSignature("(STRING string, STRING pattern, STRING replacement)").register();
    }

    public void replace_strReplace() {
        this.functionRegistry.namedDescriptorBuilder("str_replace").setInvariantType(this.stringType).setExactArgumentCount(3).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.STRING, FunctionParameterType.STRING).setArgumentListSignature("(STRING string, STRING pattern, STRING replacement)").register();
        this.functionRegistry.registerAlternateKey("replace", "str_replace");
    }

    public void concat() {
        this.functionRegistry.namedDescriptorBuilder("concat").setInvariantType(this.stringType).setMinArgumentCount(1).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.impliedOrInvariant(this.typeConfiguration, FunctionParameterType.STRING)).setArgumentListSignature("(STRING string0[, STRING string1[, ...]])").register();
    }

    public void lowerUpper() {
        this.functionRegistry.namedDescriptorBuilder("lower").setInvariantType(this.stringType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.STRING).setArgumentListSignature("(STRING string)").register();
        this.functionRegistry.namedDescriptorBuilder("upper").setInvariantType(this.stringType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.STRING).setArgumentListSignature("(STRING string)").register();
    }

    public void ascii() {
        this.functionRegistry.namedDescriptorBuilder("ascii").setExactArgumentCount(1).setParameterTypes(FunctionParameterType.STRING).setInvariantType(this.integerType).register();
    }

    public void char_chr() {
        this.functionRegistry.namedDescriptorBuilder("chr").setExactArgumentCount(1).setParameterTypes(FunctionParameterType.INTEGER).setInvariantType(this.characterType).register();
        this.functionRegistry.registerAlternateKey("char", "chr");
    }

    public void chr_char() {
        this.functionRegistry.namedDescriptorBuilder("char").setExactArgumentCount(1).setParameterTypes(FunctionParameterType.INTEGER).setInvariantType(this.characterType).register();
        this.functionRegistry.registerAlternateKey("chr", "char");
    }

    public void datepartDatename() {
        this.functionRegistry.namedDescriptorBuilder("datepart").setReturnTypeResolver(StandardFunctionReturnTypeResolvers.useArgType(1)).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.TEMPORAL_UNIT, FunctionParameterType.TEMPORAL).setArgumentListSignature("(TEMPORAL_UNIT field, TEMPORAL arg)").register();
        this.functionRegistry.namedDescriptorBuilder("datename").setInvariantType(this.stringType).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.TEMPORAL_UNIT, FunctionParameterType.TEMPORAL).setArgumentListSignature("(TEMPORAL_UNIT field, TEMPORAL arg)").register();
    }

    public void nowCurdateCurtime() {
        this.functionRegistry.noArgsBuilder("curtime").setInvariantType(this.timeType).setUseParenthesesWhenNoArgs(true).register();
        this.functionRegistry.noArgsBuilder("curdate").setInvariantType(this.dateType).setUseParenthesesWhenNoArgs(true).register();
        this.functionRegistry.noArgsBuilder("now").setInvariantType(this.timestampType).setUseParenthesesWhenNoArgs(true).register();
    }

    public void leastGreatest() {
        this.functionRegistry.namedDescriptorBuilder("least").setMinArgumentCount(2).setParameterTypes(FunctionParameterType.COMPARABLE, FunctionParameterType.COMPARABLE).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
        this.functionRegistry.namedDescriptorBuilder("greatest").setMinArgumentCount(2).setParameterTypes(FunctionParameterType.COMPARABLE, FunctionParameterType.COMPARABLE).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
    }

    public void leastGreatest_minMax() {
        this.functionRegistry.namedDescriptorBuilder("least", "min").setMinArgumentCount(2).setParameterTypes(FunctionParameterType.COMPARABLE, FunctionParameterType.COMPARABLE).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
        this.functionRegistry.namedDescriptorBuilder("greatest", "max").setMinArgumentCount(2).setParameterTypes(FunctionParameterType.COMPARABLE, FunctionParameterType.COMPARABLE).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
    }

    public void leastGreatest_minMaxValue() {
        this.functionRegistry.namedDescriptorBuilder("least", "minvalue").setMinArgumentCount(2).setParameterTypes(FunctionParameterType.COMPARABLE, FunctionParameterType.COMPARABLE).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
        this.functionRegistry.namedDescriptorBuilder("greatest", "maxvalue").setMinArgumentCount(2).setParameterTypes(FunctionParameterType.COMPARABLE, FunctionParameterType.COMPARABLE).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
    }

    public void aggregates(Dialect dialect, SqlAstNodeRenderingMode inferenceArgumentRenderingMode) {
        this.functionRegistry.namedAggregateDescriptorBuilder("max").setArgumentRenderingMode(inferenceArgumentRenderingMode).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.COMPARABLE).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.IMPLIED_RESULT_TYPE).register();
        this.functionRegistry.namedAggregateDescriptorBuilder("min").setArgumentRenderingMode(inferenceArgumentRenderingMode).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.COMPARABLE).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.IMPLIED_RESULT_TYPE).register();
        this.functionRegistry.namedAggregateDescriptorBuilder("sum").setArgumentRenderingMode(inferenceArgumentRenderingMode).setReturnTypeResolver(new SumReturnTypeResolver(this.typeConfiguration)).setExactArgumentCount(1).register();
        this.functionRegistry.namedAggregateDescriptorBuilder("avg").setArgumentRenderingMode(inferenceArgumentRenderingMode).setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
        this.functionRegistry.register("count", new CountFunction(dialect, this.typeConfiguration, inferenceArgumentRenderingMode, "||"));
    }

    public void avg_castingNonDoubleArguments(Dialect dialect, SqlAstNodeRenderingMode inferenceArgumentRenderingMode) {
        this.functionRegistry.register("avg", new AvgFunction(dialect, this.typeConfiguration, inferenceArgumentRenderingMode));
    }

    public void listagg(String emptyWithinReplacement) {
        this.functionRegistry.register("listagg", new ListaggFunction(emptyWithinReplacement, this.typeConfiguration));
    }

    public void listagg_groupConcat() {
        this.functionRegistry.register("listagg", new ListaggGroupConcatEmulation(this.typeConfiguration));
    }

    public void listagg_list(String stringType) {
        this.functionRegistry.register("listagg", new ListaggStringAggEmulation("list", stringType, false, this.typeConfiguration));
    }

    public void listagg_stringAgg(String stringType) {
        this.functionRegistry.register("listagg", new ListaggStringAggEmulation("string_agg", stringType, false, this.typeConfiguration));
    }

    public void listagg_stringAggWithinGroup(String stringType) {
        this.functionRegistry.register("listagg", new ListaggStringAggEmulation("string_agg", stringType, true, this.typeConfiguration));
    }

    public void inverseDistributionOrderedSetAggregates() {
        this.functionRegistry.register("mode", new InverseDistributionFunction("mode", null, this.typeConfiguration));
        this.functionRegistry.register("percentile_cont", new InverseDistributionFunction("percentile_cont", FunctionParameterType.NUMERIC, this.typeConfiguration));
        this.functionRegistry.register("percentile_disc", new InverseDistributionFunction("percentile_disc", FunctionParameterType.NUMERIC, this.typeConfiguration));
    }

    public void inverseDistributionOrderedSetAggregates_windowEmulation() {
        this.functionRegistry.register("percentile_cont", new InverseDistributionWindowEmulation("percentile_cont", FunctionParameterType.NUMERIC, this.typeConfiguration));
        this.functionRegistry.register("percentile_disc", new InverseDistributionWindowEmulation("percentile_disc", FunctionParameterType.NUMERIC, this.typeConfiguration));
    }

    public void hypotheticalOrderedSetAggregates() {
        this.functionRegistry.register("rank", new HypotheticalSetFunction("rank", StandardBasicTypes.LONG, this.typeConfiguration));
        this.functionRegistry.register("dense_rank", new HypotheticalSetFunction("dense_rank", StandardBasicTypes.LONG, this.typeConfiguration));
        this.functionRegistry.register("percent_rank", new HypotheticalSetFunction("percent_rank", StandardBasicTypes.DOUBLE, this.typeConfiguration));
        this.functionRegistry.register("cume_dist", new HypotheticalSetFunction("cume_dist", StandardBasicTypes.DOUBLE, this.typeConfiguration));
    }

    public void hypotheticalOrderedSetAggregates_windowEmulation() {
        this.functionRegistry.register("rank", new HypotheticalSetWindowEmulation("rank", StandardBasicTypes.LONG, this.typeConfiguration));
        this.functionRegistry.register("dense_rank", new HypotheticalSetWindowEmulation("dense_rank", StandardBasicTypes.LONG, this.typeConfiguration));
        this.functionRegistry.register("percent_rank", new HypotheticalSetWindowEmulation("percent_rank", StandardBasicTypes.DOUBLE, this.typeConfiguration));
        this.functionRegistry.register("cume_dist", new HypotheticalSetWindowEmulation("cume_dist", StandardBasicTypes.DOUBLE, this.typeConfiguration));
    }

    public void windowFunctions() {
        this.functionRegistry.namedWindowDescriptorBuilder("row_number").setExactArgumentCount(0).setInvariantType(this.longType).register();
        this.functionRegistry.namedWindowDescriptorBuilder("lag").setArgumentCountBetween(1, 3).setParameterTypes(FunctionParameterType.ANY, FunctionParameterType.INTEGER, FunctionParameterType.ANY).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.composite(StandardFunctionArgumentTypeResolvers.argumentsOrImplied(2), StandardFunctionArgumentTypeResolvers.invariant(this.typeConfiguration, FunctionParameterType.INTEGER), StandardFunctionArgumentTypeResolvers.argumentsOrImplied(0))).setArgumentListSignature("ANY value[, INTEGER offset[, ANY default]]").register();
        this.functionRegistry.namedWindowDescriptorBuilder("lead").setArgumentCountBetween(1, 3).setParameterTypes(FunctionParameterType.ANY, FunctionParameterType.INTEGER, FunctionParameterType.ANY).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.composite(StandardFunctionArgumentTypeResolvers.argumentsOrImplied(2), StandardFunctionArgumentTypeResolvers.invariant(this.typeConfiguration, FunctionParameterType.INTEGER), StandardFunctionArgumentTypeResolvers.argumentsOrImplied(0))).setArgumentListSignature("ANY value[, INTEGER offset[, ANY default]]").register();
        this.functionRegistry.namedWindowDescriptorBuilder("first_value").setExactArgumentCount(1).setParameterTypes(FunctionParameterType.ANY).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.IMPLIED_RESULT_TYPE).setArgumentListSignature("ANY value").register();
        this.functionRegistry.namedWindowDescriptorBuilder("last_value").setExactArgumentCount(1).setParameterTypes(FunctionParameterType.ANY).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.IMPLIED_RESULT_TYPE).setArgumentListSignature("ANY value").register();
        this.functionRegistry.namedWindowDescriptorBuilder("nth_value").setExactArgumentCount(2).setParameterTypes(FunctionParameterType.ANY, FunctionParameterType.INTEGER).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.IMPLIED_RESULT_TYPE).setArgumentListSignature("ANY value, INTEGER nth").register();
    }

    public void math() {
        this.functionRegistry.namedDescriptorBuilder("floor").setReturnTypeResolver(StandardFunctionReturnTypeResolvers.useArgType(1)).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
        this.functionRegistry.namedDescriptorBuilder("ceiling").setReturnTypeResolver(StandardFunctionReturnTypeResolvers.useArgType(1)).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
        this.functionRegistry.namedDescriptorBuilder("mod").setInvariantType(this.integerType).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.INTEGER, FunctionParameterType.INTEGER).register();
        this.functionRegistry.namedDescriptorBuilder("abs").setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
        this.functionRegistry.namedDescriptorBuilder("sign").setInvariantType(this.integerType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
        this.functionRegistry.namedDescriptorBuilder("sqrt").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
        this.functionRegistry.namedDescriptorBuilder("ln").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
        this.functionRegistry.namedDescriptorBuilder("exp").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
        this.functionRegistry.namedDescriptorBuilder("power").setInvariantType(this.doubleType).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.NUMERIC, FunctionParameterType.NUMERIC).register();
    }

    public void mod_operator() {
        this.functionRegistry.patternDescriptorBuilder("mod", "(?1%?2)").setInvariantType(this.integerType).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.INTEGER, FunctionParameterType.INTEGER).register();
    }

    public void power_expLn() {
        this.functionRegistry.patternDescriptorBuilder("power", "exp(ln(?1)*?2)").setInvariantType(this.doubleType).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.NUMERIC, FunctionParameterType.NUMERIC).register();
    }

    public void round() {
        this.functionRegistry.namedDescriptorBuilder("round").setReturnTypeResolver(StandardFunctionReturnTypeResolvers.useArgType(1)).setArgumentCountBetween(1, 2).setParameterTypes(FunctionParameterType.NUMERIC, FunctionParameterType.INTEGER).setArgumentListSignature("(NUMERIC number[, INTEGER places])").register();
    }

    public void round_round() {
        this.functionRegistry.registerUnaryBinaryPattern("round", "round(?1,0)", "round(?1,?2)", FunctionParameterType.NUMERIC, FunctionParameterType.INTEGER, this.typeConfiguration).setArgumentListSignature("(NUMERIC number[, INTEGER places])");
    }

    public void round_floor() {
        this.functionRegistry.registerUnaryBinaryPattern("round", "floor(?1+0.5)", "floor(?1*1e?2+0.5)/1e?2", FunctionParameterType.NUMERIC, FunctionParameterType.INTEGER, this.typeConfiguration).setArgumentListSignature("(NUMERIC number[, INTEGER places])");
    }

    public void round_roundFloor() {
        this.functionRegistry.registerUnaryBinaryPattern("round", "round(?1)", "floor(?1*1e?2+0.5)/1e?2", FunctionParameterType.NUMERIC, FunctionParameterType.INTEGER, this.typeConfiguration).setArgumentListSignature("(NUMERIC number[, INTEGER places])");
    }

    public void square() {
        this.functionRegistry.namedDescriptorBuilder("square").setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
    }

    public void cbrt() {
        this.functionRegistry.namedDescriptorBuilder("cbrt").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
    }

    public void crc32() {
        this.functionRegistry.namedDescriptorBuilder("crc32").setInvariantType(this.integerType).setParameterTypes(FunctionParameterType.STRING).setExactArgumentCount(1).register();
    }

    public void sha1() {
        this.functionRegistry.namedDescriptorBuilder("sha1").setInvariantType(this.stringType).setParameterTypes(FunctionParameterType.STRING).setExactArgumentCount(1).register();
    }

    public void sha2() {
        this.functionRegistry.namedDescriptorBuilder("sha2").setInvariantType(this.stringType).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.INTEGER).setExactArgumentCount(2).register();
    }

    public void sha() {
        this.functionRegistry.namedDescriptorBuilder("sha").setInvariantType(this.stringType).setParameterTypes(FunctionParameterType.STRING).setExactArgumentCount(1).register();
    }

    public void datediff() {
        this.functionRegistry.namedDescriptorBuilder("datediff").setInvariantType(this.integerType).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.DATE, FunctionParameterType.DATE).setArgumentListSignature("(DATE end, DATE start)").register();
    }

    public void adddateSubdateAddtimeSubtime() {
        this.functionRegistry.namedDescriptorBuilder("adddate").setReturnTypeResolver(StandardFunctionReturnTypeResolvers.useArgType(1)).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.DATE, FunctionParameterType.INTEGER).setArgumentListSignature("(DATE datetime, INTEGER days)").register();
        this.functionRegistry.namedDescriptorBuilder("subdate").setReturnTypeResolver(StandardFunctionReturnTypeResolvers.useArgType(1)).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.DATE, FunctionParameterType.INTEGER).setArgumentListSignature("(DATE datetime, INTEGER days)").register();
        this.functionRegistry.namedDescriptorBuilder("addtime").setReturnTypeResolver(StandardFunctionReturnTypeResolvers.useArgType(1)).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.TIME, FunctionParameterType.TIME).setArgumentListSignature("(TIME datetime, TIME time)").register();
        this.functionRegistry.namedDescriptorBuilder("subtime").setReturnTypeResolver(StandardFunctionReturnTypeResolvers.useArgType(1)).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.TIME, FunctionParameterType.TIME).setArgumentListSignature("(TIME datetime, TIME time)").register();
    }

    public void addMonths() {
        this.functionRegistry.namedDescriptorBuilder("add_months").setReturnTypeResolver(StandardFunctionReturnTypeResolvers.useArgType(1)).setArgumentListSignature("(DATE datetime, INTEGER months)").setExactArgumentCount(2).setParameterTypes(FunctionParameterType.DATE, FunctionParameterType.INTEGER).register();
    }

    public void monthsBetween() {
        this.functionRegistry.namedDescriptorBuilder("months_between").setInvariantType(this.integerType).setExactArgumentCount(2).setArgumentListSignature("(DATE end, DATE start)").setParameterTypes(FunctionParameterType.DATE, FunctionParameterType.DATE).register();
    }

    public void daysBetween() {
        this.functionRegistry.namedDescriptorBuilder("days_between").setInvariantType(this.integerType).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.DATE, FunctionParameterType.DATE).setArgumentListSignature("(DATE end, DATE start)").register();
    }

    public void secondsBetween() {
        this.functionRegistry.namedDescriptorBuilder("seconds_between").setInvariantType(this.longType).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.TIME, FunctionParameterType.TIME).setArgumentListSignature("(TIME end, TIME start)").register();
    }

    public void yearsMonthsDaysHoursMinutesSecondsBetween() {
        this.functionRegistry.namedDescriptorBuilder("years_between").setInvariantType(this.integerType).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.DATE, FunctionParameterType.DATE).setArgumentListSignature("(DATE end, DATE start)").register();
        this.functionRegistry.namedDescriptorBuilder("months_between").setInvariantType(this.integerType).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.DATE, FunctionParameterType.DATE).setArgumentListSignature("(DATE end, DATE start)").register();
        this.functionRegistry.namedDescriptorBuilder("days_between").setInvariantType(this.integerType).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.DATE, FunctionParameterType.DATE).setArgumentListSignature("(DATE end, DATE start)").register();
        this.functionRegistry.namedDescriptorBuilder("hours_between").setInvariantType(this.longType).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.TIME, FunctionParameterType.TIME).setArgumentListSignature("(TIME end, TIME start)").register();
        this.functionRegistry.namedDescriptorBuilder("minutes_between").setInvariantType(this.longType).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.TIME, FunctionParameterType.TIME).setArgumentListSignature("(TIME end, TIME start)").register();
        this.functionRegistry.namedDescriptorBuilder("seconds_between").setInvariantType(this.longType).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.TIME, FunctionParameterType.TIME).setArgumentListSignature("(TIME end, TIME start)").register();
    }

    public void addYearsMonthsDaysHoursMinutesSeconds() {
        this.functionRegistry.namedDescriptorBuilder("add_years").setReturnTypeResolver(StandardFunctionReturnTypeResolvers.useArgType(1)).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.DATE, FunctionParameterType.INTEGER).setArgumentListSignature("(DATE datetime, INTEGER years)").register();
        this.functionRegistry.namedDescriptorBuilder("add_months").setReturnTypeResolver(StandardFunctionReturnTypeResolvers.useArgType(1)).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.DATE, FunctionParameterType.INTEGER).setArgumentListSignature("(DATE datetime, INTEGER months)").register();
        this.functionRegistry.namedDescriptorBuilder("add_days").setReturnTypeResolver(StandardFunctionReturnTypeResolvers.useArgType(1)).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.DATE, FunctionParameterType.INTEGER).setArgumentListSignature("(DATE datetime, INTEGER days)").register();
        this.functionRegistry.namedDescriptorBuilder("add_hours").setReturnTypeResolver(StandardFunctionReturnTypeResolvers.useArgType(1)).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.TIME, FunctionParameterType.INTEGER).setArgumentListSignature("(TIME datetime, INTEGER hours)").register();
        this.functionRegistry.namedDescriptorBuilder("add_minutes").setReturnTypeResolver(StandardFunctionReturnTypeResolvers.useArgType(1)).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.TIME, FunctionParameterType.INTEGER).setArgumentListSignature("(TIME datetime, INTEGER minutes)").register();
        this.functionRegistry.namedDescriptorBuilder("add_seconds").setReturnTypeResolver(StandardFunctionReturnTypeResolvers.useArgType(1)).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.TIME, FunctionParameterType.INTEGER).setArgumentListSignature("(TIME datetime, INTEGER seconds)").register();
    }

    public void format_formatdatetime() {
        this.functionRegistry.register("format", new FormatFunction("formatdatetime", this.typeConfiguration));
    }

    public void format_toChar() {
        this.functionRegistry.register("format", new FormatFunction("to_char", this.typeConfiguration));
    }

    public void format_dateFormat() {
        this.functionRegistry.register("format", new FormatFunction("date_format", this.typeConfiguration));
    }

    public void format_toVarchar() {
        this.functionRegistry.register("format", new FormatFunction("to_varchar", this.typeConfiguration));
    }

    public void collate() {
        this.functionRegistry.patternDescriptorBuilder("collate", "(?1 collate ?2)").setInvariantType(this.stringType).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.COLLATION).setArgumentListSignature("(STRING string as COLLATION collation)").register();
    }

    public void collate_quoted() {
        this.functionRegistry.patternDescriptorBuilder("collate", "(?1 collate '?2')").setInvariantType(this.stringType).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.COLLATION).setArgumentListSignature("(STRING string as COLLATION collation)").register();
    }

    public void dateTrunc() {
        this.functionRegistry.patternDescriptorBuilder("date_trunc", "date_trunc(?1,?2)").setReturnTypeResolver(StandardFunctionReturnTypeResolvers.useArgType(2)).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.TEMPORAL).setArgumentListSignature("(STRING field, TEMPORAL datetime)").register();
    }

    public void dateTrunc_datetrunc() {
        this.functionRegistry.patternDescriptorBuilder("datetrunc", "datetrunc(?1,?2)").setReturnTypeResolver(StandardFunctionReturnTypeResolvers.useArgType(2)).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.TEMPORAL_UNIT, FunctionParameterType.TEMPORAL).setArgumentListSignature("(TEMPORAL_UNIT field, TEMPORAL datetime)").register();
    }
}

