/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.BinaryArithmeticOperator;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.function.AbstractSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.function.FunctionRenderingSupport;
import org.hibernate.query.sqm.function.MultipatternSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SelfRenderingFunctionSqlAstExpression;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StringBuilderSqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.DurationUnit;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Format;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.SqlTupleContainer;
import org.hibernate.sql.ast.tree.predicate.BetweenPredicate;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;

public class FormatFunction
extends AbstractSqmFunctionDescriptor
implements FunctionRenderingSupport {
    private final String nativeFunctionName;
    private final boolean reversedArguments;
    private final boolean concatPattern;

    public FormatFunction(String nativeFunctionName, TypeConfiguration typeConfiguration) {
        this(nativeFunctionName, false, true, typeConfiguration);
    }

    public FormatFunction(String nativeFunctionName, boolean reversedArguments, boolean concatPattern, TypeConfiguration typeConfiguration) {
        super("format", new ArgumentTypesValidator(StandardArgumentsValidators.exactly(2), FunctionParameterType.TEMPORAL, FunctionParameterType.STRING), StandardFunctionReturnTypeResolvers.invariant(typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.STRING)), StandardFunctionArgumentTypeResolvers.invariant(typeConfiguration, FunctionParameterType.TEMPORAL, FunctionParameterType.STRING));
        this.nativeFunctionName = nativeFunctionName;
        this.reversedArguments = reversedArguments;
        this.concatPattern = concatPattern;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql(this.nativeFunctionName);
        sqlAppender.append('(');
        SqlAstNode expression = sqlAstArguments.get(0);
        SqlAstNode format = sqlAstArguments.get(1);
        if (this.reversedArguments) {
            format.accept(walker);
            sqlAppender.append(',');
            expression.accept(walker);
        } else {
            expression.accept(walker);
            sqlAppender.append(',');
            format.accept(walker);
        }
        sqlAppender.append(')');
    }

    @Override
    protected <T> SelfRenderingSqmFunction<T> generateSqmFunctionExpression(List<? extends SqmTypedNode<?>> arguments, ReturnableType<T> impliedResultType, QueryEngine queryEngine, TypeConfiguration typeConfiguration) {
        return new FormatSqmFunction<T>((SqmFunctionDescriptor)this, (FunctionRenderingSupport)this, arguments, impliedResultType, this.getArgumentsValidator(), this.getReturnTypeResolver(), this.concatPattern, queryEngine);
    }

    @Override
    public String getArgumentListSignature() {
        return "(TEMPORAL datetime as STRING pattern)";
    }

    protected static class FormatSqmFunction<T>
    extends SelfRenderingSqmFunction<T> {
        private final boolean supportsPatternLiterals;
        private final TypeConfiguration typeConfiguration;

        public FormatSqmFunction(SqmFunctionDescriptor descriptor, FunctionRenderingSupport renderingSupport, List<? extends SqmTypedNode<?>> arguments, ReturnableType<T> impliedResultType, ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver, boolean supportsPatternLiterals, QueryEngine queryEngine) {
            super(descriptor, renderingSupport, arguments, impliedResultType, argumentsValidator, returnTypeResolver, queryEngine.getCriteriaBuilder(), "format");
            this.supportsPatternLiterals = supportsPatternLiterals;
            this.typeConfiguration = queryEngine.getTypeConfiguration();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Expression convertToSqlAst(SqmToSqlAstConverter walker) {
            ReturnableType<?> resultType = this.resolveResultType(walker.getCreationContext().getMappingMetamodel().getTypeConfiguration());
            MappingModelExpressible<?> mappingModelExpressible = resultType == null ? null : this.getMappingModelExpressible(walker, resultType);
            List<SqlAstNode> arguments = this.resolveSqlAstArguments(this.getArguments(), walker);
            SqlAstNode expression = arguments.get(0);
            if (expression instanceof SqlTupleContainer) {
                String delimiter;
                Format format;
                SqlTuple sqlTuple = ((SqlTupleContainer)((Object)expression)).getSqlTuple();
                AbstractSqmSelfRenderingFunctionDescriptor timestampaddFunction = this.getFunction(walker, "timestampadd");
                BasicType<Integer> integerType = this.typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER);
                arguments.set(0, this.getOffsetAdjusted(sqlTuple, timestampaddFunction, integerType));
                if (this.getArgumentsValidator() != null) {
                    this.getArgumentsValidator().validateSqlTypes(arguments, this.getFunctionName());
                }
                if (!(format = (Format)arguments.get(1)).getFormat().contains("x") && this.supportsPatternLiterals) return new SelfRenderingFunctionSqlAstExpression(this.getFunctionName(), this.getRenderingSupport(), arguments, resultType, mappingModelExpressible);
                AbstractSqmSelfRenderingFunctionDescriptor concatFunction = this.getFunction(walker, "concat");
                AbstractSqmSelfRenderingFunctionDescriptor substringFunction = this.getFunction(walker, "substring", 3);
                AbstractSqmSelfRenderingFunctionDescriptor floorFunction = this.getFunction(walker, "floor");
                AbstractSqmSelfRenderingFunctionDescriptor castFunction = this.getFunction(walker, "cast");
                BasicType<String> stringType = this.typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.STRING);
                Dialect dialect = walker.getCreationContext().getSessionFactory().getJdbcServices().getDialect();
                Expression formatExpression = null;
                StringBuilder sb = new StringBuilder();
                StringBuilderSqlAppender sqlAppender = new StringBuilderSqlAppender(sb);
                if (this.supportsPatternLiterals) {
                    dialect.appendDatetimeFormat(sqlAppender, "'a'");
                    delimiter = sb.substring(0, sb.indexOf("a")).replace("''", "'");
                } else {
                    delimiter = "";
                }
                String[] chunks = StringHelper.splitFull("'", format.getFormat());
                Expression offsetExpression = sqlTuple.getExpressions().get(1);
                for (int i = 0; i < chunks.length; i += 2) {
                    String formatLiteralPart;
                    String[] fullParts = StringHelper.splitFull("xxx", chunks[i]);
                    for (int j = 0; j < fullParts.length; ++j) {
                        if (fullParts[j].isEmpty()) continue;
                        String[] mediumParts = StringHelper.splitFull("xx", fullParts[j]);
                        for (int k = 0; k < mediumParts.length; ++k) {
                            if (mediumParts[k].isEmpty()) continue;
                            String[] smallParts = StringHelper.splitFull("x", mediumParts[k]);
                            for (int l = 0; l < smallParts.length; ++l) {
                                if (smallParts[l].isEmpty()) continue;
                                sb.setLength(0);
                                dialect.appendDatetimeFormat(sqlAppender, smallParts[l]);
                                String formatPart = sb.toString();
                                formatExpression = this.supportsPatternLiterals ? this.concat(concatFunction, stringType, formatExpression, new QueryLiteral<String>(formatPart, stringType)) : this.concat(concatFunction, stringType, formatExpression, new SelfRenderingFunctionSqlAstExpression(this.getFunctionName(), this.getRenderingSupport(), List.of(arguments.get(0), new QueryLiteral<String>(formatPart, stringType)), resultType, mappingModelExpressible));
                                if (l + 1 >= smallParts.length) continue;
                                formatExpression = this.concatAsLiteral(concatFunction, stringType, delimiter, formatExpression, this.createSmallOffset(concatFunction, substringFunction, floorFunction, castFunction, stringType, integerType, offsetExpression));
                            }
                            if (k + 1 >= mediumParts.length) continue;
                            formatExpression = this.concatAsLiteral(concatFunction, stringType, delimiter, formatExpression, this.createMediumOffset(concatFunction, substringFunction, floorFunction, castFunction, stringType, integerType, offsetExpression));
                        }
                        if (j + 1 >= fullParts.length) continue;
                        formatExpression = this.concatAsLiteral(concatFunction, stringType, delimiter, formatExpression, this.createFullOffset(concatFunction, floorFunction, castFunction, stringType, integerType, offsetExpression));
                    }
                    if (i + 1 >= chunks.length) continue;
                    if (this.supportsPatternLiterals) {
                        sb.setLength(0);
                        dialect.appendDatetimeFormat(sqlAppender, "'" + chunks[i + 1] + "'");
                        formatLiteralPart = sb.toString().replace("''", "'");
                    } else {
                        formatLiteralPart = chunks[i + 1];
                    }
                    formatExpression = this.concat(concatFunction, stringType, formatExpression, new QueryLiteral<String>(formatLiteralPart, stringType));
                }
                if (!this.supportsPatternLiterals) return formatExpression;
                arguments.set(1, formatExpression);
                return new SelfRenderingFunctionSqlAstExpression(this.getFunctionName(), this.getRenderingSupport(), arguments, resultType, mappingModelExpressible);
            } else {
                if (this.getArgumentsValidator() != null) {
                    this.getArgumentsValidator().validateSqlTypes(arguments, this.getFunctionName());
                }
                if (this.supportsPatternLiterals) return new SelfRenderingFunctionSqlAstExpression(this.getFunctionName(), this.getRenderingSupport(), arguments, resultType, mappingModelExpressible);
                AbstractSqmSelfRenderingFunctionDescriptor concatFunction = this.getFunction(walker, "concat");
                BasicType<String> stringType = this.typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.STRING);
                Expression formatExpression = null;
                Format format = (Format)arguments.get(1);
                String[] chunks = StringHelper.splitFull("'", format.getFormat());
                for (int i = 0; i < chunks.length; i += 2) {
                    formatExpression = this.concat(concatFunction, stringType, formatExpression, new SelfRenderingFunctionSqlAstExpression(this.getFunctionName(), this.getRenderingSupport(), List.of(arguments.get(0), new Format(chunks[i])), resultType, mappingModelExpressible));
                    if (i + 1 >= chunks.length) continue;
                    formatExpression = this.concat(concatFunction, stringType, formatExpression, new QueryLiteral<String>(chunks[i + 1], stringType));
                }
                return formatExpression;
            }
        }

        private AbstractSqmSelfRenderingFunctionDescriptor getFunction(SqmToSqlAstConverter walker, String name) {
            return (AbstractSqmSelfRenderingFunctionDescriptor)walker.getCreationContext().getSessionFactory().getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor(name);
        }

        private AbstractSqmSelfRenderingFunctionDescriptor getFunction(SqmToSqlAstConverter walker, String name, int argumentCount) {
            SqmFunctionDescriptor functionDescriptor = walker.getCreationContext().getSessionFactory().getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor(name);
            if (functionDescriptor instanceof MultipatternSqmFunctionDescriptor) {
                return (AbstractSqmSelfRenderingFunctionDescriptor)((MultipatternSqmFunctionDescriptor)functionDescriptor).getFunction(argumentCount);
            }
            return (AbstractSqmSelfRenderingFunctionDescriptor)functionDescriptor;
        }

        private SqlAstNode getOffsetAdjusted(SqlTuple sqlTuple, AbstractSqmSelfRenderingFunctionDescriptor timestampaddFunction, BasicType<Integer> integerType) {
            Expression instantExpression = sqlTuple.getExpressions().get(0);
            Expression offsetExpression = sqlTuple.getExpressions().get(1);
            return new SelfRenderingFunctionSqlAstExpression("timestampadd", timestampaddFunction, List.of(new DurationUnit(TemporalUnit.SECOND, integerType), offsetExpression, instantExpression), (ReturnableType)((Object)instantExpression.getExpressionType()), instantExpression.getExpressionType());
        }

        private Expression createFullOffset(AbstractSqmSelfRenderingFunctionDescriptor concatFunction, AbstractSqmSelfRenderingFunctionDescriptor floorFunction, AbstractSqmSelfRenderingFunctionDescriptor castFunction, BasicType<String> stringType, BasicType<Integer> integerType, Expression offsetExpression) {
            if (offsetExpression.getExpressionType().getSingleJdbcMapping().getJdbcType().isString()) {
                return offsetExpression;
            }
            CaseSearchedExpression caseSearchedExpression = new CaseSearchedExpression(stringType);
            caseSearchedExpression.getWhenFragments().add(new CaseSearchedExpression.WhenFragment(new ComparisonPredicate(offsetExpression, ComparisonOperator.LESS_THAN_OR_EQUAL, new QueryLiteral<Integer>(-36000, integerType)), new QueryLiteral<String>("-", stringType)));
            caseSearchedExpression.getWhenFragments().add(new CaseSearchedExpression.WhenFragment(new ComparisonPredicate(offsetExpression, ComparisonOperator.LESS_THAN, new QueryLiteral<Integer>(0, integerType)), new QueryLiteral<String>("-0", stringType)));
            caseSearchedExpression.getWhenFragments().add(new CaseSearchedExpression.WhenFragment(new ComparisonPredicate(offsetExpression, ComparisonOperator.GREATER_THAN_OR_EQUAL, new QueryLiteral<Integer>(36000, integerType)), new QueryLiteral<String>("+", stringType)));
            caseSearchedExpression.otherwise(new QueryLiteral<String>("+0", stringType));
            Expression hours = this.getHours(floorFunction, castFunction, integerType, offsetExpression);
            Expression minutes = this.getMinutes(floorFunction, castFunction, integerType, offsetExpression);
            CaseSearchedExpression minuteStart = new CaseSearchedExpression(stringType);
            minuteStart.getWhenFragments().add(new CaseSearchedExpression.WhenFragment(new BetweenPredicate(minutes, new QueryLiteral<Integer>(-9, integerType), new QueryLiteral<Integer>(9, integerType), false, null), new QueryLiteral<String>(":0", stringType)));
            minuteStart.otherwise(new QueryLiteral<String>(":", stringType));
            return this.concat(concatFunction, stringType, this.concat(concatFunction, stringType, this.concat(concatFunction, stringType, caseSearchedExpression, hours), minuteStart), minutes);
        }

        private Expression createMediumOffset(AbstractSqmSelfRenderingFunctionDescriptor concatFunction, AbstractSqmSelfRenderingFunctionDescriptor substringFunction, AbstractSqmSelfRenderingFunctionDescriptor floorFunction, AbstractSqmSelfRenderingFunctionDescriptor castFunction, BasicType<String> stringType, BasicType<Integer> integerType, Expression offsetExpression) {
            if (offsetExpression.getExpressionType().getSingleJdbcMapping().getJdbcType().isString()) {
                return this.concat(concatFunction, stringType, this.createSmallOffset(concatFunction, substringFunction, floorFunction, castFunction, stringType, integerType, offsetExpression), new SelfRenderingFunctionSqlAstExpression("substring", substringFunction, List.of(offsetExpression, new QueryLiteral<Integer>(4, integerType), new QueryLiteral<Integer>(6, integerType)), stringType, stringType));
            }
            CaseSearchedExpression caseSearchedExpression = new CaseSearchedExpression(stringType);
            caseSearchedExpression.getWhenFragments().add(new CaseSearchedExpression.WhenFragment(new ComparisonPredicate(offsetExpression, ComparisonOperator.LESS_THAN_OR_EQUAL, new QueryLiteral<Integer>(-36000, integerType)), new QueryLiteral<String>("-", stringType)));
            caseSearchedExpression.getWhenFragments().add(new CaseSearchedExpression.WhenFragment(new ComparisonPredicate(offsetExpression, ComparisonOperator.LESS_THAN, new QueryLiteral<Integer>(0, integerType)), new QueryLiteral<String>("-0", stringType)));
            caseSearchedExpression.getWhenFragments().add(new CaseSearchedExpression.WhenFragment(new ComparisonPredicate(offsetExpression, ComparisonOperator.GREATER_THAN_OR_EQUAL, new QueryLiteral<Integer>(36000, integerType)), new QueryLiteral<String>("+", stringType)));
            caseSearchedExpression.otherwise(new QueryLiteral<String>("+0", stringType));
            Expression hours = this.getHours(floorFunction, castFunction, integerType, offsetExpression);
            Expression minutes = this.getMinutes(floorFunction, castFunction, integerType, offsetExpression);
            CaseSearchedExpression minuteStart = new CaseSearchedExpression(stringType);
            minuteStart.getWhenFragments().add(new CaseSearchedExpression.WhenFragment(new BetweenPredicate(minutes, new QueryLiteral<Integer>(-9, integerType), new QueryLiteral<Integer>(9, integerType), false, null), new QueryLiteral<String>("0", stringType)));
            minuteStart.otherwise(new QueryLiteral<String>("", stringType));
            return this.concat(concatFunction, stringType, this.concat(concatFunction, stringType, this.concat(concatFunction, stringType, caseSearchedExpression, hours), minuteStart), minutes);
        }

        private Expression createSmallOffset(AbstractSqmSelfRenderingFunctionDescriptor concatFunction, AbstractSqmSelfRenderingFunctionDescriptor substringFunction, AbstractSqmSelfRenderingFunctionDescriptor floorFunction, AbstractSqmSelfRenderingFunctionDescriptor castFunction, BasicType<String> stringType, BasicType<Integer> integerType, Expression offsetExpression) {
            if (offsetExpression.getExpressionType().getSingleJdbcMapping().getJdbcType().isString()) {
                return new SelfRenderingFunctionSqlAstExpression("substring", substringFunction, List.of(offsetExpression, new QueryLiteral<Integer>(1, integerType), new QueryLiteral<Integer>(4, integerType)), stringType, stringType);
            }
            CaseSearchedExpression caseSearchedExpression = new CaseSearchedExpression(stringType);
            caseSearchedExpression.getWhenFragments().add(new CaseSearchedExpression.WhenFragment(new ComparisonPredicate(offsetExpression, ComparisonOperator.LESS_THAN_OR_EQUAL, new QueryLiteral<Integer>(-36000, integerType)), new QueryLiteral<String>("-", stringType)));
            caseSearchedExpression.getWhenFragments().add(new CaseSearchedExpression.WhenFragment(new ComparisonPredicate(offsetExpression, ComparisonOperator.LESS_THAN, new QueryLiteral<Integer>(0, integerType)), new QueryLiteral<String>("-0", stringType)));
            caseSearchedExpression.getWhenFragments().add(new CaseSearchedExpression.WhenFragment(new ComparisonPredicate(offsetExpression, ComparisonOperator.GREATER_THAN_OR_EQUAL, new QueryLiteral<Integer>(36000, integerType)), new QueryLiteral<String>("+", stringType)));
            caseSearchedExpression.otherwise(new QueryLiteral<String>("+0", stringType));
            Expression hours = this.getHours(floorFunction, castFunction, integerType, offsetExpression);
            return this.concat(concatFunction, stringType, caseSearchedExpression, hours);
        }

        private Expression concatAsLiteral(AbstractSqmSelfRenderingFunctionDescriptor concatFunction, BasicType<String> stringType, String delimiter, Expression expression, Expression expression2) {
            return this.concat(concatFunction, stringType, this.concat(concatFunction, stringType, this.concat(concatFunction, stringType, expression, new QueryLiteral<String>(delimiter, stringType)), expression2), new QueryLiteral<String>(delimiter, stringType));
        }

        private Expression concat(AbstractSqmSelfRenderingFunctionDescriptor concatFunction, BasicType<String> stringType, Expression expression, Expression expression2) {
            if (expression == null) {
                return expression2;
            }
            if (expression instanceof SelfRenderingFunctionSqlAstExpression && "concat".equals(((SelfRenderingFunctionSqlAstExpression)expression).getFunctionName())) {
                List<? extends SqlAstNode> list = ((SelfRenderingFunctionSqlAstExpression)expression).getArguments();
                SqlAstNode lastOperand = list.get(list.size() - 1);
                if (expression2 instanceof QueryLiteral && lastOperand instanceof QueryLiteral) {
                    list.set(list.size() - 1, new QueryLiteral<CallSite>((CallSite)((Object)(((QueryLiteral)lastOperand).getLiteralValue().toString() + ((QueryLiteral)expression2).getLiteralValue().toString())), stringType));
                } else {
                    list.add(expression2);
                }
                return expression;
            }
            if (expression2 instanceof SelfRenderingFunctionSqlAstExpression && "concat".equals(((SelfRenderingFunctionSqlAstExpression)expression2).getFunctionName())) {
                List<? extends SqlAstNode> list = ((SelfRenderingFunctionSqlAstExpression)expression2).getArguments();
                SqlAstNode firstOperand = list.get(0);
                if (expression instanceof QueryLiteral && firstOperand instanceof QueryLiteral) {
                    list.set(list.size() - 1, new QueryLiteral<CallSite>((CallSite)((Object)(((QueryLiteral)expression).getLiteralValue().toString() + ((QueryLiteral)firstOperand).getLiteralValue().toString())), stringType));
                } else {
                    list.add(0, expression);
                }
                return expression2;
            }
            if (expression instanceof QueryLiteral && expression2 instanceof QueryLiteral) {
                return new QueryLiteral<CallSite>((CallSite)((Object)(((QueryLiteral)expression).getLiteralValue().toString() + ((QueryLiteral)expression2).getLiteralValue().toString())), stringType);
            }
            ArrayList<Expression> list = new ArrayList<Expression>(2);
            list.add(expression);
            list.add(expression2);
            return new SelfRenderingFunctionSqlAstExpression("concat", concatFunction, list, stringType, stringType);
        }

        private Expression getHours(AbstractSqmSelfRenderingFunctionDescriptor floorFunction, AbstractSqmSelfRenderingFunctionDescriptor castFunction, BasicType<Integer> integerType, Expression offsetExpression) {
            return new SelfRenderingFunctionSqlAstExpression("cast", castFunction, List.of(new SelfRenderingFunctionSqlAstExpression("floor", floorFunction, List.of(new BinaryArithmeticExpression(offsetExpression, BinaryArithmeticOperator.DIVIDE, new QueryLiteral<Integer>(3600, integerType), integerType)), integerType, integerType), new CastTarget(integerType)), integerType, integerType);
        }

        private Expression getMinutes(AbstractSqmSelfRenderingFunctionDescriptor floorFunction, AbstractSqmSelfRenderingFunctionDescriptor castFunction, BasicType<Integer> integerType, Expression offsetExpression) {
            return new SelfRenderingFunctionSqlAstExpression("cast", castFunction, List.of(new SelfRenderingFunctionSqlAstExpression("floor", floorFunction, List.of(new BinaryArithmeticExpression(new BinaryArithmeticExpression(offsetExpression, BinaryArithmeticOperator.MODULO, new QueryLiteral<Integer>(3600, integerType), integerType), BinaryArithmeticOperator.DIVIDE, new QueryLiteral<Integer>(60, integerType), integerType)), integerType, integerType), new CastTarget(integerType)), integerType, integerType);
        }
    }
}

