/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.temptable;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Exportable;
import org.hibernate.boot.model.relational.QualifiedNameParser;
import org.hibernate.boot.model.relational.QualifiedTableName;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.temptable.TemporaryTableColumn;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.dialect.temptable.TemporaryTableSessionUidColumn;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.generator.Generator;
import org.hibernate.id.OptimizableGenerator;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Contributable;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;

public class TemporaryTable
implements Exportable,
Contributable {
    public static final String ID_TABLE_PREFIX = "HT_";
    public static final String ENTITY_TABLE_PREFIX = "HTE_";
    public static final String DEFAULT_ALIAS = "temptable_";
    public static final String ENTITY_TABLE_IDENTITY_COLUMN = "HTE_IDENTITY";
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(TemporaryTable.class);
    private final EntityMappingType entityDescriptor;
    private final String qualifiedTableName;
    private final TemporaryTableSessionUidColumn sessionUidColumn;
    private final List<TemporaryTableColumn> columns;
    private final List<TemporaryTableColumn> columnsForExport;
    private final Dialect dialect;

    private TemporaryTable(EntityMappingType entityDescriptor, Function<String, String> temporaryTableNameAdjuster, Dialect dialect, RuntimeModelCreationContext creationContext, Function<TemporaryTable, List<TemporaryTableColumn>> columnInitializer) {
        this.entityDescriptor = entityDescriptor;
        EntityPersister entityPersister = entityDescriptor.getEntityPersister();
        EntityPersister rootEntityPersister = entityDescriptor.getRootEntityDescriptor().getEntityPersister();
        String persisterQuerySpace = entityPersister.getSynchronizedQuerySpaces()[0];
        QualifiedNameParser.NameParts nameParts = QualifiedNameParser.INSTANCE.parse(persisterQuerySpace);
        Object tableBaseName = rootEntityPersister != entityPersister && rootEntityPersister instanceof SingleTableEntityPersister ? nameParts.getObjectName().getText() + ArrayHelper.indexOf(((SingleTableEntityPersister)rootEntityPersister).getSubclassClosure(), entityPersister.getEntityName()) : nameParts.getObjectName().getText();
        QualifiedNameParser.NameParts adjustedNameParts = QualifiedNameParser.INSTANCE.parse(temporaryTableNameAdjuster.apply((String)tableBaseName));
        String temporaryTableName = adjustedNameParts.getObjectName().getText();
        Identifier tableNameIdentifier = temporaryTableName.length() > dialect.getMaxIdentifierLength() ? new Identifier(temporaryTableName.substring(0, dialect.getMaxIdentifierLength()), nameParts.getObjectName().isQuoted()) : new Identifier(temporaryTableName, nameParts.getObjectName().isQuoted());
        this.qualifiedTableName = creationContext.getSqlStringGenerationContext().format(new QualifiedTableName(adjustedNameParts.getCatalogName() != null ? adjustedNameParts.getCatalogName() : nameParts.getCatalogName(), adjustedNameParts.getSchemaName() != null ? adjustedNameParts.getSchemaName() : nameParts.getSchemaName(), tableNameIdentifier));
        this.dialect = dialect;
        if (dialect.getSupportedTemporaryTableKind() == TemporaryTableKind.PERSISTENT) {
            TypeConfiguration typeConfiguration = entityPersister.getFactory().getTypeConfiguration();
            BasicType<UUID> uuidType = typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.UUID_CHAR);
            Size size = dialect.getSizeStrategy().resolveSize(uuidType.getJdbcType(), uuidType.getJavaTypeDescriptor(), null, null, null);
            this.sessionUidColumn = new TemporaryTableSessionUidColumn(this, uuidType, typeConfiguration.getDdlTypeRegistry().getTypeName(uuidType.getJdbcType().getDdlTypeCode(), size), size);
        } else {
            this.sessionUidColumn = null;
        }
        List<TemporaryTableColumn> columns = columnInitializer.apply(this);
        if (this.sessionUidColumn != null) {
            columns.add(this.sessionUidColumn);
        }
        this.columns = columns;
        if (columns.size() > 1) {
            ArrayList<TemporaryTableColumn> columnsForExport = new ArrayList<TemporaryTableColumn>(columns);
            creationContext.getBootModel().getMetadataBuildingOptions().getColumnOrderingStrategy().orderTemporaryTableColumns(columnsForExport, creationContext.getMetadata());
            this.columnsForExport = columnsForExport;
        } else {
            this.columnsForExport = columns;
        }
    }

    public static TemporaryTable createIdTable(EntityMappingType entityDescriptor, Function<String, String> temporaryTableNameAdjuster, Dialect dialect, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new TemporaryTable(entityDescriptor, temporaryTableNameAdjuster, dialect, runtimeModelCreationContext, temporaryTable -> {
            ArrayList<TemporaryTableColumn> columns = new ArrayList<TemporaryTableColumn>();
            PersistentClass entityBinding = runtimeModelCreationContext.getBootModel().getEntityBinding(entityDescriptor.getEntityName());
            Iterator<JdbcMapping> jdbcMappings = entityDescriptor.getIdentifierMapping().getJdbcMappings().iterator();
            for (Column column : entityBinding.getKey().getColumns()) {
                JdbcMapping jdbcMapping = jdbcMappings.next();
                columns.add(new TemporaryTableColumn((TemporaryTable)temporaryTable, column.getText(dialect), jdbcMapping, column.getSqlType(runtimeModelCreationContext.getMetadata()), column.getColumnSize(dialect, runtimeModelCreationContext.getMetadata()), column.isNullable(), true));
            }
            entityDescriptor.visitSubTypeAttributeMappings(attribute -> {
                PluralAttributeMapping pluralAttribute;
                if (attribute instanceof PluralAttributeMapping && (pluralAttribute = (PluralAttributeMapping)attribute).getSeparateCollectionTable() != null) {
                    ForeignKeyDescriptor keyDescriptor = pluralAttribute.getKeyDescriptor();
                    if (keyDescriptor == null) {
                        throw new IllegalStateException("Not yet ready: " + pluralAttribute);
                    }
                    ValuedModelPart fkTarget = keyDescriptor.getTargetPart();
                    if (!fkTarget.isEntityIdentifierMapping()) {
                        Value value = entityBinding.getSubclassProperty(pluralAttribute.getAttributeName()).getValue();
                        Iterator<Selectable> columnIterator = ((Collection)value).getKey().getColumnIterator();
                        fkTarget.forEachSelectable((columnIndex, selection) -> {
                            Selectable selectable = (Selectable)columnIterator.next();
                            if (selectable instanceof Column) {
                                Column column = (Column)selectable;
                                columns.add(new TemporaryTableColumn((TemporaryTable)temporaryTable, column.getText(dialect), selection.getJdbcMapping(), column.getSqlType(runtimeModelCreationContext.getMetadata()), column.getColumnSize(dialect, runtimeModelCreationContext.getMetadata()), column.isNullable()));
                            }
                        });
                    }
                }
            });
            return columns;
        });
    }

    public static TemporaryTable createEntityTable(EntityMappingType entityDescriptor, Function<String, String> temporaryTableNameAdjuster, Dialect dialect, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new TemporaryTable(entityDescriptor, temporaryTableNameAdjuster, dialect, runtimeModelCreationContext, temporaryTable -> {
            JdbcMapping jdbcMapping;
            Iterator<JdbcMapping> jdbcMappings;
            boolean hasOptimizer;
            ArrayList<TemporaryTableColumn> columns = new ArrayList<TemporaryTableColumn>();
            PersistentClass entityBinding = runtimeModelCreationContext.getBootModel().getEntityBinding(entityDescriptor.getEntityName());
            Generator identifierGenerator = entityDescriptor.getEntityPersister().getGenerator();
            boolean identityColumn = identifierGenerator.generatedOnExecution();
            if (identityColumn) {
                hasOptimizer = false;
                jdbcMappings = entityDescriptor.getIdentifierMapping().getJdbcMappings().iterator();
                for (Column column : entityBinding.getKey().getColumns()) {
                    jdbcMapping = jdbcMappings.next();
                    columns.add(new TemporaryTableColumn((TemporaryTable)temporaryTable, ENTITY_TABLE_IDENTITY_COLUMN, jdbcMapping, column.getSqlType(runtimeModelCreationContext.getMetadata()) + " " + dialect.getIdentityColumnSupport().getIdentityColumnString(column.getSqlTypeCode(runtimeModelCreationContext.getMetadata())), column.getColumnSize(dialect, runtimeModelCreationContext.getMetadata()), true, true));
                }
            } else {
                Optimizer optimizer;
                hasOptimizer = identifierGenerator instanceof OptimizableGenerator ? (optimizer = ((OptimizableGenerator)identifierGenerator).getOptimizer()) != null && optimizer.getIncrementSize() > 1 : false;
            }
            jdbcMappings = entityDescriptor.getIdentifierMapping().getJdbcMappings().iterator();
            for (Column column : entityBinding.getKey().getColumns()) {
                jdbcMapping = jdbcMappings.next();
                columns.add(new TemporaryTableColumn((TemporaryTable)temporaryTable, column.getText(dialect), jdbcMapping, column.getSqlType(runtimeModelCreationContext.getMetadata()), column.getColumnSize(dialect, runtimeModelCreationContext.getMetadata()), column.isNullable() || identityColumn || hasOptimizer, !identityColumn && !hasOptimizer));
            }
            EntityDiscriminatorMapping discriminatorMapping = entityDescriptor.getDiscriminatorMapping();
            if (entityBinding.getDiscriminator() != null && !discriminatorMapping.isFormula()) {
                Column discriminator = entityBinding.getDiscriminator().getColumns().get(0);
                columns.add(new TemporaryTableColumn((TemporaryTable)temporaryTable, discriminator.getText(dialect), discriminatorMapping.getJdbcMapping(), discriminator.getSqlType(runtimeModelCreationContext.getMetadata()), discriminator.getColumnSize(dialect, runtimeModelCreationContext.getMetadata()), discriminator.isNullable()));
            }
            entityDescriptor.visitSubTypeAttributeMappings(attribute -> {
                if (!(attribute instanceof PluralAttributeMapping)) {
                    SimpleValue value = (SimpleValue)entityBinding.getSubclassProperty(attribute.getAttributeName()).getValue();
                    Iterator<Selectable> columnIterator = value.getConstraintColumnIterator();
                    attribute.forEachSelectable((columnIndex, selection) -> {
                        Selectable selectable = (Selectable)columnIterator.next();
                        if (selectable instanceof Column) {
                            Column column = (Column)selectable;
                            columns.add(new TemporaryTableColumn((TemporaryTable)temporaryTable, selectable.getText(dialect), selection.getJdbcMapping(), column.getSqlType(runtimeModelCreationContext.getMetadata()), column.getColumnSize(dialect, runtimeModelCreationContext.getMetadata()), true));
                        }
                    });
                }
            });
            if (hasOptimizer) {
                Object rowNumberType;
                TypeConfiguration typeConfiguration = runtimeModelCreationContext.getTypeConfiguration();
                BasicType<Integer> integerBasicType = typeConfiguration.getBasicTypeForJavaType(Integer.class);
                if (dialect.supportsWindowFunctions()) {
                    rowNumberType = typeConfiguration.getDdlTypeRegistry().getTypeName(integerBasicType.getJdbcType().getDdlTypeCode(), dialect.getSizeStrategy().resolveSize(integerBasicType.getJdbcType(), integerBasicType.getJavaTypeDescriptor(), null, null, null));
                } else if (dialect.getIdentityColumnSupport().supportsIdentityColumns()) {
                    rowNumberType = typeConfiguration.getDdlTypeRegistry().getTypeName(integerBasicType.getJdbcType().getDdlTypeCode(), dialect.getSizeStrategy().resolveSize(integerBasicType.getJdbcType(), integerBasicType.getJavaTypeDescriptor(), null, null, null)) + " " + dialect.getIdentityColumnSupport().getIdentityColumnString(integerBasicType.getJdbcType().getDdlTypeCode());
                } else {
                    LOG.multiTableInsertNotAvailable(entityBinding.getEntityName());
                    rowNumberType = typeConfiguration.getDdlTypeRegistry().getTypeName(integerBasicType.getJdbcType().getDdlTypeCode(), dialect.getSizeStrategy().resolveSize(integerBasicType.getJdbcType(), integerBasicType.getJavaTypeDescriptor(), null, null, null));
                }
                columns.add(new TemporaryTableColumn((TemporaryTable)temporaryTable, "rn_", integerBasicType, (String)rowNumberType, Size.nil(), false, true));
            }
            return columns;
        });
    }

    public EntityMappingType getEntityDescriptor() {
        return this.entityDescriptor;
    }

    public String getQualifiedTableName() {
        return this.qualifiedTableName;
    }

    public List<TemporaryTableColumn> getColumns() {
        return this.columns;
    }

    public List<TemporaryTableColumn> getColumnsForExport() {
        return this.columnsForExport;
    }

    public TemporaryTableSessionUidColumn getSessionUidColumn() {
        return this.sessionUidColumn;
    }

    public String getTableExpression() {
        return this.qualifiedTableName;
    }

    @Override
    public String getContributor() {
        return this.entityDescriptor.getContributor();
    }

    @Override
    public String getExportIdentifier() {
        return this.getQualifiedTableName();
    }

    public Dialect getDialect() {
        return this.dialect;
    }
}

