/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.insert;

import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.generator.OnExecutionGenerator;
import org.hibernate.id.insert.IdentifierGeneratingInsert;
import org.hibernate.sql.Insert;

public class InsertSelectIdentityInsert
extends IdentifierGeneratingInsert {
    protected String identityColumnName;

    @Override
    public Insert addIdentityColumn(String columnName) {
        this.identityColumnName = columnName;
        return super.addIdentityColumn(columnName);
    }

    @Override
    public Insert addGeneratedColumns(String[] columnNames, OnExecutionGenerator generator) {
        if (columnNames.length != 1) {
            throw new MappingException("wrong number of generated columns");
        }
        this.identityColumnName = columnNames[0];
        return super.addGeneratedColumns(columnNames, generator);
    }

    public InsertSelectIdentityInsert(Dialect dialect) {
        super(dialect);
    }

    @Override
    public String toStatementString() {
        return this.getDialect().getIdentityColumnSupport().appendIdentitySelectToInsert(this.identityColumnName, super.toStatementString());
    }
}

