/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.SingleEntityLoadPlan;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.internal.SimpleQueryOptions;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryOptionsAdapter;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.BaseExecutionContext;
import org.hibernate.sql.exec.internal.CallbackImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.results.internal.RowTransformerStandardImpl;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.hibernate.sql.results.spi.RowTransformer;

public class SingleIdLoadPlan<T>
implements SingleEntityLoadPlan {
    private final org.hibernate.persister.entity.Loadable persister;
    private final ModelPart restrictivePart;
    private final LockOptions lockOptions;
    private final JdbcOperationQuerySelect jdbcSelect;
    private final List<JdbcParameter> jdbcParameters;

    public SingleIdLoadPlan(org.hibernate.persister.entity.Loadable persister, ModelPart restrictivePart, SelectStatement sqlAst, List<JdbcParameter> jdbcParameters, final LockOptions lockOptions, SessionFactoryImplementor sessionFactory) {
        this.persister = persister;
        this.restrictivePart = restrictivePart;
        this.lockOptions = lockOptions.makeCopy();
        this.jdbcParameters = jdbcParameters;
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        this.jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory, sqlAst).translate(null, new QueryOptionsAdapter(){

            @Override
            public LockOptions getLockOptions() {
                return lockOptions;
            }
        });
    }

    protected LockOptions getLockOptions() {
        return this.lockOptions;
    }

    protected List<JdbcParameter> getJdbcParameters() {
        return this.jdbcParameters;
    }

    @Override
    public Loadable getLoadable() {
        return this.persister;
    }

    @Override
    public ModelPart getRestrictivePart() {
        return this.restrictivePart;
    }

    @Override
    public JdbcOperationQuerySelect getJdbcSelect() {
        return this.jdbcSelect;
    }

    protected RowTransformer<T> getRowTransformer() {
        return RowTransformerStandardImpl.instance();
    }

    public T load(Object restrictedValue, SharedSessionContractImplementor session) {
        return this.load(restrictedValue, null, null, false, session);
    }

    public T load(Object restrictedValue, Boolean readOnly, SharedSessionContractImplementor session) {
        return this.load(restrictedValue, null, readOnly, false, session);
    }

    public T load(Object restrictedValue, Boolean readOnly, Boolean singleResultExpected, SharedSessionContractImplementor session) {
        return this.load(restrictedValue, null, readOnly, singleResultExpected, session);
    }

    public T load(Object restrictedValue, Object entityInstance, Boolean readOnly, Boolean singleResultExpected, SharedSessionContractImplementor session) {
        int offset;
        int jdbcTypeCount = this.restrictivePart.getJdbcTypeCount();
        assert (this.jdbcParameters.size() % jdbcTypeCount == 0);
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(jdbcTypeCount);
        this.jdbcSelect.bindFilterJdbcParameters(jdbcParameterBindings);
        for (offset = 0; offset < this.jdbcParameters.size(); offset += jdbcParameterBindings.registerParametersForEachJdbcValue(restrictedValue, offset, this.restrictivePart, this.jdbcParameters, session)) {
        }
        assert (offset == this.jdbcParameters.size());
        SimpleQueryOptions queryOptions = new SimpleQueryOptions(this.lockOptions, readOnly);
        CallbackImpl callback = new CallbackImpl();
        List<T> list = session.getJdbcServices().getJdbcSelectExecutor().list(this.jdbcSelect, jdbcParameterBindings, new SingleIdExecutionContext(session, entityInstance, restrictedValue, queryOptions, callback), this.getRowTransformer(), singleResultExpected != false ? ListResultsConsumer.UniqueSemantic.ASSERT : ListResultsConsumer.UniqueSemantic.FILTER);
        if (list.isEmpty()) {
            return null;
        }
        T entity = list.get(0);
        if (this.persister != null) {
            callback.invokeAfterLoadActions(session, entity, this.persister);
        }
        return entity;
    }

    private static class SingleIdExecutionContext
    extends BaseExecutionContext {
        private final Object entityInstance;
        private final Object restrictedValue;
        private final QueryOptions queryOptions;
        private final Callback callback;

        public SingleIdExecutionContext(SharedSessionContractImplementor session, Object entityInstance, Object restrictedValue, QueryOptions queryOptions, Callback callback) {
            super(session);
            this.entityInstance = entityInstance;
            this.restrictedValue = restrictedValue;
            this.queryOptions = queryOptions;
            this.callback = callback;
        }

        @Override
        public Object getEntityInstance() {
            return this.entityInstance;
        }

        @Override
        public Object getEntityId() {
            return this.restrictedValue;
        }

        @Override
        public QueryOptions getQueryOptions() {
            return this.queryOptions;
        }

        @Override
        public Callback getCallback() {
            return this.callback;
        }
    }
}

