/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.mapping.AssociationKey;
import org.hibernate.metamodel.mapping.BasicEntityIdentifierMapping;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.CompositeIdentifierMapping;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityAssociationMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectableMappings;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.VirtualModelPart;
import org.hibernate.metamodel.mapping.internal.AbstractEntityCollectionPart;
import org.hibernate.metamodel.mapping.internal.BasicAttributeMapping;
import org.hibernate.metamodel.mapping.internal.EmbeddedForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.internal.EntityCollectionPart;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.SelectableMappingImpl;
import org.hibernate.metamodel.mapping.internal.SelectableMappingsImpl;
import org.hibernate.metamodel.mapping.internal.SimpleForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.collection.BasicCollectionPersister;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.mutation.CollectionMutationTarget;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.from.LazyTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.type.EntityType;

public class ManyToManyCollectionPart
extends AbstractEntityCollectionPart
implements EntityAssociationMapping {
    private ForeignKeyDescriptor foreignKey;
    private ValuedModelPart fkTargetModelPart;

    public ManyToManyCollectionPart(CollectionPart.Nature nature, Collection collectionBootDescriptor, CollectionPersister collectionDescriptor, EntityMappingType associatedEntityDescriptor, MappingModelCreationProcess creationProcess) {
        this(nature, collectionBootDescriptor, collectionDescriptor, associatedEntityDescriptor, NotFoundAction.EXCEPTION, creationProcess);
    }

    public ManyToManyCollectionPart(CollectionPart.Nature nature, Collection collectionBootDescriptor, CollectionPersister collectionDescriptor, EntityMappingType associatedEntityDescriptor, NotFoundAction notFoundAction, MappingModelCreationProcess creationProcess) {
        super(nature, collectionBootDescriptor, collectionDescriptor, associatedEntityDescriptor, notFoundAction, creationProcess);
    }

    @Override
    public EntityCollectionPart.Cardinality getCardinality() {
        return EntityCollectionPart.Cardinality.MANY_TO_MANY;
    }

    @Override
    public ModelPart getInclusionCheckPart() {
        return this.getForeignKeyDescriptor().getKeyPart();
    }

    @Override
    protected AssociationKey resolveFetchAssociationKey() {
        assert (this.getForeignKeyDescriptor() != null);
        return this.getForeignKeyDescriptor().getAssociationKey();
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType targetType) {
        if (this.getTargetKeyPropertyNames().contains(name)) {
            if (this.fkTargetModelPart instanceof ToOneAttributeMapping) {
                return ((ToOneAttributeMapping)this.fkTargetModelPart).findSubPart(name, targetType);
            }
            ValuedModelPart keyPart = this.foreignKey.getKeyPart();
            if (keyPart instanceof EmbeddableValuedModelPart && keyPart instanceof VirtualModelPart) {
                return ((ModelPartContainer)((Object)keyPart)).findSubPart(name, targetType);
            }
            return keyPart;
        }
        return super.findSubPart(name, targetType);
    }

    @Override
    public <X, Y> int breakDownJdbcValues(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        return this.fkTargetModelPart.breakDownJdbcValues(domainValue, offset, x, y, valueConsumer, session);
    }

    @Override
    public SelectableMapping getSelectable(int columnIndex) {
        return this.foreignKey.getKeyPart().getSelectable(columnIndex);
    }

    @Override
    public String getContainingTableExpression() {
        return this.fkTargetModelPart.getContainingTableExpression();
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        this.foreignKey.getKeyPart().forEachSelectable(offset, consumer);
        return this.getJdbcTypeCount();
    }

    @Override
    public <X, Y> int decompose(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        return this.foreignKey.getKeyPart().decompose(this.foreignKey.getAssociationKeyFromSide(domainValue, this.foreignKey.getTargetSide(), session), offset, x, y, valueConsumer, session);
    }

    @Override
    public ForeignKeyDescriptor getForeignKeyDescriptor() {
        return this.foreignKey;
    }

    @Override
    public ForeignKeyDescriptor.Nature getSideNature() {
        return ForeignKeyDescriptor.Nature.KEY;
    }

    @Override
    public SqlAstJoinType getDefaultSqlAstJoinType(TableGroup parentTableGroup) {
        return SqlAstJoinType.INNER;
    }

    @Override
    public boolean isSimpleJoinPredicate(Predicate predicate) {
        return this.getForeignKeyDescriptor().isSimpleJoinPredicate(predicate);
    }

    @Override
    public boolean isReferenceToPrimaryKey() {
        return this.getForeignKeyDescriptor().getTargetPart().isEntityIdentifierMapping();
    }

    @Override
    public boolean isFkOptimizationAllowed() {
        return true;
    }

    @Override
    public ModelPart getKeyTargetMatchPart() {
        return this.fkTargetModelPart;
    }

    @Override
    public TableGroupJoin createTableGroupJoin(NavigablePath navigablePath, TableGroup collectionTableGroup, String explicitSourceAlias, SqlAstJoinType requestedJoinType, boolean fetched, boolean addsPredicate, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, FromClauseAccess fromClauseAccess, SqlAstCreationContext creationContext) {
        SqlAstJoinType joinType = Objects.requireNonNullElse(requestedJoinType, SqlAstJoinType.INNER);
        TableGroup lazyTableGroup = this.createRootTableGroupJoin(navigablePath, collectionTableGroup, explicitSourceAlias, requestedJoinType, fetched, (Consumer)null, aliasBaseGenerator, sqlExpressionResolver, fromClauseAccess, creationContext);
        TableGroupJoin join = new TableGroupJoin(navigablePath, joinType, lazyTableGroup, null);
        ((LazyTableGroup)lazyTableGroup).setTableGroupInitializerCallback(partTableGroup -> join.applyPredicate(this.foreignKey.generateJoinPredicate(partTableGroup.getPrimaryTableReference(), collectionTableGroup.resolveTableReference(this.foreignKey.getKeyTable()), sqlExpressionResolver, creationContext)));
        return join;
    }

    @Override
    public LazyTableGroup createRootTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAstJoinType requestedJoinType, boolean fetched, Consumer<Predicate> predicateConsumer, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, FromClauseAccess fromClauseAccess, SqlAstCreationContext creationContext) {
        SqlAstJoinType joinType = Objects.requireNonNullElse(requestedJoinType, SqlAstJoinType.INNER);
        SqlAliasBase sqlAliasBase = aliasBaseGenerator.createSqlAliasBase(this.getSqlAliasStem());
        boolean canUseInnerJoin = joinType == SqlAstJoinType.INNER || lhs.canUseInnerJoins();
        LazyTableGroup lazyTableGroup = new LazyTableGroup(canUseInnerJoin, navigablePath, fetched, () -> this.createTableGroupInternal(canUseInnerJoin, navigablePath, fetched, null, sqlAliasBase, sqlExpressionResolver, creationContext), (np, tableExpression) -> {
            if (!this.foreignKey.getKeyTable().equals(tableExpression)) {
                return false;
            }
            if (navigablePath.equals(np.getParent())) {
                return this.getTargetKeyPropertyNames().contains(np.getLocalName());
            }
            String relativePath = np.relativize(navigablePath);
            if (relativePath == null) {
                return false;
            }
            return relativePath.isEmpty() || this.getTargetKeyPropertyNames().contains(relativePath);
        }, this, explicitSourceAlias, sqlAliasBase, creationContext.getSessionFactory(), lhs);
        if (predicateConsumer != null) {
            TableReference keySideTableReference = lhs.resolveTableReference(navigablePath, this.foreignKey.getKeyTable());
            lazyTableGroup.setTableGroupInitializerCallback(tableGroup -> predicateConsumer.accept(this.foreignKey.generateJoinPredicate(tableGroup.getPrimaryTableReference(), keySideTableReference, sqlExpressionResolver, creationContext)));
        }
        return lazyTableGroup;
    }

    @Override
    public boolean hasPartitionedSelectionMapping() {
        return this.foreignKey.hasPartitionedSelectionMapping();
    }

    @Override
    public boolean finishInitialization(CollectionPersister collectionDescriptor, Collection bootCollectionDescriptor, String fkTargetModelPartName, MappingModelCreationProcess creationProcess) {
        if (fkTargetModelPartName != null) {
            this.fkTargetModelPart = ManyToManyCollectionPart.resolveNamedTargetPart(fkTargetModelPartName, this.getAssociatedEntityMappingType(), collectionDescriptor);
        } else if (this.getNature() == CollectionPart.Nature.INDEX) {
            assert (bootCollectionDescriptor.isIndexed());
            PluralAttributeMapping pluralAttribute = collectionDescriptor.getAttributeMapping();
            String mapKeyPropertyName = ((Map)bootCollectionDescriptor).getMapKeyPropertyName();
            if (StringHelper.isNotEmpty(mapKeyPropertyName)) {
                EntityCollectionPart elementDescriptor = (EntityCollectionPart)pluralAttribute.getElementDescriptor();
                EntityMappingType entityMappingType = elementDescriptor.getEntityMappingType();
                this.fkTargetModelPart = ManyToManyCollectionPart.resolveNamedTargetPart(mapKeyPropertyName, entityMappingType, collectionDescriptor);
            } else {
                this.fkTargetModelPart = this.getAssociatedEntityMappingType().getIdentifierMapping();
            }
        } else {
            if (StringHelper.isNotEmpty(bootCollectionDescriptor.getMappedByProperty())) {
                ValuedModelPart mappedByPart = ManyToManyCollectionPart.resolveNamedTargetPart(bootCollectionDescriptor.getMappedByProperty(), this.getAssociatedEntityMappingType(), collectionDescriptor);
                if (mappedByPart instanceof ToOneAttributeMapping) {
                    ManyToOne elementDescriptor = (ManyToOne)bootCollectionDescriptor.getElement();
                    assert (elementDescriptor.isReferenceToPrimaryKey());
                    String collectionTableName = ((BasicCollectionPersister)collectionDescriptor).getTableName();
                    if (this.getAssociatedEntityMappingType().getIdentifierMapping() == null) {
                        return false;
                    }
                    this.foreignKey = this.createJoinTablePartForeignKey(collectionTableName, elementDescriptor, creationProcess);
                    creationProcess.registerForeignKey(this, this.foreignKey);
                } else {
                    PluralAttributeMapping manyToManyInverse = (PluralAttributeMapping)mappedByPart;
                    if (manyToManyInverse.getKeyDescriptor() == null) {
                        return false;
                    }
                    this.foreignKey = manyToManyInverse.getKeyDescriptor();
                }
                this.fkTargetModelPart = this.foreignKey.getTargetPart();
                return true;
            }
            this.fkTargetModelPart = this.getAssociatedEntityMappingType().getIdentifierMapping();
        }
        if (this.getNature() == CollectionPart.Nature.ELEMENT) {
            this.foreignKey = this.createForeignKeyDescriptor(bootCollectionDescriptor.getElement(), (EntityType)collectionDescriptor.getElementType(), this.fkTargetModelPart, creationProcess, collectionDescriptor.getFactory().getJdbcServices().getDialect());
        } else {
            assert (bootCollectionDescriptor.isIndexed());
            this.foreignKey = this.createForeignKeyDescriptor(((IndexedCollection)bootCollectionDescriptor).getIndex(), (EntityType)collectionDescriptor.getIndexType(), this.fkTargetModelPart, creationProcess, collectionDescriptor.getFactory().getJdbcServices().getDialect());
        }
        return true;
    }

    private ForeignKeyDescriptor createJoinTablePartForeignKey(String collectionTableName, ManyToOne elementBootDescriptor, MappingModelCreationProcess creationProcess) {
        EntityMappingType associatedEntityMapping = this.getAssociatedEntityMappingType();
        EntityIdentifierMapping associatedIdMapping = associatedEntityMapping.getIdentifierMapping();
        assert (associatedIdMapping != null);
        if (associatedIdMapping.getNature() == EntityIdentifierMapping.Nature.SIMPLE) {
            BasicEntityIdentifierMapping targetModelPart = (BasicEntityIdentifierMapping)associatedIdMapping;
            assert (elementBootDescriptor.getColumns().size() == 1);
            Column keyColumn = elementBootDescriptor.getColumns().get(0);
            SelectableMapping keySelectableMapping = SelectableMappingImpl.from(collectionTableName, keyColumn, targetModelPart.getJdbcMapping(), creationProcess.getCreationContext().getTypeConfiguration(), true, false, false, creationProcess.getCreationContext().getDialect(), creationProcess.getSqmFunctionRegistry());
            BasicAttributeMapping keyModelPart = BasicAttributeMapping.withSelectableMapping(associatedEntityMapping, targetModelPart, targetModelPart.getPropertyAccess(), true, false, keySelectableMapping);
            return new SimpleForeignKeyDescriptor(keyModelPart, targetModelPart, true, !elementBootDescriptor.isNullable(), false);
        }
        CompositeIdentifierMapping targetModelPart = (CompositeIdentifierMapping)associatedIdMapping;
        SelectableMappings keySelectableMappings = SelectableMappingsImpl.from(collectionTableName, elementBootDescriptor, MappingModelCreationHelper.getPropertyOrder(elementBootDescriptor, creationProcess), creationProcess.getCreationContext().getMetadata(), creationProcess.getCreationContext().getTypeConfiguration(), elementBootDescriptor.getColumnInsertability(), elementBootDescriptor.getColumnUpdateability(), creationProcess.getCreationContext().getDialect(), creationProcess.getSqmFunctionRegistry());
        return new EmbeddedForeignKeyDescriptor(collectionTableName, keySelectableMappings, MappingModelCreationHelper.createInverseModelPart(targetModelPart, associatedEntityMapping, this, keySelectableMappings, creationProcess), targetModelPart.getContainingTableExpression(), targetModelPart.getPartMappingType(), targetModelPart, !elementBootDescriptor.isNullable(), creationProcess);
    }

    private static ValuedModelPart resolveNamedTargetPart(String targetPartName, EntityMappingType entityMappingType, CollectionPersister collectionDescriptor) {
        ModelPart namedPart = entityMappingType.findByPath(targetPartName);
        if (namedPart == null) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Could not resolve path `%s` relative to `%s` for many-to-many foreign-key target mapping - `%s`", targetPartName, entityMappingType.getEntityName(), collectionDescriptor.getRole()));
        }
        return (ValuedModelPart)namedPart;
    }

    private ForeignKeyDescriptor createForeignKeyDescriptor(Value fkBootDescriptorSource, EntityType entityType, ModelPart fkTargetModelPart, MappingModelCreationProcess creationProcess, Dialect dialect) {
        assert (fkTargetModelPart != null);
        if (fkTargetModelPart instanceof ToOneAttributeMapping) {
            ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)fkTargetModelPart;
            if (toOneAttributeMapping.getForeignKeyDescriptor() == null) {
                throw new IllegalStateException("Not yet ready: " + toOneAttributeMapping);
            }
            return toOneAttributeMapping.getForeignKeyDescriptor();
        }
        if (fkTargetModelPart instanceof ManyToManyCollectionPart) {
            ManyToManyCollectionPart targetModelPart = (ManyToManyCollectionPart)fkTargetModelPart;
            if (targetModelPart.getForeignKeyDescriptor() == null) {
                throw new IllegalStateException("Not yet ready: " + targetModelPart);
            }
            return targetModelPart.getForeignKeyDescriptor();
        }
        String collectionTableName = ((CollectionMutationTarget)((Object)this.getCollectionDescriptor())).getCollectionTableMapping().getTableName();
        if (fkTargetModelPart instanceof BasicValuedModelPart) {
            return this.createSimpleForeignKeyDescriptor(fkBootDescriptorSource, entityType, creationProcess, dialect, collectionTableName, (BasicValuedModelPart)fkTargetModelPart);
        }
        if (fkTargetModelPart instanceof EmbeddableValuedModelPart) {
            return MappingModelCreationHelper.buildEmbeddableForeignKeyDescriptor((EmbeddableValuedModelPart)fkTargetModelPart, fkBootDescriptorSource, this.findContainingEntityMapping(), this.getCollectionDescriptor().getAttributeMapping(), false, fkBootDescriptorSource.getColumnInsertability(), fkBootDescriptorSource.getColumnUpdateability(), dialect, creationProcess);
        }
        throw new UnsupportedOperationException("Could not create many-to-many foreign-key : " + this.getNavigableRole().getFullPath());
    }

    private SimpleForeignKeyDescriptor createSimpleForeignKeyDescriptor(Value fkBootDescriptorSource, EntityType entityType, MappingModelCreationProcess creationProcess, Dialect dialect, String fkKeyTableName, BasicValuedModelPart basicFkTargetPart) {
        boolean columnUpdateable;
        boolean columnInsertable;
        if (this.getNature() == CollectionPart.Nature.ELEMENT) {
            columnInsertable = true;
            columnUpdateable = true;
        } else {
            columnInsertable = fkBootDescriptorSource.isColumnInsertable(0);
            columnUpdateable = fkBootDescriptorSource.isColumnUpdateable(0);
        }
        SelectableMapping keySelectableMapping = SelectableMappingImpl.from(fkKeyTableName, fkBootDescriptorSource.getSelectables().get(0), basicFkTargetPart.getJdbcMapping(), creationProcess.getCreationContext().getTypeConfiguration(), columnInsertable, columnUpdateable, ((SimpleValue)fkBootDescriptorSource).isPartitionKey(), dialect, creationProcess.getSqmFunctionRegistry());
        boolean hasConstraint = fkBootDescriptorSource instanceof SimpleValue ? ((SimpleValue)fkBootDescriptorSource).isConstrained() : !fkBootDescriptorSource.isNullable();
        return new SimpleForeignKeyDescriptor(this.getAssociatedEntityMappingType(), keySelectableMapping, basicFkTargetPart, entityType.isReferenceToPrimaryKey(), hasConstraint);
    }
}

