/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.Objects;
import java.util.function.Consumer;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Map;
import org.hibernate.metamodel.mapping.AssociationKey;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.internal.AbstractEntityCollectionPart;
import org.hibernate.metamodel.mapping.internal.EntityCollectionPart;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.from.OneToManyTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupJoinProducer;
import org.hibernate.sql.ast.tree.predicate.Predicate;

public class OneToManyCollectionPart
extends AbstractEntityCollectionPart
implements TableGroupJoinProducer {
    private final String mapKeyPropertyName;
    private AssociationKey fetchAssociationKey;

    public OneToManyCollectionPart(CollectionPart.Nature nature, Collection bootCollectionDescriptor, CollectionPersister collectionDescriptor, EntityMappingType elementTypeDescriptor, MappingModelCreationProcess creationProcess) {
        this(nature, bootCollectionDescriptor, collectionDescriptor, elementTypeDescriptor, NotFoundAction.EXCEPTION, creationProcess);
    }

    public OneToManyCollectionPart(CollectionPart.Nature nature, Collection bootCollectionDescriptor, CollectionPersister collectionDescriptor, EntityMappingType elementTypeDescriptor, NotFoundAction notFoundAction, MappingModelCreationProcess creationProcess) {
        super(nature, bootCollectionDescriptor, collectionDescriptor, elementTypeDescriptor, notFoundAction, creationProcess);
        this.mapKeyPropertyName = nature == CollectionPart.Nature.INDEX && bootCollectionDescriptor instanceof Map ? ((Map)bootCollectionDescriptor).getMapKeyPropertyName() : null;
    }

    @Override
    public EntityCollectionPart.Cardinality getCardinality() {
        return EntityCollectionPart.Cardinality.ONE_TO_MANY;
    }

    @Override
    public <X, Y> int breakDownJdbcValues(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        return this.getAssociatedEntityMappingType().getIdentifierMapping().breakDownJdbcValues(this.disassemble(domainValue, session), offset, x, y, valueConsumer, session);
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        return this.getAssociatedEntityMappingType().getIdentifierMapping().getIdentifier(value);
    }

    @Override
    public String getContainingTableExpression() {
        return this.getCollectionDescriptor().getAttributeMapping().getKeyDescriptor().getContainingTableExpression();
    }

    @Override
    public SelectableMapping getSelectable(int columnIndex) {
        return this.getCollectionDescriptor().getAttributeMapping().getKeyDescriptor().getSelectable(columnIndex);
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        return this.getCollectionDescriptor().getAttributeMapping().getKeyDescriptor().getKeyPart().forEachSelectable(offset, consumer);
    }

    @Override
    protected AssociationKey resolveFetchAssociationKey() {
        return this.fetchAssociationKey;
    }

    @Override
    public boolean hasPartitionedSelectionMapping() {
        return false;
    }

    @Override
    public SqlAstJoinType getDefaultSqlAstJoinType(TableGroup parentTableGroup) {
        return SqlAstJoinType.INNER;
    }

    @Override
    public boolean isSimpleJoinPredicate(Predicate predicate) {
        return this.getCollectionDescriptor().getAttributeMapping().getKeyDescriptor().isSimpleJoinPredicate(predicate);
    }

    @Override
    public TableGroupJoin createTableGroupJoin(NavigablePath navigablePath, TableGroup collectionTableGroup, String explicitSourceAlias, SqlAstJoinType requestedJoinType, boolean fetched, boolean addsPredicate, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, FromClauseAccess fromClauseAccess, SqlAstCreationContext creationContext) {
        EntityCollectionPart elementPart;
        EntityMappingType elementEntity;
        AttributeMapping mapKeyAttribute;
        SqlAstJoinType joinType = Objects.requireNonNullElse(requestedJoinType, SqlAstJoinType.INNER);
        TableGroup elementTableGroup = ((OneToManyTableGroup)collectionTableGroup).getElementTableGroup();
        if (this.mapKeyPropertyName != null && (mapKeyAttribute = (elementEntity = (elementPart = (EntityCollectionPart)this.getCollectionDescriptor().getAttributeMapping().getElementDescriptor()).getAssociatedEntityMappingType()).findAttributeMapping(this.mapKeyPropertyName)) instanceof ToOneAttributeMapping) {
            ToOneAttributeMapping toOne = (ToOneAttributeMapping)mapKeyAttribute;
            NavigablePath mapKeyPropertyPath = navigablePath.append(this.mapKeyPropertyName);
            TableGroupJoin tableGroupJoin = toOne.createTableGroupJoin(mapKeyPropertyPath, elementTableGroup, null, null, fetched, addsPredicate, aliasBaseGenerator, sqlExpressionResolver, fromClauseAccess, creationContext);
            fromClauseAccess.registerTableGroup(mapKeyPropertyPath, tableGroupJoin.getJoinedGroup());
            return tableGroupJoin;
        }
        return new TableGroupJoin(navigablePath, joinType, elementTableGroup, null);
    }

    @Override
    public TableGroup createRootTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAstJoinType sqlAstJoinType, boolean fetched, Consumer<Predicate> predicateConsumer, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, FromClauseAccess fromClauseAccess, SqlAstCreationContext creationContext) {
        return this.createTableGroupInternal(true, navigablePath, fetched, explicitSourceAlias, aliasBaseGenerator.createSqlAliasBase(this.getSqlAliasStem()), sqlExpressionResolver, creationContext);
    }

    public TableGroup createAssociatedTableGroup(boolean canUseInnerJoins, NavigablePath append, boolean fetched, String sourceAlias, SqlAliasBase sqlAliasBase, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        return this.createTableGroupInternal(canUseInnerJoins, append, fetched, sourceAlias, sqlAliasBase, sqlExpressionResolver, creationContext);
    }

    @Override
    public boolean finishInitialization(CollectionPersister collectionDescriptor, Collection bootValueMapping, String fkTargetModelPartName, MappingModelCreationProcess creationProcess) {
        PluralAttributeMapping pluralAttribute = this.getCollectionDescriptor().getAttributeMapping();
        if (pluralAttribute == null) {
            return false;
        }
        ForeignKeyDescriptor foreignKey = pluralAttribute.getKeyDescriptor();
        if (foreignKey == null) {
            return false;
        }
        this.fetchAssociationKey = foreignKey.getAssociationKey();
        return true;
    }
}

