/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.PluralAttribute;
import java.util.Map;
import org.hibernate.metamodel.internal.MetadataContext;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.model.domain.MapPersistentAttribute;
import org.hibernate.metamodel.model.domain.SimpleDomainType;
import org.hibernate.metamodel.model.domain.internal.AbstractPluralAttribute;
import org.hibernate.metamodel.model.domain.internal.PluralAttributeBuilder;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.internal.SqmMappingModelHelper;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.domain.SqmMapJoin;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;

class MapAttributeImpl<X, K, V>
extends AbstractPluralAttribute<X, Map<K, V>, V>
implements MapPersistentAttribute<X, K, V> {
    private final SqmPathSource<K> keyPathSource;

    MapAttributeImpl(PluralAttributeBuilder<X, Map<K, V>, V, K> xceBuilder, MetadataContext metadataContext) {
        super(xceBuilder, metadataContext);
        this.keyPathSource = SqmMappingModelHelper.resolveSqmKeyPathSource(xceBuilder.getListIndexOrMapKeyType(), Bindable.BindableType.PLURAL_ATTRIBUTE);
    }

    @Override
    public PluralAttribute.CollectionType getCollectionType() {
        return PluralAttribute.CollectionType.MAP;
    }

    public Class<K> getKeyJavaType() {
        return this.keyPathSource.getBindableJavaType();
    }

    @Override
    public SqmPathSource<K> getKeyPathSource() {
        return this.keyPathSource;
    }

    @Override
    public SqmPathSource<K> getIndexPathSource() {
        return this.getKeyPathSource();
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        CollectionPart.Nature nature = CollectionPart.Nature.fromNameExact(name);
        if (nature != null) {
            switch (nature) {
                case INDEX: {
                    return this.keyPathSource;
                }
                case ELEMENT: {
                    return this.getElementPathSource();
                }
            }
        }
        return this.getElementPathSource().findSubPathSource(name);
    }

    @Override
    public SqmPathSource<?> getIntermediatePathSource(SqmPathSource<?> pathSource) {
        return pathSource == this.getElementPathSource() || pathSource == this.keyPathSource ? null : this.getElementPathSource();
    }

    @Override
    public SimpleDomainType<K> getKeyType() {
        return (SimpleDomainType)this.keyPathSource.getSqmPathType();
    }

    @Override
    public SimpleDomainType<K> getKeyGraphType() {
        return this.getKeyType();
    }

    public SqmAttributeJoin createSqmJoin(SqmFrom lhs, SqmJoinType joinType, String alias, boolean fetched, SqmCreationState creationState) {
        return new SqmMapJoin(lhs, this, alias, joinType, fetched, creationState.getCreationContext().getNodeBuilder());
    }
}

