/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity.mutation;

import java.util.ArrayList;
import org.hibernate.Internal;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.OnExecutionGenerator;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.AttributeMappingsList;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.ValuesAnalysis;
import org.hibernate.sql.model.ast.MutationGroup;
import org.hibernate.sql.model.ast.builder.ColumnValuesTableMutationBuilder;
import org.hibernate.sql.model.ast.builder.MutationGroupBuilder;
import org.hibernate.sql.model.internal.MutationOperationGroupNone;
import org.hibernate.sql.model.internal.MutationOperationGroupSingle;
import org.hibernate.sql.model.internal.MutationOperationGroupStandard;

@Internal
public abstract class AbstractMutationCoordinator {
    private final AbstractEntityPersister entityPersister;
    private final SessionFactoryImplementor factory;

    public AbstractMutationCoordinator(AbstractEntityPersister entityPersister, SessionFactoryImplementor factory) {
        this.entityPersister = entityPersister;
        this.factory = factory;
    }

    protected AbstractEntityPersister entityPersister() {
        return this.entityPersister;
    }

    protected SessionFactoryImplementor factory() {
        return this.factory;
    }

    protected Dialect dialect() {
        return this.factory().getJdbcServices().getDialect();
    }

    protected MutationOperationGroup createOperationGroup(ValuesAnalysis valuesAnalysis, MutationGroup mutationGroup) {
        int numberOfTableMutations = mutationGroup.getNumberOfTableMutations();
        switch (numberOfTableMutations) {
            case 0: {
                return new MutationOperationGroupNone(mutationGroup);
            }
            case 1: {
                Object operation = mutationGroup.getSingleTableMutation().createMutationOperation(valuesAnalysis, this.factory());
                return operation == null ? new MutationOperationGroupNone(mutationGroup) : new MutationOperationGroupSingle(mutationGroup, (MutationOperation)operation);
            }
        }
        ArrayList<MutationOperation> operations = CollectionHelper.arrayList(numberOfTableMutations);
        mutationGroup.forEachTableMutation((integer, tableMutation) -> {
            Object operation = tableMutation.createMutationOperation(valuesAnalysis, this.factory);
            if (operation != null) {
                operations.add((MutationOperation)operation);
            } else {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Skipping table update - %s", (Object)tableMutation.getTableName());
            }
        });
        return new MutationOperationGroupStandard(mutationGroup.getMutationType(), this.entityPersister, operations);
    }

    void handleValueGeneration(AttributeMapping attributeMapping, MutationGroupBuilder mutationGroupBuilder, OnExecutionGenerator generator) {
        Dialect dialect = this.factory.getJdbcServices().getDialect();
        boolean writePropertyValue = generator.writePropertyValue();
        String[] columnValues = writePropertyValue ? null : generator.getReferencedColumnValues(dialect);
        attributeMapping.forEachSelectable((j, mapping) -> {
            String tableName = this.entityPersister.physicalTableNameForMutation(mapping);
            ColumnValuesTableMutationBuilder tableUpdateBuilder = (ColumnValuesTableMutationBuilder)mutationGroupBuilder.findTableDetailsBuilder(tableName);
            tableUpdateBuilder.addValueColumn(mapping.getSelectionExpression(), writePropertyValue ? "?" : columnValues[j], mapping.getJdbcMapping());
        });
    }

    protected void bindPartitionColumnValueBindings(Object[] loadedState, SharedSessionContractImplementor session, JdbcValueBindings jdbcValueBindings) {
        AbstractEntityPersister persister = this.entityPersister();
        if (persister.hasPartitionedSelectionMapping()) {
            AttributeMappingsList attributeMappings = persister.getAttributeMappings();
            int size = attributeMappings.size();
            for (int i = 0; i < size; ++i) {
                AttributeMapping attributeMapping = attributeMappings.get(i);
                if (!attributeMapping.hasPartitionedSelectionMapping()) continue;
                attributeMapping.decompose(loadedState[i], 0, jdbcValueBindings, null, (valueIndex, bindings, noop, value, jdbcValueMapping) -> {
                    if (jdbcValueMapping.isPartitioned()) {
                        bindings.bindValue(value, jdbcValueMapping, ParameterUsage.RESTRICT);
                    }
                }, session);
            }
        }
    }
}

