/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity.mutation;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.Internal;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.batch.internal.BasicBatchKey;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.MutationExecutor;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.engine.jdbc.mutation.TableInclusionChecker;
import org.hibernate.engine.jdbc.mutation.spi.MutationExecutorService;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.generator.Generator;
import org.hibernate.generator.OnExecutionGenerator;
import org.hibernate.id.insert.InsertGeneratedIdentifierDelegate;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.BasicEntityIdentifierMapping;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.AttributeMappingsList;
import org.hibernate.persister.entity.mutation.AbstractMutationCoordinator;
import org.hibernate.persister.entity.mutation.EntityMutationTarget;
import org.hibernate.persister.entity.mutation.EntityTableMapping;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.ValuesAnalysis;
import org.hibernate.sql.model.ast.builder.MutationGroupBuilder;
import org.hibernate.sql.model.ast.builder.TableInsertBuilder;
import org.hibernate.sql.model.ast.builder.TableInsertBuilderStandard;
import org.hibernate.tuple.entity.EntityMetamodel;

@Internal
public class InsertCoordinator
extends AbstractMutationCoordinator {
    private final MutationOperationGroup staticInsertGroup;
    private final BasicBatchKey insertBatchKey;

    public InsertCoordinator(AbstractEntityPersister entityPersister, SessionFactoryImplementor factory) {
        super(entityPersister, factory);
        this.insertBatchKey = entityPersister.hasInsertGeneratedProperties() ? null : new BasicBatchKey(entityPersister.getEntityName() + "#INSERT", null);
        this.staticInsertGroup = entityPersister.getEntityMetamodel().isDynamicInsert() ? null : this.generateStaticOperationGroup();
    }

    public MutationOperationGroup getStaticInsertGroup() {
        return this.staticInsertGroup;
    }

    public BasicBatchKey getInsertBatchKey() {
        return this.insertBatchKey;
    }

    public Object coordinateInsert(Object id, Object[] values, Object entity, SharedSessionContractImplementor session) {
        this.preInsertInMemoryValueGeneration(values, entity, session);
        EntityMetamodel entityMetamodel = this.entityPersister().getEntityMetamodel();
        if (entityMetamodel.isDynamicInsert()) {
            return this.doDynamicInserts(id, values, entity, session);
        }
        return this.doStaticInserts(id, values, entity, session);
    }

    protected void preInsertInMemoryValueGeneration(Object[] values, Object entity, SharedSessionContractImplementor session) {
        EntityMetamodel entityMetamodel = this.entityPersister().getEntityMetamodel();
        if (entityMetamodel.hasPreInsertGeneratedValues()) {
            Generator[] generators = entityMetamodel.getGenerators();
            for (int i = 0; i < generators.length; ++i) {
                Generator generator = generators[i];
                if (generator == null || generator.generatedOnExecution() || !generator.generatesOnInsert()) continue;
                values[i] = ((BeforeExecutionGenerator)generator).generate(session, entity, values[i], EventType.INSERT);
                this.entityPersister().setPropertyValue(entity, i, values[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doStaticInserts(Object id, Object[] values, Object object, SharedSessionContractImplementor session) {
        InsertValuesAnalysis insertValuesAnalysis = new InsertValuesAnalysis(this.entityPersister(), values);
        TableInclusionChecker tableInclusionChecker = InsertCoordinator.getTableInclusionChecker(insertValuesAnalysis);
        MutationExecutor mutationExecutor = this.executor(session, this.staticInsertGroup);
        this.decomposeForInsert(mutationExecutor, id, values, this.staticInsertGroup, this.entityPersister().getPropertyInsertability(), tableInclusionChecker, session);
        try {
            Object object2 = mutationExecutor.execute(object, insertValuesAnalysis, tableInclusionChecker, (statementDetails, affectedRowCount, batchPosition) -> {
                statementDetails.getExpectation().verifyOutcome(affectedRowCount, statementDetails.getStatement(), batchPosition, statementDetails.getSqlString());
                return true;
            }, session);
            return object2;
        }
        finally {
            mutationExecutor.release();
        }
    }

    protected void decomposeForInsert(MutationExecutor mutationExecutor, Object id, Object[] values, MutationOperationGroup mutationGroup, boolean[] propertyInclusions, TableInclusionChecker tableInclusionChecker, SharedSessionContractImplementor session) {
        JdbcValueBindings jdbcValueBindings = mutationExecutor.getJdbcValueBindings();
        mutationGroup.forEachOperation((position, operation) -> {
            EntityTableMapping tableDetails = (EntityTableMapping)operation.getTableDetails();
            if (tableInclusionChecker.include(tableDetails)) {
                int[] attributeIndexes = tableDetails.getAttributeIndexes();
                for (int i = 0; i < attributeIndexes.length; ++i) {
                    int attributeIndex = attributeIndexes[i];
                    if (!propertyInclusions[attributeIndex]) continue;
                    AttributeMapping mapping = this.entityPersister().getAttributeMappings().get(attributeIndex);
                    this.decomposeAttribute(values[attributeIndex], session, jdbcValueBindings, mapping);
                }
            }
        });
        mutationGroup.forEachOperation((position, jdbcOperation) -> {
            if (id == null) {
                assert (this.entityPersister().getIdentityInsertDelegate() != null);
            } else {
                EntityTableMapping tableDetails = (EntityTableMapping)jdbcOperation.getTableDetails();
                this.breakDownJdbcValue(id, session, jdbcValueBindings, tableDetails);
            }
        });
    }

    protected void breakDownJdbcValue(Object id, SharedSessionContractImplementor session, JdbcValueBindings jdbcValueBindings, EntityTableMapping tableDetails) {
        String tableName = tableDetails.getTableName();
        tableDetails.getKeyMapping().breakDownKeyJdbcValues(id, (jdbcValue, columnMapping) -> jdbcValueBindings.bindValue(jdbcValue, tableName, columnMapping.getColumnName(), ParameterUsage.SET), session);
    }

    protected void decomposeAttribute(Object value, SharedSessionContractImplementor session, JdbcValueBindings jdbcValueBindings, AttributeMapping mapping) {
        if (!(mapping instanceof PluralAttributeMapping)) {
            mapping.decompose(value, 0, jdbcValueBindings, null, (valueIndex, bindings, noop, jdbcValue, selectableMapping) -> {
                if (selectableMapping.isInsertable()) {
                    bindings.bindValue(jdbcValue, this.entityPersister().physicalTableNameForMutation(selectableMapping), selectableMapping.getSelectionExpression(), ParameterUsage.SET);
                }
            }, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doDynamicInserts(Object id, Object[] values, Object object, SharedSessionContractImplementor session) {
        boolean[] insertability = this.getPropertiesToInsert(values);
        MutationOperationGroup insertGroup = this.generateDynamicInsertSqlGroup(insertability);
        MutationExecutor mutationExecutor = this.executor(session, insertGroup);
        InsertValuesAnalysis insertValuesAnalysis = new InsertValuesAnalysis(this.entityPersister(), values);
        TableInclusionChecker tableInclusionChecker = InsertCoordinator.getTableInclusionChecker(insertValuesAnalysis);
        this.decomposeForInsert(mutationExecutor, id, values, insertGroup, insertability, tableInclusionChecker, session);
        try {
            Object object2 = mutationExecutor.execute(object, insertValuesAnalysis, tableInclusionChecker, (statementDetails, affectedRowCount, batchPosition) -> {
                statementDetails.getExpectation().verifyOutcome(affectedRowCount, statementDetails.getStatement(), batchPosition, statementDetails.getSqlString());
                return true;
            }, session);
            return object2;
        }
        finally {
            mutationExecutor.release();
        }
    }

    private MutationExecutor executor(SharedSessionContractImplementor session, MutationOperationGroup insertGroup) {
        return session.getFactory().getServiceRegistry().getService(MutationExecutorService.class).createExecutor(() -> this.insertBatchKey, insertGroup, session);
    }

    protected static TableInclusionChecker getTableInclusionChecker(InsertValuesAnalysis insertValuesAnalysis) {
        return tableMapping -> !tableMapping.isOptional() || insertValuesAnalysis.hasNonNullBindings(tableMapping);
    }

    public boolean[] getPropertiesToInsert(Object[] fields) {
        boolean[] notNull = new boolean[fields.length];
        boolean[] insertable = this.entityPersister().getPropertyInsertability();
        for (int i = 0; i < fields.length; ++i) {
            notNull[i] = insertable[i] && fields[i] != null;
        }
        return notNull;
    }

    protected MutationOperationGroup generateDynamicInsertSqlGroup(boolean[] insertable) {
        assert (this.entityPersister().getEntityMetamodel().isDynamicInsert());
        MutationGroupBuilder insertGroupBuilder = new MutationGroupBuilder(MutationType.INSERT, this.entityPersister());
        this.entityPersister().forEachMutableTable(tableMapping -> insertGroupBuilder.addTableDetailsBuilder(this.createTableInsertBuilder((EntityTableMapping)tableMapping)));
        this.applyTableInsertDetails(insertGroupBuilder, insertable);
        return this.createOperationGroup(null, insertGroupBuilder.buildMutationGroup());
    }

    public MutationOperationGroup generateStaticOperationGroup() {
        MutationGroupBuilder insertGroupBuilder = new MutationGroupBuilder(MutationType.INSERT, this.entityPersister());
        this.entityPersister().forEachMutableTable(tableMapping -> insertGroupBuilder.addTableDetailsBuilder(this.createTableInsertBuilder((EntityTableMapping)tableMapping)));
        this.applyTableInsertDetails(insertGroupBuilder, this.entityPersister().getPropertyInsertability());
        return this.createOperationGroup(null, insertGroupBuilder.buildMutationGroup());
    }

    private TableInsertBuilder createTableInsertBuilder(EntityTableMapping tableMapping) {
        InsertGeneratedIdentifierDelegate identityDelegate = this.entityPersister().getIdentityInsertDelegate();
        if (tableMapping.isIdentifierTable() && identityDelegate != null) {
            BasicEntityIdentifierMapping mapping = (BasicEntityIdentifierMapping)this.entityPersister().getIdentifierMapping();
            return identityDelegate.createTableInsertBuilder(mapping, tableMapping.getInsertExpectation(), this.factory());
        }
        return new TableInsertBuilderStandard(this.entityPersister(), tableMapping, this.factory());
    }

    private void applyTableInsertDetails(MutationGroupBuilder insertGroupBuilder, boolean[] attributeInclusions) {
        AttributeMappingsList attributeMappings = this.entityPersister().getAttributeMappings();
        insertGroupBuilder.forEachTableMutationBuilder(builder -> {
            EntityTableMapping tableMapping = (EntityTableMapping)builder.getMutatingTable().getTableMapping();
            assert (!tableMapping.isInverse());
            int[] attributeIndexes = tableMapping.getAttributeIndexes();
            for (int i = 0; i < attributeIndexes.length; ++i) {
                int attributeIndex = attributeIndexes[i];
                AttributeMapping attributeMapping = attributeMappings.get(attributeIndex);
                if (attributeInclusions[attributeIndex]) {
                    attributeMapping.forEachInsertable(insertGroupBuilder);
                    continue;
                }
                Generator generator = attributeMapping.getGenerator();
                if (!InsertCoordinator.isValueGenerationInSql(generator, this.factory().getJdbcServices().getDialect())) continue;
                this.handleValueGeneration(attributeMapping, insertGroupBuilder, (OnExecutionGenerator)generator);
            }
        });
        this.entityPersister().addDiscriminatorToInsertGroup(insertGroupBuilder);
        InsertGeneratedIdentifierDelegate identityDelegate = this.entityPersister().getIdentityInsertDelegate();
        insertGroupBuilder.forEachTableMutationBuilder(tableMutationBuilder -> {
            TableInsertBuilder tableInsertBuilder = (TableInsertBuilder)tableMutationBuilder;
            EntityTableMapping tableMapping = (EntityTableMapping)tableInsertBuilder.getMutatingTable().getTableMapping();
            if (!tableMapping.isIdentifierTable() || identityDelegate == null) {
                tableMapping.getKeyMapping().forEachKeyColumn(tableInsertBuilder::addKeyColumn);
            }
        });
    }

    private static boolean isValueGenerationInSql(Generator generator, Dialect dialect) {
        return generator != null && generator.generatesOnInsert() && generator.generatedOnExecution() && ((OnExecutionGenerator)generator).referenceColumnsInSql(dialect);
    }

    protected static class InsertValuesAnalysis
    implements ValuesAnalysis {
        private final List<TableMapping> tablesWithNonNullValues = new ArrayList<TableMapping>();

        public InsertValuesAnalysis(EntityMutationTarget mutationTarget, Object[] values) {
            mutationTarget.forEachMutableTable(tableMapping -> {
                int[] tableAttributeIndexes = tableMapping.getAttributeIndexes();
                for (int i = 0; i < tableAttributeIndexes.length; ++i) {
                    if (values[tableAttributeIndexes[i]] == null) continue;
                    this.tablesWithNonNullValues.add((TableMapping)tableMapping);
                    break;
                }
            });
        }

        public boolean hasNonNullBindings(TableMapping tableMapping) {
            return this.tablesWithNonNullValues.contains(tableMapping);
        }
    }
}

