/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.derived;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.Incubating;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.loader.ast.spi.MultiNaturalIdLoader;
import org.hibernate.loader.ast.spi.NaturalIdLoader;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.CompositeIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityAssociationMapping;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityRowIdMapping;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.NaturalIdMapping;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.TableDetails;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.internal.OneToManyCollectionPart;
import org.hibernate.metamodel.mapping.internal.SingleAttributeIdentifierMapping;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.entity.AttributeMappingsList;
import org.hibernate.persister.entity.AttributeMappingsMap;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.LazyTableGroup;
import org.hibernate.sql.ast.tree.from.StandardTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupJoinProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.type.descriptor.java.JavaType;

@Incubating
public class AnonymousTupleEntityValuedModelPart
implements EntityValuedModelPart,
EntityMappingType,
TableGroupJoinProducer {
    private final EntityIdentifierMapping identifierMapping;
    private final DomainType<?> domainType;
    private final String componentName;
    private final EntityValuedModelPart delegate;
    private final Set<String> targetKeyPropertyNames;
    private final int fetchableIndex;

    public AnonymousTupleEntityValuedModelPart(EntityIdentifierMapping identifierMapping, DomainType<?> domainType, String componentName, EntityValuedModelPart delegate, int fetchableIndex) {
        this.identifierMapping = identifierMapping;
        this.domainType = domainType;
        this.componentName = componentName;
        this.delegate = delegate;
        EntityPersister persister = ((EntityMappingType)delegate.getPartMappingType()).getEntityPersister();
        HashSet<String> targetKeyPropertyNames = new HashSet<String>();
        targetKeyPropertyNames.add("{id}");
        ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, persister.getIdentifierPropertyName(), persister.getIdentifierType(), persister.getFactory());
        this.targetKeyPropertyNames = targetKeyPropertyNames;
        this.fetchableIndex = fetchableIndex;
    }

    public ModelPart getForeignKeyPart() {
        return this.identifierMapping;
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType treatTargetType) {
        if (this.identifierMapping instanceof SingleAttributeIdentifierMapping) {
            if (((SingleAttributeIdentifierMapping)this.identifierMapping).getAttributeName().equals(name)) {
                return this.identifierMapping;
            }
        } else {
            ModelPart subPart = ((CompositeIdentifierMapping)this.identifierMapping).getPartMappingType().findSubPart(name, treatTargetType);
            if (subPart != null) {
                return subPart;
            }
        }
        return this.delegate.findSubPart(name, treatTargetType);
    }

    @Override
    public void visitSubParts(Consumer<ModelPart> consumer, EntityMappingType treatTargetType) {
        this.delegate.visitSubParts(consumer, treatTargetType);
    }

    @Override
    public MappingType getPartMappingType() {
        return this;
    }

    @Override
    public JavaType<?> getJavaType() {
        return this.domainType.getExpressibleJavaType();
    }

    @Override
    public String getPartName() {
        return this.componentName;
    }

    @Override
    public int getJdbcTypeCount() {
        return this.delegate.getJdbcTypeCount();
    }

    @Override
    public int getNumberOfAttributeMappings() {
        return this.delegate.getEntityMappingType().getNumberOfAttributeMappings();
    }

    @Override
    public AttributeMapping getAttributeMapping(int position) {
        return this.delegate.getEntityMappingType().getAttributeMapping(position);
    }

    @Override
    public AttributeMappingsList getAttributeMappings() {
        return this.delegate.getEntityMappingType().getAttributeMappings();
    }

    @Override
    public void forEachAttributeMapping(Consumer<? super AttributeMapping> action) {
        this.delegate.getEntityMappingType().forEachAttributeMapping(action);
    }

    @Override
    public Object[] getValues(Object instance) {
        return this.delegate.getEntityMappingType().getValues(instance);
    }

    @Override
    public Object getValue(Object instance, int position) {
        return this.delegate.getEntityMappingType().getAttributeMapping(position).getValue(instance);
    }

    @Override
    public void setValues(Object instance, Object[] resolvedValues) {
        this.delegate.getEntityMappingType().setValues(instance, resolvedValues);
    }

    @Override
    public void setValue(Object instance, int position, Object value) {
        this.delegate.getEntityMappingType().getAttributeMapping(position).setValue(instance, value);
    }

    @Override
    public List<JdbcMapping> getJdbcMappings() {
        ArrayList<JdbcMapping> results = new ArrayList<JdbcMapping>();
        this.forEachSelectable((index, selection) -> results.add(selection.getJdbcMapping()));
        return results;
    }

    @Override
    public JdbcMapping getJdbcMapping(int index) {
        return this.identifierMapping.getJdbcMapping(index);
    }

    @Override
    public JdbcMapping getSingleJdbcMapping() {
        return this.identifierMapping.getSingleJdbcMapping();
    }

    @Override
    public int forEachSelectable(SelectableConsumer consumer) {
        return this.forEachSelectable(0, consumer);
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        return this.identifierMapping.forEachSelectable(offset, consumer);
    }

    @Override
    public JavaType<?> getMappedJavaType() {
        return this.delegate.getJavaType();
    }

    @Override
    public TableGroupJoin createTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAstJoinType requestedJoinType, boolean fetched, boolean addsPredicate, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, FromClauseAccess fromClauseAccess, SqlAstCreationContext creationContext) {
        SessionFactoryImplementor sessionFactory = creationContext.getSessionFactory();
        SqlAstJoinType joinType = Objects.requireNonNullElse(requestedJoinType, SqlAstJoinType.INNER);
        TableGroup lazyTableGroup = this.createRootTableGroupJoin(navigablePath, lhs, explicitSourceAlias, requestedJoinType, fetched, (Consumer)null, aliasBaseGenerator, sqlExpressionResolver, fromClauseAccess, creationContext);
        TableGroupJoin tableGroupJoin = new TableGroupJoin(navigablePath, joinType, lazyTableGroup, null);
        ((LazyTableGroup)lazyTableGroup).setTableGroupInitializerCallback(this.createTableGroupInitializerCallback(lhs, sqlExpressionResolver, sessionFactory, tableGroupJoin::applyPredicate));
        return tableGroupJoin;
    }

    private Consumer<TableGroup> createTableGroupInitializerCallback(TableGroup lhs, SqlExpressionResolver sqlExpressionResolver, SessionFactoryImplementor sessionFactory, Consumer<Predicate> predicateConsumer) {
        ArrayList<Object> targetMappings;
        ArrayList<Object> keyMappings;
        if (this.delegate instanceof OneToManyCollectionPart) {
            OneToManyCollectionPart oneToMany = (OneToManyCollectionPart)this.delegate;
            PluralAttributeMapping pluralAttribute = oneToMany.getCollectionDescriptor().getAttributeMapping();
            ValuedModelPart keyPart = pluralAttribute.getKeyDescriptor().getKeyPart();
            ValuedModelPart keyTargetPart = pluralAttribute.getKeyDescriptor().getTargetPart();
            keyMappings = CollectionHelper.arrayList(keyPart.getJdbcTypeCount());
            keyPart.forEachSelectable((selectionIndex, selectableMapping) -> keyMappings.add(selectableMapping));
            targetMappings = CollectionHelper.arrayList(keyTargetPart.getJdbcTypeCount());
            keyTargetPart.forEachSelectable((selectionIndex, selectableMapping) -> targetMappings.add(selectableMapping));
        } else {
            ModelPart targetJoinModelPart;
            EntityAssociationMapping associationMapping = (EntityAssociationMapping)((Object)this.delegate);
            if (associationMapping.isReferenceToPrimaryKey() && associationMapping.getSideNature() == ForeignKeyDescriptor.Nature.KEY) {
                targetJoinModelPart = associationMapping.getForeignKeyDescriptor().getPart(associationMapping.getSideNature().inverse());
                targetMappings = new ArrayList(targetJoinModelPart.getJdbcTypeCount());
                targetJoinModelPart.forEachSelectable(0, (i, selectableMapping) -> targetMappings.add(selectableMapping));
                keyMappings = new ArrayList(targetJoinModelPart.getJdbcTypeCount());
                associationMapping.getForeignKeyDescriptor().getPart(associationMapping.getSideNature()).forEachSelectable(0, (i, selectableMapping) -> keyMappings.add(selectableMapping));
            } else {
                targetJoinModelPart = this.delegate.getEntityMappingType().getIdentifierMapping();
                targetMappings = new ArrayList(targetJoinModelPart.getJdbcTypeCount());
                targetJoinModelPart.forEachSelectable(0, (i, selectableMapping) -> targetMappings.add(selectableMapping));
                keyMappings = targetMappings;
            }
        }
        TableReference tableReference = lhs.getPrimaryTableReference();
        ArrayList keyColumnReferences = new ArrayList(this.identifierMapping.getJdbcTypeCount());
        this.identifierMapping.forEachSelectable((i, selectableMapping) -> keyColumnReferences.add((ColumnReference)sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, ((SelectableMapping)keyMappings.get(i)).getSelectionExpression()), state -> new ColumnReference(tableReference, selectableMapping))));
        if (keyMappings != targetMappings) {
            this.identifierMapping.forEachSelectable((i, selectableMapping) -> sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, ((SelectableMapping)targetMappings.get(i)).getSelectionExpression()), state -> new ColumnReference(tableReference, selectableMapping)));
        }
        Consumer<TableGroup> tableGroupInitializerCallback = tg -> this.identifierMapping.forEachSelectable((i, selectableMapping) -> {
            SelectableMapping targetMapping = (SelectableMapping)targetMappings.get(i);
            TableReference targetTableReference = tg.resolveTableReference(null, targetMapping.getContainingTableExpression(), false);
            predicateConsumer.accept(new ComparisonPredicate((Expression)keyColumnReferences.get(i), ComparisonOperator.EQUAL, new ColumnReference(targetTableReference, targetMapping)));
        });
        return tableGroupInitializerCallback;
    }

    public TableGroup createTableGroupInternal(boolean canUseInnerJoins, NavigablePath navigablePath, boolean fetched, String sourceAlias, SqlAliasBase sqlAliasBase, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        EntityMappingType entityMappingType = this.delegate.getEntityMappingType();
        TableReference primaryTableReference = entityMappingType.createPrimaryTableReference(sqlAliasBase, sqlExpressionResolver, creationContext);
        return new StandardTableGroup(canUseInnerJoins, navigablePath, this, fetched, sourceAlias, primaryTableReference, true, sqlAliasBase, entityMappingType::containsTableReference, (tableExpression, tg) -> entityMappingType.createTableReferenceJoin((String)tableExpression, sqlAliasBase, primaryTableReference, sqlExpressionResolver, creationContext), creationContext.getSessionFactory());
    }

    @Override
    public LazyTableGroup createRootTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAstJoinType sqlAstJoinType, boolean fetched, Consumer<Predicate> predicateConsumer, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, FromClauseAccess fromClauseAccess, SqlAstCreationContext creationContext) {
        SqlAliasBase sqlAliasBase = aliasBaseGenerator.createSqlAliasBase(this.getSqlAliasStem());
        boolean canUseInnerJoin = sqlAstJoinType == SqlAstJoinType.INNER || lhs.canUseInnerJoins();
        EntityPersister entityPersister = this.delegate.getEntityMappingType().getEntityPersister();
        LazyTableGroup lazyTableGroup = new LazyTableGroup(canUseInnerJoin, navigablePath, fetched, () -> this.createTableGroupInternal(canUseInnerJoin, navigablePath, fetched, null, sqlAliasBase, sqlExpressionResolver, creationContext), (np, tableExpression) -> {
            if (!tableExpression.isEmpty() && !entityPersister.containsTableReference((String)tableExpression)) {
                return false;
            }
            if (navigablePath.equals(np.getParent())) {
                return this.targetKeyPropertyNames.contains(np.getLocalName());
            }
            String relativePath = np.relativize(navigablePath);
            if (relativePath == null) {
                return false;
            }
            return relativePath.isEmpty() || this.targetKeyPropertyNames.contains(relativePath);
        }, this, explicitSourceAlias, sqlAliasBase, creationContext.getSessionFactory(), lhs);
        if (predicateConsumer != null) {
            lazyTableGroup.setTableGroupInitializerCallback(this.createTableGroupInitializerCallback(lhs, sqlExpressionResolver, creationContext.getSessionFactory(), predicateConsumer));
        }
        return lazyTableGroup;
    }

    @Override
    public String getSqlAliasStem() {
        return this.getPartName();
    }

    @Override
    public int getNumberOfFetchables() {
        return this.delegate.getNumberOfFetchables();
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.delegate.getNavigableRole();
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this;
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        return this.delegate.createDomainResult(navigablePath, tableGroup, resultVariable, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.identifierMapping.applySqlSelections(navigablePath, tableGroup, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        this.identifierMapping.applySqlSelections(navigablePath, tableGroup, creationState, selectionConsumer);
    }

    @Override
    public <X, Y> int breakDownJdbcValues(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        return this.delegate.breakDownJdbcValues(domainValue, offset, x, y, valueConsumer, session);
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.delegate.disassemble(value, session);
    }

    @Override
    public <X, Y> int forEachDisassembledJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        return this.delegate.forEachDisassembledJdbcValue(value, offset, x, y, valuesConsumer, session);
    }

    @Override
    public <X, Y> int forEachJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> consumer, SharedSessionContractImplementor session) {
        return this.delegate.forEachJdbcValue(value, offset, x, y, consumer, session);
    }

    @Override
    public boolean isExplicitPolymorphism() {
        return false;
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        return this.delegate.forEachJdbcType(offset, action);
    }

    @Override
    public EntityPersister getEntityPersister() {
        return this.delegate.getEntityMappingType().getEntityPersister();
    }

    @Override
    public String getEntityName() {
        return this.delegate.getEntityMappingType().getEntityName();
    }

    @Override
    public TableDetails getMappedTableDetails() {
        return this.delegate.getEntityMappingType().getMappedTableDetails();
    }

    @Override
    public TableDetails getIdentifierTableDetails() {
        return this.delegate.getEntityMappingType().getIdentifierTableDetails();
    }

    @Override
    public void visitQuerySpaces(Consumer<String> querySpaceConsumer) {
        this.delegate.getEntityMappingType().visitQuerySpaces(querySpaceConsumer);
    }

    @Override
    public AttributeMapping findDeclaredAttributeMapping(String name) {
        return this.delegate.getEntityMappingType().findDeclaredAttributeMapping(name);
    }

    @Override
    public AttributeMappingsMap getDeclaredAttributeMappings() {
        return this.delegate.getEntityMappingType().getDeclaredAttributeMappings();
    }

    @Override
    public void visitDeclaredAttributeMappings(Consumer<? super AttributeMapping> action) {
        this.delegate.getEntityMappingType().visitDeclaredAttributeMappings(action);
    }

    @Override
    public EntityIdentifierMapping getIdentifierMapping() {
        return this.delegate.getEntityMappingType().getIdentifierMapping();
    }

    @Override
    public EntityDiscriminatorMapping getDiscriminatorMapping() {
        return this.delegate.getEntityMappingType().getDiscriminatorMapping();
    }

    @Override
    public Object getDiscriminatorValue() {
        return this.delegate.getEntityMappingType().getDiscriminatorValue();
    }

    @Override
    public String getDiscriminatorSQLValue() {
        return this.delegate.getEntityMappingType().getDiscriminatorSQLValue();
    }

    @Override
    public EntityVersionMapping getVersionMapping() {
        return this.delegate.getEntityMappingType().getVersionMapping();
    }

    @Override
    public OptimisticLockStyle optimisticLockStyle() {
        return this.delegate.getEntityMappingType().optimisticLockStyle();
    }

    @Override
    public NaturalIdMapping getNaturalIdMapping() {
        return this.delegate.getEntityMappingType().getNaturalIdMapping();
    }

    @Override
    public EntityRowIdMapping getRowIdMapping() {
        return this.delegate.getEntityMappingType().getRowIdMapping();
    }

    @Override
    public void visitConstraintOrderedTables(EntityMappingType.ConstraintOrderedTableConsumer consumer) {
        this.delegate.getEntityMappingType().visitConstraintOrderedTables(consumer);
    }

    @Override
    public NaturalIdLoader<?> getNaturalIdLoader() {
        return this.delegate.getEntityMappingType().getNaturalIdLoader();
    }

    @Override
    public MultiNaturalIdLoader<?> getMultiNaturalIdLoader() {
        return this.delegate.getEntityMappingType().getMultiNaturalIdLoader();
    }

    @Override
    public EntityMappingType getEntityMappingType() {
        return this;
    }

    @Override
    public SqlAstJoinType getDefaultSqlAstJoinType(TableGroup parentTableGroup) {
        return this.delegate instanceof TableGroupJoinProducer ? ((TableGroupJoinProducer)((Object)this.delegate)).getDefaultSqlAstJoinType(parentTableGroup) : null;
    }

    @Override
    public boolean isSimpleJoinPredicate(Predicate predicate) {
        return this.delegate instanceof TableGroupJoinProducer ? ((TableGroupJoinProducer)((Object)this.delegate)).isSimpleJoinPredicate(predicate) : false;
    }
}

