/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.query.BindableType;
import org.hibernate.query.internal.BindingTypeHelper;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sql.internal.NativeQueryImpl;
import org.hibernate.query.sql.spi.ParameterOccurrence;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.type.BasicTypeReference;
import org.hibernate.type.spi.TypeConfiguration;

public interface JdbcParameterBindings {
    public static final JdbcParameterBindings NO_BINDINGS = new JdbcParameterBindings(){

        @Override
        public void addBinding(JdbcParameter parameter, JdbcParameterBinding binding) {
        }

        @Override
        public Collection<JdbcParameterBinding> getBindings() {
            return Collections.emptyList();
        }

        @Override
        public JdbcParameterBinding getBinding(JdbcParameter parameter) {
            return null;
        }

        @Override
        public void visitBindings(BiConsumer<JdbcParameter, JdbcParameterBinding> action) {
        }
    };

    public void addBinding(JdbcParameter var1, JdbcParameterBinding var2);

    public Collection<JdbcParameterBinding> getBindings();

    public JdbcParameterBinding getBinding(JdbcParameter var1);

    public void visitBindings(BiConsumer<JdbcParameter, JdbcParameterBinding> var1);

    default public int registerParametersForEachJdbcValue(Object value, Bindable bindable, List<JdbcParameter> jdbcParameters, SharedSessionContractImplementor session) {
        return this.registerParametersForEachJdbcValue(value, 0, bindable, jdbcParameters, session);
    }

    default public int registerParametersForEachJdbcValue(Object value, int offset, Bindable bindable, List<JdbcParameter> jdbcParameters, SharedSessionContractImplementor session) {
        return bindable.forEachJdbcValue(value, offset, jdbcParameters, session.getFactory().getTypeConfiguration(), (selectionIndex, params, typeConfiguration, jdbcValue, type) -> this.addBinding((JdbcParameter)params.get(selectionIndex), new JdbcParameterBindingImpl(BindingTypeHelper.INSTANCE.resolveBindType(jdbcValue, type, (TypeConfiguration)typeConfiguration), jdbcValue)), session);
    }

    default public void registerNativeQueryParameters(QueryParameterBindings queryParameterBindings, List<ParameterOccurrence> parameterOccurrences, List<JdbcParameterBinder> jdbcParameterBinders, SessionFactoryImplementor factory) {
        Dialect dialect = factory.getJdbcServices().getDialect();
        boolean paddingEnabled = factory.getSessionFactoryOptions().inClauseParameterPaddingEnabled();
        int inExprLimit = dialect.getInExpressionCountLimit();
        for (ParameterOccurrence occurrence : parameterOccurrences) {
            JdbcMapping jdbcMapping;
            QueryParameterBinding<?> binding;
            QueryParameterImplementor<?> param = occurrence.getParameter();
            BindableType<?> type = this.determineParamType(param, binding = queryParameterBindings.getBinding(param));
            if (type == null) {
                jdbcMapping = factory.getTypeConfiguration().getBasicTypeForJavaType(Object.class);
            } else if (type instanceof BasicTypeReference) {
                jdbcMapping = factory.getTypeConfiguration().getBasicTypeRegistry().resolve((BasicTypeReference)type);
            } else if (type instanceof BasicValuedMapping) {
                jdbcMapping = ((BasicValuedMapping)((Object)type)).getJdbcMapping();
            } else {
                throw new IllegalArgumentException("Could not resolve NativeQuery parameter type : `" + param + "`");
            }
            if (binding.isMultiValued()) {
                JdbcParameterImpl jdbcParameter;
                Collection<?> bindValues = binding.getBindValues();
                int bindValueCount = bindValues.size();
                Object lastBindValue = null;
                for (Object bindValue : bindValues) {
                    jdbcParameter = new JdbcParameterImpl(jdbcMapping);
                    jdbcParameterBinders.add(jdbcParameter);
                    this.addBinding(jdbcParameter, new JdbcParameterBindingImpl(jdbcMapping, bindValue));
                    lastBindValue = bindValue;
                }
                int bindValueMaxCount = NativeQueryImpl.determineBindValueMaxCount(paddingEnabled, inExprLimit, bindValueCount);
                if (bindValueMaxCount == bindValueCount) continue;
                for (int i = bindValueCount; i < bindValueMaxCount; ++i) {
                    jdbcParameter = new JdbcParameterImpl(jdbcMapping);
                    jdbcParameterBinders.add(jdbcParameter);
                    this.addBinding(jdbcParameter, new JdbcParameterBindingImpl(jdbcMapping, lastBindValue));
                }
                continue;
            }
            JdbcParameterImpl jdbcParameter = new JdbcParameterImpl(jdbcMapping);
            jdbcParameterBinders.add(jdbcParameter);
            this.addBinding(jdbcParameter, new JdbcParameterBindingImpl(jdbcMapping, binding.getBindValue()));
        }
    }

    private BindableType<?> determineParamType(QueryParameterImplementor<?> param, QueryParameterBinding<?> binding) {
        BindableType<Object> type = binding.getBindType();
        if (type == null) {
            type = param.getHibernateType();
        }
        return type;
    }
}

