/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.model.ast;

import java.util.ArrayList;
import org.hibernate.Internal;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.model.ast.ColumnValueBinding;
import org.hibernate.sql.model.ast.ColumnValueParameter;
import org.hibernate.sql.model.ast.ColumnValueParameterList;
import org.hibernate.sql.model.ast.ColumnWriteFragment;
import org.hibernate.sql.model.ast.MutatingTableReference;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

@Internal
public class ColumnValueBindingList
extends ArrayList<ColumnValueBinding>
implements ModelPart.JdbcValueConsumer {
    private final MutatingTableReference mutatingTable;
    private final ColumnValueParameterList parameters;
    private final ParameterUsage parameterUsage;

    public ColumnValueBindingList(MutatingTableReference mutatingTable, ColumnValueParameterList parameters, ParameterUsage parameterUsage) {
        this.mutatingTable = mutatingTable;
        this.parameters = parameters;
        this.parameterUsage = parameterUsage;
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void consume(int valueIndex, Object value, SelectableMapping jdbcValueMapping) {
        ColumnValueBinding columnValueBinding = this.createValueBinding(jdbcValueMapping.getSelectionExpression(), value == null ? null : jdbcValueMapping.getWriteExpression(), jdbcValueMapping.getJdbcMapping());
        this.add(columnValueBinding);
    }

    public void addNullRestriction(SelectableMapping column) {
        this.add(this.createValueBinding(column.getSelectionExpression(), null, column.getJdbcMapping()));
    }

    public void addRestriction(SelectableMapping column) {
        this.add(this.createValueBinding(column.getSelectionExpression(), column.getWriteExpression(), column.getJdbcMapping()));
    }

    public void addRestriction(String columnName, String columnWriteFragment, JdbcMapping jdbcMapping) {
        this.add(this.createValueBinding(columnName, columnWriteFragment, jdbcMapping));
    }

    protected ColumnValueBinding createValueBinding(String columnName, String customWriteExpression, JdbcMapping jdbcMapping) {
        ColumnWriteFragment columnWriteFragment;
        ColumnReference columnReference = new ColumnReference(this.mutatingTable, columnName, jdbcMapping);
        if (customWriteExpression == null) {
            columnWriteFragment = null;
        } else if (customWriteExpression.contains("?")) {
            EmbeddableMappingType aggregateMappingType;
            JdbcType jdbcType = jdbcMapping.getJdbcType();
            EmbeddableMappingType embeddableMappingType = aggregateMappingType = jdbcType instanceof AggregateJdbcType ? ((AggregateJdbcType)jdbcType).getEmbeddableMappingType() : null;
            if (aggregateMappingType != null && !aggregateMappingType.shouldBindAggregateMapping()) {
                ColumnValueParameterList parameters = new ColumnValueParameterList(this.mutatingTable, this.parameterUsage, aggregateMappingType.getJdbcTypeCount());
                aggregateMappingType.forEachSelectable(parameters);
                this.parameters.addAll(parameters);
                columnWriteFragment = new ColumnWriteFragment(customWriteExpression, parameters, jdbcMapping);
            } else {
                ColumnValueParameter parameter = new ColumnValueParameter(columnReference, this.parameterUsage);
                this.parameters.add(parameter);
                columnWriteFragment = new ColumnWriteFragment(customWriteExpression, parameter, jdbcMapping);
            }
        } else {
            columnWriteFragment = new ColumnWriteFragment(customWriteExpression, jdbcMapping);
        }
        return new ColumnValueBinding(columnReference, columnWriteFragment);
    }

    @Override
    public String toString() {
        return "ColumnValueBindingList" + super.toString();
    }
}

