/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.spi.CollectionLoader;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.BaseExecutionContext;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.results.graph.entity.LoadingEntityEntry;
import org.hibernate.sql.results.internal.RowTransformerStandardImpl;
import org.hibernate.sql.results.spi.ListResultsConsumer;

public class CollectionLoaderSingleKey
implements CollectionLoader {
    private final PluralAttributeMapping attributeMapping;
    private final int keyJdbcCount;
    private final SelectStatement sqlAst;
    private final List<JdbcParameter> jdbcParameters;

    public CollectionLoaderSingleKey(PluralAttributeMapping attributeMapping, LoadQueryInfluencers influencers, SessionFactoryImplementor sessionFactory) {
        this.attributeMapping = attributeMapping;
        this.keyJdbcCount = attributeMapping.getKeyDescriptor().getJdbcTypeCount();
        this.jdbcParameters = new ArrayList<JdbcParameter>();
        this.sqlAst = LoaderSelectBuilder.createSelect((Loadable)attributeMapping, null, attributeMapping.getKeyDescriptor(), null, 1, influencers, LockOptions.NONE, this.jdbcParameters::add, sessionFactory);
    }

    @Override
    public PluralAttributeMapping getLoadable() {
        return this.getAttributeMapping();
    }

    public PluralAttributeMapping getAttributeMapping() {
        return this.attributeMapping;
    }

    public SelectStatement getSqlAst() {
        return this.sqlAst;
    }

    public List<JdbcParameter> getJdbcParameters() {
        return this.jdbcParameters;
    }

    @Override
    public PersistentCollection<?> load(Object key, SharedSessionContractImplementor session) {
        CollectionKey collectionKey = new CollectionKey(this.attributeMapping.getCollectionDescriptor(), key);
        SessionFactoryImplementor sessionFactory = session.getFactory();
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(this.keyJdbcCount);
        int offset = jdbcParameterBindings.registerParametersForEachJdbcValue(key, this.attributeMapping.getKeyDescriptor(), this.jdbcParameters, session);
        assert (offset == this.jdbcParameters.size());
        JdbcOperationQuerySelect jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory, this.sqlAst).translate(jdbcParameterBindings, QueryOptions.NONE);
        SubselectFetch.RegistrationHandler subSelectFetchableKeysHandler = SubselectFetch.createRegistrationHandler(session.getPersistenceContext().getBatchFetchQueue(), this.sqlAst, this.jdbcParameters, jdbcParameterBindings);
        jdbcServices.getJdbcSelectExecutor().list(jdbcSelect, jdbcParameterBindings, new CollectionLoaderSingleKeyExecutionContext(session, collectionKey, subSelectFetchableKeysHandler), RowTransformerStandardImpl.instance(), ListResultsConsumer.UniqueSemantic.FILTER);
        return session.getPersistenceContext().getCollection(collectionKey);
    }

    private static class CollectionLoaderSingleKeyExecutionContext
    extends BaseExecutionContext {
        private final CollectionKey collectionKey;
        private final SubselectFetch.RegistrationHandler subSelectFetchableKeysHandler;

        CollectionLoaderSingleKeyExecutionContext(SharedSessionContractImplementor session, CollectionKey collectionKey, SubselectFetch.RegistrationHandler subSelectFetchableKeysHandler) {
            super(session);
            this.collectionKey = collectionKey;
            this.subSelectFetchableKeysHandler = subSelectFetchableKeysHandler;
        }

        @Override
        public CollectionKey getCollectionKey() {
            return this.collectionKey;
        }

        @Override
        public void registerLoadingEntityEntry(EntityKey entityKey, LoadingEntityEntry entry) {
            this.subSelectFetchableKeysHandler.addKey(entityKey, entry);
        }
    }
}

