/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.LoadEvent;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.loader.ast.internal.CacheEntityLoaderHelper;
import org.hibernate.loader.ast.internal.ExecutionContextWithSubselectFetchHandler;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.loader.ast.spi.MultiIdEntityLoader;
import org.hibernate.loader.ast.spi.MultiIdLoadOptions;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.results.internal.RowTransformerStandardImpl;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.jboss.logging.Logger;

public class MultiIdLoaderStandard<T>
implements MultiIdEntityLoader<T> {
    private static final Logger log = Logger.getLogger(MultiIdLoaderStandard.class);
    private final EntityPersister entityDescriptor;
    private final SessionFactoryImplementor sessionFactory;
    private final int idJdbcTypeCount;

    public MultiIdLoaderStandard(EntityPersister entityDescriptor, PersistentClass bootDescriptor, SessionFactoryImplementor sessionFactory) {
        this.entityDescriptor = entityDescriptor;
        this.idJdbcTypeCount = bootDescriptor.getIdentifier().getColumnSpan();
        this.sessionFactory = sessionFactory;
        assert (this.idJdbcTypeCount > 0);
    }

    @Override
    public EntityMappingType getLoadable() {
        return this.entityDescriptor;
    }

    @Override
    public List<T> load(Object[] ids, MultiIdLoadOptions loadOptions, EventSource session) {
        assert (ids != null);
        if (loadOptions.isOrderReturnEnabled()) {
            return this.performOrderedMultiLoad(ids, session, loadOptions);
        }
        return this.performUnorderedMultiLoad(ids, session, loadOptions);
    }

    private List<T> performOrderedMultiLoad(Object[] ids, EventSource session, MultiIdLoadOptions loadOptions) {
        if (log.isTraceEnabled()) {
            log.tracef("#performOrderedMultiLoad(`%s`, ..)", (Object)this.entityDescriptor.getEntityName());
        }
        assert (loadOptions.isOrderReturnEnabled());
        JdbcEnvironment jdbcEnvironment = this.sessionFactory.getJdbcServices().getJdbcEnvironment();
        Dialect dialect = jdbcEnvironment.getDialect();
        ArrayList result = CollectionHelper.arrayList(ids.length);
        LockOptions lockOptions = loadOptions.getLockOptions() == null ? new LockOptions(LockMode.NONE) : loadOptions.getLockOptions();
        int maxBatchSize = loadOptions.getBatchSize() != null && loadOptions.getBatchSize() > 0 ? loadOptions.getBatchSize().intValue() : dialect.getDefaultBatchLoadSizingStrategy().determineOptimalBatchLoadSize(this.idJdbcTypeCount, ids.length, this.sessionFactory.getSessionFactoryOptions().inClauseParameterPaddingEnabled());
        ArrayList<Object> idsInBatch = new ArrayList<Object>();
        ArrayList<Integer> elementPositionsLoadedByBatch = new ArrayList<Integer>();
        boolean coerce = !this.sessionFactory.getJpaMetamodel().getJpaCompliance().isLoadByIdComplianceEnabled();
        for (int i = 0; i < ids.length; ++i) {
            Object id = coerce ? this.entityDescriptor.getIdentifierMapping().getJavaType().coerce(ids[i], session) : ids[i];
            EntityKey entityKey = new EntityKey(id, this.entityDescriptor);
            if (loadOptions.isSessionCheckingEnabled() || loadOptions.isSecondLevelCacheCheckingEnabled()) {
                CacheEntityLoaderHelper.PersistenceContextEntry persistenceContextEntry;
                LoadEvent loadEvent = new LoadEvent(id, this.entityDescriptor.getMappedClass().getName(), lockOptions, session, this.getReadOnlyFromLoadQueryInfluencers(session));
                Object managedEntity = null;
                if (loadOptions.isSessionCheckingEnabled() && (managedEntity = (persistenceContextEntry = CacheEntityLoaderHelper.INSTANCE.loadFromSessionCache(loadEvent, entityKey, LoadEventListener.GET)).getEntity()) != null && !loadOptions.isReturnOfDeletedEntitiesEnabled() && !persistenceContextEntry.isManaged()) {
                    result.add(i, null);
                    continue;
                }
                if (managedEntity == null && loadOptions.isSecondLevelCacheCheckingEnabled()) {
                    managedEntity = CacheEntityLoaderHelper.INSTANCE.loadFromSecondLevelCache(loadEvent, this.entityDescriptor, entityKey);
                }
                if (managedEntity != null) {
                    result.add(i, managedEntity);
                    continue;
                }
            }
            idsInBatch.add(id);
            if (idsInBatch.size() >= maxBatchSize) {
                this.loadEntitiesById(idsInBatch, lockOptions, session);
                idsInBatch.clear();
            }
            result.add(i, entityKey);
            elementPositionsLoadedByBatch.add(i);
        }
        if (!idsInBatch.isEmpty()) {
            this.loadEntitiesById(idsInBatch, lockOptions, session);
        }
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        for (Integer position : elementPositionsLoadedByBatch) {
            EntityEntry entry;
            EntityKey entityKey = (EntityKey)result.get(position);
            Object entity = persistenceContext.getEntity(entityKey);
            if (entity != null && !loadOptions.isReturnOfDeletedEntitiesEnabled() && (entry = persistenceContext.getEntry(entity)).getStatus().isDeletedOrGone()) {
                entity = null;
            }
            result.set(position, entity);
        }
        return result;
    }

    private List<T> loadEntitiesById(List<Object> idsInBatch, LockOptions lockOptions, SharedSessionContractImplementor session) {
        assert (idsInBatch != null);
        assert (!idsInBatch.isEmpty());
        int numberOfIdsInBatch = idsInBatch.size();
        if (numberOfIdsInBatch == 1) {
            return this.performSingleMultiLoad(idsInBatch.get(0), lockOptions, session);
        }
        if (log.isTraceEnabled()) {
            log.tracef("#loadEntitiesById(`%s`, `%s`, ..)", (Object)this.entityDescriptor.getEntityName(), (Object)numberOfIdsInBatch);
        }
        ArrayList<JdbcParameter> jdbcParameters = new ArrayList<JdbcParameter>(numberOfIdsInBatch * this.idJdbcTypeCount);
        SelectStatement sqlAst = LoaderSelectBuilder.createSelect((Loadable)this.getLoadable(), null, this.getLoadable().getIdentifierMapping(), null, numberOfIdsInBatch, session.getLoadQueryInfluencers(), lockOptions, jdbcParameters::add, this.sessionFactory);
        JdbcServices jdbcServices = this.sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(jdbcParameters.size());
        int offset = 0;
        for (int i = 0; i < numberOfIdsInBatch; ++i) {
            Object id = idsInBatch.get(i);
            offset += jdbcParameterBindings.registerParametersForEachJdbcValue(id, offset, this.entityDescriptor.getIdentifierMapping(), jdbcParameters, session);
        }
        assert (offset == jdbcParameters.size());
        JdbcOperationQuerySelect jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(this.sessionFactory, sqlAst).translate(jdbcParameterBindings, QueryOptions.NONE);
        SubselectFetch.RegistrationHandler subSelectFetchableKeysHandler = this.entityDescriptor.hasSubselectLoadableCollections() ? SubselectFetch.createRegistrationHandler(session.getPersistenceContext().getBatchFetchQueue(), sqlAst, jdbcParameters, jdbcParameterBindings) : null;
        return session.getJdbcServices().getJdbcSelectExecutor().list(jdbcSelect, jdbcParameterBindings, new ExecutionContextWithSubselectFetchHandler(session, subSelectFetchableKeysHandler), RowTransformerStandardImpl.instance(), ListResultsConsumer.UniqueSemantic.FILTER);
    }

    private List<T> performSingleMultiLoad(Object id, LockOptions lockOptions, SharedSessionContractImplementor session) {
        Object loaded = this.entityDescriptor.load(id, null, lockOptions, session);
        return Collections.singletonList(loaded);
    }

    private List<T> performUnorderedMultiLoad(Object[] ids, EventSource session, MultiIdLoadOptions loadOptions) {
        LockOptions lockOptions;
        assert (!loadOptions.isOrderReturnEnabled());
        assert (ids != null);
        if (log.isTraceEnabled()) {
            log.tracef("#performUnorderedMultiLoad(`%s`, ..)", (Object)this.entityDescriptor.getEntityName());
        }
        ArrayList result = CollectionHelper.arrayList(ids.length);
        LockOptions lockOptions2 = lockOptions = loadOptions.getLockOptions() == null ? new LockOptions(LockMode.NONE) : loadOptions.getLockOptions();
        if (loadOptions.isSessionCheckingEnabled() || loadOptions.isSecondLevelCacheCheckingEnabled()) {
            boolean foundAnyManagedEntities = false;
            ArrayList<Object> nonManagedIds = new ArrayList<Object>();
            boolean coerce = !this.sessionFactory.getJpaMetamodel().getJpaCompliance().isLoadByIdComplianceEnabled();
            for (int i = 0; i < ids.length; ++i) {
                Object id = coerce ? this.entityDescriptor.getIdentifierMapping().getJavaType().coerce(ids[i], session) : ids[i];
                EntityKey entityKey = new EntityKey(id, this.entityDescriptor);
                LoadEvent loadEvent = new LoadEvent(id, this.entityDescriptor.getMappedClass().getName(), lockOptions, session, this.getReadOnlyFromLoadQueryInfluencers(session));
                Object managedEntity = null;
                CacheEntityLoaderHelper.PersistenceContextEntry persistenceContextEntry = CacheEntityLoaderHelper.INSTANCE.loadFromSessionCache(loadEvent, entityKey, LoadEventListener.GET);
                if (loadOptions.isSessionCheckingEnabled() && (managedEntity = persistenceContextEntry.getEntity()) != null && !loadOptions.isReturnOfDeletedEntitiesEnabled() && !persistenceContextEntry.isManaged()) {
                    foundAnyManagedEntities = true;
                    result.add(null);
                    continue;
                }
                if (managedEntity == null && loadOptions.isSecondLevelCacheCheckingEnabled()) {
                    managedEntity = CacheEntityLoaderHelper.INSTANCE.loadFromSecondLevelCache(loadEvent, this.entityDescriptor, entityKey);
                }
                if (managedEntity != null) {
                    foundAnyManagedEntities = true;
                    result.add(managedEntity);
                    continue;
                }
                nonManagedIds.add(id);
            }
            if (foundAnyManagedEntities) {
                if (nonManagedIds.isEmpty()) {
                    return result;
                }
                ids = nonManagedIds.toArray((Object[])Array.newInstance(ids.getClass().getComponentType(), nonManagedIds.size()));
            }
        }
        int numberOfIdsLeft = ids.length;
        int maxBatchSize = loadOptions.getBatchSize() != null && loadOptions.getBatchSize() > 0 ? loadOptions.getBatchSize().intValue() : session.getJdbcServices().getJdbcEnvironment().getDialect().getDefaultBatchLoadSizingStrategy().determineOptimalBatchLoadSize(this.entityDescriptor.getIdentifierType().getColumnSpan(session.getFactory()), numberOfIdsLeft, this.sessionFactory.getSessionFactoryOptions().inClauseParameterPaddingEnabled());
        int idPosition = 0;
        while (numberOfIdsLeft > 0) {
            int batchSize = Math.min(numberOfIdsLeft, maxBatchSize);
            Object[] idsInBatch = new Object[batchSize];
            System.arraycopy(ids, idPosition, idsInBatch, 0, batchSize);
            result.addAll(this.loadEntitiesById(Arrays.asList(idsInBatch), lockOptions, session));
            numberOfIdsLeft -= batchSize;
            idPosition += batchSize;
        }
        return result;
    }

    private Boolean getReadOnlyFromLoadQueryInfluencers(SharedSessionContractImplementor session) {
        Boolean readOnly = null;
        LoadQueryInfluencers loadQueryInfluencers = session.getLoadQueryInfluencers();
        if (loadQueryInfluencers != null) {
            readOnly = loadQueryInfluencers.getReadOnly();
        }
        return readOnly;
    }
}

