/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.internal.AbstractBatchEntitySelectFetchInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class BatchEntityInsideEmbeddableSelectFetchInitializer
extends AbstractBatchEntitySelectFetchInitializer {
    private final Map<EntityKey, List<ParentInfo>> toBatchLoad = new HashMap<EntityKey, List<ParentInfo>>();
    private final String rootEmbeddablePropertyName;
    public static final Serializable BATCH_PROPERTY = new Serializable(){

        public String toString() {
            return "<batch>";
        }

        public Object readResolve() {
            return BATCH_PROPERTY;
        }
    };

    public BatchEntityInsideEmbeddableSelectFetchInitializer(FetchParentAccess parentAccess, ToOneAttributeMapping referencedModelPart, NavigablePath fetchedNavigable, EntityPersister concreteDescriptor, DomainResultAssembler<?> identifierAssembler) {
        super(parentAccess, referencedModelPart, fetchedNavigable, concreteDescriptor, identifierAssembler);
        this.rootEmbeddablePropertyName = BatchEntityInsideEmbeddableSelectFetchInitializer.getRootEmbeddablePropertyName(this.firstEntityInitializer, parentAccess, referencedModelPart);
    }

    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
        if (this.entityKey == null) {
            return;
        }
        this.entityInstance = BATCH_PROPERTY;
    }

    @Override
    protected void registerResolutionListener() {
        List<ParentInfo> batchParentInfos = this.getBatchInfos();
        this.parentAccess.registerResolutionListener(o -> batchParentInfos.add(new ParentInfo(this.firstEntityInitializer.getEntityKey(), o, BatchEntityInsideEmbeddableSelectFetchInitializer.getPropertyIndex(this.firstEntityInitializer, this.rootEmbeddablePropertyName))));
    }

    private List<ParentInfo> getBatchInfos() {
        List<ParentInfo> objects = this.toBatchLoad.get(this.entityKey);
        if (objects == null) {
            objects = new ArrayList<ParentInfo>();
            this.toBatchLoad.put(this.entityKey, objects);
        }
        return objects;
    }

    @Override
    public boolean isEntityInitialized() {
        return false;
    }

    @Override
    public void endLoading(ExecutionContext context) {
        this.toBatchLoad.forEach((entityKey, parentInfos) -> {
            SharedSessionContractImplementor session = context.getSession();
            Object loadedInstance = BatchEntityInsideEmbeddableSelectFetchInitializer.loadInstance(entityKey, this.referencedModelPart, session);
            for (ParentInfo parentInfo : parentInfos) {
                PersistenceContext persistenceContext = session.getPersistenceContext();
                BatchEntityInsideEmbeddableSelectFetchInitializer.setInstance(this.firstEntityInitializer, this.referencedModelPart, this.rootEmbeddablePropertyName, parentInfo.propertyIndex, loadedInstance, parentInfo.parentInstance, parentInfo.initializerEntityKey, persistenceContext.getEntry(persistenceContext.getEntity(parentInfo.initializerEntityKey)), session);
            }
        });
        this.toBatchLoad.clear();
        this.parentAccess = null;
    }

    protected static void setInstance(EntityInitializer entityInitializer, ToOneAttributeMapping referencedModelPart, String rootEmbeddablePropertyName, int propertyIndex, Object loadedInstance, Object embeddableParentInstance, EntityKey parentEntityKey, EntityEntry parentEntityEntry, SharedSessionContractImplementor session) {
        referencedModelPart.getPropertyAccess().getSetter().set(embeddableParentInstance, loadedInstance);
        BatchEntityInsideEmbeddableSelectFetchInitializer.updateRootEntityLoadedState(entityInitializer, rootEmbeddablePropertyName, propertyIndex, parentEntityKey, parentEntityEntry, session);
    }

    private static void updateRootEntityLoadedState(EntityInitializer entityInitializer, String rootEmbeddablePropertyName, int propertyIndex, EntityKey parentEntityKey, EntityEntry parentEntityEntry, SharedSessionContractImplementor session) {
        Object[] loadedState = parentEntityEntry.getLoadedState();
        if (loadedState != null) {
            EntityPersister entityDescriptor = entityInitializer.getEntityDescriptor();
            Object rootEmbeddable = entityDescriptor.getPropertyValue(session.getPersistenceContext().getEntity(parentEntityKey), rootEmbeddablePropertyName);
            loadedState[propertyIndex] = entityDescriptor.getPropertyType(rootEmbeddablePropertyName).deepCopy(rootEmbeddable, session.getFactory());
        }
    }

    protected static String getRootEmbeddablePropertyName(EntityInitializer firstEntityInitializer, FetchParentAccess parentAccess, ToOneAttributeMapping referencedModelPart) {
        NavigablePath entityPath = firstEntityInitializer.getNavigablePath();
        NavigablePath navigablePath = parentAccess.getNavigablePath();
        if (navigablePath == entityPath) {
            return referencedModelPart.getPartName();
        }
        while (navigablePath.getParent() != entityPath) {
            navigablePath = navigablePath.getParent();
        }
        return navigablePath.getLocalName();
    }

    public String toString() {
        return "BatchEntityInsideEmbeddableSelectFetchInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }

    private static class ParentInfo {
        private final EntityKey initializerEntityKey;
        private final Object parentInstance;
        private final int propertyIndex;

        public ParentInfo(EntityKey initializerEntityKey, Object parentInstance, int propertyIndex) {
            this.initializerEntityKey = initializerEntityKey;
            this.parentInstance = parentInstance;
            this.propertyIndex = propertyIndex;
        }
    }
}

