
package org.hibernate.boot.jaxb.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jakarta.persistence.AccessType;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.hibernate.annotations.PolymorphismType;
import org.hibernate.engine.OptimisticLockStyle;


/**
 * 
 *                 See jakarta.persistence.Entity
 * 
 *                 Defines the settings and mappings for an entity. Is allowed to be
 *                 sparsely populated and used in conjunction with the annotations.
 *                 Alternatively, the metadata-complete attribute can be used to
 *                 indicate that no annotations on the entity class (and its fields
 *                 or properties) are to be processed. If this is the case then
 *                 the defaulting rules for the entity and its subelements will
 *                 be recursively applied.
 * 
 *                 @Target(TYPE) @Retention(RUNTIME)
 *                 public @interface Entity {
 *                 String name() default "";
 *                 }
 * 
 *             
 * 
 * <p>Java class for entity complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="entity">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="description" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <choice minOccurs="0">
 *           <element name="table" type="{http://www.hibernate.org/xsd/orm/mapping}table"/>
 *           <element name="table-expression" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         </choice>
 *         <element name="secondary-table" type="{http://www.hibernate.org/xsd/orm/mapping}secondary-table" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="synchronize" type="{http://www.hibernate.org/xsd/orm/mapping}synchronized-table" maxOccurs="unbounded" minOccurs="0"/>
 *         <sequence>
 *           <element name="primary-key-join-column" type="{http://www.hibernate.org/xsd/orm/mapping}primary-key-join-column" maxOccurs="unbounded" minOccurs="0"/>
 *           <element name="primary-key-foreign-key" type="{http://www.hibernate.org/xsd/orm/mapping}foreign-key" minOccurs="0"/>
 *         </sequence>
 *         <element name="rowid" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="where" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="loader" type="{http://www.hibernate.org/xsd/orm/mapping}custom-loader" minOccurs="0"/>
 *         <element name="sql-insert" type="{http://www.hibernate.org/xsd/orm/mapping}custom-sql" minOccurs="0"/>
 *         <element name="sql-update" type="{http://www.hibernate.org/xsd/orm/mapping}custom-sql" minOccurs="0"/>
 *         <element name="sql-delete" type="{http://www.hibernate.org/xsd/orm/mapping}custom-sql" minOccurs="0"/>
 *         <element name="dynamic-insert" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         <element name="dynamic-update" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         <element name="select-before-update" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         <element name="caching" type="{http://www.hibernate.org/xsd/orm/mapping}caching" minOccurs="0"/>
 *         <element name="batch-size" type="{http://www.w3.org/2001/XMLSchema}int" minOccurs="0"/>
 *         <element name="lazy" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         <element name="mutable" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         <element name="optimistic-lock" type="{http://www.hibernate.org/xsd/orm/mapping}optimistic-locking-type" minOccurs="0"/>
 *         <element name="id-class" type="{http://www.hibernate.org/xsd/orm/mapping}id-class" minOccurs="0"/>
 *         <element name="inheritance" type="{http://www.hibernate.org/xsd/orm/mapping}inheritance" minOccurs="0"/>
 *         <element name="proxy" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="polymorphism" type="{http://www.hibernate.org/xsd/orm/mapping}polymorphism-type" minOccurs="0"/>
 *         <element name="discriminator-value" type="{http://www.hibernate.org/xsd/orm/mapping}discriminator-value" minOccurs="0"/>
 *         <choice minOccurs="0">
 *           <element name="discriminator-column" type="{http://www.hibernate.org/xsd/orm/mapping}discriminator-column"/>
 *           <element name="discriminator-formula" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         </choice>
 *         <element name="sequence-generator" type="{http://www.hibernate.org/xsd/orm/mapping}sequence-generator" minOccurs="0"/>
 *         <element name="table-generator" type="{http://www.hibernate.org/xsd/orm/mapping}table-generator" minOccurs="0"/>
 *         <element name="identifier-generator" type="{http://www.hibernate.org/xsd/orm/mapping}generic-id-generator" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="named-query" type="{http://www.hibernate.org/xsd/orm/mapping}named-query" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="named-native-query" type="{http://www.hibernate.org/xsd/orm/mapping}named-native-query" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="named-stored-procedure-query" type="{http://www.hibernate.org/xsd/orm/mapping}named-stored-procedure-query" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="sql-result-set-mapping" type="{http://www.hibernate.org/xsd/orm/mapping}sql-result-set-mapping" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="exclude-default-listeners" type="{http://www.hibernate.org/xsd/orm/mapping}emptyType" minOccurs="0"/>
 *         <element name="exclude-superclass-listeners" type="{http://www.hibernate.org/xsd/orm/mapping}emptyType" minOccurs="0"/>
 *         <element name="entity-listeners" type="{http://www.hibernate.org/xsd/orm/mapping}entity-listeners" minOccurs="0"/>
 *         <element name="pre-persist" type="{http://www.hibernate.org/xsd/orm/mapping}pre-persist" minOccurs="0"/>
 *         <element name="post-persist" type="{http://www.hibernate.org/xsd/orm/mapping}post-persist" minOccurs="0"/>
 *         <element name="pre-remove" type="{http://www.hibernate.org/xsd/orm/mapping}pre-remove" minOccurs="0"/>
 *         <element name="post-remove" type="{http://www.hibernate.org/xsd/orm/mapping}post-remove" minOccurs="0"/>
 *         <element name="pre-update" type="{http://www.hibernate.org/xsd/orm/mapping}pre-update" minOccurs="0"/>
 *         <element name="post-update" type="{http://www.hibernate.org/xsd/orm/mapping}post-update" minOccurs="0"/>
 *         <element name="post-load" type="{http://www.hibernate.org/xsd/orm/mapping}post-load" minOccurs="0"/>
 *         <element name="attribute-override" type="{http://www.hibernate.org/xsd/orm/mapping}attribute-override" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="association-override" type="{http://www.hibernate.org/xsd/orm/mapping}association-override" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="convert" type="{http://www.hibernate.org/xsd/orm/mapping}convert" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="named-entity-graph" type="{http://www.hibernate.org/xsd/orm/mapping}named-entity-graph" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="extends" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="filter" type="{http://www.hibernate.org/xsd/orm/mapping}hbm-filter" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="fetch-profile" type="{http://www.hibernate.org/xsd/orm/mapping}fetch-profile" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="tenant-id" type="{http://www.hibernate.org/xsd/orm/mapping}tenant-id" minOccurs="0"/>
 *         <element name="attributes" type="{http://www.hibernate.org/xsd/orm/mapping}attributes" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="name" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="class" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="access" type="{http://www.hibernate.org/xsd/orm/mapping}access-type" />
 *       <attribute name="attribute-accessor" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="cacheable" type="{http://www.w3.org/2001/XMLSchema}boolean" />
 *       <attribute name="metadata-complete" type="{http://www.w3.org/2001/XMLSchema}boolean" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "entity", namespace = "http://www.hibernate.org/xsd/orm/mapping", propOrder = {
    "description",
    "table",
    "tableExpression",
    "secondaryTable",
    "synchronize",
    "primaryKeyJoinColumn",
    "primaryKeyForeignKey",
    "rowid",
    "where",
    "loader",
    "sqlInsert",
    "sqlUpdate",
    "sqlDelete",
    "dynamicInsert",
    "dynamicUpdate",
    "selectBeforeUpdate",
    "caching",
    "batchSize",
    "lazy",
    "mutable",
    "optimisticLock",
    "idClass",
    "inheritance",
    "proxy",
    "polymorphism",
    "discriminatorValue",
    "discriminatorColumn",
    "discriminatorFormula",
    "sequenceGenerator",
    "tableGenerator",
    "identifierGenerator",
    "namedQuery",
    "namedNativeQuery",
    "namedStoredProcedureQuery",
    "sqlResultSetMapping",
    "excludeDefaultListeners",
    "excludeSuperclassListeners",
    "entityListeners",
    "prePersist",
    "postPersist",
    "preRemove",
    "postRemove",
    "preUpdate",
    "postUpdate",
    "postLoad",
    "attributeOverride",
    "associationOverride",
    "convert",
    "namedEntityGraph",
    "_extends",
    "filter",
    "fetchProfile",
    "tenantId",
    "attributes"
})
public class JaxbEntity
    implements Serializable, EntityOrMappedSuperclass
{

    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String description;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbTable table;
    @XmlElement(name = "table-expression", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String tableExpression;
    @XmlElement(name = "secondary-table", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbSecondaryTable> secondaryTable;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbSynchronizedTable> synchronize;
    @XmlElement(name = "primary-key-join-column", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbPrimaryKeyJoinColumn> primaryKeyJoinColumn;
    @XmlElement(name = "primary-key-foreign-key", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbForeignKey primaryKeyForeignKey;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String rowid;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String where;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbCustomLoader loader;
    @XmlElement(name = "sql-insert", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbCustomSql sqlInsert;
    @XmlElement(name = "sql-update", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbCustomSql sqlUpdate;
    @XmlElement(name = "sql-delete", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbCustomSql sqlDelete;
    @XmlElement(name = "dynamic-insert", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected Boolean dynamicInsert;
    @XmlElement(name = "dynamic-update", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected Boolean dynamicUpdate;
    @XmlElement(name = "select-before-update", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected Boolean selectBeforeUpdate;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbCaching caching;
    @XmlElement(name = "batch-size", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected Integer batchSize;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected Boolean lazy;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected Boolean mutable;
    @XmlElement(name = "optimistic-lock", namespace = "http://www.hibernate.org/xsd/orm/mapping", type = String.class, defaultValue = "version")
    @XmlJavaTypeAdapter(Adapter3 .class)
    @XmlSchemaType(name = "token")
    protected OptimisticLockStyle optimisticLock;
    @XmlElement(name = "id-class", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbIdClass idClass;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbInheritance inheritance;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String proxy;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping", type = String.class, defaultValue = "implicit")
    @XmlJavaTypeAdapter(Adapter2 .class)
    @XmlSchemaType(name = "token")
    protected PolymorphismType polymorphism;
    @XmlElement(name = "discriminator-value", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String discriminatorValue;
    @XmlElement(name = "discriminator-column", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbDiscriminatorColumn discriminatorColumn;
    @XmlElement(name = "discriminator-formula", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String discriminatorFormula;
    @XmlElement(name = "sequence-generator", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbSequenceGenerator sequenceGenerator;
    @XmlElement(name = "table-generator", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbTableGenerator tableGenerator;
    @XmlElement(name = "identifier-generator", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbGenericIdGenerator> identifierGenerator;
    @XmlElement(name = "named-query", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbNamedQuery> namedQuery;
    @XmlElement(name = "named-native-query", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbNamedNativeQuery> namedNativeQuery;
    @XmlElement(name = "named-stored-procedure-query", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbNamedStoredProcedureQuery> namedStoredProcedureQuery;
    @XmlElement(name = "sql-result-set-mapping", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbSqlResultSetMapping> sqlResultSetMapping;
    @XmlElement(name = "exclude-default-listeners", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbEmptyType excludeDefaultListeners;
    @XmlElement(name = "exclude-superclass-listeners", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbEmptyType excludeSuperclassListeners;
    @XmlElement(name = "entity-listeners", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbEntityListeners entityListeners;
    @XmlElement(name = "pre-persist", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbPrePersist prePersist;
    @XmlElement(name = "post-persist", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbPostPersist postPersist;
    @XmlElement(name = "pre-remove", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbPreRemove preRemove;
    @XmlElement(name = "post-remove", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbPostRemove postRemove;
    @XmlElement(name = "pre-update", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbPreUpdate preUpdate;
    @XmlElement(name = "post-update", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbPostUpdate postUpdate;
    @XmlElement(name = "post-load", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbPostLoad postLoad;
    @XmlElement(name = "attribute-override", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbAttributeOverride> attributeOverride;
    @XmlElement(name = "association-override", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbAssociationOverride> associationOverride;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbConvert> convert;
    @XmlElement(name = "named-entity-graph", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbNamedEntityGraph> namedEntityGraph;
    @XmlElement(name = "extends", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String _extends;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbHbmFilter> filter;
    @XmlElement(name = "fetch-profile", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbFetchProfile> fetchProfile;
    @XmlElement(name = "tenant-id", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbTenantId tenantId;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbAttributes attributes;
    @XmlAttribute(name = "name")
    protected String name;
    @XmlAttribute(name = "class")
    protected String clazz;
    @XmlAttribute(name = "access")
    @XmlJavaTypeAdapter(Adapter1 .class)
    protected AccessType access;
    @XmlAttribute(name = "attribute-accessor")
    protected String attributeAccessor;
    @XmlAttribute(name = "cacheable")
    protected Boolean cacheable;
    @XmlAttribute(name = "metadata-complete")
    protected Boolean metadataComplete;

    /**
     * Gets the value of the description property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDescription(String value) {
        this.description = value;
    }

    /**
     * Gets the value of the table property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbTable }
     *     
     */
    public JaxbTable getTable() {
        return table;
    }

    /**
     * Sets the value of the table property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbTable }
     *     
     */
    public void setTable(JaxbTable value) {
        this.table = value;
    }

    /**
     * Gets the value of the tableExpression property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTableExpression() {
        return tableExpression;
    }

    /**
     * Sets the value of the tableExpression property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTableExpression(String value) {
        this.tableExpression = value;
    }

    /**
     * Gets the value of the secondaryTable property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the secondaryTable property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSecondaryTable().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbSecondaryTable }
     * 
     * 
     * @return
     *     The value of the secondaryTable property.
     */
    public List<JaxbSecondaryTable> getSecondaryTable() {
        if (secondaryTable == null) {
            secondaryTable = new ArrayList<>();
        }
        return this.secondaryTable;
    }

    /**
     * Gets the value of the synchronize property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the synchronize property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSynchronize().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbSynchronizedTable }
     * 
     * 
     * @return
     *     The value of the synchronize property.
     */
    public List<JaxbSynchronizedTable> getSynchronize() {
        if (synchronize == null) {
            synchronize = new ArrayList<>();
        }
        return this.synchronize;
    }

    /**
     * Gets the value of the primaryKeyJoinColumn property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the primaryKeyJoinColumn property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPrimaryKeyJoinColumn().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbPrimaryKeyJoinColumn }
     * 
     * 
     * @return
     *     The value of the primaryKeyJoinColumn property.
     */
    public List<JaxbPrimaryKeyJoinColumn> getPrimaryKeyJoinColumn() {
        if (primaryKeyJoinColumn == null) {
            primaryKeyJoinColumn = new ArrayList<>();
        }
        return this.primaryKeyJoinColumn;
    }

    /**
     * Gets the value of the primaryKeyForeignKey property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbForeignKey }
     *     
     */
    public JaxbForeignKey getPrimaryKeyForeignKey() {
        return primaryKeyForeignKey;
    }

    /**
     * Sets the value of the primaryKeyForeignKey property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbForeignKey }
     *     
     */
    public void setPrimaryKeyForeignKey(JaxbForeignKey value) {
        this.primaryKeyForeignKey = value;
    }

    /**
     * Gets the value of the rowid property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getRowid() {
        return rowid;
    }

    /**
     * Sets the value of the rowid property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setRowid(String value) {
        this.rowid = value;
    }

    /**
     * Gets the value of the where property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getWhere() {
        return where;
    }

    /**
     * Sets the value of the where property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setWhere(String value) {
        this.where = value;
    }

    /**
     * Gets the value of the loader property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbCustomLoader }
     *     
     */
    public JaxbCustomLoader getLoader() {
        return loader;
    }

    /**
     * Sets the value of the loader property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbCustomLoader }
     *     
     */
    public void setLoader(JaxbCustomLoader value) {
        this.loader = value;
    }

    /**
     * Gets the value of the sqlInsert property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbCustomSql }
     *     
     */
    public JaxbCustomSql getSqlInsert() {
        return sqlInsert;
    }

    /**
     * Sets the value of the sqlInsert property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbCustomSql }
     *     
     */
    public void setSqlInsert(JaxbCustomSql value) {
        this.sqlInsert = value;
    }

    /**
     * Gets the value of the sqlUpdate property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbCustomSql }
     *     
     */
    public JaxbCustomSql getSqlUpdate() {
        return sqlUpdate;
    }

    /**
     * Sets the value of the sqlUpdate property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbCustomSql }
     *     
     */
    public void setSqlUpdate(JaxbCustomSql value) {
        this.sqlUpdate = value;
    }

    /**
     * Gets the value of the sqlDelete property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbCustomSql }
     *     
     */
    public JaxbCustomSql getSqlDelete() {
        return sqlDelete;
    }

    /**
     * Sets the value of the sqlDelete property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbCustomSql }
     *     
     */
    public void setSqlDelete(JaxbCustomSql value) {
        this.sqlDelete = value;
    }

    /**
     * Gets the value of the dynamicInsert property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isDynamicInsert() {
        return dynamicInsert;
    }

    /**
     * Sets the value of the dynamicInsert property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setDynamicInsert(Boolean value) {
        this.dynamicInsert = value;
    }

    /**
     * Gets the value of the dynamicUpdate property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isDynamicUpdate() {
        return dynamicUpdate;
    }

    /**
     * Sets the value of the dynamicUpdate property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setDynamicUpdate(Boolean value) {
        this.dynamicUpdate = value;
    }

    /**
     * Gets the value of the selectBeforeUpdate property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isSelectBeforeUpdate() {
        return selectBeforeUpdate;
    }

    /**
     * Sets the value of the selectBeforeUpdate property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setSelectBeforeUpdate(Boolean value) {
        this.selectBeforeUpdate = value;
    }

    /**
     * Gets the value of the caching property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbCaching }
     *     
     */
    public JaxbCaching getCaching() {
        return caching;
    }

    /**
     * Sets the value of the caching property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbCaching }
     *     
     */
    public void setCaching(JaxbCaching value) {
        this.caching = value;
    }

    /**
     * Gets the value of the batchSize property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public Integer getBatchSize() {
        return batchSize;
    }

    /**
     * Sets the value of the batchSize property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setBatchSize(Integer value) {
        this.batchSize = value;
    }

    /**
     * Gets the value of the lazy property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isLazy() {
        return lazy;
    }

    /**
     * Sets the value of the lazy property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setLazy(Boolean value) {
        this.lazy = value;
    }

    /**
     * Gets the value of the mutable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isMutable() {
        return mutable;
    }

    /**
     * Sets the value of the mutable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setMutable(Boolean value) {
        this.mutable = value;
    }

    /**
     * Gets the value of the optimisticLock property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public OptimisticLockStyle getOptimisticLock() {
        return optimisticLock;
    }

    /**
     * Sets the value of the optimisticLock property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setOptimisticLock(OptimisticLockStyle value) {
        this.optimisticLock = value;
    }

    /**
     * Gets the value of the idClass property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbIdClass }
     *     
     */
    public JaxbIdClass getIdClass() {
        return idClass;
    }

    /**
     * Sets the value of the idClass property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbIdClass }
     *     
     */
    public void setIdClass(JaxbIdClass value) {
        this.idClass = value;
    }

    /**
     * Gets the value of the inheritance property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbInheritance }
     *     
     */
    public JaxbInheritance getInheritance() {
        return inheritance;
    }

    /**
     * Sets the value of the inheritance property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbInheritance }
     *     
     */
    public void setInheritance(JaxbInheritance value) {
        this.inheritance = value;
    }

    /**
     * Gets the value of the proxy property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getProxy() {
        return proxy;
    }

    /**
     * Sets the value of the proxy property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setProxy(String value) {
        this.proxy = value;
    }

    /**
     * Gets the value of the polymorphism property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public PolymorphismType getPolymorphism() {
        return polymorphism;
    }

    /**
     * Sets the value of the polymorphism property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPolymorphism(PolymorphismType value) {
        this.polymorphism = value;
    }

    /**
     * Gets the value of the discriminatorValue property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDiscriminatorValue() {
        return discriminatorValue;
    }

    /**
     * Sets the value of the discriminatorValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDiscriminatorValue(String value) {
        this.discriminatorValue = value;
    }

    /**
     * Gets the value of the discriminatorColumn property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbDiscriminatorColumn }
     *     
     */
    public JaxbDiscriminatorColumn getDiscriminatorColumn() {
        return discriminatorColumn;
    }

    /**
     * Sets the value of the discriminatorColumn property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbDiscriminatorColumn }
     *     
     */
    public void setDiscriminatorColumn(JaxbDiscriminatorColumn value) {
        this.discriminatorColumn = value;
    }

    /**
     * Gets the value of the discriminatorFormula property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDiscriminatorFormula() {
        return discriminatorFormula;
    }

    /**
     * Sets the value of the discriminatorFormula property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDiscriminatorFormula(String value) {
        this.discriminatorFormula = value;
    }

    /**
     * Gets the value of the sequenceGenerator property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbSequenceGenerator }
     *     
     */
    public JaxbSequenceGenerator getSequenceGenerator() {
        return sequenceGenerator;
    }

    /**
     * Sets the value of the sequenceGenerator property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbSequenceGenerator }
     *     
     */
    public void setSequenceGenerator(JaxbSequenceGenerator value) {
        this.sequenceGenerator = value;
    }

    /**
     * Gets the value of the tableGenerator property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbTableGenerator }
     *     
     */
    public JaxbTableGenerator getTableGenerator() {
        return tableGenerator;
    }

    /**
     * Sets the value of the tableGenerator property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbTableGenerator }
     *     
     */
    public void setTableGenerator(JaxbTableGenerator value) {
        this.tableGenerator = value;
    }

    /**
     * Gets the value of the identifierGenerator property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the identifierGenerator property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getIdentifierGenerator().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbGenericIdGenerator }
     * 
     * 
     * @return
     *     The value of the identifierGenerator property.
     */
    public List<JaxbGenericIdGenerator> getIdentifierGenerator() {
        if (identifierGenerator == null) {
            identifierGenerator = new ArrayList<>();
        }
        return this.identifierGenerator;
    }

    /**
     * Gets the value of the namedQuery property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the namedQuery property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getNamedQuery().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbNamedQuery }
     * 
     * 
     * @return
     *     The value of the namedQuery property.
     */
    public List<JaxbNamedQuery> getNamedQuery() {
        if (namedQuery == null) {
            namedQuery = new ArrayList<>();
        }
        return this.namedQuery;
    }

    /**
     * Gets the value of the namedNativeQuery property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the namedNativeQuery property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getNamedNativeQuery().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbNamedNativeQuery }
     * 
     * 
     * @return
     *     The value of the namedNativeQuery property.
     */
    public List<JaxbNamedNativeQuery> getNamedNativeQuery() {
        if (namedNativeQuery == null) {
            namedNativeQuery = new ArrayList<>();
        }
        return this.namedNativeQuery;
    }

    /**
     * Gets the value of the namedStoredProcedureQuery property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the namedStoredProcedureQuery property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getNamedStoredProcedureQuery().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbNamedStoredProcedureQuery }
     * 
     * 
     * @return
     *     The value of the namedStoredProcedureQuery property.
     */
    public List<JaxbNamedStoredProcedureQuery> getNamedStoredProcedureQuery() {
        if (namedStoredProcedureQuery == null) {
            namedStoredProcedureQuery = new ArrayList<>();
        }
        return this.namedStoredProcedureQuery;
    }

    /**
     * Gets the value of the sqlResultSetMapping property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the sqlResultSetMapping property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSqlResultSetMapping().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbSqlResultSetMapping }
     * 
     * 
     * @return
     *     The value of the sqlResultSetMapping property.
     */
    public List<JaxbSqlResultSetMapping> getSqlResultSetMapping() {
        if (sqlResultSetMapping == null) {
            sqlResultSetMapping = new ArrayList<>();
        }
        return this.sqlResultSetMapping;
    }

    /**
     * Gets the value of the excludeDefaultListeners property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbEmptyType }
     *     
     */
    public JaxbEmptyType getExcludeDefaultListeners() {
        return excludeDefaultListeners;
    }

    /**
     * Sets the value of the excludeDefaultListeners property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbEmptyType }
     *     
     */
    public void setExcludeDefaultListeners(JaxbEmptyType value) {
        this.excludeDefaultListeners = value;
    }

    /**
     * Gets the value of the excludeSuperclassListeners property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbEmptyType }
     *     
     */
    public JaxbEmptyType getExcludeSuperclassListeners() {
        return excludeSuperclassListeners;
    }

    /**
     * Sets the value of the excludeSuperclassListeners property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbEmptyType }
     *     
     */
    public void setExcludeSuperclassListeners(JaxbEmptyType value) {
        this.excludeSuperclassListeners = value;
    }

    /**
     * Gets the value of the entityListeners property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbEntityListeners }
     *     
     */
    public JaxbEntityListeners getEntityListeners() {
        return entityListeners;
    }

    /**
     * Sets the value of the entityListeners property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbEntityListeners }
     *     
     */
    public void setEntityListeners(JaxbEntityListeners value) {
        this.entityListeners = value;
    }

    /**
     * Gets the value of the prePersist property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbPrePersist }
     *     
     */
    public JaxbPrePersist getPrePersist() {
        return prePersist;
    }

    /**
     * Sets the value of the prePersist property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbPrePersist }
     *     
     */
    public void setPrePersist(JaxbPrePersist value) {
        this.prePersist = value;
    }

    /**
     * Gets the value of the postPersist property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbPostPersist }
     *     
     */
    public JaxbPostPersist getPostPersist() {
        return postPersist;
    }

    /**
     * Sets the value of the postPersist property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbPostPersist }
     *     
     */
    public void setPostPersist(JaxbPostPersist value) {
        this.postPersist = value;
    }

    /**
     * Gets the value of the preRemove property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbPreRemove }
     *     
     */
    public JaxbPreRemove getPreRemove() {
        return preRemove;
    }

    /**
     * Sets the value of the preRemove property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbPreRemove }
     *     
     */
    public void setPreRemove(JaxbPreRemove value) {
        this.preRemove = value;
    }

    /**
     * Gets the value of the postRemove property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbPostRemove }
     *     
     */
    public JaxbPostRemove getPostRemove() {
        return postRemove;
    }

    /**
     * Sets the value of the postRemove property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbPostRemove }
     *     
     */
    public void setPostRemove(JaxbPostRemove value) {
        this.postRemove = value;
    }

    /**
     * Gets the value of the preUpdate property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbPreUpdate }
     *     
     */
    public JaxbPreUpdate getPreUpdate() {
        return preUpdate;
    }

    /**
     * Sets the value of the preUpdate property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbPreUpdate }
     *     
     */
    public void setPreUpdate(JaxbPreUpdate value) {
        this.preUpdate = value;
    }

    /**
     * Gets the value of the postUpdate property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbPostUpdate }
     *     
     */
    public JaxbPostUpdate getPostUpdate() {
        return postUpdate;
    }

    /**
     * Sets the value of the postUpdate property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbPostUpdate }
     *     
     */
    public void setPostUpdate(JaxbPostUpdate value) {
        this.postUpdate = value;
    }

    /**
     * Gets the value of the postLoad property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbPostLoad }
     *     
     */
    public JaxbPostLoad getPostLoad() {
        return postLoad;
    }

    /**
     * Sets the value of the postLoad property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbPostLoad }
     *     
     */
    public void setPostLoad(JaxbPostLoad value) {
        this.postLoad = value;
    }

    /**
     * Gets the value of the attributeOverride property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the attributeOverride property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAttributeOverride().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbAttributeOverride }
     * 
     * 
     * @return
     *     The value of the attributeOverride property.
     */
    public List<JaxbAttributeOverride> getAttributeOverride() {
        if (attributeOverride == null) {
            attributeOverride = new ArrayList<>();
        }
        return this.attributeOverride;
    }

    /**
     * Gets the value of the associationOverride property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the associationOverride property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAssociationOverride().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbAssociationOverride }
     * 
     * 
     * @return
     *     The value of the associationOverride property.
     */
    public List<JaxbAssociationOverride> getAssociationOverride() {
        if (associationOverride == null) {
            associationOverride = new ArrayList<>();
        }
        return this.associationOverride;
    }

    /**
     * Gets the value of the convert property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the convert property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getConvert().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbConvert }
     * 
     * 
     * @return
     *     The value of the convert property.
     */
    public List<JaxbConvert> getConvert() {
        if (convert == null) {
            convert = new ArrayList<>();
        }
        return this.convert;
    }

    /**
     * Gets the value of the namedEntityGraph property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the namedEntityGraph property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getNamedEntityGraph().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbNamedEntityGraph }
     * 
     * 
     * @return
     *     The value of the namedEntityGraph property.
     */
    public List<JaxbNamedEntityGraph> getNamedEntityGraph() {
        if (namedEntityGraph == null) {
            namedEntityGraph = new ArrayList<>();
        }
        return this.namedEntityGraph;
    }

    /**
     * Gets the value of the extends property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getExtends() {
        return _extends;
    }

    /**
     * Sets the value of the extends property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setExtends(String value) {
        this._extends = value;
    }

    /**
     * Gets the value of the filter property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the filter property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getFilter().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbHbmFilter }
     * 
     * 
     * @return
     *     The value of the filter property.
     */
    public List<JaxbHbmFilter> getFilter() {
        if (filter == null) {
            filter = new ArrayList<>();
        }
        return this.filter;
    }

    /**
     * Gets the value of the fetchProfile property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the fetchProfile property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getFetchProfile().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbFetchProfile }
     * 
     * 
     * @return
     *     The value of the fetchProfile property.
     */
    public List<JaxbFetchProfile> getFetchProfile() {
        if (fetchProfile == null) {
            fetchProfile = new ArrayList<>();
        }
        return this.fetchProfile;
    }

    /**
     * Gets the value of the tenantId property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbTenantId }
     *     
     */
    public JaxbTenantId getTenantId() {
        return tenantId;
    }

    /**
     * Sets the value of the tenantId property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbTenantId }
     *     
     */
    public void setTenantId(JaxbTenantId value) {
        this.tenantId = value;
    }

    /**
     * Gets the value of the attributes property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbAttributes }
     *     
     */
    public JaxbAttributes getAttributes() {
        return attributes;
    }

    /**
     * Sets the value of the attributes property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbAttributes }
     *     
     */
    public void setAttributes(JaxbAttributes value) {
        this.attributes = value;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * Gets the value of the clazz property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getClazz() {
        return clazz;
    }

    /**
     * Sets the value of the clazz property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setClazz(String value) {
        this.clazz = value;
    }

    /**
     * Gets the value of the access property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public AccessType getAccess() {
        return access;
    }

    /**
     * Sets the value of the access property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAccess(AccessType value) {
        this.access = value;
    }

    /**
     * Gets the value of the attributeAccessor property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAttributeAccessor() {
        return attributeAccessor;
    }

    /**
     * Sets the value of the attributeAccessor property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAttributeAccessor(String value) {
        this.attributeAccessor = value;
    }

    /**
     * Gets the value of the cacheable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isCacheable() {
        return cacheable;
    }

    /**
     * Sets the value of the cacheable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setCacheable(Boolean value) {
        this.cacheable = value;
    }

    /**
     * Gets the value of the metadataComplete property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isMetadataComplete() {
        return metadataComplete;
    }

    /**
     * Sets the value of the metadataComplete property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setMetadataComplete(Boolean value) {
        this.metadataComplete = value;
    }

}
