/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.function;

import java.util.Collections;
import java.util.List;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.function.FunctionKind;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.type.spi.TypeConfiguration;

public interface SqmFunctionDescriptor {
    public <T> SelfRenderingSqmFunction<T> generateSqmExpression(List<? extends SqmTypedNode<?>> var1, ReturnableType<T> var2, QueryEngine var3, TypeConfiguration var4);

    default public <T> SelfRenderingSqmFunction<T> generateAggregateSqmExpression(List<? extends SqmTypedNode<?>> arguments, SqmPredicate filter, ReturnableType<T> impliedResultType, QueryEngine queryEngine, TypeConfiguration typeConfiguration) {
        throw new UnsupportedOperationException("Not an aggregate function");
    }

    default public <T> SelfRenderingSqmFunction<T> generateOrderedSetAggregateSqmExpression(List<? extends SqmTypedNode<?>> arguments, SqmPredicate filter, SqmOrderByClause withinGroupClause, ReturnableType<T> impliedResultType, QueryEngine queryEngine, TypeConfiguration typeConfiguration) {
        throw new UnsupportedOperationException("Not an ordered set aggregate function");
    }

    default public <T> SelfRenderingSqmFunction<T> generateWindowSqmExpression(List<? extends SqmTypedNode<?>> arguments, SqmPredicate filter, Boolean respectNulls, Boolean fromFirst, ReturnableType<T> impliedResultType, QueryEngine queryEngine, TypeConfiguration typeConfiguration) {
        throw new UnsupportedOperationException("Not a window function");
    }

    default public <T> SelfRenderingSqmFunction<T> generateSqmExpression(SqmTypedNode<?> argument, ReturnableType<T> impliedResultType, QueryEngine queryEngine, TypeConfiguration typeConfiguration) {
        return this.generateSqmExpression(Collections.singletonList(argument), impliedResultType, queryEngine, typeConfiguration);
    }

    default public <T> SelfRenderingSqmFunction<T> generateSqmExpression(ReturnableType<T> impliedResultType, QueryEngine queryEngine, TypeConfiguration typeConfiguration) {
        return this.generateSqmExpression(Collections.emptyList(), impliedResultType, queryEngine, typeConfiguration);
    }

    default public boolean alwaysIncludesParentheses() {
        return true;
    }

    default public String getSignature(String name) {
        return name;
    }

    default public FunctionKind getFunctionKind() {
        return FunctionKind.NORMAL;
    }

    public ArgumentsValidator getArgumentsValidator();
}

