
package org.hibernate.boot.jaxb.hbm.spi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 *                 Optimistic locking attribute based on an incrementing value.
 *             
 * 
 * <p>Java class for VersionAttributeType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="VersionAttributeType">
 *   <complexContent>
 *     <extension base="{http://www.hibernate.org/xsd/orm/hbm}BaseVersionAttributeType">
 *       <sequence>
 *         <element name="column" type="{http://www.hibernate.org/xsd/orm/hbm}ColumnType" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="insert" type="{http://www.w3.org/2001/XMLSchema}boolean" />
 *       <attribute name="type" type="{http://www.w3.org/2001/XMLSchema}string" default="integer" />
 *       <attribute name="unsaved-value" type="{http://www.hibernate.org/xsd/orm/hbm}UnsavedValueVersionEnum" default="undefined" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "VersionAttributeType", namespace = "http://www.hibernate.org/xsd/orm/hbm", propOrder = {
    "column"
})
public class JaxbHbmVersionAttributeType
    extends JaxbHbmBaseVersionAttributeType
    implements Serializable, SingularAttributeInfo, ToolingHintContainer
{

    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/hbm")
    protected List<JaxbHbmColumnType> column;
    @XmlAttribute(name = "insert")
    protected Boolean insert;
    @XmlAttribute(name = "type")
    protected String type;
    @XmlAttribute(name = "unsaved-value")
    protected JaxbHbmUnsavedValueVersionEnum unsavedValue;

    /**
     * Gets the value of the column property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the column property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getColumn().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbHbmColumnType }
     * 
     * 
     * @return
     *     The value of the column property.
     */
    public List<JaxbHbmColumnType> getColumn() {
        if (column == null) {
            column = new ArrayList<>();
        }
        return this.column;
    }

    /**
     * Gets the value of the insert property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isInsert() {
        return insert;
    }

    /**
     * Sets the value of the insert property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setInsert(Boolean value) {
        this.insert = value;
    }

    /**
     * Gets the value of the type property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getType() {
        if (type == null) {
            return "integer";
        } else {
            return type;
        }
    }

    /**
     * Sets the value of the type property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setType(String value) {
        this.type = value;
    }

    /**
     * Gets the value of the unsavedValue property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbHbmUnsavedValueVersionEnum }
     *     
     */
    public JaxbHbmUnsavedValueVersionEnum getUnsavedValue() {
        if (unsavedValue == null) {
            return JaxbHbmUnsavedValueVersionEnum.UNDEFINED;
        } else {
            return unsavedValue;
        }
    }

    /**
     * Sets the value of the unsavedValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbHbmUnsavedValueVersionEnum }
     *     
     */
    public void setUnsavedValue(JaxbHbmUnsavedValueVersionEnum value) {
        this.unsavedValue = value;
    }

}
