
package org.hibernate.boot.jaxb.mapping;

import java.io.Serializable;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;


/**
 * <p>Java class for custom-sql complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="custom-sql">
 *   <simpleContent>
 *     <extension base="<http://www.w3.org/2001/XMLSchema>string">
 *       <attribute name="callable" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="check" type="{http://www.hibernate.org/xsd/orm/mapping}custom-sql-check-type" />
 *     </extension>
 *   </simpleContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "custom-sql", namespace = "http://www.hibernate.org/xsd/orm/mapping", propOrder = {
    "value"
})
public class JaxbCustomSql
    implements Serializable
{

    @XmlValue
    protected String value;
    @XmlAttribute(name = "callable")
    protected Boolean callable;
    @XmlAttribute(name = "check")
    @XmlJavaTypeAdapter(Adapter16 .class)
    protected ExecuteUpdateResultCheckStyle check;

    /**
     * Gets the value of the value property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getValue() {
        return value;
    }

    /**
     * Sets the value of the value property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * Gets the value of the callable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCallable() {
        if (callable == null) {
            return false;
        } else {
            return callable;
        }
    }

    /**
     * Sets the value of the callable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setCallable(Boolean value) {
        this.callable = value;
    }

    /**
     * Gets the value of the check property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public ExecuteUpdateResultCheckStyle getCheck() {
        return check;
    }

    /**
     * Sets the value of the check property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCheck(ExecuteUpdateResultCheckStyle value) {
        this.check = value;
    }

}
